/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import org.mozilla.gecko.CustomEditText;
import org.mozilla.gecko.InputMethods;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BrowserToolbar;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.StringUtils;

public class ToolbarEditText
extends CustomEditText
implements AutocompleteHandler {
    private static final String LOGTAG = "GeckoToolbarEditText";
    private final Context mContext;
    private TextType mToolbarTextType;
    private TextType mKeyboardTextType;
    private BrowserToolbar.OnCommitListener mCommitListener;
    private BrowserToolbar.OnDismissListener mDismissListener;
    private BrowserToolbar.OnFilterListener mFilterListener;
    private OnTextTypeChangeListener mTextTypeListener;
    private String mAutoCompleteResult = "";
    private String mAutoCompletePrefix = null;
    private boolean mDelayRestartInput;

    public ToolbarEditText(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mToolbarTextType = TextType.EMPTY;
        this.mKeyboardTextType = TextType.URL;
    }

    void setOnCommitListener(BrowserToolbar.OnCommitListener onCommitListener) {
        this.mCommitListener = onCommitListener;
    }

    void setOnDismissListener(BrowserToolbar.OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
    }

    void setOnFilterListener(BrowserToolbar.OnFilterListener onFilterListener) {
        this.mFilterListener = onFilterListener;
    }

    void setOnTextTypeChangeListener(OnTextTypeChangeListener onTextTypeChangeListener) {
        this.mTextTypeListener = onTextTypeChangeListener;
    }

    public void onAttachedToWindow() {
        this.setOnKeyListener(new KeyListener());
        this.setOnKeyPreImeListener(new KeyPreImeListener());
        this.addTextChangedListener(new TextChangeListener());
    }

    public void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (bl) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
        try {
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
        }
        catch (NullPointerException nullPointerException) {
            Log.e((String)LOGTAG, (String)"InputMethodManagerService, why are you throwing a NullPointerException? See bug 782096", (Throwable)nullPointerException);
        }
    }

    public final void onAutocomplete(String string2) {
        if (!this.isEnabled()) {
            return;
        }
        String string3 = this.getText().toString();
        if (string2 == null) {
            this.mAutoCompleteResult = "";
            return;
        }
        if (!string2.startsWith(string3) || string3.equals(string2)) {
            return;
        }
        this.mAutoCompleteResult = string2;
        this.getText().append((CharSequence)string2.substring(string3.length()));
        this.setSelection(string3.length(), string2.length());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateTextTypeFromText(this.getText().toString());
    }

    private void updateKeyboardInputType() {
        int n;
        String string2 = this.getText().toString();
        int n2 = this.getInputType();
        int n3 = n = StringUtils.isSearchQuery((String)string2, (boolean)false) ? n2 & 0xFFFFFFEF : n2 | 0x10;
        if (n != n2) {
            this.setRawInputType(n);
        }
    }

    private static boolean hasCompositionString(Editable editable) {
        Object[] objectArray = editable.getSpans(0, editable.length(), Object.class);
        if (objectArray != null) {
            for (Object object : objectArray) {
                if ((editable.getSpanFlags(object) & 0x100) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private void setTextType(TextType textType) {
        this.mToolbarTextType = textType;
        if (textType != TextType.EMPTY) {
            this.mKeyboardTextType = textType;
        }
        if (this.mTextTypeListener != null) {
            this.mTextTypeListener.onTextTypeChange(this, textType);
        }
    }

    private void updateTextTypeFromText(String string2) {
        if (string2.length() == 0) {
            this.setTextType(TextType.EMPTY);
            return;
        }
        if (InputMethods.shouldDisableUrlBarUpdate(this.mContext)) {
            this.setTextType(this.mKeyboardTextType);
            return;
        }
        int n = this.getImeOptions() & 0xFF;
        int n2 = StringUtils.isSearchQuery((String)string2, (n == 3 ? 1 : 0) != 0) ? 3 : 2;
        InputMethodManager inputMethodManager = InputMethods.getInputMethodManager(this.mContext);
        if (inputMethodManager == null) {
            return;
        }
        boolean bl = false;
        if (n != n2) {
            int n3 = this.getImeOptions() & 0xFFFFFF00;
            this.setImeOptions(n3 | n2);
            boolean bl2 = this.mDelayRestartInput = n2 == 2 && InputMethods.shouldDelayUrlBarUpdate(this.mContext);
            if (!this.mDelayRestartInput) {
                bl = true;
            }
        } else if (this.mDelayRestartInput) {
            this.mDelayRestartInput = false;
            bl = true;
        }
        if (!bl) {
            this.setTextType(this.mKeyboardTextType);
            return;
        }
        this.updateKeyboardInputType();
        inputMethodManager.restartInput((View)this);
        this.setTextType(n2 == 2 ? TextType.URL : TextType.SEARCH_QUERY);
    }

    private class KeyListener
    implements View.OnKeyListener {
        private KeyListener() {
        }

        public boolean onKey(View view, int n, KeyEvent keyEvent) {
            if (n == 66 || GamepadUtils.isActionKey((KeyEvent)keyEvent)) {
                if (keyEvent.getAction() != 0) {
                    return true;
                }
                if (ToolbarEditText.this.mCommitListener != null) {
                    ToolbarEditText.this.mCommitListener.onCommit();
                }
                return true;
            }
            if (GamepadUtils.isBackKey((KeyEvent)keyEvent)) {
                if (ToolbarEditText.this.mDismissListener != null) {
                    ToolbarEditText.this.mDismissListener.onDismiss();
                }
                return true;
            }
            return false;
        }
    }

    private class KeyPreImeListener
    implements CustomEditText.OnKeyPreImeListener {
        private KeyPreImeListener() {
        }

        public boolean onKeyPreIme(View view, int n, KeyEvent keyEvent) {
            Editable editable;
            if (keyEvent.getAction() != 0) {
                return false;
            }
            if (n == 66 && !ToolbarEditText.hasCompositionString(editable = ToolbarEditText.this.getText())) {
                if (ToolbarEditText.this.mCommitListener != null) {
                    ToolbarEditText.this.mCommitListener.onCommit();
                }
                return true;
            }
            if (n == 4) {
                ToolbarEditText.this.clearFocus();
                return true;
            }
            return false;
        }
    }

    private class TextChangeListener
    implements TextWatcher {
        private TextChangeListener() {
        }

        public void afterTextChanged(Editable editable) {
            if (!ToolbarEditText.this.isEnabled()) {
                return;
            }
            String string2 = editable.toString();
            boolean bl = false;
            boolean bl2 = false;
            if (!ToolbarEditText.hasCompositionString(editable) && !StringUtils.isSearchQuery((String)string2, (boolean)false)) {
                bl = true;
                if (ToolbarEditText.this.mAutoCompletePrefix != null && ToolbarEditText.this.mAutoCompletePrefix.length() >= string2.length()) {
                    bl = false;
                } else if (ToolbarEditText.this.mAutoCompleteResult != null && ToolbarEditText.this.mAutoCompleteResult.startsWith(string2)) {
                    bl = false;
                    bl2 = true;
                }
            }
            if (TextUtils.isEmpty((CharSequence)ToolbarEditText.this.mAutoCompleteResult) || !ToolbarEditText.this.mAutoCompleteResult.equals(string2)) {
                if (ToolbarEditText.this.mFilterListener != null) {
                    ToolbarEditText.this.mFilterListener.onFilter(string2, bl ? ToolbarEditText.this : null);
                }
                ToolbarEditText.this.mAutoCompletePrefix = string2;
                if (bl2) {
                    ToolbarEditText.this.onAutocomplete(ToolbarEditText.this.mAutoCompleteResult);
                }
            }
            if (!ToolbarEditText.hasCompositionString(editable) || InputMethods.isGestureKeyboard(ToolbarEditText.this.mContext)) {
                ToolbarEditText.this.updateTextTypeFromText(string2);
            }
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    static interface OnTextTypeChangeListener {
        public void onTextTypeChange(ToolbarEditText var1, TextType var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TextType {
        EMPTY,
        SEARCH_QUERY,
        URL;

    }
}

