/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.io;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpMessage;
import ch.boye.httpclientandroidlib.ParseException;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.io.HttpMessageParser;
import ch.boye.httpclientandroidlib.io.SessionInputBuffer;
import ch.boye.httpclientandroidlib.message.BasicLineParser;
import ch.boye.httpclientandroidlib.message.LineParser;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMessageParser
implements HttpMessageParser {
    private static final int HEAD_LINE = 0;
    private static final int HEADERS = 1;
    private final SessionInputBuffer sessionBuffer;
    private final int maxHeaderCount;
    private final int maxLineLen;
    private final List headerLines;
    protected final LineParser lineParser;
    private int state;
    private HttpMessage message;

    public AbstractMessageParser(SessionInputBuffer sessionInputBuffer, LineParser lineParser, HttpParams httpParams) {
        if (sessionInputBuffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sessionBuffer = sessionInputBuffer;
        this.maxHeaderCount = httpParams.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLen = httpParams.getIntParameter("http.connection.max-line-length", -1);
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.DEFAULT;
        this.headerLines = new ArrayList();
        this.state = 0;
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, int n, int n2, LineParser lineParser) throws HttpException, IOException {
        if (lineParser == null) {
            lineParser = BasicLineParser.DEFAULT;
        }
        ArrayList arrayList = new ArrayList();
        return AbstractMessageParser.parseHeaders(sessionInputBuffer, n, n2, lineParser, arrayList);
    }

    public static Header[] parseHeaders(SessionInputBuffer sessionInputBuffer, int n, int n2, LineParser lineParser, List list) throws HttpException, IOException {
        int n3;
        block12: {
            if (sessionInputBuffer == null) {
                throw new IllegalArgumentException("Session input buffer may not be null");
            }
            if (lineParser == null) {
                throw new IllegalArgumentException("Line parser may not be null");
            }
            if (list == null) {
                throw new IllegalArgumentException("Header line list may not be null");
            }
            CharArrayBuffer charArrayBuffer = null;
            CharArrayBuffer charArrayBuffer2 = null;
            do {
                if (charArrayBuffer == null) {
                    charArrayBuffer = new CharArrayBuffer(64);
                } else {
                    charArrayBuffer.clear();
                }
                int n4 = sessionInputBuffer.readLine(charArrayBuffer);
                if (n4 == -1 || charArrayBuffer.length() < 1) break block12;
                if ((charArrayBuffer.charAt(0) == ' ' || charArrayBuffer.charAt(0) == '\t') && charArrayBuffer2 != null) {
                    char c;
                    for (n3 = 0; n3 < charArrayBuffer.length() && ((c = charArrayBuffer.charAt(n3)) == ' ' || c == '\t'); ++n3) {
                    }
                    if (n2 > 0 && charArrayBuffer2.length() + 1 + charArrayBuffer.length() - n3 > n2) {
                        throw new IOException("Maximum line length limit exceeded");
                    }
                    charArrayBuffer2.append(' ');
                    charArrayBuffer2.append(charArrayBuffer, n3, charArrayBuffer.length() - n3);
                    continue;
                }
                list.add(charArrayBuffer);
                charArrayBuffer2 = charArrayBuffer;
                charArrayBuffer = null;
            } while (n <= 0 || list.size() < n);
            throw new IOException("Maximum header count exceeded");
        }
        Header[] headerArray = new Header[list.size()];
        for (n3 = 0; n3 < list.size(); ++n3) {
            CharArrayBuffer charArrayBuffer = (CharArrayBuffer)list.get(n3);
            try {
                headerArray[n3] = lineParser.parseHeader(charArrayBuffer);
                continue;
            }
            catch (ParseException parseException) {
                throw new ProtocolException(parseException.getMessage());
            }
        }
        return headerArray;
    }

    protected abstract HttpMessage parseHead(SessionInputBuffer var1) throws IOException, HttpException, ParseException;

    public HttpMessage parse() throws IOException, HttpException {
        int n = this.state;
        switch (n) {
            case 0: {
                try {
                    this.message = this.parseHead(this.sessionBuffer);
                }
                catch (ParseException parseException) {
                    throw new ProtocolException(parseException.getMessage(), parseException);
                }
                this.state = 1;
            }
            case 1: {
                Header[] headerArray = AbstractMessageParser.parseHeaders(this.sessionBuffer, this.maxHeaderCount, this.maxLineLen, this.lineParser, this.headerLines);
                this.message.setHeaders(headerArray);
                HttpMessage httpMessage = this.message;
                this.message = null;
                this.headerLines.clear();
                this.state = 0;
                return httpMessage;
            }
        }
        throw new IllegalStateException("Inconsistent parser state");
    }
}

