/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.io;

import ch.boye.httpclientandroidlib.impl.io.HttpTransportMetricsImpl;
import ch.boye.httpclientandroidlib.io.BufferInfo;
import ch.boye.httpclientandroidlib.io.HttpTransportMetrics;
import ch.boye.httpclientandroidlib.io.SessionOutputBuffer;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.params.HttpProtocolParams;
import ch.boye.httpclientandroidlib.util.ByteArrayBuffer;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import java.io.IOException;
import java.io.OutputStream;

public abstract class AbstractSessionOutputBuffer
implements SessionOutputBuffer,
BufferInfo {
    private static final byte[] CRLF = new byte[]{13, 10};
    private OutputStream outstream;
    private ByteArrayBuffer buffer;
    private String charset = "US-ASCII";
    private boolean ascii = true;
    private int minChunkLimit = 512;
    private HttpTransportMetricsImpl metrics;

    protected void init(OutputStream outputStream, int n, HttpParams httpParams) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size may not be negative or zero");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.outstream = outputStream;
        this.buffer = new ByteArrayBuffer(n);
        this.charset = HttpProtocolParams.getHttpElementCharset(httpParams);
        this.ascii = this.charset.equalsIgnoreCase("US-ASCII") || this.charset.equalsIgnoreCase("ASCII");
        this.minChunkLimit = httpParams.getIntParameter("http.connection.min-chunk-limit", 512);
        this.metrics = this.createTransportMetrics();
    }

    protected HttpTransportMetricsImpl createTransportMetrics() {
        return new HttpTransportMetricsImpl();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int length() {
        return this.buffer.length();
    }

    public int available() {
        return this.capacity() - this.length();
    }

    protected void flushBuffer() throws IOException {
        int n = this.buffer.length();
        if (n > 0) {
            this.outstream.write(this.buffer.buffer(), 0, n);
            this.buffer.clear();
            this.metrics.incrementBytesTransferred(n);
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.outstream.flush();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            return;
        }
        if (n2 > this.minChunkLimit || n2 > this.buffer.capacity()) {
            this.flushBuffer();
            this.outstream.write(byArray, n, n2);
            this.metrics.incrementBytesTransferred(n2);
        } else {
            int n3 = this.buffer.capacity() - this.buffer.length();
            if (n2 > n3) {
                this.flushBuffer();
            }
            this.buffer.append(byArray, n, n2);
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        if (this.buffer.isFull()) {
            this.flushBuffer();
        }
        this.buffer.append(n);
    }

    public void writeLine(String string) throws IOException {
        if (string == null) {
            return;
        }
        if (string.length() > 0) {
            this.write(string.getBytes(this.charset));
        }
        this.write(CRLF);
    }

    public void writeLine(CharArrayBuffer charArrayBuffer) throws IOException {
        if (charArrayBuffer == null) {
            return;
        }
        if (this.ascii) {
            int n;
            int n2 = 0;
            for (int i = charArrayBuffer.length(); i > 0; i -= n) {
                n = this.buffer.capacity() - this.buffer.length();
                if ((n = Math.min(n, i)) > 0) {
                    this.buffer.append(charArrayBuffer, n2, n);
                }
                if (this.buffer.isFull()) {
                    this.flushBuffer();
                }
                n2 += n;
            }
        } else {
            byte[] byArray = charArrayBuffer.toString().getBytes(this.charset);
            this.write(byArray);
        }
        this.write(CRLF);
    }

    public HttpTransportMetrics getMetrics() {
        return this.metrics;
    }
}

