/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.ThreadUtils;

public final class Distribution {
    private static final String LOGTAG = "GeckoDistribution";
    private static final String DEFAULT_PREFS = "GeckoApp";
    private static final int STATE_UNKNOWN = 0;
    private static final int STATE_NONE = 1;
    private static final int STATE_SET = 2;
    private final Context context;
    private final String packagePath;
    private final String prefsBranch;
    private int state = 0;
    private File distributionDir = null;

    @RobocopTarget
    public static void init(final Context context, final String string2, final String string3) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                Distribution distribution = new Distribution(context, string2, string3);
                boolean bl = distribution.doInit();
                if (bl) {
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Distribution:Set", ""));
                }
            }
        });
    }

    public static void init(Context context) {
        Distribution.init(context, context.getPackageResourcePath(), DEFAULT_PREFS);
    }

    public static JSONArray getBookmarks(Context context) {
        Distribution distribution = new Distribution(context);
        return distribution.getBookmarks();
    }

    public Distribution(Context context, String string2, String string3) {
        this.context = context;
        this.packagePath = string2;
        this.prefsBranch = string3;
    }

    public Distribution(Context context) {
        this(context, context.getPackageResourcePath(), DEFAULT_PREFS);
    }

    private boolean doInit() {
        File file;
        SharedPreferences sharedPreferences = this.context.getSharedPreferences(this.prefsBranch, 0);
        String string2 = this.context.getPackageName() + ".distribution_state";
        this.state = sharedPreferences.getInt(string2, 0);
        if (this.state == 1) {
            return false;
        }
        if (this.state == 2) {
            return true;
        }
        boolean bl = false;
        try {
            bl = this.copyFiles();
            if (bl) {
                this.distributionDir = new File(this.getDataDir(), "distribution/");
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error copying distribution files", (Throwable)iOException);
        }
        if (!bl && (file = this.getSystemDistributionDir()).exists()) {
            bl = true;
            this.distributionDir = file;
        }
        this.state = bl ? 2 : 1;
        sharedPreferences.edit().putInt(string2, this.state).commit();
        return bl;
    }

    private boolean copyFiles() throws IOException {
        File file = new File(this.packagePath);
        ZipFile zipFile = new ZipFile(file);
        boolean bl = false;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        byte[] byArray = new byte[1024];
        while (enumeration.hasMoreElements()) {
            int n;
            ZipEntry zipEntry = enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (!string2.startsWith("distribution/")) continue;
            bl = true;
            File file2 = new File(this.getDataDir(), string2);
            File file3 = file2.getParentFile();
            if (!file3.exists() && !file3.mkdirs()) {
                Log.e((String)LOGTAG, (String)("Unable to create directories: " + file3.getAbsolutePath()));
                continue;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
            file2.setLastModified(zipEntry.getTime());
        }
        zipFile.close();
        return bl;
    }

    private File ensureDistributionDir() {
        if (this.distributionDir != null) {
            return this.distributionDir;
        }
        if (this.state != 2) {
            return null;
        }
        File file = new File(this.getDataDir(), "distribution/");
        if (file.exists()) {
            this.distributionDir = file;
            return this.distributionDir;
        }
        File file2 = this.getSystemDistributionDir();
        if (file2.exists()) {
            this.distributionDir = file2;
            return this.distributionDir;
        }
        return null;
    }

    private File getDistributionFile(String string2) {
        Log.i((String)LOGTAG, (String)"Getting file from distribution.");
        if (this.state == 0 && !this.doInit()) {
            return null;
        }
        File file = this.ensureDistributionDir();
        if (file == null) {
            return null;
        }
        File file2 = new File(file, string2);
        if (!file2.exists()) {
            Log.e((String)LOGTAG, (String)("Distribution directory exists, but no file named " + string2));
            return null;
        }
        return file2;
    }

    public DistributionDescriptor getDescriptor() {
        File file = this.getDistributionFile("preferences.json");
        if (file == null) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject(this.getFileContents(file));
            if (!jSONObject.has("Global")) {
                Log.e((String)LOGTAG, (String)"Distribution preferences.json has no Global entry!");
                return null;
            }
            return new DistributionDescriptor(jSONObject.getJSONObject("Global"));
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting distribution descriptor file.", (Throwable)iOException);
            return null;
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error parsing preferences.json", (Throwable)jSONException);
            return null;
        }
    }

    public JSONArray getBookmarks() {
        File file = this.getDistributionFile("bookmarks.json");
        if (file == null) {
            return null;
        }
        try {
            return new JSONArray(this.getFileContents(file));
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"Error getting bookmarks", (Throwable)iOException);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error parsing bookmarks.json", (Throwable)jSONException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileContents(File file) throws IOException {
        Scanner scanner = null;
        try {
            scanner = new Scanner(file, "UTF-8");
            String string2 = scanner.useDelimiter("\\A").next();
            return string2;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }

    private String getDataDir() {
        return this.context.getApplicationInfo().dataDir;
    }

    private File getSystemDistributionDir() {
        return new File("/system/" + this.context.getPackageName() + "/distribution");
    }

    public static class DistributionDescriptor {
        public final boolean valid;
        public final String id;
        public final String version;
        public final String about;
        public final Map<String, String> localizedAbout;

        public DistributionDescriptor(JSONObject jSONObject) {
            this.id = jSONObject.optString("id");
            this.version = jSONObject.optString("version");
            this.about = jSONObject.optString("about");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    if (!string3.startsWith("about.") || jSONObject.isNull(string2 = string3.substring(6))) continue;
                    hashMap.put(string2, jSONObject.getString(string3));
                }
            }
            catch (JSONException jSONException) {
                Log.w((String)Distribution.LOGTAG, (String)"Unable to completely process distribution JSON.", (Throwable)jSONException);
            }
            this.localizedAbout = Collections.unmodifiableMap(hashMap);
            this.valid = null != this.id && null != this.version && null != this.about;
        }
    }
}

