/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Bitmap;

public class CairoUtils {
    private CairoUtils() {
    }

    public static int bitsPerPixelForCairoFormat(int n) {
        switch (n) {
            case 3: {
                return 1;
            }
            case 2: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 1: {
                return 24;
            }
            case 0: {
                return 32;
            }
        }
        throw new RuntimeException("Unknown Cairo format");
    }

    public static int bitmapConfigToCairoFormat(Bitmap.Config config) {
        if (config == null) {
            return 0;
        }
        switch (config) {
            case ALPHA_8: {
                return 2;
            }
            case ARGB_4444: {
                throw new RuntimeException("ARGB_444 unsupported");
            }
            case ARGB_8888: {
                return 0;
            }
            case RGB_565: {
                return 4;
            }
        }
        throw new RuntimeException("Unknown Skia bitmap config");
    }

    public static Bitmap.Config cairoFormatTobitmapConfig(int n) {
        switch (n) {
            case 2: {
                return Bitmap.Config.ALPHA_8;
            }
            case 0: {
                return Bitmap.Config.ARGB_8888;
            }
            case 4: {
                return Bitmap.Config.RGB_565;
            }
        }
        throw new RuntimeException("Unknown CairoImage format");
    }
}

