/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.util.CharArrayBuffer;

public class ParserCursor {
    private final int lowerBound;
    private final int upperBound;
    private int pos;

    public ParserCursor(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Lower bound cannot be negative");
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("Lower bound cannot be greater then upper bound");
        }
        this.lowerBound = n;
        this.upperBound = n2;
        this.pos = n;
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public int getPos() {
        return this.pos;
    }

    public void updatePos(int n) {
        if (n < this.lowerBound) {
            throw new IndexOutOfBoundsException("pos: " + n + " < lowerBound: " + this.lowerBound);
        }
        if (n > this.upperBound) {
            throw new IndexOutOfBoundsException("pos: " + n + " > upperBound: " + this.upperBound);
        }
        this.pos = n;
    }

    public boolean atEnd() {
        return this.pos >= this.upperBound;
    }

    public String toString() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(16);
        charArrayBuffer.append('[');
        charArrayBuffer.append(Integer.toString(this.lowerBound));
        charArrayBuffer.append('>');
        charArrayBuffer.append(Integer.toString(this.pos));
        charArrayBuffer.append('>');
        charArrayBuffer.append(Integer.toString(this.upperBound));
        charArrayBuffer.append(']');
        return charArrayBuffer.toString();
    }
}

