/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Intent;
import android.os.Environment;
import android.text.format.Time;
import java.io.File;
import java.util.Queue;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.util.ActivityResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CameraImageResultHandler
implements ActivityResultHandler {
    private static final String LOGTAG = "GeckoCameraImageResultHandler";
    private final Queue<String> mFilePickerResult;
    private final ActivityHandlerHelper.FileResultHandler mHandler;
    private static String sImageName = "";

    CameraImageResultHandler(Queue<String> queue) {
        this.mFilePickerResult = queue;
        this.mHandler = null;
    }

    public CameraImageResultHandler(ActivityHandlerHelper.FileResultHandler fileResultHandler) {
        this.mHandler = fileResultHandler;
        this.mFilePickerResult = null;
    }

    public void onActivityResult(int n, Intent intent) {
        if (n != -1) {
            if (this.mFilePickerResult != null) {
                this.mFilePickerResult.offer("");
            }
            return;
        }
        File file = new File(Environment.getExternalStorageDirectory(), sImageName);
        sImageName = "";
        if (this.mFilePickerResult != null) {
            this.mFilePickerResult.offer(file.getAbsolutePath());
        }
        if (this.mHandler != null) {
            this.mHandler.gotFile(file.getAbsolutePath());
        }
    }

    static String generateImageName() {
        Time time = new Time();
        time.setToNow();
        sImageName = time.format("%Y-%m-%d %H.%M.%S") + ".jpg";
        return sImageName;
    }
}

