/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import ch.boye.httpclientandroidlib.HttpResponse;
import java.net.URI;
import java.util.concurrent.Executor;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.fxa.FxAccount20CreateDelegate;
import org.mozilla.gecko.background.fxa.FxAccount20LoginDelegate;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FxAccountClient20
extends FxAccountClient {
    protected static final String[] LOGIN_RESPONSE_REQUIRED_STRING_FIELDS = new String[]{"uid", "sessionToken"};
    protected static final String[] LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS = new String[]{"uid", "sessionToken", "keyFetchToken"};
    protected static final String[] LOGIN_RESPONSE_REQUIRED_BOOLEAN_FIELDS = new String[]{"verified"};

    public FxAccountClient20(String string2, Executor executor) {
        super(string2, executor);
    }

    public void createAccount(byte[] byArray, byte[] byArray2, boolean bl, FxAccountClient.RequestDelegate<String> requestDelegate) {
        try {
            this.createAccount(new FxAccount20CreateDelegate(byArray, byArray2, bl), requestDelegate);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
    }

    public void login(byte[] byArray, byte[] byArray2, FxAccountClient.RequestDelegate<LoginResponse> requestDelegate) {
        this.login(byArray, byArray2, false, requestDelegate);
    }

    public void loginAndGetKeys(byte[] byArray, byte[] byArray2, FxAccountClient.RequestDelegate<LoginResponse> requestDelegate) {
        this.login(byArray, byArray2, true, requestDelegate);
    }

    public void login(byte[] byArray, byte[] byArray2, final boolean bl, FxAccountClient.RequestDelegate<LoginResponse> requestDelegate) {
        JSONObject jSONObject;
        BaseResource baseResource;
        String string2 = bl ? "account/login?keys=true" : "account/login";
        try {
            baseResource = new BaseResource(new URI(this.serverURI + string2));
            jSONObject = new FxAccount20LoginDelegate(byArray, byArray2).getCreateBody();
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        baseResource.delegate = new FxAccountClient.ResourceDelegate<LoginResponse>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    String[] stringArray = !bl ? LOGIN_RESPONSE_REQUIRED_STRING_FIELDS : LOGIN_RESPONSE_REQUIRED_STRING_FIELDS_KEYS;
                    String[] stringArray2 = LOGIN_RESPONSE_REQUIRED_BOOLEAN_FIELDS;
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray, String.class);
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray2, Boolean.class);
                    String string2 = extendedJSONObject.getString("uid");
                    boolean bl2 = extendedJSONObject.getBoolean("verified");
                    byte[] byArray = Utils.hex2Byte(extendedJSONObject.getString("sessionToken"));
                    byte[] byArray2 = null;
                    if (bl) {
                        byArray2 = Utils.hex2Byte(extendedJSONObject.getString("keyFetchToken"));
                    }
                    LoginResponse loginResponse = new LoginResponse(FxAccountClient20.this.serverURI, string2, bl2, byArray, byArray2);
                    this.delegate.handleSuccess(loginResponse);
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        this.post(baseResource, jSONObject, requestDelegate);
    }

    public static class LoginResponse {
        public final String serverURI;
        public final String uid;
        public final byte[] sessionToken;
        public final boolean verified;
        public final byte[] keyFetchToken;

        public LoginResponse(String string2, String string3, boolean bl, byte[] byArray, byte[] byArray2) {
            this.serverURI = string2.endsWith("v1/") ? string2.substring(0, string2.length() - "v1/".length()) : string2;
            this.uid = string3;
            this.verified = bl;
            this.sessionToken = byArray;
            this.keyFetchToken = byArray2;
        }
    }
}

