/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.mozilla.gecko.GeckoAccessibility;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TouchEventInterceptor;
import org.mozilla.gecko.ZoomConstraints;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.GLController;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.InputConnectionHandler;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerMarginsAnimator;
import org.mozilla.gecko.gfx.LayerRenderer;
import org.mozilla.gecko.gfx.Overscroll;
import org.mozilla.gecko.gfx.OverscrollEdgeEffect;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.gfx.PointUtils;
import org.mozilla.gecko.gfx.RenderTask;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;
import org.mozilla.gecko.util.EventDispatcher;

public class LayerView
extends FrameLayout
implements Tabs.OnTabsChangedListener {
    private static String LOGTAG = "GeckoLayerView";
    private GeckoLayerClient mLayerClient;
    private PanZoomController mPanZoomController;
    private LayerMarginsAnimator mMarginsAnimator;
    private GLController mGLController = GLController.getInstance(this);
    private InputConnectionHandler mInputConnectionHandler;
    private LayerRenderer mRenderer;
    private int mPaintState = 0;
    private int mBackgroundColor = -1;
    private boolean mFullScreen;
    private SurfaceView mSurfaceView;
    private TextureView mTextureView;
    private Listener mListener;
    private final ArrayList<TouchEventInterceptor> mTouchInterceptors = new ArrayList();
    private final Overscroll mOverscroll = Build.VERSION.SDK_INT >= 14 ? new OverscrollEdgeEffect((View)this) : null;
    public static final int PAINT_START = 0;
    public static final int PAINT_BEFORE_FIRST = 1;
    public static final int PAINT_AFTER_FIRST = 2;

    public boolean shouldUseTextureView() {
        return false;
    }

    public LayerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        Tabs.registerOnTabsChangedListener(this);
    }

    public LayerView(Context context) {
        this(context, null);
    }

    public void initializeView(EventDispatcher eventDispatcher) {
        this.mLayerClient = new GeckoLayerClient(this.getContext(), this, eventDispatcher);
        if (this.mOverscroll != null) {
            this.mLayerClient.setOverscrollHandler(this.mOverscroll);
        }
        this.mPanZoomController = this.mLayerClient.getPanZoomController();
        this.mMarginsAnimator = this.mLayerClient.getLayerMarginsAnimator();
        this.mRenderer = new LayerRenderer(this);
        this.mInputConnectionHandler = null;
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        GeckoAccessibility.setDelegate(this);
    }

    private Point getEventRadius(MotionEvent motionEvent) {
        if (Build.VERSION.SDK_INT >= 9) {
            return new Point((int)motionEvent.getToolMajor() / 2, (int)motionEvent.getToolMinor() / 2);
        }
        float f = motionEvent.getSize();
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        return new Point((int)(f *= (float)Math.min(displayMetrics.heightPixels, displayMetrics.widthPixels)), (int)f);
    }

    public void geckoConnected() {
        PrefsHelper.getPref("gfx.android.rgb16.force", new PrefsHelper.PrefHandlerBase(){

            public void prefValue(String string2, boolean bl) {
                if (bl) {
                    GeckoAppShell.setScreenDepthOverride(16);
                }
            }
        });
        this.mLayerClient.notifyGeckoReady();
        this.addTouchInterceptor(new TouchEventInterceptor(){
            private PointF mInitialTouchPoint = null;

            public boolean onInterceptTouchEvent(View view, MotionEvent motionEvent) {
                return false;
            }

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent == null) {
                    return true;
                }
                int n = motionEvent.getActionMasked();
                PointF pointF = new PointF(motionEvent.getX(), motionEvent.getY());
                if (n == 0) {
                    this.mInitialTouchPoint = pointF;
                }
                if (this.mInitialTouchPoint != null && n == 2) {
                    Point point = LayerView.this.getEventRadius(motionEvent);
                    if (PointUtils.subtract(pointF, this.mInitialTouchPoint).length() < Math.max(PanZoomController.CLICK_THRESHOLD, Math.min((float)Math.min(point.x, point.y), PanZoomController.PAN_THRESHOLD))) {
                        return true;
                    }
                    this.mInitialTouchPoint = null;
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createMotionEvent(motionEvent, false));
                return true;
            }
        });
    }

    public void showSurface() {
        this.mSurfaceView.setVisibility(0);
    }

    public void hideSurface() {
        this.mSurfaceView.setVisibility(4);
    }

    public void destroy() {
        if (this.mLayerClient != null) {
            this.mLayerClient.destroy();
        }
        if (this.mRenderer != null) {
            this.mRenderer.destroy();
        }
        Tabs.unregisterOnTabsChangedListener(this);
    }

    public void addTouchInterceptor(final TouchEventInterceptor touchEventInterceptor) {
        this.post(new Runnable(){

            public void run() {
                LayerView.this.mTouchInterceptors.add(touchEventInterceptor);
            }
        });
    }

    public void removeTouchInterceptor(final TouchEventInterceptor touchEventInterceptor) {
        this.post(new Runnable(){

            public void run() {
                LayerView.this.mTouchInterceptors.remove(touchEventInterceptor);
            }
        });
    }

    private boolean runTouchInterceptors(MotionEvent motionEvent, boolean bl) {
        boolean bl2 = false;
        for (TouchEventInterceptor touchEventInterceptor : this.mTouchInterceptors) {
            if (bl) {
                bl2 |= touchEventInterceptor.onTouch((View)this, motionEvent);
                continue;
            }
            bl2 |= touchEventInterceptor.onInterceptTouchEvent((View)this, motionEvent);
        }
        return bl2;
    }

    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mLayerClient != null && this.mOverscroll != null) {
            this.mOverscroll.draw(canvas, this.getViewportMetrics());
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getActionMasked() == 0) {
            this.requestFocus();
        }
        if (this.runTouchInterceptors(motionEvent, false)) {
            return true;
        }
        if (this.mPanZoomController != null && this.mPanZoomController.onTouchEvent(motionEvent)) {
            return true;
        }
        return this.runTouchInterceptors(motionEvent, true);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        return this.runTouchInterceptors(motionEvent, true);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.mPanZoomController != null && this.mPanZoomController.onMotionEvent(motionEvent);
    }

    protected void onAttachedToWindow() {
        if (this.shouldUseTextureView()) {
            this.mTextureView = new TextureView(this.getContext());
            this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)new SurfaceTextureListener());
            this.mTextureView.setBackgroundColor(-1);
            this.addView((View)this.mTextureView, -1, -1);
        } else {
            this.setWillNotCacheDrawing(false);
            this.mSurfaceView = new LayerSurfaceView(this.getContext(), this);
            this.mSurfaceView.setBackgroundColor(-1);
            this.addView((View)this.mSurfaceView, -1, -1);
            SurfaceHolder surfaceHolder = this.mSurfaceView.getHolder();
            surfaceHolder.addCallback((SurfaceHolder.Callback)new SurfaceListener());
            surfaceHolder.setFormat(4);
        }
    }

    @RobocopTarget
    public GeckoLayerClient getLayerClient() {
        return this.mLayerClient;
    }

    public PanZoomController getPanZoomController() {
        return this.mPanZoomController;
    }

    public LayerMarginsAnimator getLayerMarginsAnimator() {
        return this.mMarginsAnimator;
    }

    public ImmutableViewportMetrics getViewportMetrics() {
        return this.mLayerClient.getViewportMetrics();
    }

    public void abortPanning() {
        if (this.mPanZoomController != null) {
            this.mPanZoomController.abortPanning();
        }
    }

    public PointF convertViewPointToLayerPoint(PointF pointF) {
        return this.mLayerClient.convertViewPointToLayerPoint(pointF);
    }

    int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
        this.requestRender();
    }

    public void setZoomConstraints(ZoomConstraints zoomConstraints) {
        this.mLayerClient.setZoomConstraints(zoomConstraints);
    }

    public void setIsRTL(boolean bl) {
        this.mLayerClient.setIsRTL(bl);
    }

    public void setInputConnectionHandler(InputConnectionHandler inputConnectionHandler) {
        this.mInputConnectionHandler = inputConnectionHandler;
        this.mLayerClient.forceRedraw(null);
    }

    public Handler getHandler() {
        if (this.mInputConnectionHandler != null) {
            return this.mInputConnectionHandler.getHandler(super.getHandler());
        }
        return super.getHandler();
    }

    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.mInputConnectionHandler != null) {
            return this.mInputConnectionHandler.onCreateInputConnection(editorInfo);
        }
        return null;
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyPreIme(n, keyEvent);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.mPanZoomController != null && this.mPanZoomController.onKeyEvent(keyEvent)) {
            return true;
        }
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyDown(n, keyEvent);
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyLongPress(n, keyEvent);
    }

    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyMultiple(n, n2, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.mInputConnectionHandler != null && this.mInputConnectionHandler.onKeyUp(n, keyEvent);
    }

    public boolean isIMEEnabled() {
        if (this.mInputConnectionHandler != null) {
            return this.mInputConnectionHandler.isIMEEnabled();
        }
        return false;
    }

    public void requestRender() {
        if (this.mListener != null) {
            this.mListener.renderRequested();
        }
    }

    public void addLayer(Layer layer) {
        this.mRenderer.addLayer(layer);
    }

    public void removeLayer(Layer layer) {
        this.mRenderer.removeLayer(layer);
    }

    public void postRenderTask(RenderTask renderTask) {
        this.mRenderer.postRenderTask(renderTask);
    }

    public void removeRenderTask(RenderTask renderTask) {
        this.mRenderer.removeRenderTask(renderTask);
    }

    public int getMaxTextureSize() {
        return this.mRenderer.getMaxTextureSize();
    }

    @RobocopTarget
    public IntBuffer getPixels() {
        return this.mRenderer.getPixels();
    }

    public void setPaintState(int n) {
        this.mPaintState = n;
    }

    public int getPaintState() {
        return this.mPaintState;
    }

    public LayerRenderer getRenderer() {
        return this.mRenderer;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    Listener getListener() {
        return this.mListener;
    }

    public GLController getGLController() {
        return this.mGLController;
    }

    private Bitmap getDrawable(String string2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        Context context = this.getContext();
        int n = context.getResources().getIdentifier(string2, "drawable", context.getPackageName());
        return BitmapUtils.decodeResource(context, n, options);
    }

    Bitmap getScrollbarImage() {
        return this.getDrawable("scrollbar");
    }

    private void onSizeChanged(int n, int n2) {
        if (!this.mGLController.isCompositorCreated()) {
            return;
        }
        this.surfaceChanged(n, n2);
        if (this.mSurfaceView == null) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.sizeChanged(n, n2);
        }
        if (this.mOverscroll != null) {
            this.mOverscroll.setSize(n, n2);
        }
    }

    private void surfaceChanged(int n, int n2) {
        this.mGLController.serverSurfaceChanged(n, n2);
        if (this.mListener != null) {
            this.mListener.surfaceChanged(n, n2);
        }
        if (this.mOverscroll != null) {
            this.mOverscroll.setSize(n, n2);
        }
    }

    private void onDestroyed() {
        this.mGLController.serverSurfaceDestroyed();
    }

    public Object getNativeWindow() {
        if (this.mSurfaceView != null) {
            return this.mSurfaceView.getHolder();
        }
        return this.mTextureView.getSurfaceTexture();
    }

    @WrapElementForJNI(allowMultithread=true, stubName="RegisterCompositorWrapper")
    public static GLController registerCxxCompositor() {
        try {
            LayerView layerView = GeckoAppShell.getLayerView();
            GLController gLController = layerView.getGLController();
            gLController.compositorCreated();
            return gLController;
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error registering compositor!", (Throwable)exception);
            return null;
        }
    }

    public void setOverScrollMode(int n) {
        if (Build.VERSION.SDK_INT >= 9) {
            super.setOverScrollMode(n);
        }
        if (this.mPanZoomController != null) {
            this.mPanZoomController.setOverScrollMode(n);
        }
    }

    public int getOverScrollMode() {
        if (this.mPanZoomController != null) {
            return this.mPanZoomController.getOverScrollMode();
        }
        if (Build.VERSION.SDK_INT >= 9) {
            return super.getOverScrollMode();
        }
        return 0;
    }

    public void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        GeckoAccessibility.onLayerViewFocusChanged(this, bl);
    }

    public void setFullScreen(boolean bl) {
        this.mFullScreen = bl;
    }

    public boolean isFullScreen() {
        return this.mFullScreen;
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        if (tabEvents == Tabs.TabEvents.VIEWPORT_CHANGE && Tabs.getInstance().isSelectedTab(tab)) {
            this.setZoomConstraints(tab.getZoomConstraints());
            this.setIsRTL(tab.getIsRTL());
        }
    }

    private class SurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private SurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            LayerView.this.onSizeChanged(n, n2);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            LayerView.this.onDestroyed();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            LayerView.this.onSizeChanged(n, n2);
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }

    private class LayerSurfaceView
    extends SurfaceView {
        LayerView mParent;

        public LayerSurfaceView(Context context, LayerView layerView2) {
            super(context);
            this.mParent = layerView2;
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            if (bl) {
                this.mParent.surfaceChanged(n3 - n, n4 - n2);
            }
        }
    }

    private class SurfaceListener
    implements SurfaceHolder.Callback {
        private SurfaceListener() {
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            LayerView.this.onSizeChanged(n2, n3);
        }

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            LayerView.this.onDestroyed();
        }
    }

    public static interface Listener {
        public void renderRequested();

        public void sizeChanged(int var1, int var2);

        public void surfaceChanged(int var1, int var2);
    }
}

