/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeListView
extends ListView
implements AdapterView.OnItemLongClickListener {
    private HomeContextMenuInfo mContextMenuInfo;
    private HomePager.OnUrlOpenListener mUrlOpenListener;
    private boolean mShowTopDivider;

    public HomeListView(Context context) {
        this(context, null);
    }

    public HomeListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.homeListViewStyle);
    }

    public HomeListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.HomeListView, n, 0);
        this.mShowTopDivider = typedArray.getBoolean(0, false);
        typedArray.recycle();
        this.setOnItemLongClickListener(this);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Drawable drawable2 = this.getDivider();
        if (this.mShowTopDivider && drawable2 != null) {
            int n = this.getDividerHeight();
            View view = new View(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, n));
            this.addHeaderView(view);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mUrlOpenListener = null;
    }

    public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
        Object object = adapterView.getItemAtPosition(n);
        if (object instanceof Cursor) {
            Cursor cursor = (Cursor)object;
            this.mContextMenuInfo = new HomeContextMenuInfo(view, n, l, cursor);
            return this.showContextMenuForChild((View)this);
        }
        this.mContextMenuInfo = null;
        return false;
    }

    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public void setOnItemClickListener(final AdapterView.OnItemClickListener onItemClickListener) {
        super.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                if (HomeListView.this.mShowTopDivider) {
                    --n;
                }
                onItemClickListener.onItemClick(adapterView, view, n, l);
            }
        });
    }

    public HomePager.OnUrlOpenListener getOnUrlOpenListener() {
        return this.mUrlOpenListener;
    }

    public void setOnUrlOpenListener(HomePager.OnUrlOpenListener onUrlOpenListener) {
        this.mUrlOpenListener = onUrlOpenListener;
    }

    public static class HomeContextMenuInfo
    extends AdapterView.AdapterContextMenuInfo {
        public int bookmarkId;
        public int historyId;
        public String url;
        public String title;
        public int display;
        public boolean isFolder;
        public boolean inReadingList;

        public HomeContextMenuInfo(View view, int n, long l, Cursor cursor) {
            super(view, n, l);
            if (cursor == null) {
                return;
            }
            int n2 = cursor.getColumnIndex("type");
            this.isFolder = n2 != -1 ? cursor.getInt(n2) == 0 : false;
            if (this.isFolder) {
                return;
            }
            this.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
            this.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
            int n3 = cursor.getColumnIndex("bookmark_id");
            this.bookmarkId = n3 == -1 ? cursor.getInt(cursor.getColumnIndexOrThrow("_id")) : (cursor.isNull(n3) ? -1 : cursor.getInt(n3));
            int n4 = cursor.getColumnIndex("history_id");
            this.historyId = n4 != -1 ? cursor.getInt(n4) : -1;
            int n5 = cursor.getColumnIndex("parent");
            this.inReadingList = n5 != -1 ? cursor.getInt(n5) == -2 : false;
            int n6 = cursor.getColumnIndex("display");
            this.display = n6 != -1 ? cursor.getInt(n6) : 0;
        }

        public String getDisplayTitle() {
            return TextUtils.isEmpty((CharSequence)this.title) ? StringUtils.stripCommonSubdomains((String)StringUtils.stripScheme((String)this.url, (int)1)) : this.title;
        }
    }
}

