/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.json.JSONArray;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.mozglue.RobocopTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SuggestClient {
    private static final String LOGTAG = "GeckoSuggestClient";
    private static final String USER_AGENT = GeckoAppShell.getGeckoInterface().getDefaultUAString();
    private final Context mContext;
    private final int mTimeout;
    private final String mSuggestTemplate;
    private final int mMaxResults;
    private boolean mCheckNetwork;
    private String mPrevQuery;
    private ArrayList<String> mPrevResults;

    public SuggestClient(Context context, String string2, int n, int n2) {
        this.mContext = context;
        this.mMaxResults = n2;
        this.mSuggestTemplate = string2;
        this.mTimeout = n;
        this.mCheckNetwork = true;
    }

    @RobocopTarget
    public SuggestClient(Context context, String string2, int n) {
        this(context, string2, n, Integer.MAX_VALUE);
        this.mCheckNetwork = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> query(String string2) {
        if (string2.equals(this.mPrevQuery)) {
            return this.mPrevResults;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (TextUtils.isEmpty((CharSequence)this.mSuggestTemplate) || TextUtils.isEmpty((CharSequence)string2)) {
            return arrayList;
        }
        if (!this.isNetworkConnected() && this.mCheckNetwork) {
            Log.i((String)LOGTAG, (String)"Not connected to network");
            return arrayList;
        }
        try {
            String string3 = URLEncoder.encode(string2, "UTF-8");
            String string4 = this.mSuggestTemplate.replace("__searchTerms__", string3);
            URL uRL = new URL(string4);
            String string5 = null;
            HttpURLConnection httpURLConnection = null;
            InputStream inputStream = null;
            try {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setConnectTimeout(this.mTimeout);
                httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
                inputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                string5 = this.convertStreamToString(inputStream);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)LOGTAG, (String)"error", (Throwable)iOException);
                    }
                }
            }
            if (string5 != null) {
                JSONArray jSONArray = new JSONArray(string5);
                JSONArray jSONArray2 = jSONArray.getJSONArray(1);
                int n = 0;
                for (int i = 0; i < jSONArray2.length() && n < this.mMaxResults; ++i) {
                    String string6 = jSONArray2.getString(i);
                    if (string6.equalsIgnoreCase(string2)) continue;
                    arrayList.add(string6);
                    ++n;
                }
            } else {
                Log.e((String)LOGTAG, (String)"Suggestion query failed");
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error", (Throwable)exception);
        }
        this.mPrevQuery = string2;
        this.mPrevResults = arrayList;
        return arrayList;
    }

    private boolean isNetworkConnected() {
        NetworkInfo networkInfo = this.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private NetworkInfo getActiveNetworkInfo() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (connectivityManager == null) {
            return null;
        }
        return connectivityManager.getActiveNetworkInfo();
    }

    private String convertStreamToString(InputStream inputStream) {
        try {
            return new Scanner(inputStream).useDelimiter("\\A").next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return "";
        }
    }
}

