/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.FaviconView;

public class TwoLinePageRow
extends LinearLayout
implements Tabs.OnTabsChangedListener {
    private static final int NO_ICON = 0;
    private final TextView mTitle;
    private final TextView mUrl;
    private final FaviconView mFavicon;
    private int mUrlIconId;
    private int mBookmarkIconId;
    private boolean mShowIcons;
    private int mLoadFaviconJobId = 0;
    private final OnFaviconLoadedListener mFaviconListener;
    private String mPageUrl;

    public TwoLinePageRow(Context context) {
        this(context, null);
    }

    public TwoLinePageRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setGravity(16);
        this.mUrlIconId = 0;
        this.mBookmarkIconId = 0;
        this.mShowIcons = true;
        LayoutInflater.from((Context)context).inflate(R.layout.two_line_page_row, (ViewGroup)this);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mUrl = (TextView)this.findViewById(R.id.url);
        this.mFavicon = (FaviconView)this.findViewById(R.id.favicon);
        this.mFaviconListener = new UpdateViewFaviconLoadedListener(this.mFavicon);
    }

    protected void onAttachedToWindow() {
        Tabs.registerOnTabsChangedListener(this);
    }

    protected void onDetachedFromWindow() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Tabs.unregisterOnTabsChangedListener(TwoLinePageRow.this);
            }
        });
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: 
            case LOCATION_CHANGE: {
                this.updateDisplayedUrl();
            }
        }
    }

    private void setTitle(String string2) {
        this.mTitle.setText((CharSequence)string2);
    }

    private void setUrl(String string2) {
        this.mUrl.setText((CharSequence)string2);
    }

    private void setUrl(int n) {
        this.mUrl.setText(n);
    }

    private void setUrlIcon(int n) {
        if (this.mUrlIconId == n) {
            return;
        }
        this.mUrlIconId = n;
        this.mUrl.setCompoundDrawablesWithIntrinsicBounds(this.mUrlIconId, 0, this.mBookmarkIconId, 0);
    }

    private void setBookmarkIcon(int n) {
        if (this.mBookmarkIconId == n) {
            return;
        }
        this.mBookmarkIconId = n;
        this.mUrl.setCompoundDrawablesWithIntrinsicBounds(this.mUrlIconId, 0, this.mBookmarkIconId, 0);
    }

    private void updateDisplayedUrl(String string2) {
        this.mPageUrl = string2;
        this.updateDisplayedUrl();
    }

    private void updateDisplayedUrl() {
        boolean bl = Tabs.getInstance().getSelectedTab().isPrivate();
        int n = Tabs.getInstance().getTabIdForUrl(this.mPageUrl, bl);
        if (!this.mShowIcons || n < 0) {
            this.setUrl(this.mPageUrl);
            this.setUrlIcon(0);
        } else {
            this.setUrl(R.string.switch_to_tab);
            this.setUrlIcon(R.drawable.ic_url_bar_tab);
        }
    }

    public void setShowIcons(boolean bl) {
        this.mShowIcons = bl;
    }

    public void updateFromCursor(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        int n = cursor.getColumnIndexOrThrow("title");
        String string2 = cursor.getString(n);
        int n2 = cursor.getColumnIndexOrThrow("url");
        String string3 = cursor.getString(n2);
        if (this.mShowIcons) {
            int n3 = cursor.getColumnIndex("bookmark_id");
            if (n3 != -1) {
                long l = cursor.getLong(n3);
                int n4 = cursor.getColumnIndex("display");
                int n5 = n4 != -1 ? cursor.getInt(n4) : 0;
                if (l == 0L) {
                    this.setBookmarkIcon(0);
                } else if (n5 == 1) {
                    this.setBookmarkIcon(R.drawable.ic_url_bar_reader);
                } else {
                    this.setBookmarkIcon(R.drawable.ic_url_bar_star);
                }
            } else {
                this.setBookmarkIcon(0);
            }
        }
        this.setTitle(TextUtils.isEmpty((CharSequence)string2) ? string3 : string2);
        if (string3.equals(this.mPageUrl)) {
            return;
        }
        this.mFavicon.clearImage();
        this.mLoadFaviconJobId = Favicons.getSizedFaviconForPageFromLocal(string3, this.mFaviconListener);
        this.updateDisplayedUrl(string3);
    }

    private static class UpdateViewFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private final WeakReference<FaviconView> view;

        public UpdateViewFaviconLoadedListener(FaviconView faviconView) {
            this.view = new WeakReference<FaviconView>(faviconView);
        }

        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            FaviconView faviconView = (FaviconView)((Object)this.view.get());
            if (faviconView == null) {
                return;
            }
            if (bitmap == null) {
                faviconView.showDefaultFavicon();
                return;
            }
            faviconView.updateImage(bitmap, string3);
        }
    }
}

