/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.net;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.impl.cookie.DateParseException;
import ch.boye.httpclientandroidlib.impl.cookie.DateUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Scanner;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;

public class SyncResponse {
    private static final String HEADER_RETRY_AFTER = "retry-after";
    private static final String LOG_TAG = "SyncResponse";
    protected HttpResponse response;
    private String body = null;

    public SyncResponse() {
    }

    public SyncResponse(HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    public HttpResponse httpResponse() {
        return this.response;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public boolean wasSuccessful() {
        return this.getStatusCode() == 200;
    }

    public String body() throws IllegalStateException, IOException {
        if (this.body != null) {
            return this.body;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(this.response.getEntity().getContent());
        this.body = new Scanner(inputStreamReader).useDelimiter("\\A").next();
        return this.body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedJSONObject jsonObjectBody() throws IllegalStateException, IOException, ParseException, NonObjectJSONException {
        if (this.body != null) {
            return ExtendedJSONObject.parseJSONObject(this.body);
        }
        HttpEntity httpEntity = this.response.getEntity();
        if (httpEntity == null) {
            throw new IOException("no entity");
        }
        InputStream inputStream = httpEntity.getContent();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            ExtendedJSONObject extendedJSONObject = ExtendedJSONObject.parseJSONObject(bufferedReader);
            return extendedJSONObject;
        }
        finally {
            inputStream.close();
        }
    }

    private boolean hasHeader(String string2) {
        return this.response.containsHeader(string2);
    }

    private static boolean missingHeader(String string2) {
        return string2 == null || string2.trim().length() == 0;
    }

    private int getIntegerHeader(String string2) throws NumberFormatException {
        if (this.hasHeader(string2)) {
            Header header = this.response.getFirstHeader(string2);
            String string3 = header.getValue();
            if (SyncResponse.missingHeader(string3)) {
                Logger.warn(LOG_TAG, string2 + " header present but empty.");
                return -1;
            }
            return Integer.parseInt(string3, 10);
        }
        return -1;
    }

    public int retryAfterInSeconds() throws NumberFormatException {
        if (!this.hasHeader(HEADER_RETRY_AFTER)) {
            return -1;
        }
        Header header = this.response.getFirstHeader(HEADER_RETRY_AFTER);
        String string2 = header.getValue();
        if (SyncResponse.missingHeader(string2)) {
            Logger.warn(LOG_TAG, "Retry-After header present but empty.");
            return -1;
        }
        try {
            return Integer.parseInt(string2, 10);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                long l = DateUtils.parseDate((String)string2).getTime();
                long l2 = System.currentTimeMillis();
                return (int)((l - l2) / 1000L);
            }
            catch (DateParseException dateParseException) {
                Logger.warn(LOG_TAG, "Retry-After header neither integer nor date: " + string2);
                return -1;
            }
        }
    }

    public int weaveBackoffInSeconds() throws NumberFormatException {
        return this.getIntegerHeader("x-weave-backoff");
    }

    public long totalBackoffInMilliseconds() {
        int n = -1;
        try {
            n = this.retryAfterInSeconds();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int n2 = -1;
        try {
            n2 = this.weaveBackoffInSeconds();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long l = Math.max(n, n2);
        if (l < 0L) {
            return -1L;
        }
        return 1000L * l;
    }

    public long normalizedWeaveTimestamp() {
        String string2 = "x-weave-timestamp";
        if (!this.hasHeader(string2)) {
            return -1L;
        }
        return Utils.decimalSecondsToMilliseconds(this.response.getFirstHeader(string2).getValue());
    }

    public int weaveRecords() throws NumberFormatException {
        return this.getIntegerHeader("x-weave-records");
    }

    public int weaveQuotaRemaining() throws NumberFormatException {
        return this.getIntegerHeader("x-weave-quota-remaining");
    }

    public String weaveAlert() {
        if (this.hasHeader("x-weave-alert")) {
            return this.response.getFirstHeader("x-weave-alert").getValue();
        }
        return null;
    }
}

