/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.CachedSQLiteOpenHelper;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.HistoryRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidBrowserHistoryDataExtender
extends CachedSQLiteOpenHelper {
    public static final String LOG_TAG = "SyncHistoryVisits";
    protected static final String DB_NAME = "history_extension_database";
    protected static final int SCHEMA_VERSION = 1;
    public static final String TBL_HISTORY_EXT = "HistoryExtension";
    public static final String COL_GUID = "guid";
    public static final String GUID_IS = "guid = ?";
    public static final String COL_VISITS = "visits";
    public static final String[] TBL_COLUMNS = new String[]{"guid", "visits"};
    private final RepoUtils.QueryHelper queryHelper;

    public AndroidBrowserHistoryDataExtender(Context context) {
        super(context, DB_NAME, null, 1);
        this.queryHelper = new RepoUtils.QueryHelper(context, null, LOG_TAG);
    }

    public void onCreate(SQLiteDatabase sQLiteDatabase) {
        String string2 = "CREATE TABLE HistoryExtension (guid TEXT PRIMARY KEY, visits TEXT)";
        sQLiteDatabase.execSQL(string2);
    }

    public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
        sQLiteDatabase.execSQL("DROP TABLE IF EXISTS HistoryExtension");
        this.onCreate(sQLiteDatabase);
    }

    public void wipe() {
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        this.onUpgrade(sQLiteDatabase, 1, 1);
    }

    protected void store(SQLiteDatabase sQLiteDatabase, String string2, JSONArray jSONArray) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(COL_GUID, string2);
        if (jSONArray == null) {
            contentValues.put(COL_VISITS, "[]");
        } else {
            contentValues.put(COL_VISITS, jSONArray.toJSONString());
        }
        String[] stringArray = new String[]{string2};
        int n = sQLiteDatabase.update(TBL_HISTORY_EXT, contentValues, GUID_IS, stringArray);
        if (n >= 1) {
            Logger.debug(LOG_TAG, "Replaced history extension record for row with GUID " + string2);
        } else {
            long l = sQLiteDatabase.insert(TBL_HISTORY_EXT, null, contentValues);
            Logger.debug(LOG_TAG, "Inserted history extension record into row: " + l);
        }
    }

    public void store(String string2, JSONArray jSONArray) {
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        this.store(sQLiteDatabase, string2, jSONArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkInsert(ArrayList<HistoryRecord> arrayList) {
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        try {
            sQLiteDatabase.beginTransaction();
            for (HistoryRecord historyRecord : arrayList) {
                this.store(sQLiteDatabase, historyRecord.guid, historyRecord.visits);
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLException sQLException) {
            Logger.error(LOG_TAG, "Caught exception in bulkInsert new history visits.", sQLException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    public Cursor fetch(String string2) throws NullCursorException {
        String[] stringArray = new String[]{string2};
        SQLiteDatabase sQLiteDatabase = this.getCachedReadableDatabase();
        Cursor cursor = this.queryHelper.safeQuery(sQLiteDatabase, ".fetch", TBL_HISTORY_EXT, TBL_COLUMNS, GUID_IS, stringArray);
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray visitsForGUID(String string2) throws NullCursorException {
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Asked for visits for null GUID.");
            return new JSONArray();
        }
        Logger.debug(LOG_TAG, "Fetching visits for GUID " + string2);
        Cursor cursor = this.fetch(string2);
        try {
            if (!cursor.moveToFirst()) {
                JSONArray jSONArray = new JSONArray();
                return jSONArray;
            }
            JSONArray jSONArray = RepoUtils.getJSONArrayFromCursor(cursor, COL_VISITS);
            return jSONArray;
        }
        finally {
            cursor.close();
        }
    }

    public int delete(String string2) {
        String[] stringArray = new String[]{string2};
        SQLiteDatabase sQLiteDatabase = this.getCachedWritableDatabase();
        return sQLiteDatabase.delete(TBL_HISTORY_EXT, GUID_IS, stringArray);
    }

    public Cursor fetchAll() throws NullCursorException {
        SQLiteDatabase sQLiteDatabase = this.getCachedReadableDatabase();
        Cursor cursor = this.queryHelper.safeQuery(sQLiteDatabase, ".fetchAll", TBL_HISTORY_EXT, TBL_COLUMNS, null, null);
        return cursor;
    }
}

