/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.net.Uri;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.db.BrowserContract;

public class BrowserContractHelpers
extends BrowserContract {
    public static final Uri BOOKMARKS_CONTENT_URI = BrowserContractHelpers.withSyncAndDeleted(BrowserContract.Bookmarks.CONTENT_URI);
    public static final Uri BOOKMARKS_PARENTS_CONTENT_URI = BrowserContractHelpers.withSyncAndDeleted(BrowserContract.Bookmarks.PARENTS_CONTENT_URI);
    public static final Uri BOOKMARKS_POSITIONS_CONTENT_URI = BrowserContractHelpers.withSyncAndDeleted(BrowserContract.Bookmarks.POSITIONS_CONTENT_URI);
    public static final Uri HISTORY_CONTENT_URI = BrowserContractHelpers.withSyncAndDeleted(BrowserContract.History.CONTENT_URI);
    public static final Uri SCHEMA_CONTENT_URI = BrowserContractHelpers.withSyncAndDeleted(BrowserContract.Schema.CONTENT_URI);
    public static final Uri PASSWORDS_CONTENT_URI = BrowserContractHelpers.withSyncAndDeleted(BrowserContract.Passwords.CONTENT_URI);
    public static final Uri DELETED_PASSWORDS_CONTENT_URI = BrowserContractHelpers.withSyncAndDeleted(BrowserContract.DeletedPasswords.CONTENT_URI);
    public static final Uri FORM_HISTORY_CONTENT_URI = BrowserContractHelpers.withSync(BrowserContract.FormHistory.CONTENT_URI);
    public static final Uri DELETED_FORM_HISTORY_CONTENT_URI = BrowserContractHelpers.withSync(BrowserContract.DeletedFormHistory.CONTENT_URI);
    public static final String[] PasswordColumns = new String[]{"id", "hostname", "httpRealm", "formSubmitURL", "usernameField", "passwordField", "encryptedUsername", "encryptedPassword", "encType", "timeCreated", "timeLastUsed", "timePasswordChanged", "timesUsed", "guid"};
    public static final String[] HistoryColumns = new String[]{"_id", "guid", "created", "modified", "deleted", "title", "url", "date", "visits"};
    public static final String[] BookmarkColumns = new String[]{"_id", "guid", "created", "modified", "deleted", "title", "url", "type", "parent", "position", "tags", "description", "keyword"};
    public static final String[] FormHistoryColumns = new String[]{"id", "guid", "fieldname", "value", "timesUsed", "firstUsed", "lastUsed"};
    public static final String[] DeletedColumns = new String[]{"id", "guid", "timeDeleted"};
    public static final String[] BOOKMARK_TYPE_CODE_TO_STRING = new String[]{"folder", "bookmark", "separator", "livemark", "query"};
    private static final int MAX_BOOKMARK_TYPE_CODE = BOOKMARK_TYPE_CODE_TO_STRING.length - 1;
    public static final Map<String, Integer> BOOKMARK_TYPE_STRING_TO_CODE;

    protected static Uri withSyncAndDeleted(Uri uri) {
        return uri.buildUpon().appendQueryParameter("sync", "true").appendQueryParameter("show_deleted", "true").build();
    }

    protected static Uri withSync(Uri uri) {
        return uri.buildUpon().appendQueryParameter("sync", "true").build();
    }

    public static String typeStringForCode(int n) {
        if (0 <= n && n <= MAX_BOOKMARK_TYPE_CODE) {
            return BOOKMARK_TYPE_CODE_TO_STRING[n];
        }
        return null;
    }

    public static int typeCodeForString(String string2) {
        Integer n = BOOKMARK_TYPE_STRING_TO_CODE.get(string2);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static boolean isSupportedType(String string2) {
        return BOOKMARK_TYPE_STRING_TO_CODE.containsKey(string2);
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("folder", 0);
        hashMap.put("bookmark", 1);
        hashMap.put("separator", 2);
        hashMap.put("livemark", 3);
        hashMap.put("query", 4);
        BOOKMARK_TYPE_STRING_TO_CODE = Collections.unmodifiableMap(hashMap);
    }
}

