/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.Context;
import android.database.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.mozilla.gecko.sync.CommandProcessor;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.ClientsDatabase;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientsDatabaseAccessor {
    public static final String PROFILE_ID = "default";
    public static final String LOG_TAG = "ClientsDatabaseAccessor";
    private ClientsDatabase db;

    public ClientsDatabaseAccessor() {
    }

    public ClientsDatabaseAccessor(Context context) {
        this.db = new ClientsDatabase(context);
    }

    public void store(ClientRecord clientRecord) {
        this.db.store(this.getProfileId(), clientRecord);
    }

    public void store(Collection<ClientRecord> collection) {
        for (ClientRecord clientRecord : collection) {
            this.store(clientRecord);
        }
    }

    public void store(String string2, CommandProcessor.Command command) throws NullCursorException {
        this.db.store(string2, command.commandType, command.args.toJSONString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRecord fetchClient(String string2) throws NullCursorException {
        Cursor cursor = this.db.fetchClientsCursor(string2, this.getProfileId());
        try {
            if (!cursor.moveToFirst()) {
                ClientRecord clientRecord = null;
                return clientRecord;
            }
            ClientRecord clientRecord = ClientsDatabaseAccessor.recordFromCursor(cursor);
            return clientRecord;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ClientRecord> fetchAllClients() throws NullCursorException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Cursor cursor = this.db.fetchAllClients();
        try {
            Object object;
            if (!cursor.moveToFirst()) {
                Map<String, ClientRecord> map = Collections.unmodifiableMap(hashMap);
                return map;
            }
            while (!cursor.isAfterLast()) {
                object = ClientsDatabaseAccessor.recordFromCursor(cursor);
                hashMap.put(((ClientRecord)object).guid, object);
                cursor.moveToNext();
            }
            object = Collections.unmodifiableMap(hashMap);
            return object;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommandProcessor.Command> fetchAllCommands() throws NullCursorException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Cursor cursor = this.db.fetchAllCommands();
        try {
            Object object;
            if (!cursor.moveToFirst()) {
                List<CommandProcessor.Command> list = Collections.unmodifiableList(arrayList);
                return list;
            }
            while (!cursor.isAfterLast()) {
                object = ClientsDatabaseAccessor.commandFromCursor(cursor);
                arrayList.add(object);
                cursor.moveToNext();
            }
            object = Collections.unmodifiableList(arrayList);
            return object;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommandProcessor.Command> fetchCommandsForClient(String string2) throws NullCursorException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Cursor cursor = this.db.fetchCommandsForClient(string2);
        try {
            Object object;
            if (!cursor.moveToFirst()) {
                List<CommandProcessor.Command> list = Collections.unmodifiableList(arrayList);
                return list;
            }
            while (!cursor.isAfterLast()) {
                object = ClientsDatabaseAccessor.commandFromCursor(cursor);
                arrayList.add(object);
                cursor.moveToNext();
            }
            object = Collections.unmodifiableList(arrayList);
            return object;
        }
        finally {
            cursor.close();
        }
    }

    protected static ClientRecord recordFromCursor(Cursor cursor) {
        String string2 = RepoUtils.getStringFromCursor(cursor, "guid");
        String string3 = RepoUtils.getStringFromCursor(cursor, "name");
        String string4 = RepoUtils.getStringFromCursor(cursor, "device_type");
        ClientRecord clientRecord = new ClientRecord(string2);
        clientRecord.name = string3;
        clientRecord.type = string4;
        return clientRecord;
    }

    protected static CommandProcessor.Command commandFromCursor(Cursor cursor) {
        String string2 = RepoUtils.getStringFromCursor(cursor, "command");
        JSONArray jSONArray = RepoUtils.getJSONArrayFromCursor(cursor, "args");
        return new CommandProcessor.Command(string2, jSONArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clientsCount() {
        int n;
        Cursor cursor = this.db.fetchAllClients();
        try {
            n = cursor.getCount();
        }
        catch (Throwable throwable) {
            try {
                cursor.close();
                throw throwable;
            }
            catch (NullCursorException nullCursorException) {
                return 0;
            }
        }
        cursor.close();
        return n;
    }

    private String getProfileId() {
        return PROFILE_ID;
    }

    public void wipeDB() {
        this.db.wipeDB();
    }

    public void wipeClientsTable() {
        this.db.wipeClientsTable();
    }

    public void wipeCommandsTable() {
        this.db.wipeCommandsTable();
    }

    public void close() {
        this.db.close();
    }
}

