/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.utils;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Stack;

@Immutable
public class URIUtils {
    public static URI createURI(String string, String string2, int n, String string3, String string4, String string5) throws URISyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append("://");
            }
            stringBuilder.append(string2);
            if (n > 0) {
                stringBuilder.append(':');
                stringBuilder.append(n);
            }
        }
        if (string3 == null || !string3.startsWith("/")) {
            stringBuilder.append('/');
        }
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        if (string4 != null) {
            stringBuilder.append('?');
            stringBuilder.append(string4);
        }
        if (string5 != null) {
            stringBuilder.append('#');
            stringBuilder.append(string5);
        }
        return new URI(stringBuilder.toString());
    }

    public static URI rewriteURI(URI uRI, HttpHost httpHost, boolean bl) throws URISyntaxException {
        if (uRI == null) {
            throw new IllegalArgumentException("URI may nor be null");
        }
        if (httpHost != null) {
            return URIUtils.createURI(httpHost.getSchemeName(), httpHost.getHostName(), httpHost.getPort(), URIUtils.normalizePath(uRI.getRawPath()), uRI.getRawQuery(), bl ? null : uRI.getRawFragment());
        }
        return URIUtils.createURI(null, null, -1, URIUtils.normalizePath(uRI.getRawPath()), uRI.getRawQuery(), bl ? null : uRI.getRawFragment());
    }

    private static String normalizePath(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length() && string.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            string = string.substring(n - 1);
        }
        return string;
    }

    public static URI rewriteURI(URI uRI, HttpHost httpHost) throws URISyntaxException {
        return URIUtils.rewriteURI(uRI, httpHost, false);
    }

    public static URI resolve(URI uRI, String string) {
        return URIUtils.resolve(uRI, URI.create(string));
    }

    public static URI resolve(URI uRI, URI uRI2) {
        boolean bl;
        if (uRI == null) {
            throw new IllegalArgumentException("Base URI may nor be null");
        }
        if (uRI2 == null) {
            throw new IllegalArgumentException("Reference URI may nor be null");
        }
        String string = uRI2.toString();
        if (string.startsWith("?")) {
            return URIUtils.resolveReferenceStartingWithQueryString(uRI, uRI2);
        }
        boolean bl2 = bl = string.length() == 0;
        if (bl) {
            uRI2 = URI.create("#");
        }
        URI uRI3 = uRI.resolve(uRI2);
        if (bl) {
            String string2 = uRI3.toString();
            uRI3 = URI.create(string2.substring(0, string2.indexOf(35)));
        }
        return URIUtils.removeDotSegments(uRI3);
    }

    private static URI resolveReferenceStartingWithQueryString(URI uRI, URI uRI2) {
        String string = uRI.toString();
        string = string.indexOf(63) > -1 ? string.substring(0, string.indexOf(63)) : string;
        return URI.create(string + uRI2.toString());
    }

    private static URI removeDotSegments(URI uRI) {
        String string = uRI.getPath();
        if (string == null || string.indexOf("/.") == -1) {
            return uRI;
        }
        String[] stringArray = string.split("/");
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0 || ".".equals(stringArray[i])) continue;
            if ("..".equals(stringArray[i])) {
                if (stack.isEmpty()) continue;
                stack.pop();
                continue;
            }
            stack.push(stringArray[i]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stack) {
            stringBuilder.append('/').append(string2);
        }
        try {
            return new URI(uRI.getScheme(), uRI.getAuthority(), stringBuilder.toString(), uRI.getQuery(), uRI.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    public static HttpHost extractHost(URI uRI) {
        if (uRI == null) {
            return null;
        }
        HttpHost httpHost = null;
        if (uRI.isAbsolute()) {
            int n = uRI.getPort();
            String string = uRI.getHost();
            if (string == null && (string = uRI.getAuthority()) != null) {
                int n2;
                int n3 = string.indexOf(64);
                if (n3 >= 0) {
                    string = string.length() > n3 + 1 ? string.substring(n3 + 1) : null;
                }
                if (string != null && (n2 = string.indexOf(58)) >= 0) {
                    if (n2 + 1 < string.length()) {
                        n = Integer.parseInt(string.substring(n2 + 1));
                    }
                    string = string.substring(0, n2);
                }
            }
            String string2 = uRI.getScheme();
            if (string != null) {
                httpHost = new HttpHost(string, n, string2);
            }
        }
        return httpHost;
    }

    private URIUtils() {
    }
}

