/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.utils;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.message.BasicNameValuePair;
import ch.boye.httpclientandroidlib.util.EntityUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class URLEncodedUtils {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";

    public static List<NameValuePair> parse(URI uRI, String string) {
        List<NameValuePair> list = Collections.emptyList();
        String string2 = uRI.getRawQuery();
        if (string2 != null && string2.length() > 0) {
            list = new ArrayList<NameValuePair>();
            URLEncodedUtils.parse(list, new Scanner(string2), string);
        }
        return list;
    }

    public static List<NameValuePair> parse(HttpEntity httpEntity) throws IOException {
        Object object;
        List<NameValuePair> list = Collections.emptyList();
        String string = null;
        String string2 = null;
        Header header = httpEntity.getContentType();
        if (header != null && ((HeaderElement[])(object = header.getElements())).length > 0) {
            HeaderElement headerElement = object[0];
            string = headerElement.getName();
            NameValuePair nameValuePair = headerElement.getParameterByName("charset");
            if (nameValuePair != null) {
                string2 = nameValuePair.getValue();
            }
        }
        if (string != null && string.equalsIgnoreCase(CONTENT_TYPE) && (object = EntityUtils.toString(httpEntity, "ASCII")) != null && ((String)object).length() > 0) {
            list = new ArrayList<NameValuePair>();
            URLEncodedUtils.parse(list, new Scanner((String)object), string2);
        }
        return list;
    }

    public static boolean isEncoded(HttpEntity httpEntity) {
        Header header = httpEntity.getContentType();
        if (header != null) {
            HeaderElement[] headerElementArray = header.getElements();
            if (headerElementArray.length > 0) {
                String string = headerElementArray[0].getName();
                return string.equalsIgnoreCase(CONTENT_TYPE);
            }
            return false;
        }
        return false;
    }

    public static void parse(List<NameValuePair> list, Scanner scanner, String string) {
        scanner.useDelimiter(PARAMETER_SEPARATOR);
        while (scanner.hasNext()) {
            String[] stringArray = scanner.next().split(NAME_VALUE_SEPARATOR);
            if (stringArray.length == 0 || stringArray.length > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String string2 = URLEncodedUtils.decode(stringArray[0], string);
            String string3 = null;
            if (stringArray.length == 2) {
                string3 = URLEncodedUtils.decode(stringArray[1], string);
            }
            list.add(new BasicNameValuePair(string2, string3));
        }
    }

    public static String format(List<? extends NameValuePair> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (NameValuePair nameValuePair : list) {
            String string2;
            String string3 = URLEncodedUtils.encode(nameValuePair.getName(), string);
            String string4 = nameValuePair.getValue();
            String string5 = string2 = string4 != null ? URLEncodedUtils.encode(string4, string) : "";
            if (stringBuilder.length() > 0) {
                stringBuilder.append(PARAMETER_SEPARATOR);
            }
            stringBuilder.append(string3);
            stringBuilder.append(NAME_VALUE_SEPARATOR);
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String decode(String string, String string2) {
        try {
            return URLDecoder.decode(string, string2 != null ? string2 : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }

    private static String encode(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2 != null ? string2 : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }
}

