/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseFactory;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.conn.OperatedClientConnection;
import ch.boye.httpclientandroidlib.impl.SocketHttpClientConnection;
import ch.boye.httpclientandroidlib.impl.conn.DefaultResponseParser;
import ch.boye.httpclientandroidlib.impl.conn.LoggingSessionInputBuffer;
import ch.boye.httpclientandroidlib.impl.conn.LoggingSessionOutputBuffer;
import ch.boye.httpclientandroidlib.impl.conn.Wire;
import ch.boye.httpclientandroidlib.io.HttpMessageParser;
import ch.boye.httpclientandroidlib.io.SessionInputBuffer;
import ch.boye.httpclientandroidlib.io.SessionOutputBuffer;
import ch.boye.httpclientandroidlib.params.HttpParams;
import ch.boye.httpclientandroidlib.params.HttpProtocolParams;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

@NotThreadSafe
public class DefaultClientConnection
extends SocketHttpClientConnection
implements OperatedClientConnection,
HttpContext {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    public HttpClientAndroidLog headerLog = new HttpClientAndroidLog("ch.boye.httpclientandroidlib.headers");
    public HttpClientAndroidLog wireLog = new HttpClientAndroidLog("ch.boye.httpclientandroidlib.wire");
    private volatile Socket socket;
    private HttpHost targetHost;
    private boolean connSecure;
    private volatile boolean shutdown;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    public final boolean isSecure() {
        return this.connSecure;
    }

    public final Socket getSocket() {
        return this.socket;
    }

    public void opening(Socket socket, HttpHost httpHost) throws IOException {
        this.assertNotOpen();
        this.socket = socket;
        this.targetHost = httpHost;
        if (this.shutdown) {
            socket.close();
            throw new IOException("Connection already shutdown");
        }
    }

    public void openCompleted(boolean bl, HttpParams httpParams) throws IOException {
        this.assertNotOpen();
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.connSecure = bl;
        this.bind(this.socket, httpParams);
    }

    public void shutdown() throws IOException {
        this.shutdown = true;
        try {
            super.shutdown();
            this.log.debug("Connection shut down");
            Socket socket = this.socket;
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            this.log.debug("I/O error shutting down connection", iOException);
        }
    }

    public void close() throws IOException {
        try {
            super.close();
            this.log.debug("Connection closed");
        }
        catch (IOException iOException) {
            this.log.debug("I/O error closing connection", iOException);
        }
    }

    protected SessionInputBuffer createSessionInputBuffer(Socket socket, int n, HttpParams httpParams) throws IOException {
        if (n == -1) {
            n = 8192;
        }
        SessionInputBuffer sessionInputBuffer = super.createSessionInputBuffer(socket, n, httpParams);
        if (this.wireLog.isDebugEnabled()) {
            sessionInputBuffer = new LoggingSessionInputBuffer(sessionInputBuffer, new Wire(this.wireLog), HttpProtocolParams.getHttpElementCharset(httpParams));
        }
        return sessionInputBuffer;
    }

    protected SessionOutputBuffer createSessionOutputBuffer(Socket socket, int n, HttpParams httpParams) throws IOException {
        if (n == -1) {
            n = 8192;
        }
        SessionOutputBuffer sessionOutputBuffer = super.createSessionOutputBuffer(socket, n, httpParams);
        if (this.wireLog.isDebugEnabled()) {
            sessionOutputBuffer = new LoggingSessionOutputBuffer(sessionOutputBuffer, new Wire(this.wireLog), HttpProtocolParams.getHttpElementCharset(httpParams));
        }
        return sessionOutputBuffer;
    }

    protected HttpMessageParser createResponseParser(SessionInputBuffer sessionInputBuffer, HttpResponseFactory httpResponseFactory, HttpParams httpParams) {
        return new DefaultResponseParser(sessionInputBuffer, null, httpResponseFactory, httpParams);
    }

    public void update(Socket socket, HttpHost httpHost, boolean bl, HttpParams httpParams) throws IOException {
        this.assertOpen();
        if (httpHost == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (socket != null) {
            this.socket = socket;
            this.bind(socket, httpParams);
        }
        this.targetHost = httpHost;
        this.connSecure = bl;
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        HttpResponse httpResponse = super.receiveResponseHeader();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Receiving response: " + httpResponse.getStatusLine());
        }
        if (this.headerLog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerLog.debug("<< " + httpResponse.getStatusLine().toString());
            for (Header header : headerArray = httpResponse.getAllHeaders()) {
                this.headerLog.debug("<< " + header.toString());
            }
        }
        return httpResponse;
    }

    public void sendRequestHeader(HttpRequest httpRequest) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending request: " + httpRequest.getRequestLine());
        }
        super.sendRequestHeader(httpRequest);
        if (this.headerLog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerLog.debug(">> " + httpRequest.getRequestLine().toString());
            for (Header header : headerArray = httpRequest.getAllHeaders()) {
                this.headerLog.debug(">> " + header.toString());
            }
        }
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }
}

