/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.protocol;

import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpRequestInterceptor;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseInterceptor;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.protocol.HttpProcessor;
import ch.boye.httpclientandroidlib.protocol.HttpRequestInterceptorList;
import ch.boye.httpclientandroidlib.protocol.HttpResponseInterceptorList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BasicHttpProcessor
implements HttpProcessor,
HttpRequestInterceptorList,
HttpResponseInterceptorList,
Cloneable {
    protected final List requestInterceptors = new ArrayList();
    protected final List responseInterceptors = new ArrayList();

    public void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        if (httpRequestInterceptor == null) {
            return;
        }
        this.requestInterceptors.add(httpRequestInterceptor);
    }

    public void addRequestInterceptor(HttpRequestInterceptor httpRequestInterceptor, int n) {
        if (httpRequestInterceptor == null) {
            return;
        }
        this.requestInterceptors.add(n, httpRequestInterceptor);
    }

    public void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor, int n) {
        if (httpResponseInterceptor == null) {
            return;
        }
        this.responseInterceptors.add(n, httpResponseInterceptor);
    }

    public void removeRequestInterceptorByClass(Class clazz) {
        Iterator iterator = this.requestInterceptors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!e.getClass().equals(clazz)) continue;
            iterator.remove();
        }
    }

    public void removeResponseInterceptorByClass(Class clazz) {
        Iterator iterator = this.responseInterceptors.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!e.getClass().equals(clazz)) continue;
            iterator.remove();
        }
    }

    public final void addInterceptor(HttpRequestInterceptor httpRequestInterceptor) {
        this.addRequestInterceptor(httpRequestInterceptor);
    }

    public final void addInterceptor(HttpRequestInterceptor httpRequestInterceptor, int n) {
        this.addRequestInterceptor(httpRequestInterceptor, n);
    }

    public int getRequestInterceptorCount() {
        return this.requestInterceptors.size();
    }

    public HttpRequestInterceptor getRequestInterceptor(int n) {
        if (n < 0 || n >= this.requestInterceptors.size()) {
            return null;
        }
        return (HttpRequestInterceptor)this.requestInterceptors.get(n);
    }

    public void clearRequestInterceptors() {
        this.requestInterceptors.clear();
    }

    public void addResponseInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        if (httpResponseInterceptor == null) {
            return;
        }
        this.responseInterceptors.add(httpResponseInterceptor);
    }

    public final void addInterceptor(HttpResponseInterceptor httpResponseInterceptor) {
        this.addResponseInterceptor(httpResponseInterceptor);
    }

    public final void addInterceptor(HttpResponseInterceptor httpResponseInterceptor, int n) {
        this.addResponseInterceptor(httpResponseInterceptor, n);
    }

    public int getResponseInterceptorCount() {
        return this.responseInterceptors.size();
    }

    public HttpResponseInterceptor getResponseInterceptor(int n) {
        if (n < 0 || n >= this.responseInterceptors.size()) {
            return null;
        }
        return (HttpResponseInterceptor)this.responseInterceptors.get(n);
    }

    public void clearResponseInterceptors() {
        this.responseInterceptors.clear();
    }

    public void setInterceptors(List list) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        this.requestInterceptors.clear();
        this.responseInterceptors.clear();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof HttpRequestInterceptor) {
                this.addInterceptor((HttpRequestInterceptor)e);
            }
            if (!(e instanceof HttpResponseInterceptor)) continue;
            this.addInterceptor((HttpResponseInterceptor)e);
        }
    }

    public void clearInterceptors() {
        this.clearRequestInterceptors();
        this.clearResponseInterceptors();
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws IOException, HttpException {
        for (int i = 0; i < this.requestInterceptors.size(); ++i) {
            HttpRequestInterceptor httpRequestInterceptor = (HttpRequestInterceptor)this.requestInterceptors.get(i);
            httpRequestInterceptor.process(httpRequest, httpContext);
        }
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws IOException, HttpException {
        for (int i = 0; i < this.responseInterceptors.size(); ++i) {
            HttpResponseInterceptor httpResponseInterceptor = (HttpResponseInterceptor)this.responseInterceptors.get(i);
            httpResponseInterceptor.process(httpResponse, httpContext);
        }
    }

    protected void copyInterceptors(BasicHttpProcessor basicHttpProcessor) {
        basicHttpProcessor.requestInterceptors.clear();
        basicHttpProcessor.requestInterceptors.addAll(this.requestInterceptors);
        basicHttpProcessor.responseInterceptors.clear();
        basicHttpProcessor.responseInterceptors.addAll(this.responseInterceptors);
    }

    public BasicHttpProcessor copy() {
        BasicHttpProcessor basicHttpProcessor = new BasicHttpProcessor();
        this.copyInterceptors(basicHttpProcessor);
        return basicHttpProcessor;
    }

    public Object clone() throws CloneNotSupportedException {
        BasicHttpProcessor basicHttpProcessor = (BasicHttpProcessor)super.clone();
        this.copyInterceptors(basicHttpProcessor);
        return basicHttpProcessor;
    }
}

