/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseInterceptor;
import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;

public class ResponseConnControl
implements HttpResponseInterceptor {
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Header header;
        Object object;
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        int n = httpResponse.getStatusLine().getStatusCode();
        if (n == 400 || n == 408 || n == 411 || n == 413 || n == 414 || n == 503 || n == 501) {
            httpResponse.setHeader("Connection", "Close");
            return;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            object = httpResponse.getStatusLine().getProtocolVersion();
            if (httpEntity.getContentLength() < 0L && (!httpEntity.isChunked() || ((ProtocolVersion)object).lessEquals(HttpVersion.HTTP_1_0))) {
                httpResponse.setHeader("Connection", "Close");
                return;
            }
        }
        if ((object = (HttpRequest)httpContext.getAttribute("http.request")) != null && (header = object.getFirstHeader("Connection")) != null) {
            httpResponse.setHeader("Connection", header.getValue());
        }
    }
}

