/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.conn.ssl;

import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.conn.ConnectTimeoutException;
import ch.boye.httpclientandroidlib.conn.scheme.HostNameResolver;
import ch.boye.httpclientandroidlib.conn.scheme.LayeredSchemeSocketFactory;
import ch.boye.httpclientandroidlib.conn.scheme.LayeredSocketFactory;
import ch.boye.httpclientandroidlib.conn.ssl.AllowAllHostnameVerifier;
import ch.boye.httpclientandroidlib.conn.ssl.BrowserCompatHostnameVerifier;
import ch.boye.httpclientandroidlib.conn.ssl.StrictHostnameVerifier;
import ch.boye.httpclientandroidlib.conn.ssl.TrustManagerDecorator;
import ch.boye.httpclientandroidlib.conn.ssl.TrustStrategy;
import ch.boye.httpclientandroidlib.conn.ssl.X509HostnameVerifier;
import ch.boye.httpclientandroidlib.params.HttpConnectionParams;
import ch.boye.httpclientandroidlib.params.HttpParams;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

@ThreadSafe
public class SSLSocketFactory
implements LayeredSchemeSocketFactory,
LayeredSocketFactory {
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    public static final String SSLV2 = "SSLv2";
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private final javax.net.ssl.SSLSocketFactory socketfactory;
    private final HostNameResolver nameResolver;
    private volatile X509HostnameVerifier hostnameVerifier;

    public static SSLSocketFactory getSocketFactory() {
        return new SSLSocketFactory();
    }

    private static SSLContext createSSLContext(String string, KeyStore keyStore, String string2, KeyStore keyStore2, SecureRandom secureRandom, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        if (string == null) {
            string = TLS;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string2 != null ? string2.toCharArray() : null);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore2);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray != null && trustStrategy != null) {
            for (int i = 0; i < trustManagerArray.length; ++i) {
                TrustManager trustManager = trustManagerArray[i];
                if (!(trustManager instanceof X509TrustManager)) continue;
                trustManagerArray[i] = new TrustManagerDecorator((X509TrustManager)trustManager, trustStrategy);
            }
        }
        SSLContext sSLContext = SSLContext.getInstance(string);
        sSLContext.init(keyManagerArray, trustManagerArray, secureRandom);
        return sSLContext;
    }

    private static SSLContext createDefaultSSLContext() {
        try {
            return SSLSocketFactory.createSSLContext(TLS, null, null, null, null, null);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failure initializing default SSL context", exception);
        }
    }

    @Deprecated
    public SSLSocketFactory(String string, KeyStore keyStore, String string2, KeyStore keyStore2, SecureRandom secureRandom, HostNameResolver hostNameResolver) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLSocketFactory.createSSLContext(string, keyStore, string2, keyStore2, secureRandom, null), hostNameResolver);
    }

    public SSLSocketFactory(String string, KeyStore keyStore, String string2, KeyStore keyStore2, SecureRandom secureRandom, X509HostnameVerifier x509HostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLSocketFactory.createSSLContext(string, keyStore, string2, keyStore2, secureRandom, null), x509HostnameVerifier);
    }

    public SSLSocketFactory(String string, KeyStore keyStore, String string2, KeyStore keyStore2, SecureRandom secureRandom, TrustStrategy trustStrategy, X509HostnameVerifier x509HostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(SSLSocketFactory.createSSLContext(string, keyStore, string2, keyStore2, secureRandom, trustStrategy), x509HostnameVerifier);
    }

    public SSLSocketFactory(KeyStore keyStore, String string, KeyStore keyStore2) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, keyStore, string, keyStore2, null, null, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(KeyStore keyStore, String string) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, keyStore, string, null, null, null, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(KeyStore keyStore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, null, null, keyStore, null, null, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(TrustStrategy trustStrategy, X509HostnameVerifier x509HostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, null, null, null, null, trustStrategy, x509HostnameVerifier);
    }

    public SSLSocketFactory(TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        this(TLS, null, null, null, null, trustStrategy, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(SSLContext sSLContext) {
        this(sSLContext, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    @Deprecated
    public SSLSocketFactory(SSLContext sSLContext, HostNameResolver hostNameResolver) {
        this.socketfactory = sSLContext.getSocketFactory();
        this.hostnameVerifier = BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
        this.nameResolver = hostNameResolver;
    }

    public SSLSocketFactory(SSLContext sSLContext, X509HostnameVerifier x509HostnameVerifier) {
        this.socketfactory = sSLContext.getSocketFactory();
        this.hostnameVerifier = x509HostnameVerifier;
        this.nameResolver = null;
    }

    private SSLSocketFactory() {
        this(SSLSocketFactory.createDefaultSSLContext());
    }

    public Socket createSocket(HttpParams httpParams) throws IOException {
        return this.socketfactory.createSocket();
    }

    @Deprecated
    public Socket createSocket() throws IOException {
        return this.socketfactory.createSocket();
    }

    public Socket connectSocket(Socket socket, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        Socket socket2;
        if (inetSocketAddress == null) {
            throw new IllegalArgumentException("Remote address may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Socket socket3 = socket2 = socket != null ? socket : new Socket();
        if (inetSocketAddress2 != null) {
            socket2.setReuseAddress(HttpConnectionParams.getSoReuseaddr(httpParams));
            socket2.bind(inetSocketAddress2);
        }
        int n = HttpConnectionParams.getConnectionTimeout(httpParams);
        int n2 = HttpConnectionParams.getSoTimeout(httpParams);
        try {
            socket2.setSoTimeout(n2);
            socket2.connect(inetSocketAddress, n);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ConnectTimeoutException("Connect to " + inetSocketAddress + " timed out");
        }
        String string = inetSocketAddress.toString();
        int n3 = inetSocketAddress.getPort();
        String string2 = ":" + n3;
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        SSLSocket sSLSocket = socket2 instanceof SSLSocket ? (SSLSocket)socket2 : (SSLSocket)this.socketfactory.createSocket(socket2, string, n3, true);
        if (this.hostnameVerifier != null) {
            try {
                this.hostnameVerifier.verify(string, sSLSocket);
            }
            catch (IOException iOException) {
                try {
                    sSLSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw iOException;
            }
        }
        return sSLSocket;
    }

    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Socket not created by this factory");
        }
        if (socket.isClosed()) {
            throw new IllegalArgumentException("Socket is closed");
        }
        return true;
    }

    public Socket createLayeredSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.socketfactory.createSocket(socket, string, n, bl);
        if (this.hostnameVerifier != null) {
            this.hostnameVerifier.verify(string, sSLSocket);
        }
        return sSLSocket;
    }

    @Deprecated
    public void setHostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        if (x509HostnameVerifier == null) {
            throw new IllegalArgumentException("Hostname verifier may not be null");
        }
        this.hostnameVerifier = x509HostnameVerifier;
    }

    public X509HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Deprecated
    public Socket connectSocket(Socket socket, String string, int n, InetAddress inetAddress, int n2, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        InetSocketAddress inetSocketAddress = null;
        if (inetAddress != null || n2 > 0) {
            if (n2 < 0) {
                n2 = 0;
            }
            inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        }
        InetAddress inetAddress2 = this.nameResolver != null ? this.nameResolver.resolve(string) : InetAddress.getByName(string);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(inetAddress2, n);
        return this.connectSocket(socket, inetSocketAddress2, inetSocketAddress, httpParams);
    }

    @Deprecated
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.createLayeredSocket(socket, string, n, bl);
    }
}

