/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.auth;

import ch.boye.httpclientandroidlib.FormattedHeader;
import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.auth.AuthenticationException;
import ch.boye.httpclientandroidlib.auth.ContextAwareAuthScheme;
import ch.boye.httpclientandroidlib.auth.Credentials;
import ch.boye.httpclientandroidlib.auth.MalformedChallengeException;
import ch.boye.httpclientandroidlib.protocol.HTTP;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    private boolean proxy;

    public void processChallenge(Header header) throws MalformedChallengeException {
        int n;
        CharArrayBuffer charArrayBuffer;
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        String string = header.getName();
        if (string.equalsIgnoreCase("WWW-Authenticate")) {
            this.proxy = false;
        } else if (string.equalsIgnoreCase("Proxy-Authenticate")) {
            this.proxy = true;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + string);
        }
        if (header instanceof FormattedHeader) {
            charArrayBuffer = ((FormattedHeader)header).getBuffer();
            n = ((FormattedHeader)header).getValuePos();
        } else {
            String string2 = header.getValue();
            if (string2 == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            charArrayBuffer = new CharArrayBuffer(string2.length());
            charArrayBuffer.append(string2);
            n = 0;
        }
        while (n < charArrayBuffer.length() && HTTP.isWhitespace(charArrayBuffer.charAt(n))) {
            ++n;
        }
        int n2 = n;
        while (n < charArrayBuffer.length() && !HTTP.isWhitespace(charArrayBuffer.charAt(n))) {
            ++n;
        }
        int n3 = n;
        String string3 = charArrayBuffer.substring(n2, n3);
        if (!string3.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + string3);
        }
        this.parseChallenge(charArrayBuffer, n, charArrayBuffer.length());
    }

    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        return this.authenticate(credentials, httpRequest);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.proxy;
    }

    public String toString() {
        return this.getSchemeName();
    }
}

