/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.params;

import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.params.CoreProtocolPNames;
import ch.boye.httpclientandroidlib.params.HttpParams;

public final class HttpProtocolParams
implements CoreProtocolPNames {
    private HttpProtocolParams() {
    }

    public static String getHttpElementCharset(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String string = (String)httpParams.getParameter("http.protocol.element-charset");
        if (string == null) {
            string = "US-ASCII";
        }
        return string;
    }

    public static void setHttpElementCharset(HttpParams httpParams, String string) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setParameter("http.protocol.element-charset", string);
    }

    public static String getContentCharset(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        String string = (String)httpParams.getParameter("http.protocol.content-charset");
        if (string == null) {
            string = "ISO-8859-1";
        }
        return string;
    }

    public static void setContentCharset(HttpParams httpParams, String string) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setParameter("http.protocol.content-charset", string);
    }

    public static ProtocolVersion getVersion(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Object object = httpParams.getParameter("http.protocol.version");
        if (object == null) {
            return HttpVersion.HTTP_1_1;
        }
        return (ProtocolVersion)object;
    }

    public static void setVersion(HttpParams httpParams, ProtocolVersion protocolVersion) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setParameter("http.protocol.version", protocolVersion);
    }

    public static String getUserAgent(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return (String)httpParams.getParameter("http.useragent");
    }

    public static void setUserAgent(HttpParams httpParams, String string) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setParameter("http.useragent", string);
    }

    public static boolean useExpectContinue(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return httpParams.getBooleanParameter("http.protocol.expect-continue", false);
    }

    public static void setUseExpectContinue(HttpParams httpParams, boolean bl) {
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        httpParams.setBooleanParameter("http.protocol.expect-continue", bl);
    }
}

