/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.media.MediaScannerConnection;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.webkit.MimeTypeMap;
import android.widget.AbsoluteLayout;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.Proxy;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.ActivityHandlerHelper;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoBatteryManager;
import org.mozilla.gecko.GeckoEditable;
import org.mozilla.gecko.GeckoEditableListener;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoNetworkManager;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoScreenOrientationListener;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.GlobalHistory;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SmsManager;
import org.mozilla.gecko.SurfaceBits;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.GeckoLayerClient;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PanZoomController;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.mozglue.JNITarget;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.mozglue.generatorannotations.OptionalGeneratedParameter;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;
import org.mozilla.gecko.prompts.PromptService;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.ProxySelector;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.webapp.InstallListener;
import org.mozilla.gecko.webapp.WebAppAllocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeckoAppShell {
    private static final String LOGTAG = "GeckoAppShell";
    private static LinkedList<GeckoEvent> gPendingEvents;
    private static boolean gRestartScheduled;
    private static GeckoEditableListener mEditableListener;
    private static final HashMap<String, String> mAlertCookies;
    private static final int HIGH_MEMORY_DEVICE_THRESHOLD_MB = 768;
    public static final int WPL_STATE_START = 1;
    public static final int WPL_STATE_STOP = 16;
    public static final int WPL_STATE_IS_DOCUMENT = 131072;
    public static final int WPL_STATE_IS_NETWORK = 262144;
    public static final int LINK_TYPE_UNKNOWN = 0;
    public static final int LINK_TYPE_ETHERNET = 1;
    public static final int LINK_TYPE_USB = 2;
    public static final int LINK_TYPE_WIFI = 3;
    public static final int LINK_TYPE_WIMAX = 4;
    public static final int LINK_TYPE_2G = 5;
    public static final int LINK_TYPE_3G = 6;
    public static final int LINK_TYPE_4G = 7;
    public static final String SHORTCUT_TYPE_WEBAPP = "webapp";
    public static final String SHORTCUT_TYPE_BOOKMARK = "bookmark";
    private static final boolean LOGGING = false;
    private static int sDensityDpi;
    private static int sScreenDepth;
    private static final EventDispatcher sEventDispatcher;
    private static final float[] DEFAULT_LAUNCHER_ICON_HSV;
    private static boolean sVibrationMaybePlaying;
    private static long sVibrationEndTime;
    private static int sDefaultSensorHint;
    private static Sensor gAccelerometerSensor;
    private static Sensor gLinearAccelerometerSensor;
    private static Sensor gGyroscopeSensor;
    private static Sensor gOrientationSensor;
    private static Sensor gProximitySensor;
    private static Sensor gLightSensor;
    private static volatile boolean mLocationHighAccuracy;
    public static ActivityHandlerHelper sActivityHelper;
    static NotificationClient sNotificationClient;
    private static LayerView sLayerView;
    private static final Object sEventAckLock;
    private static boolean sWaitingForEventAck;
    public static final String PLUGIN_ACTION = "android.webkit.PLUGIN";
    public static final String PLUGIN_PERMISSION = "android.webkit.permission.PLUGIN";
    private static final String PLUGIN_SYSTEM_LIB = "/system/lib/plugins/";
    private static final String PLUGIN_TYPE = "type";
    private static final String TYPE_NATIVE = "native";
    public static ArrayList<PackageInfo> mPackageInfoCache;
    private static ContextGetter sContextGetter;
    private static GeckoInterface sGeckoInterface;
    public static Camera sCamera;
    static int kPreferedFps;
    static byte[] sCameraBuffer;
    public static final int BASE64_DEFAULT = 0;
    public static final int BASE64_URL_SAFE = 8;
    private static final byte[] map1;
    private static final byte[] map1_urlsafe;
    private static final byte[] map2;
    static final byte EQUALS_ASCII = 61;

    private GeckoAppShell() {
    }

    public static native void nativeInit();

    public static native void setLayerClient(GeckoLayerClient var0);

    public static native void onResume();

    public static void callObserver(String string2, String string3, String string4) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createCallObserverEvent(string2, string3, string4));
    }

    public static void removeObserver(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createRemoveObserverEvent(string2));
    }

    public static native Message getNextMessageFromQueue(MessageQueue var0);

    public static native void onSurfaceTextureFrameAvailable(Object var0, int var1);

    public static native void dispatchMemoryPressure();

    public static void registerGlobalExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread thread, Throwable throwable) {
                GeckoAppShell.handleUncaughtException(thread, throwable);
            }
        });
    }

    private static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private static native void reportJavaCrash(String var0);

    public static void notifyUriVisited(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createVisitedEvent(string2));
    }

    public static native void processNextNativeEvent(boolean var0);

    public static native void notifyBatteryChange(double var0, boolean var2, double var3);

    public static native void scheduleComposite();

    public static native void scheduleResumeComposition(int var0, int var1);

    public static native float computeRenderIntegrity();

    public static native SurfaceBits getSurfaceBits(Surface var0);

    public static native void onFullScreenPluginHidden(View var0);

    public static void setLayerView(LayerView layerView) {
        sLayerView = layerView;
    }

    @RobocopTarget
    public static LayerView getLayerView() {
        return sLayerView;
    }

    public static void runGecko(String string2, String string3, String string4, String string5) {
        MessageQueue.IdleHandler idleHandler = new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                Handler handler = ThreadUtils.sGeckoHandler;
                Message message = Message.obtain((Handler)handler);
                message.obj = handler;
                handler.sendMessageAtFrontOfQueue(message);
                return true;
            }
        };
        Looper.myQueue().addIdleHandler(idleHandler);
        GeckoAppShell.nativeInit();
        if (sLayerView != null) {
            GeckoAppShell.setLayerClient(sLayerView.getLayerClient());
        }
        String string6 = string2 + " -greomni " + string2;
        if (string3 != null) {
            string6 = string6 + " " + string3;
        }
        if (string4 != null) {
            string6 = string6 + " -url " + string4;
        }
        if (string5 != null) {
            string6 = string6 + " " + string5;
        }
        DisplayMetrics displayMetrics = GeckoAppShell.getContext().getResources().getDisplayMetrics();
        string6 = string6 + " -width " + displayMetrics.widthPixels + " -height " + displayMetrics.heightPixels;
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                GeckoAppShell.geckoLoaded();
            }
        });
        Log.d((String)LOGTAG, (String)("GeckoLoader.nativeRun " + string6));
        GeckoLoader.nativeRun((String)string6);
        Looper.myQueue().removeIdleHandler(idleHandler);
    }

    private static void geckoLoaded() {
        GeckoEditable geckoEditable = new GeckoEditable();
        mEditableListener = geckoEditable;
    }

    static void sendPendingEventsToGecko() {
        try {
            while (!gPendingEvents.isEmpty()) {
                GeckoEvent geckoEvent = gPendingEvents.removeFirst();
                GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @RobocopTarget
    public static void sendEventToGecko(GeckoEvent geckoEvent) {
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            GeckoAppShell.notifyGeckoOfEvent(geckoEvent);
        } else {
            gPendingEvents.addLast(geckoEvent);
        }
    }

    public static native void notifyGeckoOfEvent(GeckoEvent var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapElementForJNI(generateStatic=true, noThrow=true)
    public static void handleUncaughtException(Thread thread, Throwable throwable) {
        Throwable throwable2;
        if (thread == null) {
            thread = Thread.currentThread();
        }
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
        }
        try {
            Log.e((String)LOGTAG, (String)(">>> REPORTING UNCAUGHT EXCEPTION FROM THREAD " + thread.getId() + " (\"" + thread.getName() + "\")"), (Throwable)throwable);
            Thread thread2 = ThreadUtils.getUiThread();
            if (thread2 != null && thread != thread2) {
                Log.e((String)LOGTAG, (String)"Main thread stack:");
                for (StackTraceElement stackTraceElement : thread2.getStackTrace()) {
                    Log.e((String)LOGTAG, (String)stackTraceElement.toString());
                }
            }
            if (throwable instanceof OutOfMemoryError) {
                StackTraceElement[] stackTraceElementArray = GeckoAppShell.getSharedPreferences();
                SharedPreferences.Editor editor = stackTraceElementArray.edit();
                editor.putBoolean("OOMException", true);
                editor.commit();
            }
        }
        finally {
            GeckoAppShell.reportJavaCrash(GeckoAppShell.getStackTraceString(throwable));
        }
    }

    @WrapElementForJNI(generateStatic=true)
    public static void notifyIME(int n) {
        if (mEditableListener != null) {
            mEditableListener.notifyIME(n);
        }
    }

    @WrapElementForJNI(generateStatic=true)
    public static void notifyIMEContext(int n, String string2, String string3, String string4) {
        if (mEditableListener != null) {
            mEditableListener.notifyIMEContext(n, string2, string3, string4);
        }
    }

    @WrapElementForJNI(generateStatic=true)
    public static void notifyIMEChange(String string2, int n, int n2, int n3) {
        if (n3 < 0) {
            mEditableListener.onSelectionChange(n, n2);
        } else {
            mEditableListener.onTextChange(string2, n, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEventToGeckoSync(GeckoEvent geckoEvent) {
        geckoEvent.setAckNeeded(true);
        long l = SystemClock.uptimeMillis();
        boolean bl = ThreadUtils.isOnUiThread();
        Object object = sEventAckLock;
        synchronized (object) {
            if (sWaitingForEventAck) {
                Log.e((String)LOGTAG, (String)"geckoEventSync() may have been called twice concurrently!", (Throwable)new Exception());
            }
            GeckoAppShell.sendEventToGecko(geckoEvent);
            sWaitingForEventAck = true;
            while (true) {
                try {
                    sEventAckLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!sWaitingForEventAck) break;
                long l2 = SystemClock.uptimeMillis() - l;
                Log.d((String)LOGTAG, (String)("Gecko event sync taking too long: " + l2 + "ms"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapElementForJNI
    public static void acknowledgeEvent() {
        Object object = sEventAckLock;
        synchronized (object) {
            sWaitingForEventAck = false;
            sEventAckLock.notifyAll();
        }
    }

    private static float getLocationAccuracy(Location location) {
        float f = location.getAccuracy();
        return location.hasAccuracy() && f > 0.0f ? f : 1001.0f;
    }

    private static Location getLastKnownLocation(LocationManager locationManager) {
        Location location = null;
        List list = locationManager.getAllProviders();
        for (String string2 : list) {
            Location location2 = locationManager.getLastKnownLocation(string2);
            if (location2 == null) continue;
            if (location == null) {
                location = location2;
                continue;
            }
            long l = location2.getTime() - location.getTime();
            if (l <= 0L && (l != 0L || !(GeckoAppShell.getLocationAccuracy(location2) < GeckoAppShell.getLocationAccuracy(location)))) continue;
            location = location2;
        }
        return location;
    }

    @WrapElementForJNI
    public static void enableLocation(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                LocationManager locationManager = GeckoAppShell.getLocationManager(GeckoAppShell.getContext());
                if (locationManager == null) {
                    return;
                }
                if (bl) {
                    Location location = GeckoAppShell.getLastKnownLocation(locationManager);
                    if (location != null) {
                        GeckoAppShell.getGeckoInterface().getLocationListener().onLocationChanged(location);
                    }
                    Criteria criteria = new Criteria();
                    criteria.setSpeedRequired(false);
                    criteria.setBearingRequired(false);
                    criteria.setAltitudeRequired(false);
                    if (mLocationHighAccuracy) {
                        criteria.setAccuracy(1);
                        criteria.setCostAllowed(true);
                        criteria.setPowerRequirement(3);
                    } else {
                        criteria.setAccuracy(2);
                        criteria.setCostAllowed(false);
                        criteria.setPowerRequirement(1);
                    }
                    String string2 = locationManager.getBestProvider(criteria, true);
                    if (string2 == null) {
                        return;
                    }
                    Looper looper = Looper.getMainLooper();
                    locationManager.requestLocationUpdates(string2, 100L, 0.5f, GeckoAppShell.getGeckoInterface().getLocationListener(), looper);
                } else {
                    locationManager.removeUpdates(GeckoAppShell.getGeckoInterface().getLocationListener());
                }
            }
        });
    }

    private static LocationManager getLocationManager(Context context) {
        try {
            return (LocationManager)context.getSystemService("location");
        }
        catch (NoSuchFieldError noSuchFieldError) {
            Log.e((String)LOGTAG, (String)"LOCATION_SERVICE not found?!", (Throwable)noSuchFieldError);
            return null;
        }
    }

    @WrapElementForJNI
    public static void enableLocationHighAccuracy(boolean bl) {
        mLocationHighAccuracy = bl;
    }

    @WrapElementForJNI
    public static void enableSensor(int n) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        SensorManager sensorManager = (SensorManager)GeckoAppShell.getContext().getSystemService("sensor");
        switch (n) {
            case 0: {
                if (gOrientationSensor == null) {
                    gOrientationSensor = sensorManager.getDefaultSensor(3);
                }
                if (gOrientationSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gOrientationSensor, sDefaultSensorHint);
                break;
            }
            case 1: {
                if (gAccelerometerSensor == null) {
                    gAccelerometerSensor = sensorManager.getDefaultSensor(1);
                }
                if (gAccelerometerSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gAccelerometerSensor, sDefaultSensorHint);
                break;
            }
            case 2: {
                if (gProximitySensor == null) {
                    gProximitySensor = sensorManager.getDefaultSensor(8);
                }
                if (gProximitySensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gProximitySensor, 3);
                break;
            }
            case 5: {
                if (gLightSensor == null) {
                    gLightSensor = sensorManager.getDefaultSensor(5);
                }
                if (gLightSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gLightSensor, 3);
                break;
            }
            case 3: {
                if (gLinearAccelerometerSensor == null) {
                    gLinearAccelerometerSensor = sensorManager.getDefaultSensor(10);
                }
                if (gLinearAccelerometerSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gLinearAccelerometerSensor, sDefaultSensorHint);
                break;
            }
            case 4: {
                if (gGyroscopeSensor == null) {
                    gGyroscopeSensor = sensorManager.getDefaultSensor(4);
                }
                if (gGyroscopeSensor == null) break;
                sensorManager.registerListener(geckoInterface.getSensorEventListener(), gGyroscopeSensor, sDefaultSensorHint);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Error! Can't enable unknown SENSOR type " + n));
            }
        }
    }

    @WrapElementForJNI
    public static void disableSensor(int n) {
        GeckoInterface geckoInterface = GeckoAppShell.getGeckoInterface();
        if (geckoInterface == null) {
            return;
        }
        SensorManager sensorManager = (SensorManager)GeckoAppShell.getContext().getSystemService("sensor");
        switch (n) {
            case 0: {
                if (gOrientationSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gOrientationSensor);
                break;
            }
            case 1: {
                if (gAccelerometerSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gAccelerometerSensor);
                break;
            }
            case 2: {
                if (gProximitySensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gProximitySensor);
                break;
            }
            case 5: {
                if (gLightSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gLightSensor);
                break;
            }
            case 3: {
                if (gLinearAccelerometerSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gLinearAccelerometerSensor);
                break;
            }
            case 4: {
                if (gGyroscopeSensor == null) break;
                sensorManager.unregisterListener(geckoInterface.getSensorEventListener(), gGyroscopeSensor);
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)("Error! Can't disable unknown SENSOR type " + n));
            }
        }
    }

    @WrapElementForJNI
    public static void moveTaskToBack() {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().getActivity().moveTaskToBack(true);
        }
    }

    public static void returnIMEQueryResult(String string2, int n, int n2) {
    }

    @WrapElementForJNI(stubName="NotifyXreExit")
    static void onXreExit() {
        GeckoThread.setLaunchState(GeckoThread.LaunchState.GeckoExiting);
        if (GeckoAppShell.getGeckoInterface() != null) {
            if (gRestartScheduled) {
                GeckoAppShell.getGeckoInterface().doRestart();
            } else {
                GeckoAppShell.getGeckoInterface().getActivity().finish();
            }
        }
        Log.d((String)LOGTAG, (String)"Killing via System.exit()");
        System.exit(0);
    }

    @WrapElementForJNI
    static void scheduleRestart() {
        gRestartScheduled = true;
    }

    public static File preInstallWebApp(String string2, String string3, String string4) {
        int n = org.mozilla.gecko.WebAppAllocator.getInstance(GeckoAppShell.getContext()).findAndAllocateIndex(string4, string2, (String)null);
        GeckoProfile geckoProfile = GeckoProfile.get(GeckoAppShell.getContext(), SHORTCUT_TYPE_WEBAPP + n);
        return geckoProfile.getDir();
    }

    public static void postInstallWebApp(String string2, String string3, String string4, String string5, String string6) {
        org.mozilla.gecko.WebAppAllocator webAppAllocator = org.mozilla.gecko.WebAppAllocator.getInstance(GeckoAppShell.getContext());
        int n = webAppAllocator.getIndexForApp(string6);
        assert (n != -1 && string5 != null);
        webAppAllocator.updateAppAllocation(string4, n, BitmapUtils.getBitmapFromDataURI(string5));
        GeckoAppShell.createShortcut(string2, string3, string4, string5, SHORTCUT_TYPE_WEBAPP);
    }

    public static void postInstallWebApp(String string2, String string3) {
        WebAppAllocator webAppAllocator = WebAppAllocator.getInstance(GeckoAppShell.getContext());
        int n = webAppAllocator.findOrAllocatePackage(string2);
        webAppAllocator.putOrigin(n, string3);
    }

    public static Intent getWebAppIntent(String string2, String string3, String string4, Bitmap bitmap) {
        int n = bitmap != null && !TextUtils.isEmpty((CharSequence)string4) ? org.mozilla.gecko.WebAppAllocator.getInstance(GeckoAppShell.getContext()).findAndAllocateIndex(string3, string4, bitmap) : org.mozilla.gecko.WebAppAllocator.getInstance(GeckoAppShell.getContext()).getIndexForApp(string3);
        if (n == -1) {
            return null;
        }
        Intent intent = GeckoAppShell.getWebAppIntent(n, string2);
        return intent;
    }

    public static Intent getWebAppIntent(int n, String string2) {
        Intent intent = new Intent();
        intent.setAction("org.mozilla.gecko.WEBAPP" + n);
        intent.setData(Uri.parse((String)string2));
        intent.setClassName("org.mozilla.fennec", "org.mozilla.fennec.WebApps$WebApp" + n);
        return intent;
    }

    @WrapElementForJNI
    static void createShortcut(String string2, String string3, String string4, String string5) {
        if (SHORTCUT_TYPE_WEBAPP.equals(string5)) {
            Log.w((String)LOGTAG, (String)"createShortcut with no unique URI should not be used for aType = webapp!");
        }
        GeckoAppShell.createShortcut(string2, string3, string3, string4, string5);
    }

    public static void createShortcut(String string2, String string3, Bitmap bitmap, String string4) {
        GeckoAppShell.createShortcut(string2, string3, string3, bitmap, string4);
    }

    static void createShortcut(String string2, String string3, String string4, String string5, String string6) {
        GeckoAppShell.createShortcut(string2, string3, string4, BitmapUtils.getBitmapFromDataURI(string5), string6);
    }

    public static void createShortcut(final String string2, final String string3, final String string4, final Bitmap bitmap, final String string5) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                Intent intent;
                if (string5.equalsIgnoreCase(GeckoAppShell.SHORTCUT_TYPE_WEBAPP)) {
                    intent = GeckoAppShell.getWebAppIntent(string3, string4, string2, bitmap);
                } else {
                    intent = new Intent();
                    intent.setAction("org.mozilla.gecko.BOOKMARK");
                    intent.setData(Uri.parse((String)string3));
                    intent.setClassName("org.mozilla.fennec", "org.mozilla.fennec.App");
                }
                Intent intent2 = new Intent();
                intent2.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
                if (string2 != null) {
                    intent2.putExtra("android.intent.extra.shortcut.NAME", string2);
                } else {
                    intent2.putExtra("android.intent.extra.shortcut.NAME", string3);
                }
                intent2.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)GeckoAppShell.getLauncherIcon(bitmap, string5));
                intent2.putExtra("duplicate", false);
                intent2.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
                GeckoAppShell.getContext().sendBroadcast(intent2);
            }
        });
    }

    public static void removeShortcut(String string2, String string3, String string4) {
        GeckoAppShell.removeShortcut(string2, string3, null, string4);
    }

    public static void removeShortcut(final String string2, final String string3, final String string4, final String string5) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                Intent intent;
                if (string5.equalsIgnoreCase(GeckoAppShell.SHORTCUT_TYPE_WEBAPP)) {
                    intent = GeckoAppShell.getWebAppIntent(string3, string4, "", null);
                    if (intent == null) {
                        return;
                    }
                } else {
                    intent = new Intent();
                    intent.setAction("org.mozilla.gecko.BOOKMARK");
                    intent.setClassName("org.mozilla.fennec", "org.mozilla.fennec.App");
                    intent.setData(Uri.parse((String)string3));
                }
                Intent intent2 = new Intent();
                intent2.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)intent);
                if (string2 != null) {
                    intent2.putExtra("android.intent.extra.shortcut.NAME", string2);
                } else {
                    intent2.putExtra("android.intent.extra.shortcut.NAME", string3);
                }
                intent2.setAction("com.android.launcher.action.UNINSTALL_SHORTCUT");
                GeckoAppShell.getContext().sendBroadcast(intent2);
            }
        });
    }

    public static void uninstallWebApp(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                int n = org.mozilla.gecko.WebAppAllocator.getInstance(GeckoAppShell.getContext()).releaseIndexForApp(string2);
                if (n == -1) {
                    return;
                }
                String string22 = GeckoAppShell.getContext().getPackageName();
                string22 = string22 + ":" + string22 + ".WebApp" + n;
                ActivityManager activityManager = (ActivityManager)GeckoAppShell.getContext().getSystemService("activity");
                List list = activityManager.getRunningAppProcesses();
                if (list != null) {
                    for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                        if (!runningAppProcessInfo.processName.equals(string22)) continue;
                        Process.killProcess((int)runningAppProcessInfo.pid);
                        break;
                    }
                }
                GeckoProfile.removeProfile(GeckoAppShell.getContext(), GeckoAppShell.SHORTCUT_TYPE_WEBAPP + n);
            }
        });
    }

    @JNITarget
    public static int getPreferredIconSize() {
        if (Build.VERSION.SDK_INT >= 11) {
            ActivityManager activityManager = (ActivityManager)GeckoAppShell.getContext().getSystemService("activity");
            return activityManager.getLauncherLargeIconSize();
        }
        switch (GeckoAppShell.getDpi()) {
            case 160: {
                return 48;
            }
            case 320: {
                return 96;
            }
        }
        return 72;
    }

    private static Bitmap getLauncherIcon(Bitmap bitmap, String string2) {
        int n;
        int n2 = GeckoAppShell.getPreferredIconSize();
        int n3 = bitmap != null ? n2 * 2 / 3 : n2;
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        if (bitmap == null) {
            paint.setColor(Color.HSVToColor((float[])DEFAULT_LAUNCHER_ICON_HSV));
            canvas.drawRoundRect(new RectF(6.0f, 6.0f, (float)(n2 - 6), (float)(n2 - 6)), 5.0f, 5.0f, paint);
        } else {
            if (string2.equalsIgnoreCase(SHORTCUT_TYPE_WEBAPP) || bitmap.getWidth() >= n3 || bitmap.getHeight() >= n3) {
                Rect rect = new Rect(0, 0, n2, n2);
                canvas.drawBitmap(bitmap, null, rect, null);
                return bitmap2;
            }
            int n4 = BitmapUtils.getDominantColor(bitmap);
            paint.setColor(n4);
            canvas.drawRoundRect(new RectF(6.0f, 6.0f, (float)(n2 - 6), (float)(n2 - 6)), 5.0f, 5.0f, paint);
            paint.setColor(Color.argb((int)100, (int)255, (int)255, (int)255));
            canvas.drawRoundRect(new RectF(6.0f, 6.0f, (float)(n2 - 6), (float)(n2 - 6)), 5.0f, 5.0f, paint);
        }
        Bitmap bitmap3 = BitmapUtils.decodeResource(GeckoAppShell.getContext(), R.drawable.home_bg);
        canvas.drawBitmap(bitmap3, null, new Rect(0, 0, n2, n2), null);
        if (bitmap == null) {
            bitmap = BitmapUtils.decodeResource(GeckoAppShell.getContext(), R.drawable.home_star);
        }
        int n5 = n = n3 / 2;
        int n6 = n2 / 2;
        canvas.drawBitmap(bitmap, null, new Rect(n6 - n, n6 - n5, n6 + n, n6 + n5), null);
        return bitmap2;
    }

    @WrapElementForJNI(stubName="GetHandlersForMimeTypeWrapper")
    static String[] getHandlersForMimeType(String string2, String string3) {
        Intent intent = GeckoAppShell.getIntentForActionString(string3);
        if (string2 != null && string2.length() > 0) {
            intent.setType(string2);
        }
        return GeckoAppShell.getHandlersForIntent(intent);
    }

    @WrapElementForJNI(stubName="GetHandlersForURLWrapper")
    static String[] getHandlersForURL(String string2, String string3) {
        Uri uri = string2.indexOf(58) >= 0 ? Uri.parse((String)string2) : new Uri.Builder().scheme(string2).build();
        Intent intent = GeckoAppShell.getOpenURIIntent(GeckoAppShell.getContext(), uri.toString(), "", TextUtils.isEmpty((CharSequence)string3) ? "android.intent.action.VIEW" : string3, "");
        return GeckoAppShell.getHandlersForIntent(intent);
    }

    static boolean hasHandlersForIntent(Intent intent) {
        PackageManager packageManager = GeckoAppShell.getContext().getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        return !list.isEmpty();
    }

    static String[] getHandlersForIntent(Intent intent) {
        PackageManager packageManager = GeckoAppShell.getContext().getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 0);
        int n = 4;
        String[] stringArray = new String[list.size() * n];
        for (int i = 0; i < list.size(); ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(i);
            stringArray[i * n] = ((Object)resolveInfo.loadLabel(packageManager)).toString();
            stringArray[i * n + 1] = resolveInfo.isDefault ? "default" : "";
            stringArray[i * n + 2] = resolveInfo.activityInfo.applicationInfo.packageName;
            stringArray[i * n + 3] = resolveInfo.activityInfo.name;
        }
        return stringArray;
    }

    static Intent getIntentForActionString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return new Intent("android.intent.action.VIEW");
        }
        return new Intent(string2);
    }

    @WrapElementForJNI(stubName="GetExtensionFromMimeTypeWrapper")
    static String getExtensionFromMimeType(String string2) {
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(string2);
    }

    @WrapElementForJNI(stubName="GetMimeTypeFromExtensionsWrapper")
    static String getMimeTypeFromExtensions(String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".,; ");
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreElements()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            String string7 = GeckoAppShell.getMimeTypeFromExtension(string6);
            if (string7 == null) continue;
            int n = string7.indexOf(47);
            String string8 = string7.substring(0, n);
            if (!string8.equalsIgnoreCase(string3)) {
                String string9 = string3 = string3 == null ? string8 : "*";
            }
            if ((string5 = string7.substring(n + 1)).equalsIgnoreCase(string4)) continue;
            string4 = string4 == null ? string5 : "*";
        }
        if (string3 == null) {
            string3 = "*";
        }
        if (string4 == null) {
            string4 = "*";
        }
        return string3 + "/" + string4;
    }

    static void safeStreamClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void shareImage(String string2, String string3) {
        Intent intent = new Intent("android.intent.action.SEND");
        boolean bl = string2.startsWith("data:");
        FileOutputStream fileOutputStream = null;
        File file = GeckoApp.getTempDirectory();
        if (file == null) {
            GeckoAppShell.showImageShareFailureToast();
            return;
        }
        GeckoApp.deleteTempFiles();
        try {
            File file2 = File.createTempFile("image", "." + string3.replace("image/", ""), file);
            fileOutputStream = new FileOutputStream(file2);
            if (bl) {
                int n = string2.indexOf(44);
                byte[] byArray = Base64.decode((String)string2.substring(n + 1), (int)0);
                ((OutputStream)fileOutputStream).write(byArray);
            } else {
                InputStream inputStream = null;
                try {
                    int n;
                    URL uRL = new URL(string2);
                    inputStream = uRL.openStream();
                    byte[] byArray = new byte[2048];
                    while ((n = inputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    GeckoAppShell.safeStreamClose(inputStream);
                    throw throwable;
                }
                GeckoAppShell.safeStreamClose(inputStream);
            }
            intent.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.fromFile((File)file2));
            if (string3.startsWith("image/")) {
                intent.setType(string3);
            } else {
                intent.setType("image/*");
            }
            GeckoAppShell.safeStreamClose(fileOutputStream);
        }
        catch (IOException iOException) {
            if (bl) {
                GeckoAppShell.showImageShareFailureToast();
                return;
            }
            intent.putExtra("android.intent.extra.TEXT", string2);
            intent.setType("text/plain");
        }
        finally {
            GeckoAppShell.safeStreamClose(fileOutputStream);
        }
        GeckoAppShell.getContext().startActivity(Intent.createChooser((Intent)intent, (CharSequence)GeckoAppShell.getContext().getResources().getString(R.string.share_title)));
    }

    private static final void showImageShareFailureToast() {
        Toast toast = Toast.makeText((Context)GeckoAppShell.getContext(), (CharSequence)GeckoAppShell.getContext().getResources().getString(R.string.share_image_failed), (int)0);
        toast.show();
    }

    static boolean isUriSafeForScheme(Uri uri) {
        String string2;
        String string3 = uri.getScheme();
        return !"tel".equals(string3) && !"sms".equals(string3) || !(string2 = uri.getSchemeSpecificPart()).contains("#") && !string2.contains("*") && uri.getFragment() == null;
    }

    @WrapElementForJNI
    public static boolean openUriExternal(String string2, String string3, @OptionalGeneratedParameter String string4, @OptionalGeneratedParameter String string5, @OptionalGeneratedParameter String string6, @OptionalGeneratedParameter String string7) {
        Context context = GeckoAppShell.getContext();
        Intent intent = GeckoAppShell.getOpenURIIntent(context, string2, string3, string6, string7);
        if (intent == null) {
            return false;
        }
        if (string4.length() > 0 && string5.length() > 0) {
            intent.setClassName(string4, string5);
        }
        intent.setFlags(0x4000000);
        try {
            context.startActivity(intent);
            return true;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return false;
        }
    }

    static Uri normalizeUriScheme(Uri uri) {
        String string2 = uri.getScheme();
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals(string2)) {
            return uri;
        }
        return uri.buildUpon().scheme(string3).build();
    }

    static Intent getShareIntent(Context context, String string2, String string3, String string4) {
        Intent intent = GeckoAppShell.getIntentForActionString("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", string2);
        intent.putExtra("android.intent.extra.SUBJECT", string4);
        intent.putExtra("android.intent.extra.TITLE", string4);
        if (string3 != null && string3.length() > 0) {
            intent.setType(string3);
        }
        return intent;
    }

    static Intent getOpenURIIntent(Context context, String string2, String string3, String string4, String string5) {
        Intent intent;
        if (string4.equalsIgnoreCase("android.intent.action.SEND")) {
            Intent intent2 = GeckoAppShell.getShareIntent(context, string2, string3, string5);
            return Intent.createChooser((Intent)intent2, (CharSequence)context.getResources().getString(R.string.share_title));
        }
        Uri uri = GeckoAppShell.normalizeUriScheme(string2.indexOf(58) >= 0 ? Uri.parse((String)string2) : new Uri.Builder().scheme(string2).build());
        if (string3.length() > 0) {
            Intent intent3 = GeckoAppShell.getIntentForActionString(string4);
            intent3.setDataAndType(uri, string3);
            return intent3;
        }
        if (!GeckoAppShell.isUriSafeForScheme(uri)) {
            return null;
        }
        String string6 = uri.getScheme();
        Intent intent4 = GeckoAppShell.getIntentForActionString(string4);
        intent4.setData(uri);
        if ("vnd.youtube".equals(string6) && !GeckoAppShell.hasHandlersForIntent(intent4)) {
            intent = new Intent("org.mozilla.gecko.PLAY_VIDEO");
            intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.VideoPlayer");
            intent.setData(uri);
        } else {
            intent = intent4;
        }
        if (!"sms".equals(string6)) {
            return intent;
        }
        String string7 = uri.getEncodedQuery();
        if (TextUtils.isEmpty((CharSequence)string7)) {
            return intent;
        }
        String[] stringArray = string7.split("&");
        boolean bl = false;
        String string8 = "";
        for (String string9 : stringArray) {
            if (bl || !string9.startsWith("body=")) {
                string8 = string8.concat(string8.length() > 0 ? "&" + string9 : string9);
                continue;
            }
            String string10 = Uri.decode((String)string9.substring(5));
            intent.putExtra("sms_body", string10);
            bl = true;
        }
        if (!bl) {
            return intent;
        }
        String string11 = string8.length() > 0 ? "?" + string8 : "";
        Uri uri2 = uri.buildUpon().encodedQuery(string11).build();
        intent.setData(uri2);
        return intent;
    }

    public static void setNotificationClient(NotificationClient notificationClient) {
        if (sNotificationClient == null) {
            sNotificationClient = notificationClient;
        } else {
            Log.d((String)LOGTAG, (String)"Notification client already set");
        }
    }

    @WrapElementForJNI(stubName="ShowAlertNotificationWrapper")
    public static void showAlertNotification(String string2, String string3, String string4, String string5, String string6) {
        String string7 = GeckoAppShell.getContext().getClass().getName();
        Intent intent = new Intent("org.mozilla.gecko.ACTION_ALERT_CALLBACK");
        intent.setClassName("org.mozilla.fennec", string7);
        intent.setFlags(0x10000000);
        int n = string6.hashCode();
        Uri.Builder builder = new Uri.Builder();
        Uri uri = builder.scheme("alert").path(Integer.toString(n)).appendQueryParameter("name", string6).appendQueryParameter("cookie", string5).build();
        intent.setData(uri);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)GeckoAppShell.getContext(), (int)0, (Intent)intent, (int)0x8000000);
        mAlertCookies.put(string6, string5);
        GeckoAppShell.callObserver(string6, "alertshow", string5);
        sNotificationClient.add(n, string2, string3, string4, pendingIntent);
    }

    @WrapElementForJNI
    public static void alertsProgressListener_OnProgress(String string2, long l, long l2, String string3) {
        int n = string2.hashCode();
        sNotificationClient.update(n, l, l2, string3);
    }

    @WrapElementForJNI
    public static void closeNotification(String string2) {
        String string3 = mAlertCookies.get(string2);
        if (string3 != null) {
            GeckoAppShell.callObserver(string2, "alertfinished", string3);
            mAlertCookies.remove(string2);
        }
        GeckoAppShell.removeObserver(string2);
        int n = string2.hashCode();
        sNotificationClient.remove(n);
    }

    public static void handleNotification(String string2, String string3, String string4) {
        int n = string3.hashCode();
        if ("org.mozilla.gecko.ACTION_ALERT_CALLBACK".equals(string2)) {
            GeckoAppShell.callObserver(string3, "alertclickcallback", string4);
            if (sNotificationClient.isOngoing(n)) {
                return;
            }
        }
        GeckoAppShell.closeNotification(string3);
    }

    @WrapElementForJNI(stubName="GetDpiWrapper")
    public static int getDpi() {
        if (sDensityDpi == 0) {
            sDensityDpi = GeckoAppShell.getContext().getResources().getDisplayMetrics().densityDpi;
        }
        return sDensityDpi;
    }

    @WrapElementForJNI
    public static float getDensity() {
        return GeckoAppShell.getContext().getResources().getDisplayMetrics().density;
    }

    private static boolean isHighMemoryDevice() {
        return HardwareUtils.getMemSize() > 768;
    }

    @WrapElementForJNI(stubName="GetScreenDepthWrapper")
    public static synchronized int getScreenDepth() {
        if (sScreenDepth == 0) {
            sScreenDepth = 16;
            PixelFormat pixelFormat = new PixelFormat();
            PixelFormat.getPixelFormatInfo((int)GeckoAppShell.getGeckoInterface().getActivity().getWindowManager().getDefaultDisplay().getPixelFormat(), (PixelFormat)pixelFormat);
            if (pixelFormat.bitsPerPixel >= 24 && GeckoAppShell.isHighMemoryDevice()) {
                sScreenDepth = 24;
            }
        }
        return sScreenDepth;
    }

    public static synchronized void setScreenDepthOverride(int n) {
        if (sScreenDepth != 0) {
            Log.e((String)LOGTAG, (String)"Tried to override screen depth after it's already been set");
            return;
        }
        sScreenDepth = n;
    }

    @WrapElementForJNI
    public static void setFullScreen(boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().setFullScreen(bl);
        }
    }

    @WrapElementForJNI(stubName="ShowFilePickerForExtensionsWrapper")
    public static String showFilePickerForExtensions(String string2) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            return sActivityHelper.showFilePicker(GeckoAppShell.getGeckoInterface().getActivity(), GeckoAppShell.getMimeTypeFromExtensions(string2));
        }
        return "";
    }

    @WrapElementForJNI(stubName="ShowFilePickerForMimeTypeWrapper")
    public static String showFilePickerForMimeType(String string2) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            return sActivityHelper.showFilePicker(GeckoAppShell.getGeckoInterface().getActivity(), string2);
        }
        return "";
    }

    @WrapElementForJNI
    public static void performHapticFeedback(boolean bl) {
        if (!sVibrationMaybePlaying || System.nanoTime() >= sVibrationEndTime) {
            LayerView layerView = GeckoAppShell.getLayerView();
            layerView.performHapticFeedback(bl ? 0 : 1);
        }
    }

    private static Vibrator vibrator() {
        LayerView layerView = GeckoAppShell.getLayerView();
        return (Vibrator)layerView.getContext().getSystemService("vibrator");
    }

    @WrapElementForJNI(stubName="Vibrate1")
    public static void vibrate(long l) {
        sVibrationEndTime = System.nanoTime() + l * 1000000L;
        sVibrationMaybePlaying = true;
        GeckoAppShell.vibrator().vibrate(l);
    }

    @WrapElementForJNI(stubName="VibrateA")
    public static void vibrate(long[] lArray, int n) {
        long l = 0L;
        int n2 = lArray.length - (lArray.length % 2 == 0 ? 1 : 0);
        for (int i = 0; i < n2; ++i) {
            l += lArray[i];
        }
        sVibrationEndTime = System.nanoTime() + l * 1000000L;
        sVibrationMaybePlaying = true;
        GeckoAppShell.vibrator().vibrate(lArray, n);
    }

    @WrapElementForJNI
    public static void cancelVibrate() {
        sVibrationMaybePlaying = false;
        sVibrationEndTime = 0L;
        GeckoAppShell.vibrator().cancel();
    }

    @WrapElementForJNI
    public static void showInputMethodPicker() {
        InputMethodManager inputMethodManager = (InputMethodManager)GeckoAppShell.getContext().getSystemService("input_method");
        inputMethodManager.showInputMethodPicker();
    }

    @WrapElementForJNI
    public static void setKeepScreenOn(boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
            }
        });
    }

    @WrapElementForJNI
    public static void notifyDefaultPrevented(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                PanZoomController panZoomController;
                LayerView layerView = GeckoAppShell.getLayerView();
                PanZoomController panZoomController2 = panZoomController = layerView == null ? null : layerView.getPanZoomController();
                if (panZoomController != null) {
                    panZoomController.notifyDefaultActionPrevented(bl);
                }
            }
        });
    }

    @WrapElementForJNI
    public static boolean isNetworkLinkUp() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    @WrapElementForJNI
    public static boolean isNetworkLinkKnown() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getContext().getSystemService("connectivity");
        try {
            if (connectivityManager.getActiveNetworkInfo() == null) {
                return false;
            }
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    @WrapElementForJNI
    public static int networkLinkType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoAppShell.getContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return 0;
        }
        switch (networkInfo.getType()) {
            case 9: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 0: {
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)"Ignoring the current network type.");
                return 0;
            }
        }
        TelephonyManager telephonyManager = (TelephonyManager)GeckoAppShell.getContext().getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return 0;
        }
        switch (telephonyManager.getNetworkType()) {
            case 1: 
            case 4: 
            case 11: {
                return 5;
            }
            case 2: 
            case 7: {
                return 5;
            }
            case 3: 
            case 5: {
                return 6;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return 6;
            }
            case 15: {
                return 6;
            }
            case 13: {
                return 7;
            }
        }
        Log.w((String)LOGTAG, (String)"Connected to an unknown mobile network!");
        return 0;
    }

    @WrapElementForJNI(stubName="GetSystemColoursWrapper")
    public static int[] getSystemColors() {
        int[] nArray = new int[]{16842904, 16842806, 16842809, 16842808, 16842810, 0x1010212, 16843283, 0x1010099, 0x1010030, 0x1010031, 0x1010060, 0x1010061};
        int[] nArray2 = new int[nArray.length];
        ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper(GeckoAppShell.getContext(), 16973886);
        TypedArray typedArray = contextThemeWrapper.getTheme().obtainStyledAttributes(nArray);
        if (typedArray != null) {
            for (int i = 0; i < typedArray.getIndexCount(); ++i) {
                int n;
                int n2 = typedArray.getIndex(i);
                nArray2[n2] = n = typedArray.getColor(n2, 0);
            }
            typedArray.recycle();
        }
        return nArray2;
    }

    @WrapElementForJNI
    public static void killAnyZombies() {
        GeckoProcessesVisitor geckoProcessesVisitor = new GeckoProcessesVisitor(){

            public boolean callback(int n) {
                if (n != Process.myPid()) {
                    Process.killProcess((int)n);
                }
                return true;
            }
        };
        GeckoAppShell.EnumerateGeckoProcesses(geckoProcessesVisitor);
    }

    public static boolean checkForGeckoProcs() {
        class GeckoPidCallback
        implements GeckoProcessesVisitor {
            public boolean otherPidExist = false;

            GeckoPidCallback() {
            }

            public boolean callback(int n) {
                if (n != Process.myPid()) {
                    this.otherPidExist = true;
                    return false;
                }
                return true;
            }
        }
        GeckoPidCallback geckoPidCallback = new GeckoPidCallback();
        GeckoAppShell.EnumerateGeckoProcesses(geckoPidCallback);
        return geckoPidCallback.otherPidExist;
    }

    private static void EnumerateGeckoProcesses(GeckoProcessesVisitor geckoProcessesVisitor) {
        int n = -1;
        int n2 = -1;
        try {
            int n3;
            boolean bl;
            int n4;
            String[] stringArray;
            String string2;
            java.lang.Process process = Runtime.getRuntime().exec("ps");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 2048);
            String string3 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("PID")) {
                    n = n5;
                } else if (string2.equalsIgnoreCase("USER")) {
                    n2 = n5;
                }
                ++n5;
            }
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null && ((stringArray = string2.split("\\s+")).length <= n || stringArray.length <= n2 || (n4 = Process.getUidForName((String)stringArray[n2])) != Process.myUid() || stringArray[stringArray.length - 1].equalsIgnoreCase("ps") || (bl = geckoProcessesVisitor.callback(n3 = Integer.parseInt(stringArray[n]))))) {
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Failed to enumerate Gecko processes.", (Throwable)exception);
        }
    }

    public static void waitForAnotherGeckoProc() {
        int n = 40;
        while (!GeckoAppShell.checkForGeckoProcs() && --n > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppNameByPID(int n) {
        BufferedReader bufferedReader = null;
        String string2 = "/proc/" + n + "/cmdline";
        try {
            File file = new File(string2);
            if (!file.exists()) {
                String string3 = "";
                return string3;
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            String string4 = bufferedReader.readLine().trim();
            return string4;
        }
        catch (Exception exception) {
            String string5 = "";
            return string5;
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void listOfOpenFiles() {
        int n = -1;
        int n2 = -1;
        try {
            Object object;
            String string2 = GeckoProfile.get(GeckoAppShell.getContext()).getDir().toString();
            Log.i((String)LOGTAG, (String)("[OPENFILE] Filter: " + string2));
            java.lang.Process process = Runtime.getRuntime().exec("lsof");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 2048);
            String string3 = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).equalsIgnoreCase("PID")) {
                    n = n3;
                } else if (((String)object).equalsIgnoreCase("NAME")) {
                    n2 = n3;
                }
                ++n3;
            }
            object = new TreeMap();
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                String[] stringArray = string4.split("\\s+");
                if (stringArray.length <= n || stringArray.length <= n2) continue;
                Integer n4 = new Integer(stringArray[n]);
                String string5 = (String)object.get(n4);
                if (string5 == null) {
                    string5 = GeckoAppShell.getAppNameByPID(n4);
                    object.put(n4, string5);
                }
                String string6 = stringArray[n2];
                if (TextUtils.isEmpty((CharSequence)string5) || TextUtils.isEmpty((CharSequence)string6) || !string6.startsWith(string2)) continue;
                Log.i((String)LOGTAG, (String)("[OPENFILE] " + string5 + "(" + stringArray[n] + ") : " + string6));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @WrapElementForJNI
    public static void scanMedia(String string2, String string3) {
        int n;
        if (TextUtils.isEmpty((CharSequence)string3) && (n = string2.lastIndexOf(".")) > 0 && n < string2.length() - 1) {
            string3 = GeckoAppShell.getMimeTypeFromExtension(string2.substring(n + 1));
        }
        Context context = GeckoAppShell.getContext();
        GeckoMediaScannerClient.startScan(context, string2, string3);
    }

    @WrapElementForJNI(stubName="GetIconForExtensionWrapper")
    public static byte[] getIconForExtension(String string2, int n) {
        try {
            Bitmap bitmap;
            PackageManager packageManager;
            Drawable drawable2;
            if (n <= 0) {
                n = 16;
            }
            if (string2 != null && string2.length() > 1 && string2.charAt(0) == '.') {
                string2 = string2.substring(1);
            }
            if ((drawable2 = GeckoAppShell.getDrawableForExtension(packageManager = GeckoAppShell.getContext().getPackageManager(), string2)) == null) {
                drawable2 = packageManager.getDefaultActivityIcon();
            }
            if ((bitmap = ((BitmapDrawable)drawable2).getBitmap()).getWidth() != n || bitmap.getHeight() != n) {
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)n, (boolean)true);
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n * n * 4);
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            return byteBuffer.array();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"getIconForExtension failed.", (Throwable)exception);
            return null;
        }
    }

    private static String getMimeTypeFromExtension(String string2) {
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        return mimeTypeMap.getMimeTypeFromExtension(string2);
    }

    private static Drawable getDrawableForExtension(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        String string3 = GeckoAppShell.getMimeTypeFromExtension(string2);
        if (string3 == null || string3.length() <= 0) {
            return null;
        }
        intent.setType(string3);
        List list = packageManager.queryIntentActivities(intent, 0);
        if (list.size() == 0) {
            return null;
        }
        ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        return activityInfo.loadIcon(packageManager);
    }

    @WrapElementForJNI
    public static boolean getShowPasswordSetting() {
        try {
            int n = Settings.System.getInt((ContentResolver)GeckoAppShell.getContext().getContentResolver(), (String)"show_password", (int)1);
            return n > 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @WrapElementForJNI(stubName="AddPluginViewWrapper")
    public static void addPluginView(View view, float f, float f2, float f3, float f4, boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().addPluginView(view, new RectF(f, f2, f + f3, f2 + f4), bl);
        }
    }

    @WrapElementForJNI
    public static void removePluginView(View view, boolean bl) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().removePluginView(view, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPluginDirectories() {
        Object object;
        Object object2;
        Serializable serializable;
        boolean bl = new File("/system/lib/hw/gralloc.tegra.so").exists();
        if (bl) {
            serializable = new File("/proc/version");
            object2 = null;
            try {
                if (((File)serializable).canRead() && (((String)(object = new BufferedReader((Reader)(object2 = new FileReader((File)serializable))).readLine())).indexOf("CM9") != -1 || ((String)object).indexOf("cyanogen") != -1 || ((String)object).indexOf("Nova") != -1)) {
                    Log.w((String)LOGTAG, (String)"Blocking plugins because of Tegra 2 + unofficial ICS bug (bug 736421)");
                    String[] stringArray = null;
                    return stringArray;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (object2 != null) {
                        ((InputStreamReader)object2).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        serializable = new ArrayList();
        object2 = GeckoAppShell.getContext().getPackageManager();
        object = object2.queryIntentServices(new Intent(PLUGIN_ACTION), 132);
        ArrayList<PackageInfo> arrayList = mPackageInfoCache;
        synchronized (arrayList) {
            mPackageInfoCache.clear();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2;
                PackageInfo packageInfo;
                block37: {
                    String[] stringArray;
                    ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                    ServiceInfo serviceInfo = resolveInfo.serviceInfo;
                    if (serviceInfo == null) {
                        Log.w((String)LOGTAG, (String)"Ignoring bad plugin.");
                        continue;
                    }
                    if (serviceInfo.packageName.equals("com.htc.flashliteplugin")) {
                        Log.w((String)LOGTAG, (String)"Skipping HTC's flash lite plugin");
                        continue;
                    }
                    try {
                        packageInfo = object2.getPackageInfo(serviceInfo.packageName, 4160);
                    }
                    catch (Exception exception) {
                        Log.w((String)LOGTAG, (String)("Can't find plugin: " + serviceInfo.packageName));
                        continue;
                    }
                    if (packageInfo == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Could not load package information."));
                        continue;
                    }
                    string2 = packageInfo.applicationInfo.dataDir + "/lib";
                    int n = packageInfo.applicationInfo.flags;
                    if ((n & 0x81) == 1) {
                        string2 = PLUGIN_SYSTEM_LIB + packageInfo.packageName;
                    }
                    if ((stringArray = packageInfo.requestedPermissions) == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Does not have required permission."));
                        continue;
                    }
                    boolean bl2 = false;
                    for (String string3 : stringArray) {
                        if (!PLUGIN_PERMISSION.equals(string3)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Does not have required permission (2)."));
                        continue;
                    }
                    String[] stringArray2 = packageInfo.signatures;
                    if (stringArray2 == null) {
                        Log.w((String)LOGTAG, (String)("Not loading plugin: " + serviceInfo.packageName + ". Not signed."));
                        continue;
                    }
                    if (serviceInfo.metaData == null) {
                        Log.e((String)LOGTAG, (String)("The plugin '" + serviceInfo.name + "' has no defined type."));
                        continue;
                    }
                    String string4 = serviceInfo.metaData.getString(PLUGIN_TYPE);
                    if (!TYPE_NATIVE.equals(string4)) {
                        Log.e((String)LOGTAG, (String)("Unrecognized plugin type: " + string4));
                        continue;
                    }
                    try {
                        Class<?> clazz = GeckoAppShell.getPluginClass(serviceInfo.packageName, serviceInfo.name);
                        boolean bl3 = true;
                        if (!bl3) {
                            Log.e((String)LOGTAG, (String)("The plugin's class' " + serviceInfo.name + "' does not extend the appropriate class."));
                        }
                        break block37;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)LOGTAG, (String)("Can't find plugin: " + serviceInfo.packageName));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Log.e((String)LOGTAG, (String)("Can't find plugin's class: " + serviceInfo.name));
                    }
                    continue;
                }
                mPackageInfoCache.add(packageInfo);
                ((ArrayList)serializable).add(string2);
            }
        }
        return ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getPluginPackage(String string2) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        ArrayList<PackageInfo> arrayList = mPackageInfoCache;
        synchronized (arrayList) {
            for (PackageInfo packageInfo : mPackageInfoCache) {
                if (!string2.contains(packageInfo.packageName)) continue;
                return packageInfo.packageName;
            }
        }
        return null;
    }

    static Class<?> getPluginClass(String string2, String string3) throws PackageManager.NameNotFoundException, ClassNotFoundException {
        Context context = GeckoAppShell.getContext().createPackageContext(string2, 3);
        ClassLoader classLoader = context.getClassLoader();
        return classLoader.loadClass(string3);
    }

    @WrapElementForJNI(allowMultithread=true)
    public static Class<?> loadPluginClass(String string2, String string3) {
        if (GeckoAppShell.getGeckoInterface() == null) {
            return null;
        }
        try {
            String string4 = GeckoAppShell.getPluginPackage(string3);
            Context context = GeckoAppShell.getContext().createPackageContext(string4, 3);
            return context.getClassLoader().loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)LOGTAG, (String)("Couldn't find plugin class " + string2), (Throwable)classNotFoundException);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)LOGTAG, (String)"Couldn't find package.", (Throwable)nameNotFoundException);
            return null;
        }
    }

    @WrapElementForJNI(allowMultithread=true)
    public static Context getContext() {
        return sContextGetter.getContext();
    }

    public static void setContextGetter(ContextGetter contextGetter) {
        sContextGetter = contextGetter;
    }

    public static SharedPreferences getSharedPreferences() {
        if (sContextGetter == null) {
            throw new IllegalStateException("No ContextGetter; cannot fetch prefs.");
        }
        return sContextGetter.getSharedPreferences();
    }

    public static GeckoInterface getGeckoInterface() {
        return sGeckoInterface;
    }

    public static void setGeckoInterface(GeckoInterface geckoInterface) {
        sGeckoInterface = geckoInterface;
    }

    static native void cameraCallbackBridge(byte[] var0);

    @WrapElementForJNI(stubName="InitCameraWrapper")
    static int[] initCamera(String string2, int n, int n2, int n3) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                try {
                    if (GeckoAppShell.getGeckoInterface() != null) {
                        GeckoAppShell.getGeckoInterface().enableCameraView();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        int[] nArray = new int[4];
        nArray[0] = 0;
        if (Build.VERSION.SDK_INT >= 9 && Camera.getNumberOfCameras() == 0) {
            return nArray;
        }
        try {
            Camera.Size size;
            int n4;
            Iterator iterator;
            sCamera = Build.VERSION.SDK_INT >= 9 ? Camera.open((int)n) : Camera.open();
            Camera.Parameters parameters = sCamera.getParameters();
            parameters.setPreviewFormat(17);
            int n5 = 1000;
            try {
                iterator = parameters.getSupportedPreviewFrameRates().iterator();
                while (iterator.hasNext()) {
                    n4 = (Integer)iterator.next();
                    if (Math.abs(n4 - kPreferedFps) >= n5) continue;
                    n5 = Math.abs(n4 - kPreferedFps);
                    parameters.setPreviewFrameRate(n4);
                }
            }
            catch (Exception exception) {
                parameters.setPreviewFrameRate(kPreferedFps);
            }
            iterator = parameters.getSupportedPreviewSizes().iterator();
            n4 = 10000000;
            int n6 = 0;
            while (iterator.hasNext()) {
                size = (Camera.Size)iterator.next();
                if (Math.abs(size.width * size.height - n2 * n3) >= n4) continue;
                n4 = Math.abs(size.width * size.height - n2 * n3);
                parameters.setPreviewSize(size.width, size.height);
                n6 = size.width * size.height;
            }
            try {
                if (GeckoAppShell.getGeckoInterface() != null) {
                    size = GeckoAppShell.getGeckoInterface().getCameraView();
                    if (size instanceof SurfaceView) {
                        sCamera.setPreviewDisplay(((SurfaceView)size).getHolder());
                    } else if (size instanceof TextureView) {
                        sCamera.setPreviewTexture(((TextureView)size).getSurfaceTexture());
                    }
                }
            }
            catch (IOException iOException) {
                Log.w((String)LOGTAG, (String)"Error setPreviewXXX:", (Throwable)iOException);
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)LOGTAG, (String)"Error setPreviewXXX:", (Throwable)runtimeException);
            }
            sCamera.setParameters(parameters);
            sCameraBuffer = new byte[n6 * 12 / 8];
            sCamera.addCallbackBuffer(sCameraBuffer);
            sCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

                public void onPreviewFrame(byte[] byArray, Camera camera) {
                    GeckoAppShell.cameraCallbackBridge(byArray);
                    if (sCamera != null) {
                        sCamera.addCallbackBuffer(sCameraBuffer);
                    }
                }
            });
            sCamera.startPreview();
            parameters = sCamera.getParameters();
            nArray[0] = 1;
            nArray[1] = parameters.getPreviewSize().width;
            nArray[2] = parameters.getPreviewSize().height;
            nArray[3] = parameters.getPreviewFrameRate();
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)LOGTAG, (String)"initCamera RuntimeException.", (Throwable)runtimeException);
            nArray[3] = 0;
            nArray[2] = 0;
            nArray[1] = 0;
            nArray[0] = 0;
        }
        return nArray;
    }

    @WrapElementForJNI
    static synchronized void closeCamera() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                try {
                    if (GeckoAppShell.getGeckoInterface() != null) {
                        GeckoAppShell.getGeckoInterface().disableCameraView();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        if (sCamera != null) {
            sCamera.stopPreview();
            sCamera.release();
            sCamera = null;
            sCameraBuffer = null;
        }
    }

    @RobocopTarget
    public static void registerEventListener(String string2, GeckoEventListener geckoEventListener) {
        sEventDispatcher.registerEventListener(string2, geckoEventListener);
    }

    public static EventDispatcher getEventDispatcher() {
        return sEventDispatcher;
    }

    @RobocopTarget
    public static void unregisterEventListener(String string2, GeckoEventListener geckoEventListener) {
        sEventDispatcher.unregisterEventListener(string2, geckoEventListener);
    }

    @WrapElementForJNI
    public static void enableBatteryNotifications() {
        GeckoBatteryManager.enableNotifications();
    }

    @WrapElementForJNI(stubName="HandleGeckoMessageWrapper")
    public static String handleGeckoMessage(String string2) {
        return sEventDispatcher.dispatchEvent(string2);
    }

    @WrapElementForJNI
    public static void disableBatteryNotifications() {
        GeckoBatteryManager.disableNotifications();
    }

    @WrapElementForJNI(stubName="GetCurrentBatteryInformationWrapper")
    public static double[] getCurrentBatteryInformation() {
        return GeckoBatteryManager.getCurrentInformation();
    }

    @WrapElementForJNI(stubName="CheckURIVisited")
    static void checkUriVisited(String string2) {
        GlobalHistory.getInstance().checkUriVisited(string2);
    }

    @WrapElementForJNI(stubName="MarkURIVisited")
    static void markUriVisited(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                GlobalHistory.getInstance().add(string2);
            }
        });
    }

    @WrapElementForJNI(stubName="SetURITitle")
    static void setUriTitle(final String string2, final String string3) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                GlobalHistory.getInstance().update(string2, string3);
            }
        });
    }

    @WrapElementForJNI
    static void hideProgressDialog() {
    }

    @WrapElementForJNI(stubName="SendMessageWrapper")
    public static void sendMessage(String string2, String string3, int n) {
        if (SmsManager.getInstance() == null) {
            return;
        }
        SmsManager.getInstance().send(string2, string3, n);
    }

    @WrapElementForJNI(stubName="GetMessageWrapper")
    public static void getMessage(int n, int n2) {
        if (SmsManager.getInstance() == null) {
            return;
        }
        SmsManager.getInstance().getMessage(n, n2);
    }

    @WrapElementForJNI(stubName="DeleteMessageWrapper")
    public static void deleteMessage(int n, int n2) {
        if (SmsManager.getInstance() == null) {
            return;
        }
        SmsManager.getInstance().deleteMessage(n, n2);
    }

    @WrapElementForJNI(stubName="CreateMessageListWrapper")
    public static void createMessageList(long l, long l2, String[] stringArray, int n, int n2, boolean bl, int n3) {
        if (SmsManager.getInstance() == null) {
            return;
        }
        SmsManager.getInstance().createMessageList(l, l2, stringArray, n, n2, bl, n3);
    }

    @WrapElementForJNI(stubName="GetNextMessageInListWrapper")
    public static void getNextMessageInList(int n, int n2) {
        if (SmsManager.getInstance() == null) {
            return;
        }
        SmsManager.getInstance().getNextMessageInList(n, n2);
    }

    @WrapElementForJNI
    public static void clearMessageList(int n) {
        if (SmsManager.getInstance() == null) {
            return;
        }
        SmsManager.getInstance().clearMessageList(n);
    }

    @WrapElementForJNI
    @RobocopTarget
    public static boolean isTablet() {
        return HardwareUtils.isTablet();
    }

    public static void viewSizeChanged() {
        LayerView layerView = GeckoAppShell.getLayerView();
        if (layerView != null && layerView.isIMEEnabled()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("ScrollTo:FocusedInput", ""));
        }
    }

    @WrapElementForJNI(stubName="GetCurrentNetworkInformationWrapper")
    public static double[] getCurrentNetworkInformation() {
        return GeckoNetworkManager.getInstance().getCurrentInformation();
    }

    @WrapElementForJNI
    public static void enableNetworkNotifications() {
        GeckoNetworkManager.getInstance().enableNotifications();
    }

    @WrapElementForJNI
    public static void disableNetworkNotifications() {
        GeckoNetworkManager.getInstance().disableNotifications();
    }

    public static byte[] encodeBase64(byte[] byArray, int n) {
        byte[] byArray2;
        if (Build.VERSION.SDK_INT >= 8) {
            return Base64.encode((byte[])byArray, (int)(n | 2));
        }
        int n2 = (byArray.length * 4 + 2) / 3;
        int n3 = (byArray.length + 2) / 3 * 4;
        byte[] byArray3 = new byte[n3];
        int n4 = 0;
        int n5 = byArray.length;
        int n6 = 0;
        byte[] byArray4 = byArray2 = (n & 8) == 0 ? map1 : map1_urlsafe;
        while (n4 < n5) {
            int n7 = byArray[n4++] & 0xFF;
            int n8 = n4 < n5 ? byArray[n4++] & 0xFF : 0;
            int n9 = n4 < n5 ? byArray[n4++] & 0xFF : 0;
            int n10 = n7 >>> 2;
            int n11 = (n7 & 3) << 4 | n8 >>> 4;
            int n12 = (n8 & 0xF) << 2 | n9 >>> 6;
            int n13 = n9 & 0x3F;
            byArray3[n6++] = byArray2[n10];
            byArray3[n6++] = byArray2[n11];
            byArray3[n6] = n6 < n2 ? byArray2[n12] : 61;
            int n14 = ++n6 < n2 ? byArray2[n13] : 61;
            byArray3[n6] = n14;
            ++n6;
        }
        return byArray3;
    }

    public static byte[] decodeBase64(byte[] byArray, int n) {
        if (Build.VERSION.SDK_INT >= 8) {
            return Base64.decode((byte[])byArray, (int)n);
        }
        int n2 = 0;
        int n3 = byArray.length;
        if (n3 % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (n3 > 0 && byArray[n2 + n3 - 1] == 61) {
            --n3;
        }
        int n4 = n3 * 3 / 4;
        byte[] byArray2 = new byte[n4];
        int n5 = n2;
        int n6 = n2 + n3;
        int n7 = 0;
        while (n5 < n6) {
            int n8;
            byte by = byArray[n5++];
            byte by2 = byArray[n5++];
            int n9 = n5 < n6 ? byArray[n5++] : 65;
            int n10 = n8 = n5 < n6 ? byArray[n5++] : 65;
            if (by > 127 || by2 > 127 || n9 > 127 || n8 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte by3 = map2[by];
            byte by4 = map2[by2];
            byte by5 = map2[n9];
            byte by6 = map2[n8];
            if (by3 < 0 || by4 < 0 || by5 < 0 || by6 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int n11 = by3 << 2 | by4 >>> 4;
            int n12 = (by4 & 0xF) << 4 | by5 >>> 2;
            int n13 = (by5 & 3) << 6 | by6;
            byArray2[n7++] = (byte)n11;
            if (n7 < n4) {
                byArray2[n7++] = (byte)n12;
            }
            if (n7 >= n4) continue;
            byArray2[n7++] = (byte)n13;
        }
        return byArray2;
    }

    public static byte[] decodeBase64(String string2, int n) {
        return GeckoAppShell.decodeBase64(string2.getBytes(), n);
    }

    @WrapElementForJNI(stubName="GetScreenOrientationWrapper")
    public static short getScreenOrientation() {
        return GeckoScreenOrientationListener.getInstance().getScreenOrientation();
    }

    @WrapElementForJNI
    public static void enableScreenOrientationNotifications() {
        GeckoScreenOrientationListener.getInstance().enableNotifications();
    }

    @WrapElementForJNI
    public static void disableScreenOrientationNotifications() {
        GeckoScreenOrientationListener.getInstance().disableNotifications();
    }

    @WrapElementForJNI
    public static void lockScreenOrientation(int n) {
        GeckoScreenOrientationListener.getInstance().lockScreenOrientation(n);
    }

    @WrapElementForJNI
    public static void unlockScreenOrientation() {
        GeckoScreenOrientationListener.getInstance().unlockScreenOrientation();
    }

    @WrapElementForJNI
    public static boolean pumpMessageLoop() {
        Handler handler = ThreadUtils.sGeckoHandler;
        Message message = GeckoAppShell.getNextMessageFromQueue(ThreadUtils.sGeckoQueue);
        if (message == null) {
            return false;
        }
        if (message.obj == handler && message.getTarget() == handler) {
            message.recycle();
            return false;
        }
        if (message.getTarget() == null) {
            Looper.myLooper().quit();
        } else {
            message.getTarget().dispatchMessage(message);
        }
        message.recycle();
        return true;
    }

    static native void notifyFilePickerResult(String var0, long var1);

    @WrapElementForJNI(stubName="ShowFilePickerAsyncWrapper")
    public static void showFilePickerAsync(String string2, final long l) {
        sActivityHelper.showFilePickerAsync(GeckoAppShell.getGeckoInterface().getActivity(), string2, new ActivityHandlerHelper.FileResultHandler(){

            public void gotFile(String string2) {
                GeckoAppShell.notifyFilePickerResult(string2, l);
            }
        });
    }

    @WrapElementForJNI
    public static void notifyWakeLockChanged(String string2, String string3) {
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoAppShell.getGeckoInterface().notifyWakeLockChanged(string2, string3);
        }
    }

    @WrapElementForJNI
    public static void registerSurfaceTextureFrameListener(Object object, final int n) {
        ((SurfaceTexture)object).setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                GeckoAppShell.onSurfaceTextureFrameAvailable(surfaceTexture, n);
            }
        });
    }

    @WrapElementForJNI(allowMultithread=true)
    public static void unregisterSurfaceTextureFrameListener(Object object) {
        ((SurfaceTexture)object).setOnFrameAvailableListener(null);
    }

    @WrapElementForJNI
    public static boolean unlockProfile() {
        GeckoAppShell.killAnyZombies();
        if (GeckoAppShell.getGeckoInterface() != null) {
            GeckoProfile geckoProfile = GeckoAppShell.getGeckoInterface().getProfile();
            File file = geckoProfile.getFile(".parentlock");
            return file.exists() && file.delete();
        }
        return false;
    }

    @WrapElementForJNI(stubName="GetProxyForURIWrapper")
    public static String getProxyForURI(String string2, String string3, String string4, int n) {
        ProxySelector proxySelector = new ProxySelector();
        Proxy proxy = proxySelector.select(string3, string4);
        if (Proxy.NO_PROXY.equals(proxy)) {
            return "DIRECT";
        }
        switch (proxy.type()) {
            case HTTP: {
                return "PROXY " + proxy.address().toString();
            }
            case SOCKS: {
                return "SOCKS " + proxy.address().toString();
            }
        }
        return "DIRECT";
    }

    public static void installApk(final Activity activity, String string2, String string3) {
        JSONObject jSONObject = null;
        String string4 = null;
        try {
            jSONObject = new JSONObject(string3);
            string4 = jSONObject.getJSONObject("app").getString("manifestURL");
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"can't get manifest URL from JSON data", (Throwable)jSONException);
            return;
        }
        final InstallListener installListener = new InstallListener(string4, jSONObject);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        activity.registerReceiver((BroadcastReceiver)installListener, intentFilter);
        File file = new File(string2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        sActivityHelper.startIntentForActivity(activity, intent, new ActivityResultHandler(){

            public void onActivityResult(int n, Intent intent) {
                if (n == 0) {
                    try {
                        activity.unregisterReceiver((BroadcastReceiver)installListener);
                        installListener.cleanup();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.e((String)GeckoAppShell.LOGTAG, (String)"error unregistering install receiver: ", (Throwable)illegalArgumentException);
                    }
                }
            }
        });
    }

    static {
        int n;
        gPendingEvents = new LinkedList();
        gRestartScheduled = false;
        mEditableListener = null;
        mAlertCookies = new HashMap();
        sDensityDpi = 0;
        sScreenDepth = 0;
        sEventDispatcher = new EventDispatcher();
        DEFAULT_LAUNCHER_ICON_HSV = new float[]{32.0f, 1.0f, 1.0f};
        sVibrationMaybePlaying = false;
        sVibrationEndTime = 0L;
        sDefaultSensorHint = 100;
        gAccelerometerSensor = null;
        gLinearAccelerometerSensor = null;
        gGyroscopeSensor = null;
        gOrientationSensor = null;
        gProximitySensor = null;
        gLightSensor = null;
        sActivityHelper = new ActivityHandlerHelper();
        sEventAckLock = new Object();
        mPackageInfoCache = new ArrayList();
        sCamera = null;
        kPreferedFps = 25;
        sCameraBuffer = null;
        map1 = new byte[64];
        int n2 = 0;
        for (n = 65; n <= 90; n = (int)((byte)(n + 1))) {
            GeckoAppShell.map1[n2++] = n;
        }
        for (n = 97; n <= 122; n = (int)((byte)(n + 1))) {
            GeckoAppShell.map1[n2++] = n;
        }
        for (n = 48; n <= 57; n = (int)((byte)(n + 1))) {
            GeckoAppShell.map1[n2++] = n;
        }
        GeckoAppShell.map1[n2++] = 43;
        GeckoAppShell.map1[n2++] = 47;
        map1_urlsafe = (byte[])map1.clone();
        GeckoAppShell.map1_urlsafe[62] = 45;
        GeckoAppShell.map1_urlsafe[63] = 95;
        map2 = new byte[128];
        for (n2 = 0; n2 < map2.length; ++n2) {
            GeckoAppShell.map2[n2] = -1;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            GeckoAppShell.map2[GeckoAppShell.map1[n2]] = (byte)n2;
        }
        GeckoAppShell.map2[45] = 62;
        GeckoAppShell.map2[95] = 63;
    }

    public static interface GeckoInterface {
        public GeckoProfile getProfile();

        public PromptService getPromptService();

        public Activity getActivity();

        public String getDefaultUAString();

        public LocationListener getLocationListener();

        public SensorEventListener getSensorEventListener();

        public void doRestart();

        public void setFullScreen(boolean var1);

        public void addPluginView(View var1, RectF var2, boolean var3);

        public void removePluginView(View var1, boolean var2);

        public void enableCameraView();

        public void disableCameraView();

        public void addAppStateListener(AppStateListener var1);

        public void removeAppStateListener(AppStateListener var1);

        public View getCameraView();

        public void notifyWakeLockChanged(String var1, String var2);

        public FormAssistPopup getFormAssistPopup();

        public boolean areTabsShown();

        public AbsoluteLayout getPluginContainer();

        public void notifyCheckUpdateResult(String var1);

        public boolean hasTabsSideBar();

        public void invalidateOptionsMenu();
    }

    public static interface AppStateListener {
        public void onPause();

        public void onResume();

        public void onOrientationChanged();
    }

    static interface GeckoProcessesVisitor {
        public boolean callback(int var1);
    }

    private static final class GeckoMediaScannerClient
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private final String mFile;
        private final String mMimeType;
        private MediaScannerConnection mScanner;

        public static void startScan(Context context, String string2, String string3) {
            new GeckoMediaScannerClient(context, string2, string3);
        }

        private GeckoMediaScannerClient(Context context, String string2, String string3) {
            this.mFile = string2;
            this.mMimeType = string3;
            this.mScanner = new MediaScannerConnection(context, (MediaScannerConnection.MediaScannerConnectionClient)this);
            this.mScanner.connect();
        }

        public void onMediaScannerConnected() {
            this.mScanner.scanFile(this.mFile, this.mMimeType);
        }

        public void onScanCompleted(String string2, Uri uri) {
            if (string2.equals(this.mFile)) {
                this.mScanner.disconnect();
                this.mScanner = null;
            }
        }
    }

    public static class CreateShortcutFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private final String title;
        private final String url;

        public CreateShortcutFaviconLoadedListener(String string2, String string3) {
            this.url = string2;
            this.title = string3;
        }

        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            GeckoAppShell.createShortcut(this.title, this.url, this.url, bitmap, "");
        }
    }
}

