/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import java.io.IOException;
import java.util.Locale;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoJavaSampler;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoThread
extends Thread
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoThread";
    private static LaunchState sLaunchState = LaunchState.Launching;
    private static GeckoThread sGeckoThread;
    private final String mArgs;
    private final String mAction;
    private final String mUri;
    public static String sArgs;
    public static String sAction;
    public static String sUri;
    private static Object sLock;

    public static boolean ensureInit() {
        ThreadUtils.assertOnUiThread();
        if (GeckoThread.isCreated()) {
            return false;
        }
        sGeckoThread = new GeckoThread(sArgs, sAction, sUri);
        return true;
    }

    public static void setArgs(String string2) {
        sArgs = string2;
    }

    public static void setAction(String string2) {
        sAction = string2;
    }

    public static void setUri(String string2) {
        sUri = string2;
    }

    GeckoThread(String string2, String string3, String string4) {
        this.mArgs = string2;
        this.mAction = string3;
        this.mUri = string4;
        this.setName("Gecko");
        GeckoAppShell.getEventDispatcher().registerEventListener("Gecko:Ready", (GeckoEventListener)this);
    }

    public static boolean isCreated() {
        return sGeckoThread != null;
    }

    public static void createAndStart() {
        if (GeckoThread.ensureInit()) {
            sGeckoThread.start();
        }
    }

    private String initGeckoEnvironment() {
        Activity activity;
        Locale locale = Locale.getDefault();
        if (locale.toString().equalsIgnoreCase("zh_hk")) {
            locale = Locale.TRADITIONAL_CHINESE;
            Locale.setDefault(locale);
        }
        Context context = GeckoAppShell.getContext();
        String string2 = "";
        Resources resources = null;
        String[] stringArray = null;
        try {
            stringArray = GeckoAppShell.getPluginDirectories();
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Caught exception getting plugin dirs.", (Throwable)exception);
        }
        if (context instanceof Activity) {
            activity = (Activity)context;
            string2 = activity.getApplication().getPackageResourcePath();
            resources = activity.getBaseContext().getResources();
            GeckoLoader.setupGeckoEnvironment((Activity)activity, (String[])stringArray, (String)context.getFilesDir().getPath());
        }
        GeckoLoader.loadSQLiteLibs((Context)context, (String)string2);
        GeckoLoader.loadNSSLibs((Context)context, (String)string2);
        GeckoLoader.loadGeckoLibs((Context)context, (String)string2);
        GeckoJavaSampler.setLibsLoaded();
        Locale.setDefault(locale);
        activity = resources.getConfiguration();
        activity.locale = locale;
        resources.updateConfiguration((Configuration)activity, resources.getDisplayMetrics());
        return string2;
    }

    private String getTypeFromAction(String string2) {
        if (string2 != null && string2.startsWith("org.mozilla.gecko.WEBAPP")) {
            return "-webapp";
        }
        if ("org.mozilla.gecko.BOOKMARK".equals(string2)) {
            return "-bookmark";
        }
        return null;
    }

    private String addCustomProfileArg(String string2) {
        String string3 = "";
        String string4 = "";
        if (GeckoAppShell.getGeckoInterface() != null) {
            if (GeckoAppShell.getGeckoInterface().getProfile().inGuestMode()) {
                try {
                    string3 = " -profile " + GeckoAppShell.getGeckoInterface().getProfile().getDir().getCanonicalPath();
                }
                catch (IOException iOException) {
                    Log.e((String)LOGTAG, (String)"error getting guest profile path", (Throwable)iOException);
                }
                if (string2 == null || !string2.contains("--guest")) {
                    string4 = " --guest";
                }
            } else if (!GeckoProfile.sIsUsingCustomProfile) {
                string3 = " -P " + GeckoAppShell.getGeckoInterface().getProfile().getName();
            }
        }
        return (string2 != null ? string2 : "") + string3 + string4;
    }

    public void run() {
        Looper.prepare();
        ThreadUtils.sGeckoThread = this;
        ThreadUtils.sGeckoHandler = new Handler();
        ThreadUtils.sGeckoQueue = Looper.myQueue();
        String string2 = this.initGeckoEnvironment();
        Log.w((String)LOGTAG, (String)("zerdatime " + SystemClock.uptimeMillis() + " - runGecko"));
        String string3 = this.addCustomProfileArg(this.mArgs);
        String string4 = this.getTypeFromAction(this.mAction);
        Log.i((String)LOGTAG, (String)("RunGecko - args = " + string3));
        GeckoAppShell.runGecko(string2, string3, this.mUri, string4);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if ("Gecko:Ready".equals(string2)) {
            GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
            GeckoThread.setLaunchState(LaunchState.GeckoRunning);
            GeckoAppShell.sendPendingEventsToGecko();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RobocopTarget
    public static boolean checkLaunchState(LaunchState launchState) {
        Object object = sLock;
        synchronized (object) {
            return sLaunchState == launchState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setLaunchState(LaunchState launchState) {
        Object object = sLock;
        synchronized (object) {
            sLaunchState = launchState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkAndSetLaunchState(LaunchState launchState, LaunchState launchState2) {
        Object object = sLock;
        synchronized (object) {
            if (sLaunchState != launchState) {
                return false;
            }
            sLaunchState = launchState2;
            return true;
        }
    }

    static {
        sLock = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RobocopTarget
    public static enum LaunchState {
        Launching,
        WaitForDebugger,
        Launched,
        GeckoRunning,
        GeckoExiting;

    }
}

