/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.database.Cursor;
import android.util.Log;
import java.util.ArrayList;

class MessagesListManager {
    private static final MessagesListManager sInstance = new MessagesListManager();
    private ArrayList<Cursor> mCursors = new ArrayList(0);

    MessagesListManager() {
    }

    public static MessagesListManager getInstance() {
        return sInstance;
    }

    public int add(Cursor cursor) {
        int n = this.mCursors.size();
        for (int i = 0; i < n; ++i) {
            if (this.mCursors.get(i) != null) continue;
            this.mCursors.set(i, cursor);
            return i;
        }
        this.mCursors.add(cursor);
        return n;
    }

    public Cursor get(int n) {
        if (n < 0 || this.mCursors.size() <= n) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to get an unknown list!");
            return null;
        }
        Cursor cursor = this.mCursors.get(n);
        if (cursor == null) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to get an empty list!");
        }
        return cursor;
    }

    public void remove(int n) {
        if (n < 0 || this.mCursors.size() <= n) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to destroy an unknown list!");
            return;
        }
        Cursor cursor = this.mCursors.set(n, null);
        if (cursor == null) {
            Log.e((String)"GeckoSmsManager", (String)"Trying to destroy an empty list!");
            return;
        }
        cursor.close();
    }

    public void clear() {
        for (int i = 0; i < this.mCursors.size(); ++i) {
            Cursor cursor = this.mCursors.get(i);
            if (cursor == null) continue;
            cursor.close();
        }
        this.mCursors.clear();
    }
}

