/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.view.MotionEvent;
import android.view.View;
import java.util.Timer;
import java.util.TimerTask;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.util.GamepadUtils;

public class ScrollAnimator
implements View.OnGenericMotionListener {
    private Timer mScrollTimer;
    private int mX;
    private int mY;
    static final long MS_PER_FRAME = 16L;
    static final float MAX_SCROLL = 0.075f * (float)GeckoAppShell.getDpi();

    public boolean onGenericMotion(View view, MotionEvent motionEvent) {
        if ((motionEvent.getSource() & 0x10) != 0) {
            switch (motionEvent.getAction()) {
                case 2: {
                    if (GamepadUtils.isValueInDeadZone((MotionEvent)motionEvent, (int)0) && GamepadUtils.isValueInDeadZone((MotionEvent)motionEvent, (int)1)) {
                        if (this.mScrollTimer != null) {
                            this.mScrollTimer.cancel();
                            this.mScrollTimer = null;
                        }
                        return true;
                    }
                    this.mX = (int)(motionEvent.getAxisValue(0) * MAX_SCROLL);
                    this.mY = (int)(motionEvent.getAxisValue(1) * MAX_SCROLL);
                    if (this.mScrollTimer == null) {
                        this.mScrollTimer = new Timer();
                        ScrollRunnable scrollRunnable = new ScrollRunnable(view);
                        this.mScrollTimer.scheduleAtFixedRate((TimerTask)scrollRunnable, 0L, 16L);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void cancel() {
        if (this.mScrollTimer != null) {
            this.mScrollTimer.cancel();
            this.mScrollTimer = null;
        }
    }

    private class ScrollRunnable
    extends TimerTask {
        private View mView;

        public ScrollRunnable(View view) {
            this.mView = view;
        }

        public final void run() {
            this.mView.scrollBy(ScrollAnimator.this.mX, ScrollAnimator.this.mY);
        }
    }
}

