/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.concurrent.CountDownLatch;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FxAccountSetupTask<T>
extends AsyncTask<Void, Void, InnerRequestDelegate<T>> {
    protected static final String LOG_TAG = FxAccountSetupTask.class.getSimpleName();
    protected final Context context;
    protected final String email;
    protected final byte[] emailUTF8;
    protected final String password;
    public final byte[] quickStretchedPW;
    protected final FxAccountClient20 client;
    protected ProgressDialog progressDialog = null;
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected final InnerRequestDelegate<T> innerDelegate = new InnerRequestDelegate(this.latch);
    protected final FxAccountClient10.RequestDelegate<T> delegate;

    public FxAccountSetupTask(Context context, String string2, String string3, FxAccountClient20 fxAccountClient20, FxAccountClient10.RequestDelegate<T> requestDelegate) throws UnsupportedEncodingException, GeneralSecurityException {
        this.context = context;
        this.email = string2;
        this.emailUTF8 = string2.getBytes("UTF-8");
        this.password = string3;
        this.quickStretchedPW = FxAccountUtils.generateQuickStretchedPW(this.emailUTF8, string3.getBytes("UTF-8"));
        this.client = fxAccountClient20;
        this.delegate = requestDelegate;
    }

    protected void onPreExecute() {
        this.progressDialog = new ProgressDialog(this.context);
        this.progressDialog.setTitle((CharSequence)"Firefox Account...");
        this.progressDialog.setMessage((CharSequence)"Please wait.");
        this.progressDialog.setCancelable(false);
        this.progressDialog.setIndeterminate(true);
        this.progressDialog.show();
    }

    protected void onPostExecute(InnerRequestDelegate<T> innerRequestDelegate) {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
        }
        if (innerRequestDelegate.response != null) {
            this.delegate.handleSuccess(innerRequestDelegate.response);
        } else if (innerRequestDelegate.exception instanceof HTTPFailureException) {
            HTTPFailureException hTTPFailureException = (HTTPFailureException)innerRequestDelegate.exception;
            this.delegate.handleFailure(hTTPFailureException.response.getStatusCode(), hTTPFailureException.response.httpResponse());
        } else if (this.innerDelegate.exception != null) {
            this.delegate.handleError(this.innerDelegate.exception);
        } else {
            this.delegate.handleError(new IllegalStateException("Got bad state."));
        }
    }

    protected void onCancelled(InnerRequestDelegate<T> innerRequestDelegate) {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
        }
        this.delegate.handleError(new IllegalStateException("Task was cancelled."));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FxAccountSignInTask
    extends FxAccountSetupTask<FxAccountClient20.LoginResponse> {
        protected static final String LOG_TAG = FxAccountSignUpTask.class.getSimpleName();

        public FxAccountSignInTask(Context context, String string2, String string3, FxAccountClient20 fxAccountClient20, FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> requestDelegate) throws UnsupportedEncodingException, GeneralSecurityException {
            super(context, string2, string3, fxAccountClient20, requestDelegate);
        }

        protected InnerRequestDelegate<FxAccountClient20.LoginResponse> doInBackground(Void ... voidArray) {
            try {
                this.client.loginAndGetKeys(this.emailUTF8, this.quickStretchedPW, this.innerDelegate);
                this.latch.await();
                return this.innerDelegate;
            }
            catch (InterruptedException interruptedException) {
                Logger.error(LOG_TAG, "Got exception signing in.", interruptedException);
                this.delegate.handleError(interruptedException);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FxAccountSignUpTask
    extends FxAccountSetupTask<String> {
        protected static final String LOG_TAG = FxAccountSignUpTask.class.getSimpleName();

        public FxAccountSignUpTask(Context context, String string2, String string3, FxAccountClient20 fxAccountClient20, FxAccountClient10.RequestDelegate<String> requestDelegate) throws UnsupportedEncodingException, GeneralSecurityException {
            super(context, string2, string3, fxAccountClient20, requestDelegate);
        }

        protected InnerRequestDelegate<String> doInBackground(Void ... voidArray) {
            try {
                this.client.createAccount(this.emailUTF8, this.quickStretchedPW, false, this.innerDelegate);
                this.latch.await();
                return this.innerDelegate;
            }
            catch (InterruptedException interruptedException) {
                Logger.error(LOG_TAG, "Got exception logging in.", interruptedException);
                this.delegate.handleError(interruptedException);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InnerRequestDelegate<T>
    implements FxAccountClient10.RequestDelegate<T> {
        protected final CountDownLatch latch;
        public T response = null;
        public Exception exception = null;

        protected InnerRequestDelegate(CountDownLatch countDownLatch) {
            this.latch = countDownLatch;
        }

        @Override
        public void handleError(Exception exception) {
            Logger.error(LOG_TAG, "Got exception.");
            this.exception = exception;
            this.latch.countDown();
        }

        @Override
        public void handleFailure(int n, HttpResponse httpResponse) {
            Logger.warn(LOG_TAG, "Got failure.");
            this.exception = new HTTPFailureException(new SyncStorageResponse(httpResponse));
            this.latch.countDown();
        }

        @Override
        public void handleSuccess(T t) {
            Logger.info(LOG_TAG, "Got success.");
            this.response = t;
            this.latch.countDown();
        }
    }
}

