/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountUpdateCredentialsActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;

public class FxAccountStatusActivity
extends FxAccountAbstractActivity {
    protected static final String LOG_TAG = FxAccountStatusActivity.class.getSimpleName();
    protected View connectionStatusUnverifiedView;
    protected View connectionStatusSignInView;
    protected View connectionStatusSyncingView;

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_status);
        this.connectionStatusUnverifiedView = this.ensureFindViewById(null, R.id.unverified_view, "unverified view");
        this.connectionStatusSignInView = this.ensureFindViewById(null, R.id.sign_in_view, "sign in view");
        this.connectionStatusSyncingView = this.ensureFindViewById(null, R.id.syncing_view, "syncing view");
        this.launchActivityOnClick(this.connectionStatusSignInView, FxAccountUpdateCredentialsActivity.class);
    }

    public void onResume() {
        super.onResume();
        this.refresh();
    }

    protected void refresh(Account account) {
        TextView textView = (TextView)this.findViewById(R.id.email);
        if (account == null) {
            this.redirectToActivity(FxAccountGetStartedActivity.class);
            return;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)this, account);
        textView.setText((CharSequence)account.name);
        if (!androidFxAccount.isVerified()) {
            this.connectionStatusUnverifiedView.setVisibility(0);
            this.connectionStatusSignInView.setVisibility(8);
            this.connectionStatusSyncingView.setVisibility(8);
            return;
        }
        if (androidFxAccount.getQuickStretchedPW() == null) {
            this.connectionStatusUnverifiedView.setVisibility(8);
            this.connectionStatusSignInView.setVisibility(0);
            this.connectionStatusSyncingView.setVisibility(8);
            return;
        }
        this.connectionStatusUnverifiedView.setVisibility(8);
        this.connectionStatusSignInView.setVisibility(8);
        this.connectionStatusSyncingView.setVisibility(0);
    }

    protected void refresh() {
        Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)this);
        if (accountArray.length < 1) {
            this.refresh(null);
            return;
        }
        this.refresh(accountArray[0]);
    }

    protected void dumpAccountDetails() {
        Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)this);
        if (accountArray.length < 1) {
            return;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)this, accountArray[0]);
        androidFxAccount.dump();
    }

    protected void forgetAccountTokens() {
        Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)this);
        if (accountArray.length < 1) {
            return;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)this, accountArray[0]);
        androidFxAccount.forgetAccountTokens();
        androidFxAccount.dump();
    }

    protected void forgetQuickStretchedPW() {
        Account[] accountArray = FxAccountAuthenticator.getFirefoxAccounts((Context)this);
        if (accountArray.length < 1) {
            return;
        }
        AndroidFxAccount androidFxAccount = new AndroidFxAccount((Context)this, accountArray[0]);
        androidFxAccount.forgetQuickstretchedPW();
        androidFxAccount.dump();
    }

    public void onClickRefresh(View view) {
        Logger.debug(LOG_TAG, "Refreshing.");
        this.refresh();
    }

    public void onClickForgetAccountTokens(View view) {
        Logger.debug(LOG_TAG, "Forgetting account tokens.");
        this.forgetAccountTokens();
    }

    public void onClickForgetPassword(View view) {
        Logger.debug(LOG_TAG, "Forgetting quickStretchedPW.");
        this.forgetQuickStretchedPW();
    }

    public void onClickDumpAccountDetails(View view) {
        Logger.debug(LOG_TAG, "Dumping account details.");
        this.dumpAccountDetails();
    }

    public void onClickGetStarted(View view) {
        Logger.debug(LOG_TAG, "Launching get started activity.");
        this.redirectToActivity(FxAccountGetStartedActivity.class);
    }

    public void onClickVerify(View view) {
        Logger.debug(LOG_TAG, "Launching verification activity.");
    }

    public void onClickSignIn(View view) {
        Logger.debug(LOG_TAG, "Launching sign in again activity.");
    }
}

