/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.os.Bundle;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.RSACryptoImplementation;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.authenticator.AbstractFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public class AndroidFxAccount
implements AbstractFxAccount {
    protected static final String LOG_TAG = AndroidFxAccount.class.getSimpleName();
    public static final String ACCOUNT_KEY_ASSERTION = "assertion";
    public static final String ACCOUNT_KEY_CERTIFICATE = "certificate";
    public static final String ACCOUNT_KEY_INVALID = "invalid";
    public static final String ACCOUNT_KEY_SERVERURI = "serverURI";
    public static final String ACCOUNT_KEY_SESSION_TOKEN = "sessionToken";
    public static final String ACCOUNT_KEY_KEY_FETCH_TOKEN = "keyFetchToken";
    public static final String ACCOUNT_KEY_VERIFIED = "verified";
    public static final String ACCOUNT_KEY_KA = "kA";
    public static final String ACCOUNT_KEY_KB = "kB";
    public static final String ACCOUNT_KEY_UNWRAPKB = "unwrapkB";
    public static final String ACCOUNT_KEY_ASSERTION_KEY_PAIR = "assertionKeyPair";
    protected final Context context;
    protected final AccountManager accountManager;
    protected final Account account;

    public AndroidFxAccount(Context context, Account account) {
        this.context = context;
        this.account = account;
        this.accountManager = AccountManager.get((Context)this.context);
    }

    public byte[] getEmailUTF8() {
        try {
            return this.account.name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public void setQuickStretchedPW(byte[] byArray) {
        this.accountManager.setPassword(this.account, byArray == null ? null : Utils.byte2Hex(byArray));
    }

    public byte[] getQuickStretchedPW() {
        String string2 = this.accountManager.getPassword(this.account);
        return string2 == null ? null : Utils.hex2Byte(string2);
    }

    public String getServerURI() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_SERVERURI);
    }

    protected byte[] getUserDataBytes(String string2) {
        String string3 = this.accountManager.getUserData(this.account, string2);
        if (string3 == null) {
            return null;
        }
        return Utils.hex2Byte(string3);
    }

    public byte[] getSessionToken() {
        return this.getUserDataBytes(ACCOUNT_KEY_SESSION_TOKEN);
    }

    public byte[] getKeyFetchToken() {
        return this.getUserDataBytes(ACCOUNT_KEY_KEY_FETCH_TOKEN);
    }

    public void setSessionToken(byte[] byArray) {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_SESSION_TOKEN, byArray == null ? null : Utils.byte2Hex(byArray));
    }

    public void setKeyFetchToken(byte[] byArray) {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_KEY_FETCH_TOKEN, byArray == null ? null : Utils.byte2Hex(byArray));
    }

    public boolean isVerified() {
        String string2 = this.accountManager.getUserData(this.account, ACCOUNT_KEY_VERIFIED);
        return Boolean.valueOf(string2);
    }

    public void setVerified() {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_VERIFIED, Boolean.valueOf(true).toString());
    }

    public byte[] getKa() {
        return this.getUserDataBytes(ACCOUNT_KEY_KA);
    }

    public void setKa(byte[] byArray) {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_KA, Utils.byte2Hex(byArray));
    }

    public void setWrappedKb(byte[] byArray) {
        byte[] byArray2 = this.getUserDataBytes(ACCOUNT_KEY_UNWRAPKB);
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_KB, Utils.byte2Hex(byArray3));
    }

    public byte[] getKb() {
        return this.getUserDataBytes(ACCOUNT_KEY_KB);
    }

    protected BrowserIDKeyPair generateNewAssertionKeyPair() throws GeneralSecurityException {
        Logger.info(LOG_TAG, "Generating new assertion key pair.");
        return RSACryptoImplementation.generateKeyPair(1024);
    }

    public BrowserIDKeyPair getAssertionKeyPair() throws GeneralSecurityException {
        try {
            String string2 = this.accountManager.getUserData(this.account, ACCOUNT_KEY_ASSERTION_KEY_PAIR);
            return RSACryptoImplementation.fromJSONObject(new ExtendedJSONObject(string2));
        }
        catch (Exception exception) {
            BrowserIDKeyPair browserIDKeyPair = this.generateNewAssertionKeyPair();
            this.accountManager.setUserData(this.account, ACCOUNT_KEY_ASSERTION_KEY_PAIR, browserIDKeyPair.toJSONObject().toJSONString());
            return browserIDKeyPair;
        }
    }

    public String getCertificate() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_CERTIFICATE);
    }

    public void setCertificate(String string2) {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_CERTIFICATE, string2);
    }

    public String getAssertion() {
        return this.accountManager.getUserData(this.account, ACCOUNT_KEY_ASSERTION);
    }

    public void setAssertion(String string2) {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_ASSERTION, string2);
    }

    public ExtendedJSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        for (String string2 : new String[]{ACCOUNT_KEY_ASSERTION, ACCOUNT_KEY_CERTIFICATE, ACCOUNT_KEY_SERVERURI, ACCOUNT_KEY_SESSION_TOKEN, ACCOUNT_KEY_INVALID, ACCOUNT_KEY_KEY_FETCH_TOKEN, ACCOUNT_KEY_VERIFIED, ACCOUNT_KEY_KA, ACCOUNT_KEY_KB, ACCOUNT_KEY_UNWRAPKB, ACCOUNT_KEY_ASSERTION_KEY_PAIR}) {
            extendedJSONObject.put(string2, this.accountManager.getUserData(this.account, string2));
        }
        extendedJSONObject.put("email", this.account.name);
        try {
            extendedJSONObject.put("emailUTF8", Utils.byte2Hex(this.account.name.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        extendedJSONObject.put("quickStretchedPW", this.accountManager.getPassword(this.account));
        return extendedJSONObject;
    }

    public static Account addAndroidAccount(Context context, String string2, String string3, String string4, byte[] byArray, byte[] byArray2, boolean bl) throws UnsupportedEncodingException, GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("email must not be null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("password must not be null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("serverURI must not be null");
        }
        if (byArray == null && byArray2 != null || byArray != null && byArray2 == null) {
            throw new IllegalArgumentException("none or both of sessionToken and keyFetchToken may be null");
        }
        byte[] byArray3 = string2.getBytes("UTF-8");
        byte[] byArray4 = string3.getBytes("UTF-8");
        byte[] byArray5 = FxAccountUtils.generateQuickStretchedPW(byArray3, byArray4);
        byte[] byArray6 = FxAccountUtils.generateUnwrapBKey(byArray5);
        Bundle bundle = new Bundle();
        bundle.putString(ACCOUNT_KEY_SERVERURI, string4);
        bundle.putString(ACCOUNT_KEY_SESSION_TOKEN, byArray == null ? null : Utils.byte2Hex(byArray));
        bundle.putString(ACCOUNT_KEY_KEY_FETCH_TOKEN, byArray2 == null ? null : Utils.byte2Hex(byArray2));
        bundle.putString(ACCOUNT_KEY_VERIFIED, Boolean.valueOf(bl).toString());
        bundle.putString(ACCOUNT_KEY_UNWRAPKB, Utils.byte2Hex(byArray6));
        Account account = new Account(string2, "org.mozilla.fennec_account");
        AccountManager accountManager = AccountManager.get((Context)context);
        boolean bl2 = accountManager.addAccountExplicitly(account, Utils.byte2Hex(byArray5), bundle);
        if (!bl2) {
            return null;
        }
        FxAccountAuthenticator.enableSyncing(context, account);
        return account;
    }

    public boolean isValid() {
        boolean bl = Boolean.valueOf(this.accountManager.getUserData(this.account, ACCOUNT_KEY_INVALID));
        return !bl;
    }

    public void setInvalid() {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_INVALID, Boolean.valueOf(true).toString());
    }

    public void dump() {
        if (!FxAccountConstants.LOG_PERSONAL_INFORMATION) {
            return;
        }
        ExtendedJSONObject extendedJSONObject = this.toJSONObject();
        ArrayList<String> arrayList = new ArrayList<String>(extendedJSONObject.keySet());
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            FxAccountConstants.pii(LOG_TAG, string2 + ": " + extendedJSONObject.getString(string2));
        }
    }

    public void forgetAccountTokens() {
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_SESSION_TOKEN, null);
        this.accountManager.setUserData(this.account, ACCOUNT_KEY_KEY_FETCH_TOKEN, null);
    }

    public void forgetQuickstretchedPW() {
        this.accountManager.setPassword(this.account, null);
    }
}

