/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.authenticator;

import android.content.Context;
import ch.boye.httpclientandroidlib.HttpResponse;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.JSONWebTokenUtils;
import org.mozilla.gecko.browserid.VerifyingPublicKey;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.authenticator.AbstractFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountLoginDelegate;
import org.mozilla.gecko.fxa.authenticator.FxAccountLoginException;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FxAccountLoginPolicy {
    public static final String LOG_TAG = FxAccountLoginPolicy.class.getSimpleName();
    public final Context context;
    public final AbstractFxAccount fxAccount;
    public final Executor executor;
    public long certificateDurationInMilliseconds = 3600000L;
    public long assertionDurationInMilliseconds = 3600000L;
    public static int[] DUMMY = null;

    public FxAccountLoginPolicy(Context context, AbstractFxAccount abstractFxAccount, Executor executor) {
        this.context = context;
        this.fxAccount = abstractFxAccount;
        this.executor = executor;
    }

    public long getCertificateDurationInMilliseconds() {
        return this.certificateDurationInMilliseconds;
    }

    public long getAssertionDurationInMilliseconds() {
        return this.assertionDurationInMilliseconds;
    }

    protected FxAccountClient makeFxAccountClient() {
        String string2 = this.fxAccount.getServerURI();
        return new FxAccountClient20(string2, this.executor);
    }

    protected boolean isInvalidCertificate(String string2) {
        return false;
    }

    protected boolean isInvalidAssertion(String string2) {
        return false;
    }

    public AccountState getAccountState(AbstractFxAccount abstractFxAccount) {
        String string2 = abstractFxAccount.getServerURI();
        byte[] byArray = abstractFxAccount.getEmailUTF8();
        byte[] byArray2 = abstractFxAccount.getQuickStretchedPW();
        if (!abstractFxAccount.isValid() || string2 == null || byArray == null || byArray2 == null) {
            return AccountState.Invalid;
        }
        byte[] byArray3 = abstractFxAccount.getSessionToken();
        if (byArray3 == null) {
            return AccountState.NeedsSessionToken;
        }
        if (!abstractFxAccount.isVerified()) {
            return AccountState.NeedsVerification;
        }
        if (abstractFxAccount.getKa() == null || abstractFxAccount.getKb() == null) {
            return AccountState.NeedsKeys;
        }
        String string3 = abstractFxAccount.getCertificate();
        if (string3 == null || this.isInvalidCertificate(string3)) {
            return AccountState.NeedsCertificate;
        }
        String string4 = abstractFxAccount.getAssertion();
        if (string4 == null || this.isInvalidAssertion(string4)) {
            return AccountState.NeedsAssertion;
        }
        return AccountState.Valid;
    }

    protected LinkedList<LoginStage> getStages(AccountState accountState) {
        LinkedList<LoginStage> linkedList = new LinkedList<LoginStage>();
        if (accountState == AccountState.Invalid) {
            linkedList.addFirst(new FailStage());
            return linkedList;
        }
        linkedList.addFirst(new SuccessStage());
        if (accountState == AccountState.Valid) {
            return linkedList;
        }
        linkedList.addFirst(new EnsureAssertionStage());
        if (accountState == AccountState.NeedsAssertion) {
            return linkedList;
        }
        linkedList.addFirst(new EnsureCertificateStage());
        if (accountState == AccountState.NeedsCertificate) {
            return linkedList;
        }
        linkedList.addFirst(new EnsureKeysStage());
        linkedList.addFirst(new EnsureKeyFetchTokenStage());
        if (accountState == AccountState.NeedsKeys) {
            return linkedList;
        }
        linkedList.addFirst(new EnsureVerificationStage());
        if (accountState == AccountState.NeedsVerification) {
            return linkedList;
        }
        linkedList.addFirst(new EnsureSessionTokenStage());
        if (accountState == AccountState.NeedsSessionToken) {
            return linkedList;
        }
        return linkedList;
    }

    public void login(String string2, FxAccountLoginDelegate fxAccountLoginDelegate) {
        AccountState accountState = this.getAccountState(this.fxAccount);
        Logger.info(LOG_TAG, "Logging in account from initial state " + (Object)((Object)accountState) + ".");
        LinkedList<LoginStage> linkedList = this.getStages(accountState);
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (LoginStage loginStage : linkedList) {
            linkedList2.add(loginStage.getClass().getSimpleName());
        }
        Logger.info(LOG_TAG, "Executing stages: [" + Utils.toCommaSeparatedString(linkedList2) + "]");
        LoginStageDelegate loginStageDelegate = new LoginStageDelegate(linkedList, string2, fxAccountLoginDelegate);
        loginStageDelegate.advance();
    }

    public class FailStage
    implements LoginStage {
        public void execute(LoginStageDelegate loginStageDelegate) {
            AccountState accountState = FxAccountLoginPolicy.this.getAccountState(FxAccountLoginPolicy.this.fxAccount);
            Logger.info(LOG_TAG, "Failed to login account; final state is " + (Object)((Object)accountState) + ".");
            loginStageDelegate.handleError(new FxAccountLoginException("Failed to login."));
        }
    }

    public class SuccessStage
    implements LoginStage {
        public void execute(LoginStageDelegate loginStageDelegate) throws Exception {
            String string2 = FxAccountLoginPolicy.this.fxAccount.getAssertion();
            if (string2 == null) {
                throw new IllegalStateException("assertion must not be null");
            }
            loginStageDelegate.handleLoginSuccess(string2);
        }
    }

    public class EnsureAssertionStage
    implements LoginStage {
        public void execute(LoginStageDelegate loginStageDelegate) throws Exception {
            String string2;
            BrowserIDKeyPair browserIDKeyPair = FxAccountLoginPolicy.this.fxAccount.getAssertionKeyPair();
            if (browserIDKeyPair == null) {
                throw new IllegalStateException("keyPair must not be null");
            }
            String string3 = FxAccountLoginPolicy.this.fxAccount.getCertificate();
            if (string3 == null) {
                throw new IllegalStateException("certificate must not be null");
            }
            try {
                long l = System.currentTimeMillis();
                string2 = JSONWebTokenUtils.createAssertion(browserIDKeyPair.getPrivate(), string3, loginStageDelegate.audience, "127.0.0.1", l, FxAccountLoginPolicy.this.getAssertionDurationInMilliseconds());
            }
            catch (Exception exception) {
                FxAccountLoginPolicy.this.fxAccount.setInvalid();
                throw exception;
            }
            FxAccountLoginPolicy.this.fxAccount.setAssertion(string2);
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                FxAccountConstants.pii(LOG_TAG, "Generated assertion: " + string2);
                JSONWebTokenUtils.dumpAssertion(string2);
            }
            loginStageDelegate.handleStageSuccess();
        }
    }

    public class EnsureCertificateStage
    implements LoginStage {
        public void execute(final LoginStageDelegate loginStageDelegate) throws Exception {
            byte[] byArray = FxAccountLoginPolicy.this.fxAccount.getSessionToken();
            if (byArray == null) {
                throw new IllegalStateException("keyPair must not be null");
            }
            BrowserIDKeyPair browserIDKeyPair = FxAccountLoginPolicy.this.fxAccount.getAssertionKeyPair();
            if (browserIDKeyPair == null) {
                FxAccountLoginPolicy.this.fxAccount.setInvalid();
                throw new IllegalStateException("keyPair must not be null");
            }
            VerifyingPublicKey verifyingPublicKey = browserIDKeyPair.getPublic();
            loginStageDelegate.client.sign(byArray, verifyingPublicKey.toJSONObject(), FxAccountLoginPolicy.this.getCertificateDurationInMilliseconds(), new FxAccountClient10.RequestDelegate<String>(){

                @Override
                public void handleError(Exception exception) {
                    loginStageDelegate.handleError(new FxAccountLoginException(exception));
                }

                @Override
                public void handleFailure(int n, HttpResponse httpResponse) {
                    if (n != 401) {
                        loginStageDelegate.handleError(new FxAccountLoginException(new HTTPFailureException(new SyncStorageResponse(httpResponse))));
                        return;
                    }
                    FxAccountLoginPolicy.this.fxAccount.setSessionToken(null);
                    loginStageDelegate.handleError(new FxAccountLoginException.FxAccountLoginBadPasswordException("Auth server rejected session token while fetching status."));
                }

                @Override
                public void handleSuccess(String string2) {
                    FxAccountLoginPolicy.this.fxAccount.setCertificate(string2);
                    if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                        FxAccountConstants.pii(LOG_TAG, "Fetched certificate: " + string2);
                        JSONWebTokenUtils.dumpCertificate(string2);
                    }
                    loginStageDelegate.handleStageSuccess();
                }
            });
        }
    }

    public class EnsureKeysStage
    implements LoginStage {
        public void execute(final LoginStageDelegate loginStageDelegate) throws Exception {
            byte[] byArray = FxAccountLoginPolicy.this.fxAccount.getKeyFetchToken();
            if (byArray == null) {
                throw new IllegalStateException("keyFetchToken must not be null");
            }
            FxAccountLoginPolicy.this.fxAccount.setKeyFetchToken(null);
            loginStageDelegate.client.keys(byArray, new FxAccountClient10.RequestDelegate<FxAccountClient10.TwoKeys>(){

                @Override
                public void handleError(Exception exception) {
                    loginStageDelegate.handleError(new FxAccountLoginException(exception));
                }

                @Override
                public void handleFailure(int n, HttpResponse httpResponse) {
                    if (n != 401) {
                        loginStageDelegate.handleError(new FxAccountLoginException(new HTTPFailureException(new SyncStorageResponse(httpResponse))));
                        return;
                    }
                    loginStageDelegate.handleError(new FxAccountLoginException.FxAccountLoginBadPasswordException("Auth server rejected key token while fetching keys."));
                }

                @Override
                public void handleSuccess(FxAccountClient10.TwoKeys twoKeys) {
                    FxAccountLoginPolicy.this.fxAccount.setKa(twoKeys.kA);
                    FxAccountLoginPolicy.this.fxAccount.setWrappedKb(twoKeys.wrapkB);
                    if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                        FxAccountConstants.pii(LOG_TAG, "Fetched kA: " + Utils.byte2Hex(twoKeys.kA));
                        FxAccountConstants.pii(LOG_TAG, "And wrapkB: " + Utils.byte2Hex(twoKeys.wrapkB));
                        FxAccountConstants.pii(LOG_TAG, "Giving kB : " + Utils.byte2Hex(FxAccountLoginPolicy.this.fxAccount.getKb()));
                    }
                    loginStageDelegate.handleStageSuccess();
                }
            });
        }
    }

    public class EnsureKeyFetchTokenStage
    implements LoginStage {
        public void execute(final LoginStageDelegate loginStageDelegate) throws Exception {
            byte[] byArray = FxAccountLoginPolicy.this.fxAccount.getEmailUTF8();
            if (byArray == null) {
                throw new IllegalStateException("emailUTF8 must not be null");
            }
            byte[] byArray2 = FxAccountLoginPolicy.this.fxAccount.getQuickStretchedPW();
            if (byArray2 == null) {
                throw new IllegalStateException("quickStretchedPW must not be null");
            }
            boolean bl = FxAccountLoginPolicy.this.fxAccount.isVerified();
            if (!bl) {
                throw new IllegalStateException("must be verified");
            }
            if (FxAccountLoginPolicy.this.fxAccount.getKeyFetchToken() != null) {
                Logger.info(LOG_TAG, "Using existing keyFetchToken.");
                loginStageDelegate.handleStageSuccess();
                return;
            }
            loginStageDelegate.client.loginAndGetKeys(byArray, byArray2, new FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse>(){

                @Override
                public void handleError(Exception exception) {
                    loginStageDelegate.handleError(new FxAccountLoginException(exception));
                }

                @Override
                public void handleFailure(int n, HttpResponse httpResponse) {
                    if (n != 401) {
                        loginStageDelegate.handleError(new FxAccountLoginException(new HTTPFailureException(new SyncStorageResponse(httpResponse))));
                        return;
                    }
                    FxAccountLoginPolicy.this.fxAccount.setInvalid();
                    loginStageDelegate.handleError(new FxAccountLoginException.FxAccountLoginBadPasswordException("Auth server rejected email/password while fetching keyFetchToken."));
                }

                @Override
                public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
                    FxAccountLoginPolicy.this.fxAccount.setKeyFetchToken(loginResponse.keyFetchToken);
                    if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                        FxAccountConstants.pii(LOG_TAG, "Fetched keyFetchToken: " + Utils.byte2Hex(loginResponse.keyFetchToken));
                    }
                    loginStageDelegate.handleStageSuccess();
                }
            });
        }
    }

    public class EnsureVerificationStage
    implements LoginStage {
        public void execute(final LoginStageDelegate loginStageDelegate) {
            byte[] byArray = FxAccountLoginPolicy.this.fxAccount.getSessionToken();
            if (byArray == null) {
                throw new IllegalArgumentException("sessionToken must not be null");
            }
            loginStageDelegate.client.status(byArray, new FxAccountClient10.RequestDelegate<FxAccountClient10.StatusResponse>(){

                @Override
                public void handleError(Exception exception) {
                    loginStageDelegate.handleError(new FxAccountLoginException(exception));
                }

                @Override
                public void handleFailure(int n, HttpResponse httpResponse) {
                    if (n != 401) {
                        loginStageDelegate.handleError(new FxAccountLoginException(new HTTPFailureException(new SyncStorageResponse(httpResponse))));
                        return;
                    }
                    FxAccountLoginPolicy.this.fxAccount.setSessionToken(null);
                    loginStageDelegate.handleError(new FxAccountLoginException.FxAccountLoginBadPasswordException("Auth server rejected session token while fetching status."));
                }

                @Override
                public void handleSuccess(FxAccountClient10.StatusResponse statusResponse) {
                    if (!statusResponse.verified) {
                        loginStageDelegate.handleError(new FxAccountLoginException.FxAccountLoginAccountNotVerifiedException("Account is not yet verified."));
                        return;
                    }
                    FxAccountLoginPolicy.this.fxAccount.setVerified();
                    loginStageDelegate.handleStageSuccess();
                }
            });
        }
    }

    public class EnsureSessionTokenStage
    implements LoginStage {
        public void execute(final LoginStageDelegate loginStageDelegate) throws Exception {
            byte[] byArray = FxAccountLoginPolicy.this.fxAccount.getEmailUTF8();
            if (byArray == null) {
                throw new IllegalStateException("emailUTF8 must not be null");
            }
            byte[] byArray2 = FxAccountLoginPolicy.this.fxAccount.getQuickStretchedPW();
            if (byArray2 == null) {
                throw new IllegalStateException("quickStretchedPW must not be null");
            }
            loginStageDelegate.client.loginAndGetKeys(byArray, byArray2, new FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse>(){

                @Override
                public void handleError(Exception exception) {
                    loginStageDelegate.handleError(new FxAccountLoginException(exception));
                }

                @Override
                public void handleFailure(int n, HttpResponse httpResponse) {
                    if (n != 401) {
                        loginStageDelegate.handleError(new FxAccountLoginException(new HTTPFailureException(new SyncStorageResponse(httpResponse))));
                        return;
                    }
                    FxAccountLoginPolicy.this.fxAccount.setInvalid();
                    loginStageDelegate.handleError(new FxAccountLoginException.FxAccountLoginBadPasswordException("Auth server rejected email/password while fetching sessionToken."));
                }

                @Override
                public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
                    FxAccountLoginPolicy.this.fxAccount.setSessionToken(loginResponse.sessionToken);
                    FxAccountLoginPolicy.this.fxAccount.setKeyFetchToken(loginResponse.keyFetchToken);
                    if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                        FxAccountConstants.pii(LOG_TAG, "Fetched sessionToken : " + Utils.byte2Hex(loginResponse.sessionToken));
                        FxAccountConstants.pii(LOG_TAG, "Fetched keyFetchToken: " + Utils.byte2Hex(loginResponse.keyFetchToken));
                    }
                    loginStageDelegate.handleStageSuccess();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LoginStageDelegate {
        public final LinkedList<LoginStage> stages;
        public final String audience;
        public final FxAccountLoginDelegate delegate;
        public final FxAccountClient client;
        protected LoginStage currentStage = null;

        public LoginStageDelegate(LinkedList<LoginStage> linkedList, String string2, FxAccountLoginDelegate fxAccountLoginDelegate) {
            this.stages = linkedList;
            this.audience = string2;
            this.delegate = fxAccountLoginDelegate;
            this.client = FxAccountLoginPolicy.this.makeFxAccountClient();
        }

        protected void invokeHandleHardFailure(final FxAccountLoginDelegate fxAccountLoginDelegate, final FxAccountLoginException fxAccountLoginException) {
            FxAccountLoginPolicy.this.executor.execute(new Runnable(){

                public void run() {
                    fxAccountLoginDelegate.handleError(fxAccountLoginException);
                }
            });
        }

        public void advance() {
            this.currentStage = this.stages.poll();
            if (this.currentStage == null) {
                Logger.info(LOG_TAG, "No more stages: login failed?");
                this.invokeHandleHardFailure(this.delegate, new FxAccountLoginException("No more stages, but no assertion: login failed?"));
                return;
            }
            try {
                Logger.info(LOG_TAG, "Executing stage: " + this.currentStage.getClass().getSimpleName());
                this.currentStage.execute(this);
            }
            catch (Exception exception) {
                Logger.info(LOG_TAG, "Got exception during stage.", exception);
                this.invokeHandleHardFailure(this.delegate, new FxAccountLoginException(exception));
                return;
            }
        }

        public void handleStageSuccess() {
            Logger.info(LOG_TAG, "Stage succeeded: " + this.currentStage.getClass().getSimpleName());
            this.advance();
        }

        public void handleLoginSuccess(final String string2) {
            Logger.info(LOG_TAG, "Login succeeded.");
            FxAccountLoginPolicy.this.executor.execute(new Runnable(){

                public void run() {
                    LoginStageDelegate.this.delegate.handleSuccess(string2);
                }
            });
        }

        public void handleError(FxAccountLoginException fxAccountLoginException) {
            this.invokeHandleHardFailure(this.delegate, fxAccountLoginException);
        }
    }

    protected static interface LoginStage {
        public void execute(LoginStageDelegate var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccountState {
        Invalid,
        NeedsSessionToken,
        NeedsVerification,
        NeedsKeys,
        NeedsCertificate,
        NeedsAssertion,
        Valid;

    }
}

