/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SyncResult;
import android.os.Bundle;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.browserid.verifier.BrowserIDRemoteVerifierClient;
import org.mozilla.gecko.browserid.verifier.BrowserIDVerifierDelegate;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.authenticator.FxAccountLoginDelegate;
import org.mozilla.gecko.fxa.authenticator.FxAccountLoginException;
import org.mozilla.gecko.fxa.authenticator.FxAccountLoginPolicy;
import org.mozilla.gecko.fxa.sync.FxAccountGlobalSession;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.BaseGlobalSessionCallback;
import org.mozilla.gecko.sync.net.HawkAuthHeaderProvider;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;
import org.mozilla.gecko.tokenserver.TokenServerClient;
import org.mozilla.gecko.tokenserver.TokenServerClientDelegate;
import org.mozilla.gecko.tokenserver.TokenServerException;
import org.mozilla.gecko.tokenserver.TokenServerToken;

public class FxAccountSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String LOG_TAG = FxAccountSyncAdapter.class.getSimpleName();
    protected final ExecutorService executor = Executors.newSingleThreadExecutor();

    public FxAccountSyncAdapter(Context context, boolean bl) {
        super(context, bl);
    }

    public void onPerformSync(Account account, final Bundle bundle, String string2, ContentProviderClient contentProviderClient, SyncResult syncResult) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.info(LOG_TAG, "Syncing FxAccount account named " + account.name + " for authority " + string2 + " with instance " + (Object)((Object)this) + ".");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        final SessionCallback sessionCallback = new SessionCallback(countDownLatch, syncResult);
        try {
            final String string3 = "http://auth.oldsync.dev.lcip.org" + ("http://auth.oldsync.dev.lcip.org".endsWith("/") ? "" : "/") + "1.0/sync/1.1";
            final URI uRI = new URI(string3);
            final AndroidFxAccount androidFxAccount = new AndroidFxAccount(this.getContext(), account);
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                androidFxAccount.dump();
            }
            final SharedPreferences sharedPreferences = this.getContext().getSharedPreferences("fxa.v1", 0);
            FxAccountLoginPolicy fxAccountLoginPolicy = new FxAccountLoginPolicy(this.getContext(), androidFxAccount, this.executor);
            fxAccountLoginPolicy.certificateDurationInMilliseconds = 1200000L;
            fxAccountLoginPolicy.assertionDurationInMilliseconds = 900000L;
            Logger.info(LOG_TAG, "Asking for certificates to expire after 20 minutes and assertions to expire after 15 minutes.");
            fxAccountLoginPolicy.login("http://auth.oldsync.dev.lcip.org", new FxAccountLoginDelegate(){

                public void handleSuccess(final String string2) {
                    TokenServerClient tokenServerClient = new TokenServerClient(uRI, FxAccountSyncAdapter.this.executor);
                    tokenServerClient.getTokenFromBrowserIDAssertion(string2, true, new TokenServerClientDelegate(){

                        public void handleSuccess(TokenServerToken tokenServerToken) {
                            FxAccountConstants.pii(LOG_TAG, "Got token! uid is " + tokenServerToken.uid + " and endpoint is " + tokenServerToken.endpoint + ".");
                            sharedPreferences.edit().putLong("tokenFailures", 0L).commit();
                            FxAccountGlobalSession fxAccountGlobalSession = null;
                            try {
                                SharedPreferencesClientsDataDelegate sharedPreferencesClientsDataDelegate = new SharedPreferencesClientsDataDelegate(sharedPreferences);
                                KeyBundle keyBundle = FxAccountUtils.generateSyncKeyBundle(androidFxAccount.getKb());
                                HawkAuthHeaderProvider hawkAuthHeaderProvider = new HawkAuthHeaderProvider(tokenServerToken.id, tokenServerToken.key.getBytes("UTF-8"), false);
                                fxAccountGlobalSession = new FxAccountGlobalSession(tokenServerToken.endpoint, tokenServerToken.uid, hawkAuthHeaderProvider, "fxa.v1", keyBundle, sessionCallback, FxAccountSyncAdapter.this.getContext(), bundle, sharedPreferencesClientsDataDelegate);
                                fxAccountGlobalSession.start();
                            }
                            catch (Exception exception) {
                                sessionCallback.handleError(fxAccountGlobalSession, exception);
                                return;
                            }
                        }

                        public void handleFailure(TokenServerException tokenServerException) {
                            long l = 2L;
                            long l2 = 1L + sharedPreferences.getLong("tokenFailures", 0L);
                            if (l2 > l) {
                                androidFxAccount.setCertificate(null);
                                l2 = 0L;
                                Logger.warn(LOG_TAG, "Seen too many failures with this token; resetting: " + l2);
                                Logger.warn(LOG_TAG, "To aid debugging, synchronously sending assertion to remote verifier for second look.");
                                FxAccountSyncAdapter.this.debugAssertion(string3, string2);
                            } else {
                                Logger.info(LOG_TAG, "Seen " + l2 + " failures with this token so far.");
                            }
                            sharedPreferences.edit().putLong("tokenFailures", l2).commit();
                            this.handleError(tokenServerException);
                        }

                        public void handleError(Exception exception) {
                            Logger.error(LOG_TAG, "Failed to get token.", exception);
                            sessionCallback.handleError(null, exception);
                        }
                    });
                }

                public void handleError(FxAccountLoginException fxAccountLoginException) {
                    Logger.error(LOG_TAG, "Got error logging in.", fxAccountLoginException);
                    sessionCallback.handleError(null, fxAccountLoginException);
                }
            });
            countDownLatch.await();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got error syncing.", exception);
            sessionCallback.handleError(null, exception);
        }
        Logger.error(LOG_TAG, "Syncing done.");
    }

    protected void debugAssertion(String string2, String string3) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        BrowserIDRemoteVerifierClient browserIDRemoteVerifierClient = new BrowserIDRemoteVerifierClient(URI.create("https://verifier.login.persona.org/verify"));
        browserIDRemoteVerifierClient.verify(string2, string3, new BrowserIDVerifierDelegate(){

            public void handleSuccess(ExtendedJSONObject extendedJSONObject) {
                Logger.info(LOG_TAG, "Remote verifier returned success: " + extendedJSONObject.toJSONString());
                countDownLatch.countDown();
            }

            public void handleFailure(ExtendedJSONObject extendedJSONObject) {
                Logger.warn(LOG_TAG, "Remote verifier returned failure: " + extendedJSONObject.toJSONString());
                countDownLatch.countDown();
            }

            public void handleError(Exception exception) {
                Logger.error(LOG_TAG, "Remote verifier returned error.", exception);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Logger.error(LOG_TAG, "Got error.", interruptedException);
        }
    }

    protected static class SessionCallback
    implements BaseGlobalSessionCallback {
        protected final CountDownLatch latch;
        protected final SyncResult syncResult;

        public SessionCallback(CountDownLatch countDownLatch, SyncResult syncResult) {
            if (countDownLatch == null) {
                throw new IllegalArgumentException("latch must not be null");
            }
            if (syncResult == null) {
                throw new IllegalArgumentException("syncResult must not be null");
            }
            this.latch = countDownLatch;
            this.syncResult = syncResult;
        }

        public boolean shouldBackOff() {
            return false;
        }

        public void requestBackoff(long l) {
        }

        public void informUpgradeRequiredResponse(GlobalSession globalSession) {
        }

        public void informUnauthorizedResponse(GlobalSession globalSession, URI uRI) {
        }

        public void handleStageCompleted(GlobalSyncStage.Stage stage, GlobalSession globalSession) {
        }

        protected void setSyncResultSuccess() {
            ++this.syncResult.stats.numUpdates;
        }

        protected void setSyncResultSoftError() {
            ++this.syncResult.stats.numUpdates;
            ++this.syncResult.stats.numIoExceptions;
        }

        protected void setSyncResultHardError() {
            ++this.syncResult.stats.numAuthExceptions;
        }

        public void handleSuccess(GlobalSession globalSession) {
            this.setSyncResultSuccess();
            Logger.info(LOG_TAG, "Sync succeeded.");
            this.latch.countDown();
        }

        public void handleError(GlobalSession globalSession, Exception exception) {
            this.setSyncResultSoftError();
            Logger.warn(LOG_TAG, "Sync failed.", exception);
            this.latch.countDown();
        }

        public void handleAborted(GlobalSession globalSession, String string2) {
            this.setSyncResultSoftError();
            Logger.warn(LOG_TAG, "Sync aborted: " + string2);
            this.latch.countDown();
        }
    }
}

