/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.menu.GeckoMenuItem;

public class MenuItemDefault
extends TextView
implements GeckoMenuItem.Layout {
    private static final int[] STATE_MORE = new int[]{R.attr.state_more};
    private static final int[] STATE_CHECKED = new int[]{16842911, 0x10100A0};
    private static final int[] STATE_UNCHECKED = new int[]{16842911};
    private Drawable mIcon;
    private Drawable mState;
    private static Rect sIconBounds;
    private boolean mCheckable = false;
    private boolean mChecked = false;
    private boolean mHasSubMenu = false;
    private boolean mShowIcon = false;

    public MenuItemDefault(Context context) {
        this(context, null);
    }

    public MenuItemDefault(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.menuItemDefaultStyle);
    }

    public MenuItemDefault(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        Resources resources = this.getResources();
        int n2 = resources.getDimensionPixelSize(R.dimen.menu_item_row_width);
        int n3 = resources.getDimensionPixelSize(R.dimen.menu_item_row_height);
        this.setMinimumWidth(n2);
        this.setMinimumHeight(n3);
        int n4 = resources.getDimensionPixelSize(R.dimen.menu_item_state_icon);
        Rect rect = new Rect(0, 0, n4, n4);
        this.mState = resources.getDrawable(R.drawable.menu_item_state);
        this.mState.setBounds(rect);
        if (sIconBounds == null) {
            int n5 = resources.getDimensionPixelSize(R.dimen.menu_item_icon);
            sIconBounds = new Rect(0, 0, n5, n5);
        }
        this.setCompoundDrawables(this.mIcon, null, this.mState, null);
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 2);
        if (this.mHasSubMenu) {
            MenuItemDefault.mergeDrawableStates((int[])nArray, (int[])STATE_MORE);
        } else if (this.mCheckable && this.mChecked) {
            MenuItemDefault.mergeDrawableStates((int[])nArray, (int[])STATE_CHECKED);
        } else if (this.mCheckable && !this.mChecked) {
            MenuItemDefault.mergeDrawableStates((int[])nArray, (int[])STATE_UNCHECKED);
        }
        return nArray;
    }

    public void initialize(GeckoMenuItem geckoMenuItem) {
        if (geckoMenuItem == null) {
            return;
        }
        this.setTitle(geckoMenuItem.getTitle());
        this.setIcon(geckoMenuItem.getIcon());
        this.setEnabled(geckoMenuItem.isEnabled());
        this.setCheckable(geckoMenuItem.isCheckable());
        this.setChecked(geckoMenuItem.isChecked());
        this.setSubMenuIndicator(geckoMenuItem.hasSubMenu());
    }

    private void refreshIcon() {
        this.setCompoundDrawables(this.mShowIcon ? this.mIcon : null, null, this.mState, null);
    }

    void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (this.mIcon != null) {
            this.mIcon.setBounds(sIconBounds);
            this.mIcon.setAlpha(this.isEnabled() ? 255 : 99);
        }
        this.refreshIcon();
    }

    void setIcon(int n) {
        this.setIcon(n == 0 ? null : this.getResources().getDrawable(n));
    }

    void setTitle(CharSequence charSequence) {
        this.setText(charSequence);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.mIcon != null) {
            this.mIcon.setAlpha(bl ? 255 : 99);
        }
        if (this.mState != null) {
            this.mState.setAlpha(bl ? 255 : 99);
        }
    }

    private void setCheckable(boolean bl) {
        if (this.mCheckable != bl) {
            this.mCheckable = bl;
            this.refreshDrawableState();
        }
    }

    private void setChecked(boolean bl) {
        if (this.mChecked != bl) {
            this.mChecked = bl;
            this.refreshDrawableState();
        }
    }

    public void setShowIcon(boolean bl) {
        if (this.mShowIcon != bl) {
            this.mShowIcon = bl;
            this.refreshIcon();
        }
    }

    private void setSubMenuIndicator(boolean bl) {
        if (this.mHasSubMenu != bl) {
            this.mHasSubMenu = bl;
            this.refreshDrawableState();
        }
    }
}

