/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.prompts.PromptInput;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Prompt
implements DialogInterface.OnClickListener,
DialogInterface.OnCancelListener,
AdapterView.OnItemClickListener {
    private static final String LOGTAG = "GeckoPromptService";
    private String[] mButtons;
    private PromptInput[] mInputs;
    private boolean[] mSelected;
    private AlertDialog mDialog;
    private final LayoutInflater mInflater;
    private ConcurrentLinkedQueue<String> mPromptQueue;
    private final Context mContext;
    private PromptCallback mCallback;
    private String mGuid;
    private static boolean mInitialized = false;
    private static int mGroupPaddingSize;
    private static int mLeftRightTextWithIconPadding;
    private static int mTopBottomTextWithIconPadding;
    private static int mIconTextPadding;
    private static int mIconSize;
    private static int mInputPaddingSize;
    private static int mMinRowSize;

    public Prompt(Context context, ConcurrentLinkedQueue<String> concurrentLinkedQueue) {
        this(context);
        this.mCallback = null;
        this.mPromptQueue = concurrentLinkedQueue;
    }

    public Prompt(Context context, PromptCallback promptCallback) {
        this(context);
        this.mCallback = promptCallback;
        this.mPromptQueue = null;
    }

    private Prompt(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)this.mContext);
        if (!mInitialized) {
            Resources resources = this.mContext.getResources();
            mGroupPaddingSize = (int)resources.getDimension(R.dimen.prompt_service_group_padding_size);
            mLeftRightTextWithIconPadding = (int)resources.getDimension(R.dimen.prompt_service_left_right_text_with_icon_padding);
            mTopBottomTextWithIconPadding = (int)resources.getDimension(R.dimen.prompt_service_top_bottom_text_with_icon_padding);
            mIconTextPadding = (int)resources.getDimension(R.dimen.prompt_service_icon_text_padding);
            mIconSize = (int)resources.getDimension(R.dimen.prompt_service_icon_size);
            mInputPaddingSize = (int)resources.getDimension(R.dimen.prompt_service_inputs_padding);
            mMinRowSize = (int)resources.getDimension(R.dimen.prompt_service_min_list_item_height);
            mInitialized = true;
        }
    }

    private View applyInputStyle(View view, PromptInput promptInput) {
        if (promptInput.canApplyInputStyle()) {
            view.setPadding(mInputPaddingSize, 0, mInputPaddingSize, 0);
        }
        return view;
    }

    public void show(JSONObject jSONObject) {
        this.processMessage(jSONObject);
    }

    public void show(String string2, String string3, PromptListItem[] promptListItemArray, boolean bl) {
        int n;
        ThreadUtils.assertOnUiThread();
        GeckoAppShell.getLayerView().abortPanning();
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setTitle((CharSequence)string2);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            builder.setMessage((CharSequence)string3);
        }
        if (promptListItemArray != null && promptListItemArray.length > 0) {
            this.addlistItems(builder, promptListItemArray, bl);
        } else if (!this.addInputs(builder)) {
            return;
        }
        int n2 = n = this.mButtons == null ? 0 : this.mButtons.length;
        if (n > 0) {
            builder.setPositiveButton((CharSequence)this.mButtons[0], (DialogInterface.OnClickListener)this);
            if (n > 1) {
                builder.setNeutralButton((CharSequence)this.mButtons[1], (DialogInterface.OnClickListener)this);
                if (n > 2) {
                    builder.setNegativeButton((CharSequence)this.mButtons[2], (DialogInterface.OnClickListener)this);
                }
            }
        }
        this.mDialog = builder.create();
        this.mDialog.setOnCancelListener((DialogInterface.OnCancelListener)this);
        this.mDialog.show();
    }

    public void setButtons(String[] stringArray) {
        this.mButtons = stringArray;
    }

    public void setInputs(PromptInput[] promptInputArray) {
        this.mInputs = promptInputArray;
    }

    private void addListResult(JSONObject jSONObject, int n) {
        try {
            if (this.mSelected != null) {
                JSONArray jSONArray = new JSONArray();
                for (int i = 0; i < this.mSelected.length; ++i) {
                    if (!this.mSelected[i]) continue;
                    jSONArray.put(i);
                }
                jSONObject.put("list", (Object)jSONArray);
            } else {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put(n);
                jSONObject.put("list", (Object)jSONArray);
                jSONObject.put("button", n);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void addInputValues(JSONObject jSONObject) {
        try {
            if (this.mInputs != null) {
                for (int i = 0; i < this.mInputs.length; ++i) {
                    jSONObject.put(this.mInputs[i].getId(), (Object)this.mInputs[i].getValue());
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void addButtonResult(JSONObject jSONObject, int n) {
        int n2 = -1;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case -3: {
                n2 = 1;
                break;
            }
            case -2: {
                n2 = 2;
            }
        }
        try {
            jSONObject.put("button", n2);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void onClick(DialogInterface dialogInterface, int n) {
        ThreadUtils.assertOnUiThread();
        JSONObject jSONObject = new JSONObject();
        try {
            ListView listView = this.mDialog.getListView();
            this.addButtonResult(jSONObject, n);
            this.addInputValues(jSONObject);
            if (listView != null || this.mSelected != null) {
                this.addListResult(jSONObject, n);
            }
        }
        catch (Exception exception) {
            Log.i((String)LOGTAG, (String)("Error building return: " + exception));
        }
        if (dialogInterface != null) {
            dialogInterface.dismiss();
        }
        this.finishDialog(jSONObject);
    }

    private void addlistItems(AlertDialog.Builder builder, PromptListItem[] promptListItemArray, boolean bl) {
        if (this.mSelected != null && this.mSelected.length > 0) {
            if (bl) {
                this.addMultiSelectList(builder, promptListItemArray);
            } else {
                this.addSingleSelectList(builder, promptListItemArray);
            }
        } else {
            this.addMenuList(builder, promptListItemArray);
        }
    }

    private void addMultiSelectList(AlertDialog.Builder builder, PromptListItem[] promptListItemArray) {
        PromptListAdapter promptListAdapter = new PromptListAdapter(this.mContext, R.layout.select_dialog_multichoice, promptListItemArray);
        promptListAdapter.listView = (ListView)this.mInflater.inflate(R.layout.select_dialog_list, null);
        promptListAdapter.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        builder.setInverseBackgroundForced(true);
        promptListAdapter.listView.setChoiceMode(2);
        promptListAdapter.listView.setAdapter((ListAdapter)promptListAdapter);
        builder.setView((View)promptListAdapter.listView);
    }

    private void addSingleSelectList(AlertDialog.Builder builder, PromptListItem[] promptListItemArray) {
        PromptListAdapter promptListAdapter = new PromptListAdapter(this.mContext, R.layout.select_dialog_singlechoice, promptListItemArray);
        int n = -1;
        for (int i = 0; i < this.mSelected.length; ++i) {
            if (!this.mSelected[i]) continue;
            n = i;
            break;
        }
        this.mSelected = null;
        builder.setSingleChoiceItems((ListAdapter)promptListAdapter, n, (DialogInterface.OnClickListener)this);
    }

    private void addMenuList(AlertDialog.Builder builder, PromptListItem[] promptListItemArray) {
        PromptListAdapter promptListAdapter = new PromptListAdapter(this.mContext, 17367043, promptListItemArray);
        builder.setAdapter((ListAdapter)promptListAdapter, (DialogInterface.OnClickListener)this);
        this.mSelected = null;
    }

    private boolean addInputs(AlertDialog.Builder builder) {
        int n;
        int n2 = n = this.mInputs == null ? 0 : this.mInputs.length;
        if (n == 0) {
            return true;
        }
        try {
            LinearLayout linearLayout;
            View view = null;
            boolean bl = false;
            if (n == 1) {
                view = this.mInputs[0].getView(this.mContext);
                this.applyInputStyle(view, this.mInputs[0]);
                bl |= this.mInputs[0].getScrollable();
            } else if (n > 1) {
                linearLayout = new LinearLayout(this.mContext);
                linearLayout.setOrientation(1);
                for (int i = 0; i < n; ++i) {
                    View view2 = this.mInputs[i].getView(this.mContext);
                    this.applyInputStyle(view2, this.mInputs[i]);
                    linearLayout.addView(view2);
                    bl |= this.mInputs[i].getScrollable();
                }
                view = linearLayout;
            }
            if (bl) {
                builder.setView(view);
            } else {
                linearLayout = new ScrollView(this.mContext);
                linearLayout.addView(view);
                builder.setView((View)linearLayout);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"Error showing prompt inputs", (Throwable)exception);
            this.cancelDialog();
            return false;
        }
        return true;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        ThreadUtils.assertOnUiThread();
        this.mSelected[n] = !this.mSelected[n];
    }

    public void onCancel(DialogInterface dialogInterface) {
        ThreadUtils.assertOnUiThread();
        this.cancelDialog();
    }

    private void cancelDialog() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("button", -1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.addInputValues(jSONObject);
        this.finishDialog(jSONObject);
    }

    public void finishDialog(JSONObject jSONObject) {
        this.mInputs = null;
        this.mButtons = null;
        this.mDialog = null;
        this.mSelected = null;
        try {
            jSONObject.put("guid", (Object)this.mGuid);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (this.mPromptQueue != null) {
            this.mPromptQueue.offer(jSONObject.toString());
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createNoOpEvent());
        if (this.mCallback != null) {
            this.mCallback.onPromptFinished(jSONObject.toString());
        }
        this.mGuid = null;
    }

    private void processMessage(JSONObject jSONObject) {
        String string2 = jSONObject.optString("title");
        String string3 = jSONObject.optString("text");
        this.mGuid = jSONObject.optString("guid");
        this.mButtons = Prompt.getStringArray(jSONObject, "buttons");
        JSONArray jSONArray = Prompt.getSafeArray(jSONObject, "inputs");
        this.mInputs = new PromptInput[jSONArray.length()];
        for (int i = 0; i < this.mInputs.length; ++i) {
            try {
                this.mInputs[i] = PromptInput.getInput(jSONArray.getJSONObject(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PromptListItem[] promptListItemArray = this.getListItemArray(jSONObject, "listitems");
        this.mSelected = Prompt.getBooleanArray(jSONObject, "selected");
        boolean bl = jSONObject.optBoolean("multiple");
        this.show(string2, string3, promptListItemArray, bl);
    }

    private static JSONArray getSafeArray(JSONObject jSONObject, String string2) {
        try {
            return jSONObject.getJSONArray(string2);
        }
        catch (Exception exception) {
            return new JSONArray();
        }
    }

    public static String[] getStringArray(JSONObject jSONObject, String string2) {
        JSONArray jSONArray = Prompt.getSafeArray(jSONObject, string2);
        int n = jSONArray.length();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            try {
                stringArray[i] = jSONArray.getString(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stringArray;
    }

    private static boolean[] getBooleanArray(JSONObject jSONObject, String string2) {
        JSONArray jSONArray = new JSONArray();
        try {
            jSONArray = jSONObject.getJSONArray(string2);
        }
        catch (Exception exception) {
            return null;
        }
        int n = jSONArray.length();
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            try {
                blArray[i] = jSONArray.getBoolean(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return blArray;
    }

    private PromptListItem[] getListItemArray(JSONObject jSONObject, String string2) {
        JSONArray jSONArray = Prompt.getSafeArray(jSONObject, string2);
        int n = jSONArray.length();
        PromptListItem[] promptListItemArray = new PromptListItem[n];
        for (int i = 0; i < n; ++i) {
            try {
                promptListItemArray[i] = new PromptListItem(jSONArray.getJSONObject(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return promptListItemArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PromptListAdapter
    extends ArrayAdapter<PromptListItem> {
        private static final int VIEW_TYPE_ITEM = 0;
        private static final int VIEW_TYPE_GROUP = 1;
        private static final int VIEW_TYPE_COUNT = 2;
        public ListView listView;
        private int mResourceId;
        private Drawable mBlankDrawable;
        private Drawable mMoreDrawable;

        PromptListAdapter(Context context, int n, PromptListItem[] promptListItemArray) {
            super(context, n, (Object[])promptListItemArray);
            this.mResourceId = -1;
            this.mBlankDrawable = null;
            this.mMoreDrawable = null;
            this.mResourceId = n;
        }

        public int getItemViewType(int n) {
            PromptListItem promptListItem = (PromptListItem)this.getItem(n);
            return promptListItem.isGroup ? 1 : 0;
        }

        public int getViewTypeCount() {
            return 2;
        }

        private Drawable getMoreDrawable(Resources resources) {
            if (this.mMoreDrawable == null) {
                this.mMoreDrawable = resources.getDrawable(17301573);
            }
            return this.mMoreDrawable;
        }

        private Drawable getBlankDrawable(Resources resources) {
            if (this.mBlankDrawable == null) {
                this.mBlankDrawable = resources.getDrawable(R.drawable.blank);
            }
            return this.mBlankDrawable;
        }

        private void maybeUpdateIcon(PromptListItem promptListItem, TextView textView) {
            Bitmap bitmap;
            if (promptListItem.icon == null && !promptListItem.inGroup && !promptListItem.isParent) {
                textView.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
                return;
            }
            Drawable drawable2 = null;
            Resources resources = Prompt.this.mContext.getResources();
            textView.setCompoundDrawablePadding(mIconTextPadding);
            if (promptListItem.icon != null) {
                bitmap = ((BitmapDrawable)promptListItem.icon).getBitmap();
                drawable2 = new BitmapDrawable(resources, Bitmap.createScaledBitmap((Bitmap)bitmap, (int)mIconSize, (int)mIconSize, (boolean)true));
            } else if (promptListItem.inGroup) {
                drawable2 = this.getBlankDrawable(resources);
            }
            bitmap = null;
            if (promptListItem.isParent) {
                bitmap = this.getMoreDrawable(resources);
            }
            if (drawable2 != null || bitmap != null) {
                textView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, (Drawable)bitmap, null);
            }
        }

        private void maybeUpdateCheckedState(int n, PromptListItem promptListItem, ViewHolder viewHolder) {
            viewHolder.textView.setEnabled(!promptListItem.disabled && !promptListItem.isGroup);
            viewHolder.textView.setClickable(promptListItem.isGroup || promptListItem.disabled);
            if (Prompt.this.mSelected == null) {
                return;
            }
            try {
                CheckedTextView checkedTextView = (CheckedTextView)viewHolder.textView;
                if (this.listView != null) {
                    this.listView.setItemChecked(n, Prompt.this.mSelected[n]);
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        public View getView(int n, View view, ViewGroup viewGroup) {
            PromptListItem promptListItem = (PromptListItem)this.getItem(n);
            ViewHolder viewHolder = null;
            if (view == null) {
                int n2 = this.mResourceId;
                if (promptListItem.isGroup) {
                    n2 = R.layout.list_item_header;
                }
                view = Prompt.this.mInflater.inflate(n2, null);
                view.setMinimumHeight(mMinRowSize);
                TextView textView = (TextView)view.findViewById(16908308);
                viewHolder = new ViewHolder(textView, textView.getPaddingLeft(), textView.getPaddingRight(), textView.getPaddingTop(), textView.getPaddingBottom());
                view.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)view.getTag();
            }
            viewHolder.textView.setText((CharSequence)promptListItem.label);
            this.maybeUpdateCheckedState(n, promptListItem, viewHolder);
            this.maybeUpdateIcon(promptListItem, viewHolder.textView);
            return view;
        }

        private class ViewHolder {
            public final TextView textView;
            public final int paddingLeft;
            public final int paddingRight;
            public final int paddingTop;
            public final int paddingBottom;

            ViewHolder(TextView textView, int n, int n2, int n3, int n4) {
                this.textView = textView;
                this.paddingLeft = n;
                this.paddingRight = n2;
                this.paddingTop = n3;
                this.paddingBottom = n4;
            }
        }
    }

    public static interface PromptCallback {
        public void onPromptFinished(String var1);
    }

    public static class PromptListItem {
        public final String label;
        public final boolean isGroup;
        public final boolean inGroup;
        public final boolean disabled;
        public final int id;
        public final boolean isParent;
        public Drawable icon;

        PromptListItem(JSONObject jSONObject) {
            this.label = jSONObject.optString("label");
            this.isGroup = jSONObject.optBoolean("isGroup");
            this.inGroup = jSONObject.optBoolean("inGroup");
            this.disabled = jSONObject.optBoolean("disabled");
            this.id = jSONObject.optInt("id");
            this.isParent = jSONObject.optBoolean("isParent");
        }

        public PromptListItem(String string2) {
            this.label = string2;
            this.isGroup = false;
            this.inGroup = false;
            this.disabled = false;
            this.id = 0;
            this.isParent = false;
        }
    }
}

