/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.json.JSONObject;
import org.mozilla.gecko.BrowserApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.menu.MenuPopup;
import org.mozilla.gecko.toolbar.AutocompleteHandler;
import org.mozilla.gecko.toolbar.BackButton;
import org.mozilla.gecko.toolbar.ForwardButton;
import org.mozilla.gecko.toolbar.ShapedButton;
import org.mozilla.gecko.toolbar.TabCounter;
import org.mozilla.gecko.toolbar.ToolbarDisplayLayout;
import org.mozilla.gecko.toolbar.ToolbarEditLayout;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.widget.GeckoImageButton;
import org.mozilla.gecko.widget.GeckoImageView;
import org.mozilla.gecko.widget.GeckoLinearLayout;
import org.mozilla.gecko.widget.GeckoRelativeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserToolbar
extends GeckoRelativeLayout
implements Tabs.OnTabsChangedListener,
GeckoMenu.ActionItemBarPresenter,
GeckoEventListener {
    private static final String LOGTAG = "GeckoToolbar";
    private ToolbarDisplayLayout mUrlDisplayLayout;
    private ToolbarEditLayout mUrlEditLayout;
    private View mUrlBarEntry;
    private ImageView mUrlBarRightEdge;
    private boolean mSwitchingTabs;
    private ShapedButton mTabs;
    private ImageButton mBack;
    private ImageButton mForward;
    private TabCounter mTabsCounter;
    private GeckoImageButton mMenu;
    private GeckoImageView mMenuIcon;
    private LinearLayout mActionItemBar;
    private MenuPopup mMenuPopup;
    private List<View> mFocusOrder;
    private OnActivateListener mActivateListener;
    private OnCommitListener mCommitListener;
    private OnDismissListener mDismissListener;
    private OnFilterListener mFilterListener;
    private OnStartEditingListener mStartEditingListener;
    private OnStopEditingListener mStopEditingListener;
    private final BrowserApp mActivity;
    private boolean mHasSoftMenuButton;
    private boolean mIsEditing;
    private boolean mAnimatingEntry;
    private int mUrlBarViewOffset;
    private int mDefaultForwardMargin;
    private static final Interpolator sButtonsInterpolator = new AccelerateInterpolator();
    private static final int FORWARD_ANIMATION_DURATION = 450;
    private final LightweightTheme mTheme;

    public BrowserToolbar(Context context) {
        this(context, null);
    }

    public BrowserToolbar(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        this.mActivity = (BrowserApp)context;
        LayoutInflater.from((Context)context).inflate(R.layout.browser_toolbar, (ViewGroup)this);
        Tabs.registerOnTabsChangedListener(this);
        this.mSwitchingTabs = true;
        this.mAnimatingEntry = false;
        this.registerEventListener("Reader:Click");
        this.registerEventListener("Reader:LongClick");
        this.mAnimatingEntry = false;
        Resources resources = this.getResources();
        this.mUrlBarViewOffset = resources.getDimensionPixelSize(R.dimen.url_bar_offset_left);
        this.mDefaultForwardMargin = resources.getDimensionPixelSize(R.dimen.forward_default_offset);
        this.mUrlDisplayLayout = (ToolbarDisplayLayout)this.findViewById(R.id.display_layout);
        this.mUrlBarEntry = this.findViewById(R.id.url_bar_entry);
        this.mUrlEditLayout = (ToolbarEditLayout)this.findViewById(R.id.edit_layout);
        this.mUrlBarRightEdge = (ImageView)this.findViewById(R.id.url_bar_right_edge);
        if (this.mUrlBarRightEdge != null) {
            this.mUrlBarRightEdge.getDrawable().setLevel(6000);
        }
        this.mTabs = (ShapedButton)this.findViewById(R.id.tabs);
        this.mTabsCounter = (TabCounter)this.findViewById(R.id.tabs_counter);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mTabsCounter.setLayerType(1, null);
        }
        this.mBack = (ImageButton)this.findViewById(R.id.back);
        this.setButtonEnabled(this.mBack, false);
        this.mForward = (ImageButton)this.findViewById(R.id.forward);
        this.setButtonEnabled(this.mForward, false);
        this.mMenu = (GeckoImageButton)this.findViewById(R.id.menu);
        this.mMenuIcon = (GeckoImageView)this.findViewById(R.id.menu_icon);
        this.mActionItemBar = (LinearLayout)this.findViewById(R.id.menu_items);
        this.mHasSoftMenuButton = !HardwareUtils.hasMenuButton();
        this.mFocusOrder = new ArrayList<View>();
        if (HardwareUtils.isTablet()) {
            this.mFocusOrder.addAll(Arrays.asList(this.mTabs, this.mBack, this.mForward, this));
            this.mFocusOrder.addAll(this.mUrlDisplayLayout.getFocusOrder());
            this.mFocusOrder.addAll(Arrays.asList(this.mActionItemBar, this.mMenu));
        } else {
            this.mFocusOrder.add((View)this);
            this.mFocusOrder.addAll(this.mUrlDisplayLayout.getFocusOrder());
            this.mFocusOrder.addAll(Arrays.asList(this.mTabs, this.mMenu));
        }
        this.setIsEditing(false);
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (BrowserToolbar.this.mActivateListener != null) {
                    BrowserToolbar.this.mActivateListener.onActivate();
                }
            }
        });
        this.setOnCreateContextMenuListener(new View.OnCreateContextMenuListener(){

            public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
                Tab tab;
                if (BrowserToolbar.this.isEditing()) {
                    return;
                }
                MenuInflater menuInflater = BrowserToolbar.this.mActivity.getMenuInflater();
                menuInflater.inflate(R.menu.titlebar_contextmenu, (Menu)contextMenu);
                String string2 = Clipboard.getText();
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    contextMenu.findItem(R.id.pasteandgo).setVisible(false);
                    contextMenu.findItem(R.id.paste).setVisible(false);
                }
                if ((tab = Tabs.getInstance().getSelectedTab()) != null) {
                    String string3 = tab.getURL();
                    if (string3 == null) {
                        contextMenu.findItem(R.id.copyurl).setVisible(false);
                        contextMenu.findItem(R.id.share).setVisible(false);
                        contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    }
                    contextMenu.findItem(R.id.subscribe).setVisible(tab.hasFeeds());
                    contextMenu.findItem(R.id.add_search_engine).setVisible(tab.hasOpenSearch());
                } else {
                    contextMenu.findItem(R.id.copyurl).setVisible(false);
                    contextMenu.findItem(R.id.share).setVisible(false);
                    contextMenu.findItem(R.id.add_to_launcher).setVisible(false);
                    contextMenu.findItem(R.id.subscribe).setVisible(false);
                    contextMenu.findItem(R.id.add_search_engine).setVisible(false);
                }
                contextMenu.findItem(R.id.share).setVisible(!GeckoProfile.get(BrowserToolbar.this.getContext()).inGuestMode());
            }
        });
        this.mUrlDisplayLayout.setOnStopListener(new ToolbarDisplayLayout.OnStopListener(){

            public Tab onStop() {
                Tab tab = Tabs.getInstance().getSelectedTab();
                if (tab != null) {
                    tab.doStop();
                    return tab;
                }
                return null;
            }
        });
        this.mUrlDisplayLayout.setOnTitleChangeListener(new ToolbarDisplayLayout.OnTitleChangeListener(){

            public void onTitleChange(CharSequence charSequence) {
                String string2 = charSequence != null ? ((Object)charSequence).toString() : BrowserToolbar.this.mActivity.getString(R.string.url_bar_default_text);
                BrowserToolbar.this.setContentDescription(string2);
            }
        });
        this.mUrlEditLayout.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean bl) {
                BrowserToolbar.this.setSelected(bl);
            }
        });
        this.mTabs.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                BrowserToolbar.this.toggleTabs();
            }
        });
        this.mTabs.setImageLevel(0);
        this.mBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doBack();
            }
        });
        this.mBack.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showBackHistory();
            }
        });
        this.mForward.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Tabs.getInstance().getSelectedTab().doForward();
            }
        });
        this.mForward.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                return Tabs.getInstance().getSelectedTab().showForwardHistory();
            }
        });
        if (this.mHasSoftMenuButton) {
            this.mMenu.setVisibility(0);
            this.mMenuIcon.setVisibility(0);
            this.mMenu.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BrowserToolbar.this.mActivity.openOptionsMenu();
                }
            });
        }
    }

    public void refresh() {
        this.mUrlDisplayLayout.dismissSiteIdentityPopup();
    }

    public boolean onBackPressed() {
        return this.mUrlDisplayLayout.dismissSiteIdentityPopup();
    }

    public boolean onKey(int n, KeyEvent keyEvent) {
        if (keyEvent.getAction() != 0) {
            return false;
        }
        if (n > KeyEvent.getMaxKeyCode()) {
            return true;
        }
        if (n == 4 || n == 82 || n == 19 || n == 20 || n == 21 || n == 22 || n == 23 || n == 67 || n == 24 || n == 25) {
            return false;
        }
        if (this.isEditing()) {
            return this.mUrlEditLayout.onKey(n, keyEvent);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent != null && motionEvent.getY() > (float)this.getHeight() + ViewHelper.getTranslationY((View)this)) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n2 != n4) {
            this.post(new Runnable(){

                public void run() {
                    BrowserToolbar.this.mActivity.refreshToolbarHeight();
                }
            });
        }
    }

    @Override
    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        Log.d((String)LOGTAG, (String)("onTabChanged: " + (Object)((Object)tabEvents)));
        Tabs tabs = Tabs.getInstance();
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: {
                this.updateTabCount(tabs.getDisplayCount());
                break;
            }
            case RESTORED: 
            case SELECTED: {
                this.mUrlDisplayLayout.dismissSiteIdentityPopup();
                this.updateTabCount(tabs.getDisplayCount());
                this.mSwitchingTabs = true;
            }
        }
        if (tabs.isSelectedTab(tab)) {
            EnumSet<ToolbarDisplayLayout.UpdateFlags> enumSet = EnumSet.noneOf(ToolbarDisplayLayout.UpdateFlags.class);
            switch (tabEvents) {
                case TITLE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                    break;
                }
                case START: {
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PROGRESS);
                    break;
                }
                case STOP: {
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.PROGRESS);
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                    break;
                }
                case SELECTED: 
                case LOAD_ERROR: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.TITLE);
                }
                case LOCATION_CHANGE: {
                    this.refreshState();
                    break;
                }
                case ADDED: 
                case CLOSED: {
                    this.updateBackButton(tab);
                    this.updateForwardButton(tab);
                    break;
                }
                case FAVICON: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.FAVICON);
                    break;
                }
                case SECURITY_CHANGE: {
                    enumSet.add(ToolbarDisplayLayout.UpdateFlags.SITE_IDENTITY);
                }
            }
            if (!enumSet.isEmpty()) {
                this.updateDisplayLayout(tab, enumSet);
            }
        }
        switch (tabEvents) {
            case SELECTED: 
            case LOAD_ERROR: 
            case LOCATION_CHANGE: {
                this.mSwitchingTabs = false;
            }
        }
    }

    public boolean isVisible() {
        return ViewHelper.getTranslationY((View)this) == 0.0f;
    }

    public void setNextFocusDownId(int n) {
        super.setNextFocusDownId(n);
        this.mTabs.setNextFocusDownId(n);
        this.mBack.setNextFocusDownId(n);
        this.mForward.setNextFocusDownId(n);
        this.mUrlDisplayLayout.setNextFocusDownId(n);
        this.mMenu.setNextFocusDownId(n);
    }

    private int getUrlBarEntryTranslation() {
        return this.getWidth() - this.mUrlBarEntry.getRight();
    }

    private int getUrlBarCurveTranslation() {
        return this.getWidth() - this.mTabs.getLeft();
    }

    private boolean canDoBack(Tab tab) {
        return tab.canDoBack() && !this.mIsEditing;
    }

    private boolean canDoForward(Tab tab) {
        return tab.canDoForward() && !this.mIsEditing;
    }

    private void addTab() {
        this.mActivity.addTab();
    }

    private void toggleTabs() {
        if (this.mActivity.areTabsShown()) {
            if (this.mActivity.hasTabsSideBar()) {
                this.mActivity.hideTabs();
            }
        } else {
            InputMethodManager inputMethodManager = (InputMethodManager)this.mActivity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(this.mTabs.getWindowToken(), 0);
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                if (!tab.isPrivate()) {
                    this.mActivity.showNormalTabs();
                } else {
                    this.mActivity.showPrivateTabs();
                }
            }
        }
    }

    private void updateTabCountAndAnimate(int n) {
        if (!this.isVisible()) {
            this.updateTabCount(n);
            return;
        }
        if (!this.isEditing() || HardwareUtils.isTablet()) {
            this.mTabsCounter.setCount(n);
            this.mTabs.setContentDescription(n > 1 ? this.mActivity.getString(R.string.num_tabs, new Object[]{n}) : this.mActivity.getString(R.string.one_tab));
        }
    }

    private void updateTabCount(int n) {
        if (this.isEditing() && !HardwareUtils.isTablet()) {
            return;
        }
        if (this.isVisible() && ViewHelper.getAlpha((View)this.mTabsCounter) != 0.0f) {
            this.mTabsCounter.setCountWithAnimation(n);
        } else {
            this.mTabsCounter.setCount(n);
        }
        this.mTabs.setContentDescription(n > 1 ? this.mActivity.getString(R.string.num_tabs, new Object[]{n}) : this.mActivity.getString(R.string.one_tab));
    }

    private void updateDisplayLayout(Tab tab, EnumSet<ToolbarDisplayLayout.UpdateFlags> enumSet) {
        if (this.mSwitchingTabs) {
            enumSet.add(ToolbarDisplayLayout.UpdateFlags.DISABLE_ANIMATIONS);
        }
        this.mUrlDisplayLayout.updateFromTab(tab, enumSet);
        if (enumSet.contains((Object)ToolbarDisplayLayout.UpdateFlags.TITLE) && !this.isEditing()) {
            this.mUrlEditLayout.setText(tab.getURL());
        }
        if (enumSet.contains((Object)ToolbarDisplayLayout.UpdateFlags.PROGRESS)) {
            this.updateFocusOrder();
        }
    }

    private void updateFocusOrder() {
        View view = null;
        boolean bl = false;
        for (View view2 : this.mFocusOrder) {
            if (view2.getVisibility() != 0 || !view2.isEnabled()) {
                if (!view2.hasFocus()) continue;
                bl = true;
                continue;
            }
            if (view2 == this.mActionItemBar) {
                int n = this.mActionItemBar.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view3 = this.mActionItemBar.getChildAt(i);
                    if (view != null) {
                        view3.setNextFocusLeftId(view.getId());
                        view.setNextFocusRightId(view3.getId());
                    }
                    view = view3;
                }
                continue;
            }
            if (view != null) {
                view2.setNextFocusLeftId(view.getId());
                view.setNextFocusRightId(view2.getId());
            }
            view = view2;
        }
        if (bl) {
            this.requestFocus();
        }
    }

    public void onEditSuggestion(String string2) {
        if (!this.isEditing()) {
            return;
        }
        this.mUrlEditLayout.onEditSuggestion(string2);
    }

    public void setTitle(CharSequence charSequence) {
        this.mUrlDisplayLayout.setTitle(charSequence);
    }

    public void prepareTabsAnimation(PropertyAnimator propertyAnimator, boolean bl) {
        if (!bl) {
            PropertyAnimator propertyAnimator2 = new PropertyAnimator(propertyAnimator.getDuration(), sButtonsInterpolator);
            propertyAnimator2.attach((View)this.mTabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
            if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
                propertyAnimator2.attach((View)this.mMenuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
            }
            propertyAnimator2.start();
            return;
        }
        ViewHelper.setAlpha((View)this.mTabsCounter, 0.0f);
        if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
            ViewHelper.setAlpha((View)this.mMenuIcon, 0.0f);
        }
    }

    public void finishTabsAnimation(boolean bl) {
        if (bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(150L);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.ALPHA, 1.0f);
        if (this.mHasSoftMenuButton && !HardwareUtils.isTablet()) {
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        propertyAnimator.start();
    }

    public void setOnActivateListener(OnActivateListener onActivateListener) {
        this.mActivateListener = onActivateListener;
    }

    public void setOnCommitListener(OnCommitListener onCommitListener) {
        this.mCommitListener = onCommitListener;
        this.mUrlEditLayout.setOnCommitListener(onCommitListener);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mDismissListener = onDismissListener;
        this.mUrlEditLayout.setOnDismissListener(onDismissListener);
    }

    public void setOnFilterListener(OnFilterListener onFilterListener) {
        this.mFilterListener = onFilterListener;
        this.mUrlEditLayout.setOnFilterListener(onFilterListener);
    }

    public void setOnStartEditingListener(OnStartEditingListener onStartEditingListener) {
        this.mStartEditingListener = onStartEditingListener;
    }

    public void setOnStopEditingListener(OnStopEditingListener onStopEditingListener) {
        this.mStopEditingListener = onStopEditingListener;
    }

    private void showUrlEditLayout() {
        this.setUrlEditLayoutVisibility(true, null);
    }

    private void showUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(true, propertyAnimator);
    }

    private void hideUrlEditLayout() {
        this.setUrlEditLayoutVisibility(false, null);
    }

    private void hideUrlEditLayout(PropertyAnimator propertyAnimator) {
        this.setUrlEditLayoutVisibility(false, propertyAnimator);
    }

    private void setUrlEditLayoutVisibility(boolean bl, PropertyAnimator propertyAnimator) {
        GeckoLinearLayout geckoLinearLayout;
        GeckoLinearLayout geckoLinearLayout2 = bl ? this.mUrlEditLayout : this.mUrlDisplayLayout;
        GeckoLinearLayout geckoLinearLayout3 = geckoLinearLayout = bl ? this.mUrlDisplayLayout : this.mUrlEditLayout;
        if (bl) {
            this.mUrlEditLayout.prepareShowAnimation(propertyAnimator);
        }
        if (propertyAnimator == null) {
            geckoLinearLayout.setVisibility(8);
            geckoLinearLayout2.setVisibility(0);
            return;
        }
        ViewHelper.setAlpha((View)geckoLinearLayout2, 0.0f);
        propertyAnimator.attach((View)geckoLinearLayout2, PropertyAnimator.Property.ALPHA, 1.0f);
        propertyAnimator.attach((View)geckoLinearLayout, PropertyAnimator.Property.ALPHA, 0.0f);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener((View)geckoLinearLayout2, (View)geckoLinearLayout){
            final /* synthetic */ View val$viewToShow;
            final /* synthetic */ View val$viewToHide;
            {
                this.val$viewToShow = view;
                this.val$viewToHide = view2;
            }

            public void onPropertyAnimationStart() {
                this.val$viewToShow.setVisibility(0);
            }

            public void onPropertyAnimationEnd() {
                this.val$viewToHide.setVisibility(8);
                ViewHelper.setAlpha(this.val$viewToHide, 1.0f);
            }
        });
    }

    private void updateChildrenForEditing() {
        if (!HardwareUtils.isTablet()) {
            return;
        }
        boolean bl = !this.mIsEditing;
        float f = bl ? 1.0f : 0.24f;
        this.mTabs.setEnabled(bl);
        ViewHelper.setAlpha((View)this.mTabsCounter, f);
        this.mMenu.setEnabled(bl);
        ViewHelper.setAlpha((View)this.mMenuIcon, f);
        int n = this.mActionItemBar.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.mActionItemBar.getChildAt(i).setEnabled(bl);
        }
        ViewHelper.setAlpha((View)this.mActionItemBar, f);
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.setButtonEnabled(this.mBack, this.canDoBack(tab));
            this.setButtonEnabled(this.mForward, this.canDoForward(tab));
            if (!this.mIsEditing) {
                this.animateForwardButton(this.canDoForward(tab) ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
            }
        }
    }

    private void setIsEditing(boolean bl) {
        this.mIsEditing = bl;
        this.mUrlEditLayout.setEnabled(bl);
    }

    public boolean isEditing() {
        return this.mIsEditing;
    }

    public void startEditing(String string2, PropertyAnimator propertyAnimator) {
        if (this.isEditing()) {
            return;
        }
        this.mUrlEditLayout.setText(string2 != null ? string2 : "");
        this.setIsEditing(true);
        this.updateChildrenForEditing();
        if (this.mStartEditingListener != null) {
            this.mStartEditingListener.onStartEditing();
        }
        if (this.mUrlBarRightEdge != null) {
            this.mUrlBarRightEdge.setVisibility(0);
        }
        int n = this.getUrlBarEntryTranslation();
        int n2 = this.getUrlBarCurveTranslation();
        if (HardwareUtils.isTablet() || Build.VERSION.SDK_INT < 11) {
            this.showUrlEditLayout();
            if (!HardwareUtils.isTablet()) {
                if (this.mUrlBarRightEdge != null) {
                    ViewHelper.setTranslationX((View)this.mUrlBarRightEdge, n);
                }
                ViewHelper.setTranslationX((View)this.mTabs, n2);
                ViewHelper.setTranslationX((View)this.mTabsCounter, n2);
                ViewHelper.setTranslationX((View)this.mActionItemBar, n2);
                if (this.mHasSoftMenuButton) {
                    ViewHelper.setTranslationX((View)this.mMenu, n2);
                    ViewHelper.setTranslationX((View)this.mMenuIcon, n2);
                }
            }
            return;
        }
        if (this.mAnimatingEntry) {
            return;
        }
        this.setSelected(true);
        this.mUrlDisplayLayout.prepareStartEditingAnimation();
        if (this.mUrlBarRightEdge != null) {
            propertyAnimator.attach((View)this.mUrlBarRightEdge, PropertyAnimator.Property.TRANSLATION_X, n);
        }
        propertyAnimator.attach((View)this.mTabs, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.TRANSLATION_X, n2);
        propertyAnimator.attach((View)this.mActionItemBar, PropertyAnimator.Property.TRANSLATION_X, n2);
        if (this.mHasSoftMenuButton) {
            propertyAnimator.attach((View)this.mMenu, PropertyAnimator.Property.TRANSLATION_X, n2);
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.TRANSLATION_X, n2);
        }
        this.showUrlEditLayout(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                BrowserToolbar.this.mAnimatingEntry = false;
            }
        });
        this.mAnimatingEntry = true;
    }

    public String cancelEdit() {
        return this.stopEditing();
    }

    public String commitEdit() {
        String string2 = this.stopEditing();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.setTitle(string2);
        }
        return string2;
    }

    private String stopEditing() {
        String string2 = this.mUrlEditLayout.getText();
        if (!this.isEditing()) {
            return string2;
        }
        this.setIsEditing(false);
        this.updateChildrenForEditing();
        if (this.mStopEditingListener != null) {
            this.mStopEditingListener.onStopEditing();
        }
        if (HardwareUtils.isTablet() || Build.VERSION.SDK_INT < 11) {
            this.hideUrlEditLayout();
            if (!HardwareUtils.isTablet()) {
                this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
                if (this.mUrlBarRightEdge != null) {
                    ViewHelper.setTranslationX((View)this.mUrlBarRightEdge, 0.0f);
                }
                ViewHelper.setTranslationX((View)this.mTabs, 0.0f);
                ViewHelper.setTranslationX((View)this.mTabsCounter, 0.0f);
                ViewHelper.setTranslationX((View)this.mActionItemBar, 0.0f);
                if (this.mHasSoftMenuButton) {
                    ViewHelper.setTranslationX((View)this.mMenu, 0.0f);
                    ViewHelper.setTranslationX((View)this.mMenuIcon, 0.0f);
                }
            }
            return string2;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(250L);
        propertyAnimator.setUseHardwareLayer(false);
        if (this.mUrlBarRightEdge != null) {
            propertyAnimator.attach((View)this.mUrlBarRightEdge, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        }
        propertyAnimator.attach((View)this.mTabs, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.mTabsCounter, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        propertyAnimator.attach((View)this.mActionItemBar, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        if (this.mHasSoftMenuButton) {
            propertyAnimator.attach((View)this.mMenu, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
            propertyAnimator.attach((View)this.mMenuIcon, PropertyAnimator.Property.TRANSLATION_X, 0.0f);
        }
        this.hideUrlEditLayout(propertyAnimator);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
            }

            public void onPropertyAnimationEnd() {
                if (BrowserToolbar.this.mUrlBarRightEdge != null) {
                    BrowserToolbar.this.mUrlBarRightEdge.setVisibility(4);
                }
                PropertyAnimator propertyAnimator = new PropertyAnimator(300L);
                BrowserToolbar.this.mUrlDisplayLayout.prepareStopEditingAnimation(propertyAnimator);
                propertyAnimator.start();
                BrowserToolbar.this.mAnimatingEntry = false;
                BrowserToolbar.this.updateTabCountAndAnimate(Tabs.getInstance().getDisplayCount());
            }
        });
        this.mAnimatingEntry = true;
        propertyAnimator.start();
        return string2;
    }

    public void setButtonEnabled(ImageButton imageButton, boolean bl) {
        Drawable drawable2 = imageButton.getDrawable();
        if (drawable2 != null) {
            drawable2.setAlpha(bl ? 255 : 61);
        }
        imageButton.setEnabled(bl);
    }

    public void updateBackButton(Tab tab) {
        this.setButtonEnabled(this.mBack, this.canDoBack(tab));
    }

    private void animateForwardButton(ForwardButtonAnimation forwardButtonAnimation) {
        if (this.mForward.getVisibility() != 0) {
            return;
        }
        final boolean bl = forwardButtonAnimation == ForwardButtonAnimation.SHOW;
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mForward.getLayoutParams();
        if (marginLayoutParams.leftMargin > this.mDefaultForwardMargin && bl || marginLayoutParams.leftMargin == this.mDefaultForwardMargin && !bl) {
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(this.mSwitchingTabs ? 10L : 450L);
        final int n = this.mForward.getWidth() / 2;
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            public void onPropertyAnimationStart() {
                if (!bl) {
                    ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = 0;
                    BrowserToolbar.this.requestLayout();
                }
            }

            public void onPropertyAnimationEnd() {
                ViewGroup.MarginLayoutParams marginLayoutParams;
                if (bl) {
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlDisplayLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.mUrlBarViewOffset;
                    marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mUrlEditLayout.getLayoutParams();
                    marginLayoutParams.leftMargin = BrowserToolbar.this.mUrlBarViewOffset;
                }
                BrowserToolbar.this.mUrlDisplayLayout.finishForwardAnimation();
                marginLayoutParams = (ViewGroup.MarginLayoutParams)BrowserToolbar.this.mForward.getLayoutParams();
                marginLayoutParams.leftMargin = BrowserToolbar.this.mDefaultForwardMargin + (bl ? n : 0);
                ViewHelper.setTranslationX((View)BrowserToolbar.this.mForward, 0.0f);
                BrowserToolbar.this.requestLayout();
            }
        });
        this.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
        propertyAnimator.start();
    }

    public void updateForwardButton(Tab tab) {
        boolean bl = this.canDoForward(tab);
        if (this.mForward.isEnabled() == bl) {
            return;
        }
        this.setButtonEnabled(this.mForward, bl);
        this.animateForwardButton(bl ? ForwardButtonAnimation.SHOW : ForwardButtonAnimation.HIDE);
    }

    private void prepareForwardAnimation(PropertyAnimator propertyAnimator, ForwardButtonAnimation forwardButtonAnimation, int n) {
        if (forwardButtonAnimation == ForwardButtonAnimation.HIDE) {
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.TRANSLATION_X, -n);
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.ALPHA, 0.0f);
        } else {
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.TRANSLATION_X, n);
            propertyAnimator.attach((View)this.mForward, PropertyAnimator.Property.ALPHA, 1.0f);
        }
        this.mUrlDisplayLayout.prepareForwardAnimation(propertyAnimator, forwardButtonAnimation, n);
    }

    @Override
    public boolean addActionItem(View view) {
        this.mActionItemBar.addView(view);
        return true;
    }

    @Override
    public void removeActionItem(View view) {
        this.mActionItemBar.removeView(view);
    }

    public void show() {
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    private void refreshState() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            this.updateDisplayLayout(tab, EnumSet.of(ToolbarDisplayLayout.UpdateFlags.FAVICON, ToolbarDisplayLayout.UpdateFlags.SITE_IDENTITY, ToolbarDisplayLayout.UpdateFlags.PROGRESS, ToolbarDisplayLayout.UpdateFlags.PRIVATE_MODE));
            this.updateBackButton(tab);
            this.updateForwardButton(tab);
            boolean bl = tab.isPrivate();
            this.setPrivateMode(bl);
            this.mTabs.setPrivateMode(bl);
            this.mMenu.setPrivateMode(bl);
            this.mMenuIcon.setPrivateMode(bl);
            this.mUrlEditLayout.setPrivateMode(bl);
            if (this.mBack instanceof BackButton) {
                ((BackButton)this.mBack).setPrivateMode(bl);
            }
            if (this.mForward instanceof ForwardButton) {
                ((ForwardButton)this.mForward).setPrivateMode(bl);
            }
        }
    }

    public View getDoorHangerAnchor() {
        return this.mUrlDisplayLayout.getDoorHangerAnchor();
    }

    public void onDestroy() {
        Tabs.unregisterOnTabsChangedListener(this);
        this.unregisterEventListener("Reader:Click");
        this.unregisterEventListener("Reader:LongClick");
    }

    public boolean openOptionsMenu() {
        if (!this.mHasSoftMenuButton) {
            return false;
        }
        if (this.mMenuPopup == null) {
            MenuPanel menuPanel = this.mActivity.getMenuPanel();
            this.mMenuPopup = new MenuPopup((Context)this.mActivity);
            this.mMenuPopup.setPanelView((View)menuPanel);
            this.mMenuPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    BrowserToolbar.this.mActivity.onOptionsMenuClosed(null);
                }
            });
        }
        GeckoAppShell.getGeckoInterface().invalidateOptionsMenu();
        if (!this.mMenuPopup.isShowing()) {
            this.mMenuPopup.showAsDropDown((View)this.mMenu);
        }
        return true;
    }

    public boolean closeOptionsMenu() {
        if (!this.mHasSoftMenuButton) {
            return false;
        }
        if (this.mMenuPopup != null && this.mMenuPopup.isShowing()) {
            this.mMenuPopup.dismiss();
        }
        return true;
    }

    private void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)this);
    }

    private void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        Tab tab;
        Log.d((String)LOGTAG, (String)("handleMessage: " + string2));
        if (string2.equals("Reader:Click")) {
            Tab tab2 = Tabs.getInstance().getSelectedTab();
            if (tab2 != null) {
                tab2.toggleReaderMode();
            }
        } else if (string2.equals("Reader:LongClick") && (tab = Tabs.getInstance().getSelectedTab()) != null) {
            tab.addToReadingList();
        }
    }

    @Override
    public void onLightweightThemeChanged() {
        Drawable drawable2 = this.mTheme.getDrawable((View)this);
        if (drawable2 == null) {
            return;
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(PRIVATE_STATE_SET, (Drawable)this.getColorDrawable(R.color.background_private));
        stateListDrawable.addState(EMPTY_STATE_SET, drawable2);
        this.setBackgroundDrawable((Drawable)stateListDrawable);
    }

    @Override
    public void onLightweightThemeReset() {
        this.setBackgroundResource(R.drawable.url_bar_bg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ForwardButtonAnimation {
        SHOW,
        HIDE;

    }

    public static interface OnStopEditingListener {
        public void onStopEditing();
    }

    public static interface OnStartEditingListener {
        public void onStartEditing();
    }

    public static interface OnFilterListener {
        public void onFilter(String var1, AutocompleteHandler var2);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnCommitListener {
        public void onCommit();
    }

    public static interface OnActivateListener {
        public void onActivate();
    }
}

