/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.ArrayList;
import org.mozilla.gecko.GeckoAppShell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppAllocator {
    private final String LOGTAG = "GeckoWebAppAllocator";
    private static final String PREFIX_ORIGIN = "webapp-origin-";
    private static final String PREFIX_PACKAGE_NAME = "webapp-package-name-";
    private static final int MAX_WEB_APPS = 100;
    protected static WebAppAllocator sInstance = null;
    SharedPreferences mPrefs;

    public static WebAppAllocator getInstance() {
        return WebAppAllocator.getInstance(GeckoAppShell.getContext());
    }

    public static synchronized WebAppAllocator getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new WebAppAllocator(context);
        }
        return sInstance;
    }

    protected WebAppAllocator(Context context) {
        this.mPrefs = context.getSharedPreferences("webapps", 4);
    }

    private static String appKey(int n) {
        return PREFIX_PACKAGE_NAME + n;
    }

    public static String iconKey(int n) {
        return "web-app-color-" + n;
    }

    public static String originKey(int n) {
        return PREFIX_ORIGIN + n;
    }

    public ArrayList<String> getInstalledPackageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            if (!this.mPrefs.contains(WebAppAllocator.appKey(i))) continue;
            arrayList.add(this.mPrefs.getString(WebAppAllocator.appKey(i), ""));
        }
        return arrayList;
    }

    public synchronized int findOrAllocatePackage(String string2) {
        int n = this.getIndexForApp(string2);
        if (n != -1) {
            return n;
        }
        for (int i = 0; i < 100; ++i) {
            if (this.mPrefs.contains(WebAppAllocator.appKey(i))) continue;
            this.putPackageName(i, string2);
            return i;
        }
        return -1;
    }

    public synchronized void putPackageName(int n, String string2) {
        this.mPrefs.edit().putString(WebAppAllocator.appKey(n), string2).apply();
    }

    public void updateColor(int n, int n2) {
        this.mPrefs.edit().putInt(WebAppAllocator.iconKey(n), n2).apply();
    }

    public synchronized int getIndexForApp(String string2) {
        return this.findSlotForPrefix(PREFIX_PACKAGE_NAME, string2);
    }

    public synchronized int getIndexForOrigin(String string2) {
        return this.findSlotForPrefix(PREFIX_ORIGIN, string2);
    }

    protected int findSlotForPrefix(String string2, String string3) {
        for (int i = 0; i < 100; ++i) {
            if (!this.mPrefs.getString(string2 + i, "").equals(string3)) continue;
            return i;
        }
        return -1;
    }

    public synchronized String getAppForIndex(int n) {
        return this.mPrefs.getString(WebAppAllocator.appKey(n), null);
    }

    public synchronized int releaseIndexForApp(String string2) {
        int n = this.getIndexForApp(string2);
        if (n == -1) {
            return -1;
        }
        this.releaseIndex(n);
        return n;
    }

    public synchronized void releaseIndex(int n) {
        this.mPrefs.edit().remove(WebAppAllocator.appKey(n)).remove(WebAppAllocator.iconKey(n)).remove(WebAppAllocator.originKey(n)).apply();
    }

    public void putOrigin(int n, String string2) {
        this.mPrefs.edit().putString(WebAppAllocator.originKey(n), string2).apply();
    }

    public String getOrigin(int n) {
        return this.mPrefs.getString(WebAppAllocator.originKey(n), null);
    }

    public int getColor(int n) {
        return this.mPrefs.getInt(WebAppAllocator.iconKey(n), -1);
    }
}

