/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn.tsccm;

import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.conn.params.ConnPerRoute;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.impl.conn.AbstractPoolEntry;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.BasicPoolEntry;
import ch.boye.httpclientandroidlib.impl.conn.tsccm.WaitingThread;
import ch.boye.httpclientandroidlib.util.LangUtils;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;

@NotThreadSafe
public class RouteSpecificPool {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());
    protected final HttpRoute route;
    @Deprecated
    protected final int maxEntries;
    protected final ConnPerRoute connPerRoute;
    protected final LinkedList<BasicPoolEntry> freeEntries;
    protected final Queue<WaitingThread> waitingThreads;
    protected int numEntries;

    @Deprecated
    public RouteSpecificPool(HttpRoute httpRoute, int n) {
        this.route = httpRoute;
        this.maxEntries = n;
        this.connPerRoute = new ConnPerRoute(){

            public int getMaxForRoute(HttpRoute httpRoute) {
                return RouteSpecificPool.this.maxEntries;
            }
        };
        this.freeEntries = new LinkedList();
        this.waitingThreads = new LinkedList<WaitingThread>();
        this.numEntries = 0;
    }

    public RouteSpecificPool(HttpRoute httpRoute, ConnPerRoute connPerRoute) {
        this.route = httpRoute;
        this.connPerRoute = connPerRoute;
        this.maxEntries = connPerRoute.getMaxForRoute(httpRoute);
        this.freeEntries = new LinkedList();
        this.waitingThreads = new LinkedList<WaitingThread>();
        this.numEntries = 0;
    }

    public final HttpRoute getRoute() {
        return this.route;
    }

    public final int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean isUnused() {
        return this.numEntries < 1 && this.waitingThreads.isEmpty();
    }

    public int getCapacity() {
        return this.connPerRoute.getMaxForRoute(this.route) - this.numEntries;
    }

    public final int getEntryCount() {
        return this.numEntries;
    }

    public BasicPoolEntry allocEntry(Object object) {
        Object object2;
        Object object3;
        if (!this.freeEntries.isEmpty()) {
            object3 = this.freeEntries.listIterator(this.freeEntries.size());
            while (object3.hasPrevious()) {
                object2 = object3.previous();
                if (((AbstractPoolEntry)object2).getState() != null && !LangUtils.equals(object, ((AbstractPoolEntry)object2).getState())) continue;
                object3.remove();
                return object2;
            }
        }
        if (this.getCapacity() == 0 && !this.freeEntries.isEmpty()) {
            object3 = this.freeEntries.remove();
            ((BasicPoolEntry)object3).shutdownEntry();
            object2 = ((BasicPoolEntry)object3).getConnection();
            try {
                object2.close();
            }
            catch (IOException iOException) {
                this.log.debug("I/O error closing connection", iOException);
            }
            return object3;
        }
        return null;
    }

    public void freeEntry(BasicPoolEntry basicPoolEntry) {
        if (this.numEntries < 1) {
            throw new IllegalStateException("No entry created for this pool. " + this.route);
        }
        if (this.numEntries <= this.freeEntries.size()) {
            throw new IllegalStateException("No entry allocated from this pool. " + this.route);
        }
        this.freeEntries.add(basicPoolEntry);
    }

    public void createdEntry(BasicPoolEntry basicPoolEntry) {
        if (!this.route.equals(basicPoolEntry.getPlannedRoute())) {
            throw new IllegalArgumentException("Entry not planned for this pool.\npool: " + this.route + "\nplan: " + basicPoolEntry.getPlannedRoute());
        }
        ++this.numEntries;
    }

    public boolean deleteEntry(BasicPoolEntry basicPoolEntry) {
        boolean bl = this.freeEntries.remove(basicPoolEntry);
        if (bl) {
            --this.numEntries;
        }
        return bl;
    }

    public void dropEntry() {
        if (this.numEntries < 1) {
            throw new IllegalStateException("There is no entry that could be dropped.");
        }
        --this.numEntries;
    }

    public void queueThread(WaitingThread waitingThread) {
        if (waitingThread == null) {
            throw new IllegalArgumentException("Waiting thread must not be null.");
        }
        this.waitingThreads.add(waitingThread);
    }

    public boolean hasThread() {
        return !this.waitingThreads.isEmpty();
    }

    public WaitingThread nextThread() {
        return this.waitingThreads.peek();
    }

    public void removeThread(WaitingThread waitingThread) {
        if (waitingThread == null) {
            return;
        }
        this.waitingThreads.remove(waitingThread);
    }
}

