/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.CameraImageResultHandler;
import org.mozilla.gecko.CameraVideoResultHandler;
import org.mozilla.gecko.FilePickerResultHandlerSync;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.prompts.PromptService;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.ActivityResultHandlerMap;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityHandlerHelper
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoActivityHandlerHelper";
    private final ConcurrentLinkedQueue<String> mFilePickerResult = new ConcurrentLinkedQueue<String>(){

        @Override
        public boolean offer(String string2) {
            if (super.offer(string2)) {
                GeckoAppShell.sendEventToGecko(GeckoEvent.createNoOpEvent());
                return true;
            }
            return false;
        }
    };
    private final ActivityResultHandlerMap mActivityResultHandlerMap = new ActivityResultHandlerMap();
    private final FilePickerResultHandlerSync mFilePickerResultHandlerSync = new FilePickerResultHandlerSync(this.mFilePickerResult);
    private final CameraImageResultHandler mCameraImageResultHandler = new CameraImageResultHandler(this.mFilePickerResult);
    private final CameraVideoResultHandler mCameraVideoResultHandler = new CameraVideoResultHandler(this.mFilePickerResult);

    public ActivityHandlerHelper() {
        GeckoAppShell.getEventDispatcher().registerEventListener("FilePicker:Show", (GeckoEventListener)this);
    }

    public void handleMessage(String string2, final JSONObject jSONObject) {
        if (string2.equals("FilePicker:Show")) {
            String string3 = "*/*";
            String string4 = jSONObject.optString("mode");
            if ("mimeType".equals(string4)) {
                string3 = jSONObject.optString("mimeType");
            } else if ("extension".equals(string4)) {
                string3 = GeckoAppShell.getMimeTypeFromExtensions(jSONObject.optString("extensions"));
            }
            Log.i((String)LOGTAG, (String)("Mime: " + string3));
            this.showFilePickerAsync(GeckoAppShell.getGeckoInterface().getActivity(), string3, new FileResultHandler(){

                public void gotFile(String string2) {
                    try {
                        jSONObject.put("file", (Object)string2);
                    }
                    catch (JSONException jSONException) {
                        Log.i((String)ActivityHandlerHelper.LOGTAG, (String)("Can't add filename to message " + string2));
                    }
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("FilePicker:Result", jSONObject.toString()));
                }
            });
        }
    }

    public int makeRequestCode(ActivityResultHandler activityResultHandler) {
        return this.mActivityResultHandlerMap.put(activityResultHandler);
    }

    public void startIntentForActivity(Activity activity, Intent intent, ActivityResultHandler activityResultHandler) {
        activity.startActivityForResult(intent, this.mActivityResultHandlerMap.put(activityResultHandler));
    }

    private int addIntentActivitiesToList(Context context, Intent intent, ArrayList<Prompt.PromptListItem> arrayList, ArrayList<Intent> arrayList2) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivityOptions(GeckoAppShell.getGeckoInterface().getActivity().getComponentName(), null, intent, 0);
        if (list == null) {
            return 0;
        }
        for (ResolveInfo resolveInfo : list) {
            Intent intent2 = new Intent(intent);
            intent2.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
            Prompt.PromptListItem promptListItem = new Prompt.PromptListItem(((Object)resolveInfo.loadLabel(packageManager)).toString());
            promptListItem.icon = resolveInfo.loadIcon(packageManager);
            arrayList.add(promptListItem);
            arrayList2.add(intent2);
        }
        return list.size();
    }

    private int addFilePickingActivities(Context context, ArrayList<Prompt.PromptListItem> arrayList, String string2, ArrayList<Intent> arrayList2) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType(string2);
        intent.addCategory("android.intent.category.OPENABLE");
        return this.addIntentActivitiesToList(context, intent, arrayList, arrayList2);
    }

    private Prompt.PromptListItem[] getItemsAndIntentsForFilePicker(Context context, String string2, ArrayList<Intent> arrayList) {
        ArrayList<Prompt.PromptListItem> arrayList2 = new ArrayList<Prompt.PromptListItem>();
        if (string2.equals("audio/*")) {
            if (this.addFilePickingActivities(context, arrayList2, "audio/*", arrayList) <= 0) {
                this.addFilePickingActivities(context, arrayList2, "*/*", arrayList);
            }
        } else if (string2.equals("image/*")) {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)new File(Environment.getExternalStorageDirectory(), CameraImageResultHandler.generateImageName())));
            this.addIntentActivitiesToList(context, intent, arrayList2, arrayList);
            if (this.addFilePickingActivities(context, arrayList2, "image/*", arrayList) <= 0) {
                this.addFilePickingActivities(context, arrayList2, "*/*", arrayList);
            }
        } else if (string2.equals("video/*")) {
            Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
            this.addIntentActivitiesToList(context, intent, arrayList2, arrayList);
            if (this.addFilePickingActivities(context, arrayList2, "video/*", arrayList) <= 0) {
                this.addFilePickingActivities(context, arrayList2, "*/*", arrayList);
            }
        } else {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)new File(Environment.getExternalStorageDirectory(), CameraImageResultHandler.generateImageName())));
            this.addIntentActivitiesToList(context, intent, arrayList2, arrayList);
            intent = new Intent("android.media.action.VIDEO_CAPTURE");
            this.addIntentActivitiesToList(context, intent, arrayList2, arrayList);
            this.addFilePickingActivities(context, arrayList2, "*/*", arrayList);
        }
        return arrayList2.toArray(new Prompt.PromptListItem[0]);
    }

    private String getFilePickerTitle(Context context, String string2) {
        if (string2.equals("audio/*")) {
            return context.getString(R.string.filepicker_audio_title);
        }
        if (string2.equals("image/*")) {
            return context.getString(R.string.filepicker_image_title);
        }
        if (string2.equals("video/*")) {
            return context.getString(R.string.filepicker_video_title);
        }
        return context.getString(R.string.filepicker_title);
    }

    private void getFilePickerIntentAsync(Context context, String string2, final IntentHandler intentHandler) {
        final ArrayList<Intent> arrayList = new ArrayList<Intent>();
        final Prompt.PromptListItem[] promptListItemArray = this.getItemsAndIntentsForFilePicker(context, string2, arrayList);
        if (arrayList.size() == 0) {
            Log.i((String)LOGTAG, (String)"no activities for the file picker!");
            intentHandler.gotIntent(null);
            return;
        }
        if (arrayList.size() == 1) {
            intentHandler.gotIntent(arrayList.get(0));
            return;
        }
        final Prompt prompt = new Prompt(context, new Prompt.PromptCallback(){

            public void onPromptFinished(String string2) {
                if (intentHandler == null) {
                    return;
                }
                int n = -1;
                try {
                    n = new JSONObject(string2).getInt("button");
                }
                catch (JSONException jSONException) {
                    Log.e((String)ActivityHandlerHelper.LOGTAG, (String)"result from promptservice was invalid: ", (Throwable)jSONException);
                }
                if (n == -1) {
                    intentHandler.gotIntent(null);
                } else {
                    intentHandler.gotIntent((Intent)arrayList.get(n));
                }
            }
        });
        final String string3 = this.getFilePickerTitle(context, string2);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                prompt.show(string3, "", promptListItemArray, false);
            }
        });
    }

    private Intent getFilePickerIntent(Context context, String string2) {
        ArrayList<Intent> arrayList = new ArrayList<Intent>();
        final Prompt.PromptListItem[] promptListItemArray = this.getItemsAndIntentsForFilePicker(context, string2, arrayList);
        if (arrayList.size() == 0) {
            Log.i((String)LOGTAG, (String)"no activities for the file picker!");
            return null;
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        final PromptService promptService = GeckoAppShell.getGeckoInterface().getPromptService();
        final String string3 = this.getFilePickerTitle(context, string2);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                promptService.show(string3, "", promptListItemArray, false, null);
            }
        });
        String string4 = promptService.getResponse(null);
        int n = -1;
        try {
            n = new JSONObject(string4).getInt("button");
            if (n == -1) {
                return null;
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"result from promptservice was invalid: ", (Throwable)jSONException);
            return null;
        }
        return arrayList.get(n);
    }

    boolean showFilePicker(Activity activity, String string2, ActivityResultHandler activityResultHandler) {
        Intent intent = this.getFilePickerIntent((Context)activity, string2);
        if (intent == null) {
            return false;
        }
        activity.startActivityForResult(intent, this.mActivityResultHandlerMap.put(activityResultHandler));
        return true;
    }

    String showFilePicker(Activity activity, String string2) {
        String string3;
        Intent intent = this.getFilePickerIntent((Context)activity, string2);
        if (intent == null) {
            return "";
        }
        if (intent.getAction().equals("android.media.action.IMAGE_CAPTURE")) {
            activity.startActivityForResult(intent, this.mActivityResultHandlerMap.put((ActivityResultHandler)this.mCameraImageResultHandler));
        } else if (intent.getAction().equals("android.media.action.VIDEO_CAPTURE")) {
            activity.startActivityForResult(intent, this.mActivityResultHandlerMap.put((ActivityResultHandler)this.mCameraVideoResultHandler));
        } else if (intent.getAction().equals("android.intent.action.GET_CONTENT")) {
            activity.startActivityForResult(intent, this.mActivityResultHandlerMap.put((ActivityResultHandler)this.mFilePickerResultHandlerSync));
        } else {
            Log.e((String)LOGTAG, (String)"We should not get an intent with another action!");
            return "";
        }
        while (null == (string3 = this.mFilePickerResult.poll())) {
            GeckoAppShell.processNextNativeEvent(true);
        }
        return string3;
    }

    public void showFilePickerAsync(final Activity activity, String string2, final FileResultHandler fileResultHandler) {
        this.getFilePickerIntentAsync((Context)activity, string2, new IntentHandler(){

            public void gotIntent(Intent intent) {
                if (fileResultHandler == null) {
                    return;
                }
                if (intent == null) {
                    fileResultHandler.gotFile("");
                    return;
                }
                if ("android.media.action.IMAGE_CAPTURE".equals(intent.getAction())) {
                    CameraImageResultHandler cameraImageResultHandler = new CameraImageResultHandler(fileResultHandler);
                    activity.startActivityForResult(intent, ActivityHandlerHelper.this.mActivityResultHandlerMap.put((ActivityResultHandler)cameraImageResultHandler));
                } else if ("android.media.action.VIDEO_CAPTURE".equals(intent.getAction())) {
                    CameraVideoResultHandler cameraVideoResultHandler = new CameraVideoResultHandler(fileResultHandler);
                    activity.startActivityForResult(intent, ActivityHandlerHelper.this.mActivityResultHandlerMap.put((ActivityResultHandler)cameraVideoResultHandler));
                } else if ("android.intent.action.GET_CONTENT".equals(intent.getAction())) {
                    FilePickerResultHandlerSync filePickerResultHandlerSync = new FilePickerResultHandlerSync(fileResultHandler);
                    activity.startActivityForResult(intent, ActivityHandlerHelper.this.mActivityResultHandlerMap.put((ActivityResultHandler)filePickerResultHandlerSync));
                } else {
                    Log.e((String)ActivityHandlerHelper.LOGTAG, (String)"We should not get an intent with another action!");
                    fileResultHandler.gotFile("");
                    return;
                }
            }
        });
    }

    boolean handleActivityResult(int n, int n2, Intent intent) {
        ActivityResultHandler activityResultHandler = this.mActivityResultHandlerMap.getAndRemove(n);
        if (activityResultHandler != null) {
            activityResultHandler.onActivityResult(n2, intent);
            return true;
        }
        return false;
    }

    private static interface IntentHandler {
        public void gotIntent(Intent var1);
    }

    public static interface FileResultHandler {
        public void gotFile(String var1);
    }
}

