/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.GeckoEventResponder;

public final class SharedPreferencesHelper
implements GeckoEventResponder {
    public static final String LOGTAG = "GeckoAndSharedPrefs";
    protected final Context mContext;
    protected String mResponse;
    protected final Map<String, SharedPreferences.OnSharedPreferenceChangeListener> mListeners;

    public SharedPreferencesHelper(Context context) {
        this.mContext = context;
        this.mListeners = new HashMap<String, SharedPreferences.OnSharedPreferenceChangeListener>();
        EventDispatcher eventDispatcher = GeckoAppShell.getEventDispatcher();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.registerEventListener("SharedPreferences:Set", (GeckoEventListener)this);
        eventDispatcher.registerEventListener("SharedPreferences:Get", (GeckoEventListener)this);
        eventDispatcher.registerEventListener("SharedPreferences:Observe", (GeckoEventListener)this);
    }

    public synchronized void uninit() {
        EventDispatcher eventDispatcher = GeckoAppShell.getEventDispatcher();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.unregisterEventListener("SharedPreferences:Set", (GeckoEventListener)this);
        eventDispatcher.unregisterEventListener("SharedPreferences:Get", (GeckoEventListener)this);
        eventDispatcher.unregisterEventListener("SharedPreferences:Observe", (GeckoEventListener)this);
    }

    private SharedPreferences getSharedPreferences(String string2) {
        if (string2 == null) {
            return PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        }
        return this.mContext.getSharedPreferences(string2, 0);
    }

    private void handleSet(JSONObject jSONObject) throws JSONException {
        if (!jSONObject.has("branch")) {
            Log.e((String)LOGTAG, (String)"No branch specified for SharedPreference:Set; aborting.");
            return;
        }
        String string2 = jSONObject.isNull("branch") ? null : jSONObject.getString("branch");
        SharedPreferences.Editor editor = this.getSharedPreferences(string2).edit();
        JSONArray jSONArray = jSONObject.getJSONArray("preferences");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string3 = jSONObject2.getString("name");
            String string4 = jSONObject2.getString("type");
            if ("bool".equals(string4)) {
                editor.putBoolean(string3, jSONObject2.getBoolean("value"));
            } else if ("int".equals(string4)) {
                editor.putInt(string3, jSONObject2.getInt("value"));
            } else if ("string".equals(string4)) {
                editor.putString(string3, jSONObject2.getString("value"));
            } else {
                Log.w((String)LOGTAG, (String)("Unknown pref value type [" + string4 + "] for pref [" + string3 + "]"));
            }
            editor.commit();
        }
    }

    private String handleGet(JSONObject jSONObject) throws JSONException {
        if (!jSONObject.has("branch")) {
            Log.e((String)LOGTAG, (String)"No branch specified for SharedPreference:Get; aborting.");
            return null;
        }
        String string2 = jSONObject.isNull("branch") ? null : jSONObject.getString("branch");
        SharedPreferences sharedPreferences = this.getSharedPreferences(string2);
        JSONArray jSONArray = jSONObject.getJSONArray("preferences");
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string3 = jSONObject2.getString("name");
            String string4 = jSONObject2.getString("type");
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("name", (Object)string3);
            jSONObject3.put("type", (Object)string4);
            try {
                if ("bool".equals(string4)) {
                    boolean bl = sharedPreferences.getBoolean(string3, false);
                    jSONObject3.put("value", bl);
                } else if ("int".equals(string4)) {
                    int n = sharedPreferences.getInt(string3, 0);
                    jSONObject3.put("value", n);
                } else if ("string".equals(string4)) {
                    String string5 = sharedPreferences.getString(string3, "");
                    jSONObject3.put("value", (Object)string5);
                } else {
                    Log.w((String)LOGTAG, (String)("Unknown pref value type [" + string4 + "] for pref [" + string3 + "]"));
                }
            }
            catch (ClassCastException classCastException) {
                Log.w((String)LOGTAG, (String)("Wrong pref value type [" + string4 + "] for pref [" + string3 + "]"));
            }
            jSONArray2.put((Object)jSONObject3);
        }
        return jSONArray2.toString();
    }

    private void handleObserve(JSONObject jSONObject) throws JSONException {
        ChangeListener changeListener;
        if (!jSONObject.has("branch")) {
            Log.e((String)LOGTAG, (String)"No branch specified for SharedPreference:Observe; aborting.");
            return;
        }
        String string2 = jSONObject.isNull("branch") ? null : jSONObject.getString("branch");
        SharedPreferences sharedPreferences = this.getSharedPreferences(string2);
        boolean bl = jSONObject.getBoolean("enable");
        if (bl && !this.mListeners.containsKey(string2)) {
            changeListener = new ChangeListener(string2);
            this.mListeners.put(string2, changeListener);
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)changeListener);
        }
        if (!bl && this.mListeners.containsKey(string2)) {
            changeListener = this.mListeners.remove(string2);
            sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)changeListener);
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        block8: {
            this.mResponse = null;
            try {
                if (string2.equals("SharedPreferences:Set")) {
                    if (Log.isLoggable((String)LOGTAG, (int)2)) {
                        Log.v((String)LOGTAG, (String)"Got SharedPreferences:Set message.");
                    }
                    this.handleSet(jSONObject);
                    break block8;
                }
                if (string2.equals("SharedPreferences:Get")) {
                    if (Log.isLoggable((String)LOGTAG, (int)2)) {
                        Log.v((String)LOGTAG, (String)"Got SharedPreferences:Get message.");
                    }
                    this.mResponse = this.handleGet(jSONObject);
                    break block8;
                }
                if (string2.equals("SharedPreferences:Observe")) {
                    if (Log.isLoggable((String)LOGTAG, (int)2)) {
                        Log.v((String)LOGTAG, (String)"Got SharedPreferences:Observe message.");
                    }
                    this.handleObserve(jSONObject);
                    break block8;
                }
                Log.e((String)LOGTAG, (String)("SharedPreferencesHelper got unexpected message " + string2));
                return;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)("Got exception in handleMessage handling event " + string2), (Throwable)jSONException);
                return;
            }
        }
    }

    public String getResponse(JSONObject jSONObject) {
        return this.mResponse;
    }

    private static class ChangeListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        public final String branch;

        public ChangeListener(String string2) {
            this.branch = string2;
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
            if (Log.isLoggable((String)SharedPreferencesHelper.LOGTAG, (int)2)) {
                Log.v((String)SharedPreferencesHelper.LOGTAG, (String)"Got onSharedPreferenceChanged");
            }
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("branch", (Object)this.branch);
                jSONObject.put("key", (Object)string2);
                jSONObject.put("value", sharedPreferences.getAll().get(string2));
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SharedPreferences:Changed", jSONObject.toString()));
            }
            catch (JSONException jSONException) {
                Log.e((String)SharedPreferencesHelper.LOGTAG, (String)"Got exception creating JSON object", (Throwable)jSONException);
                return;
            }
        }
    }
}

