/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.updater;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import java.net.MalformedURLException;
import java.net.URL;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.updater.UpdateService;
import org.mozilla.gecko.util.GeckoJarReader;

public class UpdateServiceHelper {
    public static final String ACTION_REGISTER_FOR_UPDATES = "org.mozilla.fennec.REGISTER_FOR_UPDATES";
    public static final String ACTION_UNREGISTER_FOR_UPDATES = "org.mozilla.fennec.UNREGISTER_FOR_UPDATES";
    public static final String ACTION_CHECK_FOR_UPDATE = "org.mozilla.fennec.CHECK_FOR_UPDATE";
    public static final String ACTION_CHECK_UPDATE_RESULT = "org.mozilla.fennec.CHECK_UPDATE_RESULT";
    public static final String ACTION_DOWNLOAD_UPDATE = "org.mozilla.fennec.DOWNLOAD_UPDATE";
    public static final String ACTION_APPLY_UPDATE = "org.mozilla.fennec.APPLY_UPDATE";
    public static final String ACTION_CANCEL_DOWNLOAD = "org.mozilla.fennec.CANCEL_DOWNLOAD";
    public static final int FLAG_FORCE_DOWNLOAD = 1;
    public static final int FLAG_OVERWRITE_EXISTING = 2;
    public static final int FLAG_REINSTALL = 4;
    public static final int FLAG_RETRY = 8;
    public static final String EXTRA_AUTODOWNLOAD_NAME = "autodownload";
    public static final int AUTODOWNLOAD_WIFI = 0;
    public static final int AUTODOWNLOAD_DISABLED = 1;
    public static final int AUTODOWNLOAD_ENABLED = 2;
    public static final String EXTRA_UPDATE_FLAGS_NAME = "updateFlags";
    public static final String EXTRA_PACKAGE_PATH_NAME = "packagePath";
    private static final String LOGTAG = "UpdateServiceHelper";
    private static final String DEFAULT_UPDATE_LOCALE = "en-US";
    private static final String UPDATE_URL;

    public static URL getUpdateUrl(Context context, boolean bl) {
        Object object;
        PackageManager packageManager = context.getPackageManager();
        String string2 = null;
        try {
            object = packageManager.getApplicationInfo("org.mozilla.fennec", 0);
            String string3 = "jar:jar:file://" + object.sourceDir + "!/" + "assets/omni.ja" + "!/update.locale";
            string2 = GeckoJarReader.getText((String)string3);
            string2 = string2 != null ? string2.trim() : DEFAULT_UPDATE_LOCALE;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.i((String)LOGTAG, (String)"Failed to read update locale file, falling back to en-US");
            string2 = DEFAULT_UPDATE_LOCALE;
        }
        object = UPDATE_URL.replace("%LOCALE%", string2).replace("%OS_VERSION%", Build.VERSION.RELEASE).replace("%BUILDID%", bl ? "0" : "20140119030202");
        try {
            return new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            Log.e((String)LOGTAG, (String)"Failed to create update url: ", (Throwable)malformedURLException);
            return null;
        }
    }

    public static boolean isUpdaterEnabled() {
        return true;
    }

    public static void registerForUpdates(Context context, String string2) {
        int n;
        if (string2 == null) {
            return;
        }
        if (string2.equals("wifi")) {
            n = 0;
        } else if (string2.equals("disabled")) {
            n = 1;
        } else if (string2.equals("enabled")) {
            n = 2;
        } else {
            Log.w((String)LOGTAG, (String)("Unhandled autoupdate policy: " + string2));
            return;
        }
        UpdateServiceHelper.registerForUpdates(context, n);
    }

    public static void registerForUpdates(Context context, int n) {
        if (!UpdateServiceHelper.isUpdaterEnabled()) {
            return;
        }
        Intent intent = new Intent(ACTION_REGISTER_FOR_UPDATES, null, context, UpdateService.class);
        intent.putExtra(EXTRA_AUTODOWNLOAD_NAME, n);
        context.startService(intent);
    }

    static {
        String string2 = AppConstants.MOZ_PKG_SPECIAL != null ? "-" + AppConstants.MOZ_PKG_SPECIAL : "";
        UPDATE_URL = "https://aus4.mozilla.org/update/4/Fennec/29.0a1/%BUILDID%/Android_arm-eabi-gcc3" + string2 + "/%LOCALE%/" + "nightly" + "/%OS_VERSION%/default/default/" + "29.0a1" + "/update.xml";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckUpdateResult {
        NOT_AVAILABLE,
        AVAILABLE,
        DOWNLOADING,
        DOWNLOADED;

    }
}

