/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import org.mozilla.gecko.db.HomeListsDatabaseHelper;
import org.mozilla.gecko.db.PerProfileDatabases;

public class HomeListsProvider
extends ContentProvider {
    private static final String LOGTAG = "GeckoHomeListsProvider";
    private static final boolean DB_DISABLED = true;
    private PerProfileDatabases<HomeListsDatabaseHelper> mDatabases;
    static final int ITEMS_FAKE = 100;
    static final int ITEMS = 101;
    static final int ITEMS_ID = 102;
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static boolean logDebug;
    private static boolean logVerbose;

    protected static void trace(String string2) {
        if (logVerbose) {
            Log.v((String)LOGTAG, (String)string2);
        }
    }

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    private boolean isTest(Uri uri) {
        String string2 = uri.getQueryParameter("test");
        return !TextUtils.isEmpty((CharSequence)string2);
    }

    private SQLiteDatabase getReadableDatabase(Uri uri) {
        throw new UnsupportedOperationException("Database operations are disabled!");
    }

    private SQLiteDatabase getWritableDatabase(Uri uri) {
        throw new UnsupportedOperationException("Database operations are disabled!");
    }

    public boolean onCreate() {
        return true;
    }

    public String getType(Uri uri) {
        HomeListsProvider.trace("Getting URI type: " + uri);
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 100: {
                HomeListsProvider.trace("URI is ITEMS_FAKE: " + uri);
                return "vnd.android.cursor.dir/homelistitem";
            }
            case 101: {
                HomeListsProvider.trace("URI is ITEMS: " + uri);
                return "vnd.android.cursor.dir/homelistitem";
            }
            case 102: {
                HomeListsProvider.trace("URI is ITEMS_ID: " + uri);
                return "vnd.android.cursor.item/homelistitem";
            }
        }
        HomeListsProvider.debug("URI has unrecognized type: " + uri);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Uri uri, String string2, String[] stringArray) {
        HomeListsProvider.trace("Calling delete on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            HomeListsProvider.trace("Beginning delete transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                n = this.deleteInTransaction(uri, string2, stringArray);
                sQLiteDatabase.setTransactionSuccessful();
                HomeListsProvider.trace("Successful delete transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            n = this.deleteInTransaction(uri, string2, stringArray);
        }
        if (n > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n;
    }

    public int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        HomeListsProvider.trace("Calling delete in transaction on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        int n2 = URI_MATCHER.match(uri);
        switch (n2) {
            case 101: {
                HomeListsProvider.trace("Delete on ITEMS: " + uri);
                n = sQLiteDatabase.delete("items", string2, stringArray);
                break;
            }
            case 102: {
                HomeListsProvider.trace("Delete on ITEMS: " + uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown delete URI " + uri);
            }
        }
        HomeListsProvider.debug("Deleted " + n + " rows for URI: " + uri);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(Uri uri, ContentValues contentValues) {
        HomeListsProvider.trace("Calling insert on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        Uri uri2 = null;
        if (Build.VERSION.SDK_INT >= 11) {
            HomeListsProvider.trace("Beginning insert transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                uri2 = this.insertInTransaction(uri, contentValues);
                sQLiteDatabase.setTransactionSuccessful();
                HomeListsProvider.trace("Successful insert transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            uri2 = this.insertInTransaction(uri, contentValues);
        }
        if (uri2 != null) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return uri2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        if (contentValuesArray == null) {
            return 0;
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = contentValuesArray.length;
        int n2 = 0;
        sQLiteDatabase.beginTransaction();
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    this.insertInTransaction(uri, contentValuesArray[i]);
                    ++n2;
                    continue;
                }
                catch (SQLException sQLException) {
                    Log.e((String)LOGTAG, (String)"SQLException in bulkInsert", (Throwable)sQLException);
                    sQLiteDatabase.setTransactionSuccessful();
                    sQLiteDatabase.endTransaction();
                    sQLiteDatabase.beginTransaction();
                }
            }
            HomeListsProvider.trace("Flushing DB bulkinsert...");
            sQLiteDatabase.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        if (n2 > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n2;
    }

    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        HomeListsProvider.trace("Calling insert in transaction on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        long l = -1L;
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                HomeListsProvider.trace("Insert on ITEMS: " + uri);
                l = sQLiteDatabase.insertOrThrow("items", null, contentValues);
                break;
            }
            case 102: {
                HomeListsProvider.trace("Insert on ITEMS_ID: " + uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
        if (l >= 0L) {
            HomeListsProvider.debug("Inserted ID in database: " + l);
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        HomeListsProvider.trace("Calling update on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        if (Build.VERSION.SDK_INT >= 11) {
            HomeListsProvider.trace("Beginning update transaction: " + uri);
            sQLiteDatabase.beginTransaction();
            try {
                n = this.updateInTransaction(uri, contentValues, string2, stringArray);
                sQLiteDatabase.setTransactionSuccessful();
                HomeListsProvider.trace("Successful update transaction: " + uri);
            }
            finally {
                sQLiteDatabase.endTransaction();
            }
        } else {
            n = this.updateInTransaction(uri, contentValues, string2, stringArray);
        }
        if (n > 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return n;
    }

    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        HomeListsProvider.trace("Calling update in transaction on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        int n = 0;
        int n2 = URI_MATCHER.match(uri);
        switch (n2) {
            case 101: {
                HomeListsProvider.trace("Update on ITEMS: " + uri);
                n = sQLiteDatabase.update("items", contentValues, string2, stringArray);
                break;
            }
            case 102: {
                HomeListsProvider.trace("Update on ITEMS_ID: " + uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        HomeListsProvider.debug("Updated " + n + " rows for URI: " + uri);
        return n;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        int n = URI_MATCHER.match(uri);
        if (n == 100) {
            HomeListsProvider.trace("Query on ITEMS_FAKE: " + uri);
            return this.queryFakeItems(uri, stringArray, string2, stringArray2, string3);
        }
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        Cursor cursor = null;
        switch (n) {
            case 101: {
                HomeListsProvider.trace("Query on ITEMS: " + uri);
                cursor = sQLiteDatabase.query("items", stringArray, string2, stringArray2, null, null, string3, null);
                break;
            }
            case 102: {
                HomeListsProvider.trace("Query on ITEMS_ID: " + uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        return cursor;
    }

    private Cursor queryFakeItems(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        String[] stringArray3 = new String[]{"_id", "provider_id", "url", "title"};
        MatrixCursor matrixCursor = new MatrixCursor(stringArray3);
        matrixCursor.addRow(new Object[]{1, "fake-provider", "http://example.com", "Example"});
        matrixCursor.addRow(new Object[]{2, "fake-provider", "http://mozilla.org", "Mozilla"});
        return matrixCursor;
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.homelists", "items/fake", 100);
        URI_MATCHER.addURI("org.mozilla.fennec.db.homelists", "items", 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.homelists", "items/#", 102);
        logDebug = Log.isLoggable((String)LOGTAG, (int)3);
        logVerbose = Log.isLoggable((String)LOGTAG, (int)2);
    }
}

