/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl;

import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseFactory;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.ReasonPhraseCatalog;
import ch.boye.httpclientandroidlib.StatusLine;
import ch.boye.httpclientandroidlib.impl.EnglishReasonPhraseCatalog;
import ch.boye.httpclientandroidlib.message.BasicHttpResponse;
import ch.boye.httpclientandroidlib.message.BasicStatusLine;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.util.Locale;

public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog reasonPhraseCatalog) {
        if (reasonPhraseCatalog == null) {
            throw new IllegalArgumentException("Reason phrase catalog must not be null.");
        }
        this.reasonCatalog = reasonPhraseCatalog;
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    public HttpResponse newHttpResponse(ProtocolVersion protocolVersion, int n, HttpContext httpContext) {
        if (protocolVersion == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        Locale locale = this.determineLocale(httpContext);
        String string = this.reasonCatalog.getReason(n, locale);
        BasicStatusLine basicStatusLine = new BasicStatusLine(protocolVersion, n, string);
        return new BasicHttpResponse(basicStatusLine, this.reasonCatalog, locale);
    }

    public HttpResponse newHttpResponse(StatusLine statusLine, HttpContext httpContext) {
        if (statusLine == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        Locale locale = this.determineLocale(httpContext);
        return new BasicHttpResponse(statusLine, this.reasonCatalog, locale);
    }

    protected Locale determineLocale(HttpContext httpContext) {
        return Locale.getDefault();
    }
}

