/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.NameValuePair;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import ch.boye.httpclientandroidlib.util.LangUtils;

public class BasicHeaderElement
implements HeaderElement,
Cloneable {
    private final String name;
    private final String value;
    private final NameValuePair[] parameters;

    public BasicHeaderElement(String string, String string2, NameValuePair[] nameValuePairArray) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = string;
        this.value = string2;
        this.parameters = nameValuePairArray != null ? nameValuePairArray : new NameValuePair[0];
    }

    public BasicHeaderElement(String string, String string2) {
        this(string, string2, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public NameValuePair[] getParameters() {
        return (NameValuePair[])this.parameters.clone();
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public NameValuePair getParameter(int n) {
        return this.parameters[n];
    }

    public NameValuePair getParameterByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        NameValuePair nameValuePair = null;
        for (int i = 0; i < this.parameters.length; ++i) {
            NameValuePair nameValuePair2 = this.parameters[i];
            if (!nameValuePair2.getName().equalsIgnoreCase(string)) continue;
            nameValuePair = nameValuePair2;
            break;
        }
        return nameValuePair;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HeaderElement) {
            BasicHeaderElement basicHeaderElement = (BasicHeaderElement)object;
            return this.name.equals(basicHeaderElement.name) && LangUtils.equals(this.value, basicHeaderElement.value) && LangUtils.equals(this.parameters, basicHeaderElement.parameters);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.name);
        n = LangUtils.hashCode(n, this.value);
        for (int i = 0; i < this.parameters.length; ++i) {
            n = LangUtils.hashCode(n, this.parameters[i]);
        }
        return n;
    }

    public String toString() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(64);
        charArrayBuffer.append(this.name);
        if (this.value != null) {
            charArrayBuffer.append("=");
            charArrayBuffer.append(this.value);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            charArrayBuffer.append("; ");
            charArrayBuffer.append(this.parameters[i]);
        }
        return charArrayBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

