/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SyncResult;
import android.os.Bundle;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.browserid.BrowserIDKeyPair;
import org.mozilla.gecko.browserid.RSACryptoImplementation;
import org.mozilla.gecko.fxa.authenticator.FxAccountAuthenticator;
import org.mozilla.gecko.fxa.sync.FxAccount;
import org.mozilla.gecko.fxa.sync.FxAccountGlobalSession;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.BaseGlobalSessionCallback;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;

public class FxAccountSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String LOG_TAG = FxAccountSyncAdapter.class.getSimpleName();
    protected final ExecutorService executor = Executors.newSingleThreadExecutor();

    public FxAccountSyncAdapter(Context context, boolean bl) {
        super(context, bl);
    }

    public void onPerformSync(Account account, final Bundle bundle, String string2, ContentProviderClient contentProviderClient, SyncResult syncResult) {
        Logger.setThreadLogTag("FxAccounts");
        Logger.info(LOG_TAG, "Syncing FxAccount account named " + account.name + " for authority " + string2 + " with instance " + (Object)((Object)this) + ".");
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        try {
            BrowserIDKeyPair browserIDKeyPair = RSACryptoImplementation.generateKeyPair(1024);
            Logger.info(LOG_TAG, "Generated keypair. ");
            final FxAccount fxAccount = FxAccountAuthenticator.fromAndroidAccount(this.getContext(), account);
            String string3 = fxAccount.authEndpoint + (fxAccount.authEndpoint.endsWith("/") ? "" : "/") + "1.0/sync/1.1";
            fxAccount.login(this.getContext(), string3, browserIDKeyPair, new FxAccount.Delegate(){

                public void handleSuccess(final String string2, final String string3, final AuthHeaderProvider authHeaderProvider) {
                    Logger.pii(LOG_TAG, "Got token! uid is " + string2 + " and endpoint is " + string3 + ".");
                    final SessionCallback sessionCallback = new SessionCallback(countDownLatch);
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        public void run() {
                            FxAccountGlobalSession fxAccountGlobalSession = null;
                            try {
                                SharedPreferences sharedPreferences = FxAccountSyncAdapter.this.getContext().getSharedPreferences("fxa.v1", 0);
                                SharedPreferencesClientsDataDelegate sharedPreferencesClientsDataDelegate = new SharedPreferencesClientsDataDelegate(sharedPreferences);
                                KeyBundle keyBundle = FxAccountUtils.generateSyncKeyBundle(fxAccount.kB);
                                fxAccountGlobalSession = new FxAccountGlobalSession(string3, string2, authHeaderProvider, "fxa.v1", keyBundle, sessionCallback, FxAccountSyncAdapter.this.getContext(), bundle, sharedPreferencesClientsDataDelegate);
                                fxAccountGlobalSession.start();
                            }
                            catch (Exception exception) {
                                sessionCallback.handleError(fxAccountGlobalSession, exception);
                                return;
                            }
                        }
                    });
                }

                public void handleError(Exception exception) {
                    Logger.info(LOG_TAG, "Failed to get token.", exception);
                    countDownLatch.countDown();
                }
            });
            countDownLatch.await();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got error logging in.", exception);
        }
    }

    protected static class SessionCallback
    implements BaseGlobalSessionCallback {
        protected final CountDownLatch latch;

        public SessionCallback(CountDownLatch countDownLatch) {
            if (countDownLatch == null) {
                throw new IllegalArgumentException("latch must not be null");
            }
            this.latch = countDownLatch;
        }

        public boolean shouldBackOff() {
            return false;
        }

        public void requestBackoff(long l) {
        }

        public void informUpgradeRequiredResponse(GlobalSession globalSession) {
        }

        public void informUnauthorizedResponse(GlobalSession globalSession, URI uRI) {
        }

        public void handleStageCompleted(GlobalSyncStage.Stage stage, GlobalSession globalSession) {
        }

        public void handleSuccess(GlobalSession globalSession) {
            Logger.info(LOG_TAG, "Successfully synced!");
            this.latch.countDown();
        }

        public void handleError(GlobalSession globalSession, Exception exception) {
            Logger.warn(LOG_TAG, "Sync failed.", exception);
            this.latch.countDown();
        }

        public void handleAborted(GlobalSession globalSession, String string2) {
            Logger.warn(LOG_TAG, "Sync aborted: " + string2);
            this.latch.countDown();
        }
    }
}

