/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.location.Location;
import android.location.LocationListener;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PowerManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.provider.MediaStore;
import android.telephony.CellLocation;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.Toast;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.AppNotificationClient;
import org.mozilla.gecko.ContactService;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.DoorHangerPopup;
import org.mozilla.gecko.FormAssistPopup;
import org.mozilla.gecko.GeckoAccessibility;
import org.mozilla.gecko.GeckoActivity;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoJavaSampler;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoScreenOrientationListener;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.LocaleManager;
import org.mozilla.gecko.MotionEventInterceptor;
import org.mozilla.gecko.NotificationClient;
import org.mozilla.gecko.NotificationHelper;
import org.mozilla.gecko.PrefsHelper;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SessionParser;
import org.mozilla.gecko.SmsManager;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsPanel;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TextSelection;
import org.mozilla.gecko.TextSelectionHandle;
import org.mozilla.gecko.TouchEventInterceptor;
import org.mozilla.gecko.background.announcements.AnnouncementsBroadcastService;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.gfx.Layer;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.gfx.PluginLayer;
import org.mozilla.gecko.health.BrowserHealthRecorder;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.menu.GeckoMenuInflater;
import org.mozilla.gecko.menu.MenuPanel;
import org.mozilla.gecko.preferences.GeckoPreferences;
import org.mozilla.gecko.prompts.PromptService;
import org.mozilla.gecko.updater.UpdateService;
import org.mozilla.gecko.updater.UpdateServiceHelper;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.GeckoEventResponder;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UiAsyncTask;
import org.mozilla.gecko.widget.ButtonToast;

public abstract class GeckoApp
extends GeckoActivity
implements ContextGetter,
GeckoAppShell.GeckoInterface,
GeckoEventListener,
GeckoEventResponder,
GeckoMenu.Callback,
GeckoMenu.MenuPresenter,
LocationListener,
SensorEventListener,
Tabs.OnTabsChangedListener {
    private static final String LOGTAG = "GeckoApp";
    public static final String ACTION_ALERT_CALLBACK = "org.mozilla.gecko.ACTION_ALERT_CALLBACK";
    public static final String ACTION_BOOKMARK = "org.mozilla.gecko.BOOKMARK";
    public static final String ACTION_DEBUG = "org.mozilla.gecko.DEBUG";
    public static final String ACTION_LAUNCH_SETTINGS = "org.mozilla.gecko.SETTINGS";
    public static final String ACTION_LOAD = "org.mozilla.gecko.LOAD";
    public static final String ACTION_INIT_PW = "org.mozilla.gecko.INIT_PW";
    public static final String ACTION_WEBAPP_PREFIX = "org.mozilla.gecko.WEBAPP";
    public static final String EXTRA_STATE_BUNDLE = "stateBundle";
    public static final String PREFS_ALLOW_STATE_BUNDLE = "allowStateBundle";
    public static final String PREFS_CRASHED = "crashed";
    public static final String PREFS_NAME = "GeckoApp";
    public static final String PREFS_OOM_EXCEPTION = "OOMException";
    public static final String PREFS_VERSION_CODE = "versionCode";
    public static final String PREFS_WAS_STOPPED = "wasStopped";
    public static final String SAVED_STATE_IN_BACKGROUND = "inBackground";
    public static final String SAVED_STATE_PRIVATE_SESSION = "privateSession";
    private static final String LOCATION_URL = "https://location.services.mozilla.com/v1/submit";
    private static final int CLEANUP_DEFERRAL_SECONDS = 15;
    protected RelativeLayout mMainLayout;
    protected RelativeLayout mGeckoLayout;
    private View mCameraView;
    private OrientationEventListener mCameraOrientationEventListener;
    public List<GeckoAppShell.AppStateListener> mAppStateListeners;
    private static GeckoApp sAppContext;
    protected MenuPanel mMenuPanel;
    protected Menu mMenu;
    protected GeckoProfile mProfile;
    public static int mOrientation;
    protected boolean mIsRestoringActivity;
    private String mCurrentResponse = "";
    private ContactService mContactService;
    private PromptService mPromptService;
    private TextSelection mTextSelection;
    protected DoorHangerPopup mDoorHangerPopup;
    protected FormAssistPopup mFormAssistPopup;
    protected TabsPanel mTabsPanel;
    protected ButtonToast mToast;
    protected LayerView mLayerView;
    private AbsoluteLayout mPluginContainer;
    private FullScreenHolder mFullScreenPluginContainer;
    private View mFullScreenPluginView;
    private HashMap<String, PowerManager.WakeLock> mWakeLocks = new HashMap();
    protected boolean mShouldRestore;
    protected boolean mInitialized = false;
    private Telemetry.Timer mJavaUiStartupTimer;
    private Telemetry.Timer mGeckoReadyStartupTimer;
    private String mPrivateBrowsingSession;
    private volatile BrowserHealthRecorder mHealthRecorder = null;
    private int mSignalStrenth;
    private PhoneStateListener mPhoneStateListener = null;
    private boolean mShouldReportGeoData = false;
    private static final String RESTARTER_ACTION = "org.mozilla.gecko.restart";
    private static final String RESTARTER_CLASS = "org.mozilla.gecko.Restarter";
    private static final Set<Character> AD_HOC_HEX_VALUES;
    private static final String OPTOUT_SSID_SUFFIX = "_nomap";
    private static final String SESSION_END_LOCALE_CHANGED = "L";

    public View getView() {
        return this.mGeckoLayout;
    }

    public abstract int getLayout();

    public abstract boolean hasTabsSideBar();

    protected abstract String getDefaultProfileName();

    void toggleChrome(boolean bl) {
    }

    void focusChrome() {
    }

    public Context getContext() {
        return sAppContext;
    }

    public SharedPreferences getSharedPreferences() {
        return GeckoApp.getAppSharedPreferences();
    }

    public static SharedPreferences getAppSharedPreferences() {
        return sAppContext.getSharedPreferences("GeckoApp", 0);
    }

    public Activity getActivity() {
        return this;
    }

    public LocationListener getLocationListener() {
        if (this.mShouldReportGeoData && this.mPhoneStateListener == null) {
            this.mPhoneStateListener = new PhoneStateListener(){

                public void onSignalStrengthsChanged(SignalStrength signalStrength) {
                    GeckoApp.this.setCurrentSignalStrenth(signalStrength);
                }
            };
            TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
            telephonyManager.listen(this.mPhoneStateListener, 256);
        }
        return this;
    }

    public SensorEventListener getSensorEventListener() {
        return this;
    }

    public View getCameraView() {
        return this.mCameraView;
    }

    public void addAppStateListener(GeckoAppShell.AppStateListener appStateListener) {
        this.mAppStateListeners.add(appStateListener);
    }

    public void removeAppStateListener(GeckoAppShell.AppStateListener appStateListener) {
        this.mAppStateListeners.remove(appStateListener);
    }

    public FormAssistPopup getFormAssistPopup() {
        return this.mFormAssistPopup;
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case UNSELECTED: {
                this.hidePlugins(tab);
                break;
            }
            case LOCATION_CHANGE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
            }
            case SELECTED: {
                this.invalidateOptionsMenu();
                if (this.mFormAssistPopup == null) break;
                this.mFormAssistPopup.hide();
                break;
            }
            case LOADED: {
                LayerView layerView = this.mLayerView;
                if (layerView == null || !Tabs.getInstance().isSelectedTab(tab)) break;
                layerView.setBackgroundColor(tab.getBackgroundColor());
                break;
            }
            case DESKTOP_MODE_CHANGE: {
                if (!Tabs.getInstance().isSelectedTab(tab)) break;
                this.invalidateOptionsMenu();
            }
        }
    }

    public void refreshChrome() {
    }

    public void invalidateOptionsMenu() {
        if (this.mMenu == null) {
            return;
        }
        this.onPrepareOptionsMenu(this.mMenu);
        if (Build.VERSION.SDK_INT >= 11) {
            super.invalidateOptionsMenu();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.mMenu = menu2;
        MenuInflater menuInflater = this.getMenuInflater();
        menuInflater.inflate(R.menu.gecko_app_menu, this.mMenu);
        return true;
    }

    public MenuInflater getMenuInflater() {
        if (Build.VERSION.SDK_INT >= 11) {
            return new GeckoMenuInflater((Context)this);
        }
        return super.getMenuInflater();
    }

    public MenuPanel getMenuPanel() {
        return this.mMenuPanel;
    }

    public boolean onMenuItemSelected(MenuItem menuItem) {
        return this.onOptionsItemSelected(menuItem);
    }

    public void openMenu() {
        this.openOptionsMenu();
    }

    public void showMenu(View view) {
        if (!HardwareUtils.hasMenuButton()) {
            this.closeMenu();
        }
        this.mMenuPanel.removeAllViews();
        this.mMenuPanel.addView(view);
        this.openOptionsMenu();
    }

    public void closeMenu() {
        this.closeOptionsMenu();
    }

    public View onCreatePanelView(int n) {
        if (Build.VERSION.SDK_INT >= 11 && n == 0) {
            if (this.mMenuPanel == null) {
                this.mMenuPanel = new MenuPanel((Context)this, null);
            } else {
                this.onPreparePanel(n, (View)this.mMenuPanel, this.mMenu);
            }
            return this.mMenuPanel;
        }
        return super.onCreatePanelView(n);
    }

    public boolean onCreatePanelMenu(int n, Menu menu2) {
        if (Build.VERSION.SDK_INT >= 11 && n == 0) {
            if (this.mMenuPanel == null) {
                this.mMenuPanel = (MenuPanel)this.onCreatePanelView(n);
            }
            GeckoMenu geckoMenu = new GeckoMenu((Context)this, null);
            geckoMenu.setCallback(this);
            geckoMenu.setMenuPresenter(this);
            menu2 = geckoMenu;
            this.mMenuPanel.addView((View)geckoMenu);
            return this.onCreateOptionsMenu(menu2);
        }
        return super.onCreatePanelMenu(n, menu2);
    }

    public boolean onPreparePanel(int n, View view, Menu menu2) {
        if (Build.VERSION.SDK_INT >= 11 && n == 0) {
            return this.onPrepareOptionsMenu(menu2);
        }
        return super.onPreparePanel(n, view, menu2);
    }

    public boolean onMenuOpened(int n, Menu menu2) {
        if (this.mLayerView != null && this.mLayerView.isFullScreen()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("FullScreen:Exit", null));
        }
        if (Build.VERSION.SDK_INT >= 11 && n == 0) {
            if (this.mMenu == null) {
                this.onCreatePanelMenu(n, menu2);
                this.onPreparePanel(n, (View)this.mMenuPanel, this.mMenu);
            }
            if (this.mMenuPanel != null) {
                this.mMenuPanel.scrollTo(0, 0);
            }
            return true;
        }
        return super.onMenuOpened(n, menu2);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.quit) {
            if (GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.GeckoRunning, GeckoThread.LaunchState.GeckoExiting)) {
                GeckoAppShell.notifyGeckoOfEvent(GeckoEvent.createBroadcastEvent("Browser:Quit", null));
            } else {
                System.exit(0);
            }
            return true;
        }
        return super.onOptionsItemSelected(menuItem);
    }

    public void onOptionsMenuClosed(Menu menu2) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.mMenuPanel.removeAllViews();
            this.mMenuPanel.addView((View)((GeckoMenu)this.mMenu));
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n == 82) {
            this.openOptionsMenu();
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean(SAVED_STATE_IN_BACKGROUND, this.isApplicationInBackground());
        bundle.putString(SAVED_STATE_PRIVATE_SESSION, this.mPrivateBrowsingSession);
    }

    void handleFaviconRequest(final String string2) {
        new UiAsyncTask<Void, Void, String>(ThreadUtils.getBackgroundHandler()){

            public String doInBackground(Void ... voidArray) {
                return Favicons.getFaviconURLForPageURL(string2);
            }

            public void onPostExecute(String string22) {
                JSONObject jSONObject = new JSONObject();
                if (string22 != null) {
                    try {
                        jSONObject.put("url", (Object)string2);
                        jSONObject.put("faviconUrl", (Object)string22);
                    }
                    catch (JSONException jSONException) {
                        Log.w((String)"GeckoApp", (String)"Error building JSON favicon arguments.", (Throwable)jSONException);
                    }
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Reader:FaviconReturn", jSONObject.toString()));
            }
        }.execute((Object[])new Void[0]);
    }

    void handleClearHistory() {
        BrowserDB.clearHistory(this.getContentResolver());
    }

    public void addTab() {
    }

    public void addPrivateTab() {
    }

    public void showNormalTabs() {
    }

    public void showPrivateTabs() {
    }

    public void showRemoteTabs() {
    }

    private void showTabs(TabsPanel.Panel panel) {
    }

    public void hideTabs() {
    }

    public boolean autoHideTabs() {
        return false;
    }

    public boolean areTabsShown() {
        return false;
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("Toast:Show")) {
                String string3 = jSONObject.getString("message");
                JSONObject jSONObject2 = jSONObject.optJSONObject("button");
                if (jSONObject2 != null) {
                    String string4 = jSONObject2.optString("label");
                    String string5 = jSONObject2.optString("icon");
                    String string6 = jSONObject2.optString("id");
                    this.showButtonToast(string3, string4, string5, string6);
                } else {
                    String string7 = jSONObject.getString("duration");
                    this.showNormalToast(string3, string7);
                }
            } else if (string2.equals("log")) {
                String string8 = jSONObject.getString("msg");
                Log.d((String)"GeckoApp", (String)("Log: " + string8));
            } else if (string2.equals("Reader:FaviconRequest")) {
                String string9 = jSONObject.getString("url");
                this.handleFaviconRequest(string9);
            } else if (string2.equals("Gecko:Ready")) {
                this.mGeckoReadyStartupTimer.stop();
                this.geckoConnected();
                BrowserHealthRecorder browserHealthRecorder = this.mHealthRecorder;
                if (browserHealthRecorder != null) {
                    browserHealthRecorder.recordGeckoStartupTime(this.mGeckoReadyStartupTimer.getElapsed());
                }
            } else if (string2.equals("ToggleChrome:Hide")) {
                this.toggleChrome(false);
            } else if (string2.equals("ToggleChrome:Show")) {
                this.toggleChrome(true);
            } else if (string2.equals("ToggleChrome:Focus")) {
                this.focusChrome();
            } else if (string2.equals("DOMFullScreen:Start")) {
                LayerView layerView = this.mLayerView;
                if (layerView != null) {
                    layerView.setFullScreen(true);
                }
            } else if (string2.equals("DOMFullScreen:Stop")) {
                LayerView layerView = this.mLayerView;
                if (layerView != null) {
                    layerView.setFullScreen(false);
                }
            } else if (string2.equals("Permissions:Data")) {
                String string10 = jSONObject.getString("host");
                JSONArray jSONArray = jSONObject.getJSONArray("permissions");
                this.showSiteSettingsDialog(string10, jSONArray);
            } else if (string2.equals("Session:StatePurged")) {
                this.onStatePurged();
            } else if (string2.equals("Bookmark:Insert")) {
                String string11 = jSONObject.getString("url");
                String string12 = jSONObject.getString("title");
                GeckoApp geckoApp = this;
                ThreadUtils.postToUiThread((Runnable)new Runnable((Context)geckoApp, string12, string11){
                    final /* synthetic */ Context val$context;
                    final /* synthetic */ String val$title;
                    final /* synthetic */ String val$url;
                    {
                        this.val$context = context;
                        this.val$title = string2;
                        this.val$url = string3;
                    }

                    public void run() {
                        Toast.makeText((Context)this.val$context, (int)R.string.bookmark_added, (int)0).show();
                        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                            public void run() {
                                BrowserDB.addBookmark(GeckoApp.this.getContentResolver(), val$title, val$url);
                            }
                        });
                    }
                });
            } else if (string2.equals("Accessibility:Event")) {
                GeckoAccessibility.sendAccessibilityEvent(jSONObject);
            } else if (string2.equals("Accessibility:Ready")) {
                GeckoAccessibility.updateAccessibilitySettings(this);
            } else if (string2.equals("Shortcut:Remove")) {
                String string13 = jSONObject.getString("url");
                String string14 = jSONObject.getString("origin");
                String string15 = jSONObject.getString("title");
                String string16 = jSONObject.getString("shortcutType");
                GeckoAppShell.removeShortcut(string15, string13, string14, string16);
            } else if (string2.equals("WebApps:PreInstall")) {
                String string17 = jSONObject.getString("name");
                String string18 = jSONObject.getString("manifestURL");
                String string19 = jSONObject.getString("origin");
                this.mCurrentResponse = GeckoAppShell.preInstallWebApp(string17, string18, string19).toString();
            } else if (string2.equals("WebApps:PostInstall")) {
                String string20 = jSONObject.getString("name");
                String string21 = jSONObject.getString("manifestURL");
                String string22 = jSONObject.getString("iconURL");
                String string23 = jSONObject.getString("originalOrigin");
                String string24 = jSONObject.getString("origin");
                GeckoAppShell.postInstallWebApp(string20, string21, string24, string22, string23);
            } else if (string2.equals("WebApps:Open")) {
                String string25;
                String string26 = jSONObject.getString("manifestURL");
                Intent intent = GeckoAppShell.getWebAppIntent(string26, string25 = jSONObject.getString("origin"), "", null);
                if (intent == null) {
                    return;
                }
                this.startActivity(intent);
            } else if (string2.equals("WebApps:Uninstall")) {
                GeckoAppShell.uninstallWebApp(jSONObject.getString("origin"));
            } else if (string2.equals("Share:Text")) {
                String string27 = jSONObject.getString("text");
                GeckoAppShell.openUriExternal(string27, "text/plain", "", "", "android.intent.action.SEND", "");
            } else if (string2.equals("Share:Image")) {
                String string28 = jSONObject.getString("url");
                String string29 = jSONObject.getString("mime");
                GeckoAppShell.shareImage(string28, string29);
            } else if (string2.equals("Image:SetAs")) {
                String string30 = jSONObject.getString("url");
                this.setImageAs(string30);
            } else if (string2.equals("Sanitize:ClearHistory")) {
                this.handleClearHistory();
            } else if (string2.equals("Update:Check")) {
                this.startService(new Intent("org.mozilla.fennec.CHECK_FOR_UPDATE", null, (Context)this, UpdateService.class));
            } else if (string2.equals("Update:Download")) {
                this.startService(new Intent("org.mozilla.fennec.DOWNLOAD_UPDATE", null, (Context)this, UpdateService.class));
            } else if (string2.equals("Update:Install")) {
                this.startService(new Intent("org.mozilla.fennec.APPLY_UPDATE", null, (Context)this, UpdateService.class));
            } else if (string2.equals("PrivateBrowsing:Data")) {
                this.mPrivateBrowsingSession = jSONObject.isNull("session") ? null : jSONObject.getString("session");
            } else if (string2.equals("Contact:Add")) {
                if (!jSONObject.isNull("email")) {
                    Uri uri = Uri.parse((String)jSONObject.getString("email"));
                    Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", uri);
                    this.startActivity(intent);
                } else if (!jSONObject.isNull("phone")) {
                    Uri uri = Uri.parse((String)jSONObject.getString("phone"));
                    Intent intent = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", uri);
                    this.startActivity(intent);
                } else {
                    Log.e((String)"GeckoApp", (String)"Received Contact:Add message with no email nor phone number");
                }
            } else if (string2.equals("Intent:GetHandlers")) {
                Intent intent = GeckoAppShell.getOpenURIIntent((Context)sAppContext, jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("action"), jSONObject.optString("title"));
                String[] stringArray = GeckoAppShell.getHandlersForIntent(intent);
                ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put("apps", (Object)new JSONArray(arrayList));
                this.mCurrentResponse = jSONObject3.toString();
            } else if (string2.equals("Intent:Open")) {
                GeckoAppShell.openUriExternal(jSONObject.optString("url"), jSONObject.optString("mime"), jSONObject.optString("packageName"), jSONObject.optString("className"), jSONObject.optString("action"), jSONObject.optString("title"));
            } else if (string2.equals("Locale:Set")) {
                this.setLocale(jSONObject.getString("locale"));
            }
        }
        catch (Exception exception) {
            Log.e((String)"GeckoApp", (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    public String getResponse(JSONObject jSONObject) {
        String string2 = this.mCurrentResponse;
        this.mCurrentResponse = "";
        return string2;
    }

    void onStatePurged() {
    }

    private void showSiteSettingsDialog(String string2, JSONArray jSONArray) {
        final AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        View view = this.getLayoutInflater().inflate(R.layout.site_setting_title, null);
        ((TextView)view.findViewById(R.id.title)).setText(R.string.site_settings_title);
        ((TextView)view.findViewById(R.id.host)).setText((CharSequence)string2);
        builder.setCustomTitle(view);
        if (jSONArray.length() == 0) {
            builder.setMessage(R.string.site_settings_no_settings);
        } else {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("setting", jSONObject.getString("setting"));
                    hashMap.put("value", jSONObject.getString("value"));
                    arrayList.add(hashMap);
                    continue;
                }
                catch (JSONException jSONException) {
                    Log.w((String)"GeckoApp", (String)"Exception populating settings items.", (Throwable)jSONException);
                }
            }
            builder.setSingleChoiceItems((ListAdapter)new SimpleAdapter((Context)this, arrayList, R.layout.site_setting_item, new String[]{"setting", "value"}, new int[]{R.id.setting, R.id.value}), -1, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                }
            });
            builder.setPositiveButton(R.string.site_settings_clear, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n) {
                    ListView listView = ((AlertDialog)dialogInterface).getListView();
                    SparseBooleanArray sparseBooleanArray = listView.getCheckedItemPositions();
                    JSONArray jSONArray = new JSONArray();
                    for (int i = 0; i < sparseBooleanArray.size(); ++i) {
                        if (!sparseBooleanArray.get(i)) continue;
                        jSONArray.put(i);
                    }
                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Permissions:Clear", jSONArray.toString()));
                }
            });
        }
        builder.setNegativeButton(R.string.site_settings_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.cancel();
            }
        });
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                AlertDialog alertDialog = builder.create();
                alertDialog.show();
                ListView listView = alertDialog.getListView();
                if (listView != null) {
                    listView.setChoiceMode(2);
                    int n = listView.getAdapter().getCount();
                    for (int i = 0; i < n; ++i) {
                        listView.setItemChecked(i, true);
                    }
                }
            }
        });
    }

    public void showToast(final int n, final int n2) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Toast.makeText((Context)GeckoApp.this, (int)n, (int)n2).show();
            }
        });
    }

    public void showNormalToast(final String string2, final String string3) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Toast toast = string3.equals("long") ? Toast.makeText((Context)GeckoApp.this, (CharSequence)string2, (int)1) : Toast.makeText((Context)GeckoApp.this, (CharSequence)string2, (int)0);
                toast.show();
            }
        });
    }

    void showButtonToast(final String string2, final String string3, String string4, final String string5) {
        BitmapUtils.getDrawable((Context)this, string4, new BitmapUtils.BitmapLoader(){

            public void onBitmapFound(final Drawable drawable2) {
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        GeckoApp.this.mToast.show(false, string2, string3, drawable2, new ButtonToast.ToastListener(){

                            public void onButtonClicked() {
                                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Toast:Click", string5));
                            }

                            public void onToastHidden(ButtonToast.ReasonHidden reasonHidden) {
                                if (reasonHidden == ButtonToast.ReasonHidden.TIMEOUT) {
                                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Toast:Hidden", string5));
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void addFullScreenPluginView(View view) {
        if (this.mFullScreenPluginView != null) {
            Log.w((String)"GeckoApp", (String)"Already have a fullscreen plugin view");
            return;
        }
        this.setFullScreen(true);
        view.setWillNotDraw(false);
        if (view instanceof SurfaceView) {
            ((SurfaceView)view).setZOrderOnTop(true);
        }
        this.mFullScreenPluginContainer = new FullScreenHolder((Context)this);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mFullScreenPluginContainer.addView(view, (ViewGroup.LayoutParams)layoutParams);
        FrameLayout frameLayout = (FrameLayout)this.getWindow().getDecorView();
        frameLayout.addView((View)this.mFullScreenPluginContainer, (ViewGroup.LayoutParams)layoutParams);
        this.mFullScreenPluginView = view;
    }

    public void addPluginView(final View view, final RectF rectF, final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getSelectedTab();
                if (bl) {
                    GeckoApp.this.addFullScreenPluginView(view);
                    return;
                }
                PluginLayer pluginLayer = (PluginLayer)tab.getPluginLayer(view);
                if (pluginLayer == null) {
                    pluginLayer = new PluginLayer(view, rectF, GeckoApp.this.mLayerView.getRenderer().getMaxTextureSize());
                    tab.addPluginLayer(view, pluginLayer);
                } else {
                    pluginLayer.reset(rectF);
                    pluginLayer.setVisible(true);
                }
                GeckoApp.this.mLayerView.addLayer(pluginLayer);
            }
        });
    }

    private void removeFullScreenPluginView(View view) {
        if (this.mFullScreenPluginView == null) {
            Log.w((String)"GeckoApp", (String)"Don't have a fullscreen plugin view");
            return;
        }
        if (this.mFullScreenPluginView != view) {
            Log.w((String)"GeckoApp", (String)"Passed view is not the current full screen view");
            return;
        }
        this.mFullScreenPluginContainer.removeView(this.mFullScreenPluginView);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                GeckoApp.this.mLayerView.showSurface();
            }
        });
        FrameLayout frameLayout = (FrameLayout)this.getWindow().getDecorView();
        frameLayout.removeView((View)this.mFullScreenPluginContainer);
        this.mFullScreenPluginView = null;
        GeckoScreenOrientationListener.getInstance().unlockScreenOrientation();
        this.setFullScreen(false);
    }

    public void removePluginView(final View view, final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Tabs tabs = Tabs.getInstance();
                Tab tab = tabs.getSelectedTab();
                if (bl) {
                    GeckoApp.this.removeFullScreenPluginView(view);
                    return;
                }
                PluginLayer pluginLayer = (PluginLayer)tab.removePluginLayer(view);
                if (pluginLayer != null) {
                    pluginLayer.destroy();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImageAs(String string2) {
        boolean bl = string2.startsWith("data:");
        Bitmap bitmap = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            Object object;
            int n;
            if (bl) {
                n = string2.indexOf(",");
                object = Base64.decode((String)string2.substring(n + 1), (int)0);
                bitmap = BitmapUtils.decodeByteArray(object);
            } else {
                object = new byte[4192];
                byteArrayOutputStream = new ByteArrayOutputStream();
                URL uRL = new URL(string2);
                inputStream = uRL.openStream();
                while ((n = inputStream.read((byte[])object)) != -1) {
                    byteArrayOutputStream.write((byte[])object, 0, n);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                bitmap = BitmapUtils.decodeByteArray(byArray);
            }
            if (bitmap != null) {
                String string3 = MediaStore.Images.Media.insertImage((ContentResolver)this.getContentResolver(), (Bitmap)bitmap, null, null);
                object = new Intent("android.intent.action.ATTACH_DATA");
                object.addCategory("android.intent.category.DEFAULT");
                object.setData(Uri.parse((String)string3));
                GeckoAppShell.sActivityHelper.startIntentForActivity((Activity)this, Intent.createChooser((Intent)object, (CharSequence)sAppContext.getString(R.string.set_image_chooser_title)), new ActivityResultHandler((Intent)object){
                    final /* synthetic */ Intent val$intent;
                    {
                        this.val$intent = intent;
                    }

                    public void onActivityResult(int n, Intent intent) {
                        GeckoApp.this.getContentResolver().delete(this.val$intent.getData(), null, null);
                    }
                });
            } else {
                Toast.makeText((Context)sAppContext, (int)R.string.set_image_fail, (int)0).show();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.e((String)"GeckoApp", (String)"Out of Memory when converting to byte array", (Throwable)outOfMemoryError);
        }
        catch (IOException iOException) {
            Log.e((String)"GeckoApp", (String)"I/O Exception while setting wallpaper", (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.w((String)"GeckoApp", (String)"I/O Exception while closing stream", (Throwable)iOException);
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.w((String)"GeckoApp", (String)"I/O Exception while closing stream", (Throwable)iOException);
                }
            }
        }
    }

    private int getBitmapSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outWidth;
        int n4 = options.outHeight;
        int n5 = 1;
        if (n4 > n2 || n3 > n) {
            n5 = n3 > n4 ? Math.round((float)n4 / (float)n2) : Math.round((float)n3 / (float)n);
        }
        return n5;
    }

    private void hidePluginLayer(Layer layer) {
        LayerView layerView = this.mLayerView;
        layerView.removeLayer(layer);
        layerView.requestRender();
    }

    private void showPluginLayer(Layer layer) {
        LayerView layerView = this.mLayerView;
        layerView.addLayer(layer);
        layerView.requestRender();
    }

    public void requestRender() {
        this.mLayerView.requestRender();
    }

    public void hidePlugins(Tab tab) {
        for (Layer layer : tab.getPluginLayers()) {
            if (layer instanceof PluginLayer) {
                ((PluginLayer)layer).setVisible(false);
            }
            this.hidePluginLayer(layer);
        }
        this.requestRender();
    }

    public void showPlugins() {
        Tabs tabs = Tabs.getInstance();
        Tab tab = tabs.getSelectedTab();
        this.showPlugins(tab);
    }

    public void showPlugins(Tab tab) {
        for (Layer layer : tab.getPluginLayers()) {
            this.showPluginLayer(layer);
            if (!(layer instanceof PluginLayer)) continue;
            ((PluginLayer)layer).setVisible(true);
        }
        this.requestRender();
    }

    public void setFullScreen(final boolean bl) {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Window window = GeckoApp.this.getWindow();
                window.setFlags(bl ? 1024 : 0, 1024);
                if (Build.VERSION.SDK_INT >= 11) {
                    window.getDecorView().setSystemUiVisibility(bl ? 1 : 0);
                }
            }
        });
    }

    protected void earlyStartJavaSampler(Intent intent) {
        String string2 = intent.getStringExtra("env0");
        int n = 1;
        while (string2 != null) {
            if (string2.startsWith("MOZ_PROFILER_STARTUP=")) {
                if (string2.endsWith("=")) break;
                GeckoJavaSampler.start(10, 1000);
                Log.d((String)"GeckoApp", (String)"Profiling Java on startup");
                break;
            }
            string2 = intent.getStringExtra("env" + n);
            ++n;
        }
    }

    public void onCreate(Bundle object) {
        Object object2;
        Object object3;
        GeckoAppShell.registerGlobalExceptionHandler();
        if ("default".equals("nightly-holly")) {
            this.enableStrictMode();
        }
        this.mJavaUiStartupTimer = new Telemetry.UptimeTimer("FENNEC_STARTUP_TIME_JAVAUI");
        this.mGeckoReadyStartupTimer = new Telemetry.UptimeTimer("FENNEC_STARTUP_TIME_GECKOREADY");
        Intent intent = this.getIntent();
        String string2 = intent.getStringExtra("args");
        this.earlyStartJavaSampler(intent);
        if (this.mProfile == null) {
            object3 = null;
            object2 = null;
            if (string2 != null) {
                Pattern pattern;
                Matcher matcher;
                if (string2.contains("-P") && (matcher = (pattern = Pattern.compile("(?:-P\\s*)(\\w*)(\\s*)")).matcher(string2)).find()) {
                    object3 = matcher.group(1);
                }
                if (string2.contains("-profile")) {
                    pattern = Pattern.compile("(?:-profile\\s*)(\\S*)(\\s*)");
                    matcher = pattern.matcher(string2);
                    if (matcher.find()) {
                        object2 = matcher.group(1);
                    }
                    if (object3 == null && (object3 = this.getDefaultProfileName()) == null) {
                        object3 = "default";
                    }
                    GeckoProfile.sIsUsingCustomProfile = true;
                }
                if (object3 != null || object2 != null) {
                    this.mProfile = GeckoProfile.get((Context)this, object3, object2);
                }
            }
        }
        BrowserDB.initialize(this.getProfile().getName());
        ((GeckoApplication)this.getApplication()).initialize();
        sAppContext = this;
        GeckoAppShell.setContextGetter(this);
        GeckoAppShell.setGeckoInterface(this);
        ThreadUtils.setUiThread((Thread)Thread.currentThread(), (Handler)new Handler());
        Tabs.getInstance().attachToContext((Context)this);
        try {
            Favicons.attachToContext((Context)this);
        }
        catch (Exception exception) {
            Log.e((String)"GeckoApp", (String)"Exception starting favicon cache. Corrupt resources?", (Throwable)exception);
        }
        if (LocaleManager.systemLocaleDidChange()) {
            Log.i((String)"GeckoApp", (String)"System locale changed. Restarting.");
            this.doRestart();
            System.exit(0);
            return;
        }
        if (GeckoThread.isCreated()) {
            this.mIsRestoringActivity = true;
            Telemetry.HistogramAdd("FENNEC_RESTORING_ACTIVITY", 1);
        }
        if (Build.VERSION.SDK_INT < 9) {
            try {
                object3 = Class.forName("com.android.internal.view.InputBindResult");
                object2 = ((Class)object3).getField("CREATOR");
                Log.i((String)"GeckoApp", (String)("froyo startup fix: " + String.valueOf(((Field)object2).get(null))));
            }
            catch (Exception exception) {
                Log.w((String)"GeckoApp", (String)"froyo startup fix failed", (Throwable)exception);
            }
        }
        if ((object3 = this.getIntent().getBundleExtra(EXTRA_STATE_BUNDLE)) != null) {
            object2 = this.getSharedPreferences("GeckoApp", 0);
            if (object2.getBoolean(PREFS_ALLOW_STATE_BUNDLE, false)) {
                Log.i((String)"GeckoApp", (String)"Restoring state from intent bundle");
                object2.edit().remove(PREFS_ALLOW_STATE_BUNDLE).commit();
                object = object3;
            }
        } else if (object != null) {
            this.setIntent(new Intent("android.intent.action.MAIN"));
        }
        super.onCreate((Bundle)object);
        mOrientation = this.getResources().getConfiguration().orientation;
        this.setContentView(this.getLayout());
        this.mGeckoLayout = (RelativeLayout)this.findViewById(R.id.gecko_layout);
        this.mMainLayout = (RelativeLayout)this.findViewById(R.id.main_layout);
        this.mTabsPanel = (TabsPanel)this.findViewById(R.id.tabs_panel);
        this.mToast = new ButtonToast(this.findViewById(R.id.toast));
        this.mShouldRestore = this.getSessionRestoreState((Bundle)object);
        if (this.mShouldRestore && object != null) {
            boolean bl = object.getBoolean(SAVED_STATE_IN_BACKGROUND, false);
            if (!bl && !this.mIsRestoringActivity) {
                Telemetry.HistogramAdd("FENNEC_WAS_KILLED", 1);
            }
            this.mPrivateBrowsingSession = object.getString(SAVED_STATE_PRIVATE_SESSION);
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                SharedPreferences sharedPreferences = GeckoApp.getAppSharedPreferences();
                LocaleManager.setContextGetter(GeckoApp.this);
                LocaleManager.initialize();
                BrowserHealthRecorder.SessionInformation sessionInformation = BrowserHealthRecorder.SessionInformation.fromSharedPrefs(sharedPreferences);
                if (sessionInformation.wasKilled()) {
                    Telemetry.HistogramAdd("FENNEC_WAS_KILLED", 1);
                }
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_OOM_EXCEPTION, false);
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, false);
                editor.commit();
                String string2 = GeckoApp.this.getProfile().getDir().getAbsolutePath();
                EventDispatcher eventDispatcher = GeckoAppShell.getEventDispatcher();
                Log.i((String)"GeckoApp", (String)"Creating BrowserHealthRecorder.");
                String string3 = Locale.getDefault().toString();
                String string4 = LocaleManager.getAndApplyPersistedLocale();
                Log.d((String)"GeckoApp", (String)("OS locale is " + string3 + ", app locale is " + string4));
                if (string4 == null) {
                    string4 = string3;
                }
                GeckoApp.this.mHealthRecorder = new BrowserHealthRecorder((Context)GeckoApp.this, string2, eventDispatcher, string3, string4, sessionInformation);
                final String string5 = string4;
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        GeckoApp.this.onLocaleReady(string5);
                    }
                });
            }
        });
        GeckoAppShell.setNotificationClient(this.makeNotificationClient());
        NotificationHelper.init(this.getApplicationContext());
    }

    public void onLocaleReady(String string2) {
        if (!ThreadUtils.isOnUiThread()) {
            throw new RuntimeException("onLocaleReady must always be called from the UI thread.");
        }
        TextView textView = (TextView)this.findViewById(R.id.url_bar_title);
        if (textView == null) {
            return;
        }
        String string3 = this.getResources().getString(R.string.url_bar_default_text);
        textView.setHint((CharSequence)string3);
        this.onConfigurationChanged(this.getResources().getConfiguration());
    }

    protected void initializeChrome() {
        this.mDoorHangerPopup = new DoorHangerPopup(this);
        this.mPluginContainer = (AbsoluteLayout)this.findViewById(R.id.plugin_container);
        this.mFormAssistPopup = (FormAssistPopup)this.findViewById(R.id.form_assist_popup);
        if (this.mCameraView == null) {
            if (Build.VERSION.SDK_INT < 14) {
                this.mCameraView = new SurfaceView((Context)this);
                ((SurfaceView)this.mCameraView).getHolder().setType(3);
            } else {
                this.mCameraView = new TextureView((Context)this);
            }
        }
        if (this.mLayerView == null) {
            LayerView layerView = (LayerView)this.findViewById(R.id.layer_view);
            layerView.initializeView(GeckoAppShell.getEventDispatcher());
            this.mLayerView = layerView;
            GeckoAppShell.setLayerView(layerView);
            GeckoAppShell.notifyIMEContext(0, "", "", "");
        }
    }

    protected void loadStartupTab(String string2) {
        if (string2 == null) {
            if (!this.mShouldRestore) {
                Tabs.getInstance().loadUrl("about:home", 1);
            }
        } else {
            int n = 131;
            Tabs.getInstance().loadUrl(string2, n);
        }
    }

    private void initialize() {
        String string2;
        this.mInitialized = true;
        if (Build.VERSION.SDK_INT >= 11) {
            this.onCreatePanelMenu(0, null);
        }
        this.invalidateOptionsMenu();
        Intent intent = this.getIntent();
        String string3 = intent.getAction();
        String string4 = null;
        String string5 = this.getURIFromIntent(intent);
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            string4 = string5;
        }
        boolean bl = string4 != null && !AboutPages.isAboutHome(string4);
        StartupAction startupAction = bl ? StartupAction.URL : StartupAction.NORMAL;
        this.checkMigrateProfile();
        Uri uri = intent.getData();
        if (uri != null && "http".equals(uri.getScheme())) {
            startupAction = StartupAction.PREFETCH;
            ThreadUtils.postToBackgroundThread((Runnable)new PrefetchRunnable(uri.toString()));
        }
        Tabs.registerOnTabsChangedListener(this);
        this.initializeChrome();
        if (!this.mIsRestoringActivity) {
            string2 = null;
            if (this.mShouldRestore) {
                try {
                    string2 = this.restoreSessionTabs(bl);
                }
                catch (SessionRestoreException sessionRestoreException) {
                    Log.e((String)"GeckoApp", (String)"An error occurred during restore", (Throwable)sessionRestoreException);
                    this.mShouldRestore = false;
                }
            }
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Session:Restore", string2));
        }
        if (bl) {
            this.loadStartupTab(string4);
        } else if (!this.mIsRestoringActivity) {
            this.loadStartupTab(null);
        }
        Tabs.getInstance().notifyListeners(null, Tabs.TabEvents.RESTORED);
        if (!this.mShouldRestore) {
            this.getProfile().moveSessionFile();
        }
        Telemetry.HistogramAdd("FENNEC_STARTUP_GECKOAPP_ACTION", startupAction.ordinal());
        if (!this.mIsRestoringActivity) {
            GeckoThread.setArgs(intent.getStringExtra("args"));
            GeckoThread.setAction(intent.getAction());
            GeckoThread.setUri(string4);
        }
        if (!ACTION_DEBUG.equals(string3) && GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.Launching, GeckoThread.LaunchState.Launched)) {
            GeckoThread.createAndStart();
        } else if (ACTION_DEBUG.equals(string3) && GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.Launching, GeckoThread.LaunchState.WaitForDebugger)) {
            ThreadUtils.getUiHandler().postDelayed(new Runnable(){

                public void run() {
                    GeckoThread.setLaunchState(GeckoThread.LaunchState.Launching);
                    GeckoThread.createAndStart();
                }
            }, 5000L);
        }
        if (ACTION_LAUNCH_SETTINGS.equals(string3)) {
            string2 = new Intent((Context)this, GeckoPreferences.class);
            string2.putExtras(intent);
            this.startActivity((Intent)string2);
        }
        this.mAppStateListeners = new LinkedList<GeckoAppShell.AppStateListener>();
        this.registerEventListener("log");
        this.registerEventListener("Reader:ListCountRequest");
        this.registerEventListener("Reader:ListStatusRequest");
        this.registerEventListener("Reader:Added");
        this.registerEventListener("Reader:Removed");
        this.registerEventListener("Reader:Share");
        this.registerEventListener("Reader:FaviconRequest");
        this.registerEventListener("onCameraCapture");
        this.registerEventListener("Menu:Add");
        this.registerEventListener("Menu:Remove");
        this.registerEventListener("Menu:Update");
        this.registerEventListener("Gecko:Ready");
        this.registerEventListener("Toast:Show");
        this.registerEventListener("DOMFullScreen:Start");
        this.registerEventListener("DOMFullScreen:Stop");
        this.registerEventListener("ToggleChrome:Hide");
        this.registerEventListener("ToggleChrome:Show");
        this.registerEventListener("ToggleChrome:Focus");
        this.registerEventListener("Permissions:Data");
        this.registerEventListener("Session:StatePurged");
        this.registerEventListener("Bookmark:Insert");
        this.registerEventListener("Accessibility:Event");
        this.registerEventListener("Accessibility:Ready");
        this.registerEventListener("Shortcut:Remove");
        this.registerEventListener("WebApps:InstallApk");
        this.registerEventListener("WebApps:PreInstall");
        this.registerEventListener("WebApps:PostInstall");
        this.registerEventListener("WebApps:Open");
        this.registerEventListener("WebApps:Uninstall");
        this.registerEventListener("Share:Text");
        this.registerEventListener("Share:Image");
        this.registerEventListener("Image:SetAs");
        this.registerEventListener("Sanitize:ClearHistory");
        this.registerEventListener("Update:Check");
        this.registerEventListener("Update:Download");
        this.registerEventListener("Update:Install");
        this.registerEventListener("PrivateBrowsing:Data");
        this.registerEventListener("Contact:Add");
        this.registerEventListener("Intent:Open");
        this.registerEventListener("Intent:GetHandlers");
        this.registerEventListener("Locale:Set");
        if (SmsManager.getInstance() != null) {
            SmsManager.getInstance().start();
        }
        this.mContactService = new ContactService(GeckoAppShell.getEventDispatcher(), this);
        this.mPromptService = new PromptService((Context)this);
        this.mTextSelection = new TextSelection((TextSelectionHandle)this.findViewById(R.id.start_handle), (TextSelectionHandle)this.findViewById(R.id.middle_handle), (TextSelectionHandle)this.findViewById(R.id.end_handle), GeckoAppShell.getEventDispatcher(), this);
        PrefsHelper.getPref("app.update.autodownload", new PrefsHelper.PrefHandlerBase(){

            public void prefValue(String string2, String string3) {
                UpdateServiceHelper.registerForUpdates((Context)GeckoApp.this, string3);
            }
        });
        PrefsHelper.getPref("app.geo.reportdata", new PrefsHelper.PrefHandlerBase(){

            public void prefValue(String string2, int n) {
                if (n == 1) {
                    GeckoApp.this.mShouldReportGeoData = true;
                } else {
                    GeckoApp.this.mShouldReportGeoData = false;
                }
            }
        });
        this.mJavaUiStartupTimer.stop();
        final long l = this.mJavaUiStartupTimer.getElapsed();
        ThreadUtils.getBackgroundHandler().postDelayed(new Runnable(){

            public void run() {
                BrowserHealthRecorder browserHealthRecorder = GeckoApp.this.mHealthRecorder;
                if (browserHealthRecorder != null) {
                    browserHealthRecorder.recordJavaStartupTime(l);
                }
                GeckoApp geckoApp = GeckoApp.this;
                AnnouncementsBroadcastService.recordLastLaunch((Context)geckoApp);
                GeckoPreferences.broadcastAnnouncementsPref((Context)geckoApp);
                GeckoPreferences.broadcastHealthReportUploadPref((Context)geckoApp);
                if (!GeckoThread.checkLaunchState(GeckoThread.LaunchState.Launched)) {
                    return;
                }
            }
        }, 50L);
        if (this.mIsRestoringActivity) {
            GeckoThread.setLaunchState(GeckoThread.LaunchState.GeckoRunning);
            Tab tab = Tabs.getInstance().getSelectedTab();
            if (tab != null) {
                Tabs.getInstance().notifyListeners(tab, Tabs.TabEvents.SELECTED);
            }
            this.geckoConnected();
            GeckoAppShell.setLayerClient(this.mLayerView.getLayerClient());
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Viewport:Flush", null));
        }
        if (ACTION_ALERT_CALLBACK.equals(string3)) {
            this.processAlertCallback(intent);
        }
    }

    private String restoreSessionTabs(final boolean bl) throws SessionRestoreException {
        try {
            JSONArray jSONArray;
            String string2 = this.getProfile().readSessionFile(false);
            if (string2 == null) {
                throw new SessionRestoreException("Could not read from session file");
            }
            if (this.mShouldRestore) {
                jSONArray = new JSONArray();
                SessionParser sessionParser = new SessionParser(){

                    public void onTabRead(SessionParser.SessionTab sessionTab) {
                        JSONObject jSONObject = sessionTab.getTabObject();
                        int n = 1;
                        n |= bl || !sessionTab.isSelected() ? 16 : 0;
                        n |= jSONObject.optBoolean("desktopMode") ? 32 : 0;
                        Tab tab = Tabs.getInstance().loadUrl(sessionTab.getUrl(), n |= jSONObject.optBoolean("isPrivate") ? 4 : 0);
                        tab.updateTitle(sessionTab.getTitle());
                        try {
                            jSONObject.put("tabId", tab.getId());
                        }
                        catch (JSONException jSONException) {
                            Log.e((String)"GeckoApp", (String)"JSON error", (Throwable)jSONException);
                        }
                        jSONArray.put((Object)jSONObject);
                    }
                };
                if (this.mPrivateBrowsingSession == null) {
                    sessionParser.parse(string2);
                } else {
                    sessionParser.parse(string2, this.mPrivateBrowsingSession);
                }
                if (jSONArray.length() > 0) {
                    string2 = new JSONObject().put("windows", (Object)new JSONArray().put((Object)new JSONObject().put("tabs", (Object)jSONArray))).toString();
                } else {
                    throw new SessionRestoreException("No tabs could be read from session file");
                }
            }
            jSONArray = new JSONObject();
            jSONArray.put("sessionString", (Object)string2);
            return jSONArray.toString();
        }
        catch (JSONException jSONException) {
            throw new SessionRestoreException((Exception)((Object)jSONException));
        }
    }

    public GeckoProfile getProfile() {
        if (this.mProfile == null) {
            this.mProfile = GeckoProfile.get((Context)this);
        }
        return this.mProfile;
    }

    protected boolean getSessionRestoreState(Bundle bundle) {
        final SharedPreferences sharedPreferences = GeckoApp.getAppSharedPreferences();
        boolean bl = false;
        final int n = this.getVersionCode();
        if (sharedPreferences.getInt(PREFS_VERSION_CODE, 0) != n) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    sharedPreferences.edit().putInt(GeckoApp.PREFS_VERSION_CODE, n).commit();
                }
            });
            bl = true;
        } else if (bundle != null || this.getSessionRestorePreference().equals("always") || this.getRestartFromIntent()) {
            bl = true;
        }
        return bl;
    }

    private String getSessionRestorePreference() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this).getString(GeckoPreferences.PREFS_RESTORE_SESSION, "quit");
    }

    private boolean getRestartFromIntent() {
        return this.getIntent().getBooleanExtra("didRestart", false);
    }

    private void enableStrictMode() {
        if (Build.VERSION.SDK_INT < 9) {
            return;
        }
        Log.d((String)"GeckoApp", (String)"Enabling Android StrictMode");
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy((StrictMode.VmPolicy)new StrictMode.VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    public void enableCameraView() {
        this.mCameraOrientationEventListener = new OrientationEventListener((Context)this){

            public void onOrientationChanged(int n) {
                if (GeckoApp.this.mAppStateListeners != null) {
                    for (GeckoAppShell.AppStateListener appStateListener : GeckoApp.this.mAppStateListeners) {
                        appStateListener.onOrientationChanged();
                    }
                }
            }
        };
        this.mCameraOrientationEventListener.enable();
        if (this.mCameraView instanceof SurfaceView) {
            if (Build.VERSION.SDK_INT >= 11) {
                this.mCameraView.setAlpha(0.0f);
            }
        } else if (this.mCameraView instanceof TextureView) {
            this.mCameraView.setAlpha(0.0f);
        }
        RelativeLayout relativeLayout = (RelativeLayout)this.findViewById(R.id.camera_layout);
        relativeLayout.addView(this.mCameraView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(8, 16, 0, 0));
    }

    public void disableCameraView() {
        if (this.mCameraOrientationEventListener != null) {
            this.mCameraOrientationEventListener.disable();
            this.mCameraOrientationEventListener = null;
        }
        RelativeLayout relativeLayout = (RelativeLayout)this.findViewById(R.id.camera_layout);
        relativeLayout.removeView(this.mCameraView);
    }

    public String getDefaultUAString() {
        return HardwareUtils.isTablet() ? "Mozilla/5.0 (Android; Tablet; rv:29.0a1) Gecko/29.0a1 Firefox/29.0a1" : "Mozilla/5.0 (Android; Mobile; rv:29.0a1) Gecko/29.0a1 Firefox/29.0a1";
    }

    public String getUAStringForHost(String string2) {
        if ("t.co".equals(string2)) {
            return "Redirector/29.0a1 (Android; rv:29.0a1)";
        }
        return this.getDefaultUAString();
    }

    private void processAlertCallback(Intent intent) {
        String string2 = "";
        String string3 = "";
        Uri uri = intent.getData();
        if (uri != null) {
            string2 = uri.getQueryParameter("name");
            if (string2 == null) {
                string2 = "";
            }
            if ((string3 = uri.getQueryParameter("cookie")) == null) {
                string3 = "";
            }
        }
        this.handleNotification(ACTION_ALERT_CALLBACK, string2, string3);
    }

    protected void onNewIntent(Intent intent) {
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoExiting)) {
            System.exit(0);
            return;
        }
        if (!this.mInitialized) {
            this.setIntent(intent);
            return;
        }
        String string2 = intent.getAction();
        if (ACTION_LOAD.equals(string2)) {
            String string3 = intent.getDataString();
            Tabs.getInstance().loadUrl(string3);
        } else if ("android.intent.action.VIEW".equals(string2)) {
            String string4 = intent.getDataString();
            Tabs.getInstance().loadUrl(string4, 131);
        } else if (string2 != null && string2.startsWith(ACTION_WEBAPP_PREFIX)) {
            String string5 = this.getURIFromIntent(intent);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createWebappLoadEvent(string5));
        } else if (ACTION_BOOKMARK.equals(string2)) {
            String string6 = this.getURIFromIntent(intent);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBookmarkLoadEvent(string6));
        } else if ("android.intent.action.SEARCH".equals(string2)) {
            String string7 = this.getURIFromIntent(intent);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent(string7));
        } else if (ACTION_ALERT_CALLBACK.equals(string2)) {
            this.processAlertCallback(intent);
        } else if (ACTION_LAUNCH_SETTINGS.equals(string2)) {
            Intent intent2 = new Intent((Context)this, GeckoPreferences.class);
            intent2.putExtras(intent);
            this.startActivity(intent2);
        }
    }

    protected String getURIFromIntent(Intent intent) {
        String string2 = intent.getAction();
        if (ACTION_ALERT_CALLBACK.equals(string2)) {
            return null;
        }
        String string3 = intent.getDataString();
        if (string3 != null) {
            return string3;
        }
        if ((string2 != null && string2.startsWith(ACTION_WEBAPP_PREFIX) || ACTION_BOOKMARK.equals(string2)) && (string3 = intent.getStringExtra("args")) != null && string3.startsWith("--url=")) {
            string3.replace("--url=", "");
        }
        return string3;
    }

    public void onResume() {
        super.onResume();
        int n = this.getResources().getConfiguration().orientation;
        if (mOrientation != n) {
            mOrientation = n;
            this.refreshChrome();
        }
        GeckoScreenOrientationListener.getInstance().start();
        GeckoAccessibility.updateAccessibilitySettings(this);
        if (this.mAppStateListeners != null) {
            for (GeckoAppShell.AppStateListener appStateListener : this.mAppStateListeners) {
                appStateListener.onResume();
            }
        }
        final long l = System.currentTimeMillis();
        final long l2 = SystemClock.elapsedRealtime();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                BrowserHealthRecorder.SessionInformation sessionInformation = new BrowserHealthRecorder.SessionInformation(l, l2);
                SharedPreferences sharedPreferences = GeckoApp.getAppSharedPreferences();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, false);
                sessionInformation.recordBegin(editor);
                editor.commit();
                BrowserHealthRecorder browserHealthRecorder = GeckoApp.this.mHealthRecorder;
                if (browserHealthRecorder != null) {
                    browserHealthRecorder.setCurrentSession(sessionInformation);
                } else {
                    Log.w((String)"GeckoApp", (String)"Can't record session: rec is null.");
                }
            }
        });
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (!this.mInitialized && bl) {
            this.initialize();
            this.getWindow().setBackgroundDrawable(null);
        }
    }

    public void onPause() {
        final BrowserHealthRecorder browserHealthRecorder = this.mHealthRecorder;
        GeckoApp geckoApp = this;
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable((Context)geckoApp){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void run() {
                SharedPreferences sharedPreferences = GeckoApp.getAppSharedPreferences();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, true);
                if (browserHealthRecorder != null) {
                    browserHealthRecorder.recordSessionEnd("P", editor);
                }
                editor.commit();
                GeckoPreferences.broadcastHealthReportPrune(this.val$context);
            }
        });
        GeckoScreenOrientationListener.getInstance().stop();
        if (this.mAppStateListeners != null) {
            for (GeckoAppShell.AppStateListener appStateListener : this.mAppStateListeners) {
                appStateListener.onPause();
            }
        }
        super.onPause();
    }

    public void onRestart() {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                SharedPreferences sharedPreferences = GeckoApp.getAppSharedPreferences();
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putBoolean(GeckoApp.PREFS_WAS_STOPPED, false);
                editor.commit();
            }
        });
        super.onRestart();
    }

    public void onDestroy() {
        this.unregisterEventListener("log");
        this.unregisterEventListener("Reader:ListCountRequest");
        this.unregisterEventListener("Reader:ListStatusRequest");
        this.unregisterEventListener("Reader:Added");
        this.unregisterEventListener("Reader:Removed");
        this.unregisterEventListener("Reader:Share");
        this.unregisterEventListener("Reader:FaviconRequest");
        this.unregisterEventListener("onCameraCapture");
        this.unregisterEventListener("Menu:Add");
        this.unregisterEventListener("Menu:Remove");
        this.unregisterEventListener("Menu:Update");
        this.unregisterEventListener("Gecko:Ready");
        this.unregisterEventListener("Toast:Show");
        this.unregisterEventListener("DOMFullScreen:Start");
        this.unregisterEventListener("DOMFullScreen:Stop");
        this.unregisterEventListener("ToggleChrome:Hide");
        this.unregisterEventListener("ToggleChrome:Show");
        this.unregisterEventListener("ToggleChrome:Focus");
        this.unregisterEventListener("Permissions:Data");
        this.unregisterEventListener("Session:StatePurged");
        this.unregisterEventListener("Bookmark:Insert");
        this.unregisterEventListener("Accessibility:Event");
        this.unregisterEventListener("Accessibility:Ready");
        this.unregisterEventListener("Shortcut:Remove");
        this.unregisterEventListener("WebApps:InstallApk");
        this.unregisterEventListener("WebApps:PreInstall");
        this.unregisterEventListener("WebApps:PostInstall");
        this.unregisterEventListener("WebApps:Open");
        this.unregisterEventListener("WebApps:Uninstall");
        this.unregisterEventListener("Share:Text");
        this.unregisterEventListener("Share:Image");
        this.unregisterEventListener("Image:SetAs");
        this.unregisterEventListener("Sanitize:ClearHistory");
        this.unregisterEventListener("Update:Check");
        this.unregisterEventListener("Update:Download");
        this.unregisterEventListener("Update:Install");
        this.unregisterEventListener("PrivateBrowsing:Data");
        this.unregisterEventListener("Contact:Add");
        this.unregisterEventListener("Intent:Open");
        this.unregisterEventListener("Intent:GetHandlers");
        this.unregisterEventListener("Locale:Set");
        GeckoApp.deleteTempFiles();
        if (this.mLayerView != null) {
            this.mLayerView.destroy();
        }
        if (this.mDoorHangerPopup != null) {
            this.mDoorHangerPopup.destroy();
        }
        if (this.mFormAssistPopup != null) {
            this.mFormAssistPopup.destroy();
        }
        if (this.mContactService != null) {
            this.mContactService.destroy();
        }
        if (this.mPromptService != null) {
            this.mPromptService.destroy();
        }
        if (this.mTextSelection != null) {
            this.mTextSelection.destroy();
        }
        NotificationHelper.destroy();
        if (SmsManager.getInstance() != null) {
            SmsManager.getInstance().stop();
            if (this.isFinishing()) {
                SmsManager.getInstance().shutdown();
            }
        }
        final BrowserHealthRecorder browserHealthRecorder = this.mHealthRecorder;
        this.mHealthRecorder = null;
        if (browserHealthRecorder != null) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    browserHealthRecorder.close();
                }
            });
        }
        Favicons.close();
        super.onDestroy();
        Tabs.unregisterOnTabsChangedListener(this);
    }

    protected void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)this);
    }

    protected void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
    }

    public static File getTempDirectory() {
        File file = sAppContext.getExternalFilesDir("temp");
        return file;
    }

    public static void deleteTempFiles() {
        File file = GeckoApp.getTempDirectory();
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            file2.delete();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        Log.d((String)"GeckoApp", (String)("onConfigurationChanged: " + configuration.locale));
        LocaleManager.correctLocale(this.getResources(), configuration);
        super.onConfigurationChanged(configuration);
        if (mOrientation != configuration.orientation) {
            mOrientation = configuration.orientation;
            if (this.mFormAssistPopup != null) {
                this.mFormAssistPopup.hide();
            }
            this.refreshChrome();
        }
    }

    public String getContentProcessName() {
        return "lib/libplugin-container.so";
    }

    public void addEnvToIntent(Intent intent) {
        Map<String, String> map = System.getenv();
        Set<Map.Entry<String, String>> set = map.entrySet();
        Iterator<Map.Entry<String, String>> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            intent.putExtra("env" + n, entry.getKey() + "=" + entry.getValue());
            ++n;
        }
    }

    public void doRestart() {
        this.doRestart(RESTARTER_ACTION, null);
    }

    public void doRestart(String string2) {
        this.doRestart(RESTARTER_ACTION, string2);
    }

    public void doRestart(String string2, String string3) {
        Log.d((String)"GeckoApp", (String)("doRestart(\"" + string2 + "\")"));
        try {
            Intent intent = new Intent(string2);
            intent.setClassName("org.mozilla.fennec", RESTARTER_CLASS);
            if (string3 != null) {
                intent.putExtra("args", string3);
            }
            intent.putExtra("didRestart", true);
            Log.d((String)"GeckoApp", (String)("Restart intent: " + intent.toString()));
            GeckoAppShell.killAnyZombies();
            this.startActivity(intent);
        }
        catch (Exception exception) {
            Log.e((String)"GeckoApp", (String)"Error effecting restart.", (Throwable)exception);
        }
        this.finish();
        GeckoAppShell.waitForAnotherGeckoProc();
    }

    public void handleNotification(String string2, String string3, String string4) {
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            GeckoAppShell.handleNotification(string2, string3, string4);
        }
    }

    private void checkMigrateProfile() {
        File file = this.getProfile().getDir();
        if (file != null) {
            GeckoApp geckoApp = sAppContext;
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                public void run() {
                    Handler handler = new Handler();
                    handler.postDelayed((Runnable)new DeferredCleanupTask(), 15000L);
                }
            });
        }
    }

    public PromptService getPromptService() {
        return this.mPromptService;
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            super.onBackPressed();
            return;
        }
        if (this.autoHideTabs()) {
            return;
        }
        if (this.mDoorHangerPopup != null && this.mDoorHangerPopup.isShowing()) {
            this.mDoorHangerPopup.dismiss();
            return;
        }
        if (this.mFullScreenPluginView != null) {
            GeckoAppShell.onFullScreenPluginHidden(this.mFullScreenPluginView);
            this.removeFullScreenPluginView(this.mFullScreenPluginView);
            return;
        }
        if (this.mLayerView != null && this.mLayerView.isFullScreen()) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("FullScreen:Exit", null));
            return;
        }
        Tabs tabs = Tabs.getInstance();
        Tab tab = tabs.getSelectedTab();
        if (tab == null) {
            this.moveTaskToBack(true);
            return;
        }
        if (tab.doBack()) {
            return;
        }
        if (tab.isExternal()) {
            this.moveTaskToBack(true);
            tabs.closeTab(tab);
            return;
        }
        int n = tab.getParentId();
        Tab tab2 = tabs.getTab(n);
        if (tab2 != null) {
            tabs.closeTab(tab, tab2);
            return;
        }
        this.moveTaskToBack(true);
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (!GeckoAppShell.sActivityHelper.handleActivityResult(n, n2, intent)) {
            super.onActivityResult(n, n2, intent);
        }
    }

    public AbsoluteLayout getPluginContainer() {
        return this.mPluginContainer;
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createSensorEvent(sensorEvent));
    }

    public void onLocationChanged(Location location) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createLocationEvent(location));
        if (this.mShouldReportGeoData) {
            this.collectAndReportLocInfo(location);
        }
    }

    public void setCurrentSignalStrenth(SignalStrength signalStrength) {
        if (signalStrength.isGsm()) {
            this.mSignalStrenth = signalStrength.getGsmSignalStrength();
        }
    }

    private int getCellInfo(JSONArray jSONArray) {
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return 0;
        }
        List list = telephonyManager.getNeighboringCellInfo();
        CellLocation cellLocation = telephonyManager.getCellLocation();
        String string2 = "";
        String string3 = "";
        if (cellLocation instanceof GsmCellLocation) {
            JSONObject jSONObject = new JSONObject();
            GsmCellLocation gsmCellLocation = (GsmCellLocation)cellLocation;
            try {
                jSONObject.put("lac", gsmCellLocation.getLac());
                jSONObject.put("cid", gsmCellLocation.getCid());
                int n = Build.VERSION.SDK_INT >= 9 ? gsmCellLocation.getPsc() : -1;
                jSONObject.put("psc", n);
                switch (telephonyManager.getNetworkType()) {
                    case 1: 
                    case 2: {
                        jSONObject.put("radio", (Object)"gsm");
                        break;
                    }
                    case 3: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 15: {
                        jSONObject.put("radio", (Object)"umts");
                    }
                }
                String string4 = telephonyManager.getNetworkOperator();
                if (string4.length() > 3) {
                    string2 = string4.substring(0, 3);
                    string3 = string4.substring(3);
                    jSONObject.put("mcc", (Object)string2);
                    jSONObject.put("mnc", (Object)string3);
                }
                jSONObject.put("asu", this.mSignalStrenth);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            jSONArray.put((Object)jSONObject);
        }
        if (list != null) {
            for (GsmCellLocation gsmCellLocation : list) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("lac", gsmCellLocation.getLac());
                    jSONObject.put("cid", gsmCellLocation.getCid());
                    jSONObject.put("psc", gsmCellLocation.getPsc());
                    jSONObject.put("mcc", (Object)string2);
                    jSONObject.put("mnc", (Object)string3);
                    switch (gsmCellLocation.getNetworkType()) {
                        case 1: 
                        case 2: {
                            jSONObject.put("radio", (Object)"gsm");
                            break;
                        }
                        case 3: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 15: {
                            jSONObject.put("radio", (Object)"umts");
                        }
                    }
                    jSONObject.put("asu", gsmCellLocation.getRssi());
                    jSONArray.put((Object)jSONObject);
                }
                catch (JSONException jSONException) {}
            }
        }
        return telephonyManager.getPhoneType();
    }

    private static boolean shouldLog(ScanResult scanResult) {
        char c;
        char c2 = c = scanResult.BSSID.length() == 17 ? (char)scanResult.BSSID.charAt(1) : (char)' ';
        if (AD_HOC_HEX_VALUES.contains(Character.valueOf(c))) {
            return false;
        }
        return scanResult.SSID == null || !scanResult.SSID.endsWith(OPTOUT_SSID_SUFFIX);
    }

    private void collectAndReportLocInfo(Location location) {
        final JSONObject jSONObject = new JSONObject();
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        wifiManager.startScan();
        try {
            JSONArray jSONArray = new JSONArray();
            String string2 = GeckoApp.getRadioTypeName(this.getCellInfo(jSONArray));
            if (string2 != null) {
                jSONObject.put("radio", (Object)string2);
            }
            jSONObject.put("lon", location.getLongitude());
            jSONObject.put("lat", location.getLatitude());
            jSONObject.put("accuracy", (int)location.getAccuracy());
            jSONObject.put("altitude", (int)location.getAltitude());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            jSONObject.put("time", (Object)simpleDateFormat.format(new Date(location.getTime())));
            jSONObject.put("cell", (Object)jSONArray);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            JSONArray jSONArray2 = new JSONArray();
            List list = wifiManager.getScanResults();
            if (list != null) {
                for (ScanResult scanResult : list) {
                    if (!GeckoApp.shouldLog(scanResult)) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        byte[] byArray;
                        for (byte by : byArray = messageDigest.digest((scanResult.BSSID + scanResult.SSID).getBytes("UTF-8"))) {
                            stringBuilder.append(String.format("%02X", by));
                        }
                        JSONObject object = new JSONObject();
                        object.put("key", (Object)stringBuilder.toString());
                        object.put("frequency", scanResult.frequency);
                        object.put("signal", scanResult.level);
                        jSONArray2.put((Object)object);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Log.w((String)"GeckoApp", (String)"can't encode the key", (Throwable)unsupportedEncodingException);
                    }
                }
            }
            jSONObject.put("wifi", (Object)jSONArray2);
        }
        catch (JSONException jSONException) {
            Log.w((String)"GeckoApp", (String)"json exception", (Throwable)jSONException);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.w((String)"GeckoApp", (String)"can't create a SHA1", (Throwable)noSuchAlgorithmException);
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    URL uRL = new URL(GeckoApp.LOCATION_URL);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    try {
                        httpURLConnection.setDoOutput(true);
                        JSONArray jSONArray = new JSONArray();
                        jSONArray.put((Object)jSONObject);
                        JSONObject jSONObject2 = new JSONObject();
                        jSONObject2.put("items", (Object)jSONArray);
                        byte[] byArray = jSONObject2.toString().getBytes();
                        httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream());
                        ((OutputStream)bufferedOutputStream).write(byArray);
                        ((OutputStream)bufferedOutputStream).flush();
                    }
                    catch (JSONException jSONException) {
                        Log.e((String)"GeckoApp", (String)"error wrapping data as a batch", (Throwable)jSONException);
                    }
                    catch (IOException iOException) {
                        Log.e((String)"GeckoApp", (String)"error submitting data", (Throwable)iOException);
                    }
                    finally {
                        httpURLConnection.disconnect();
                    }
                }
                catch (IOException iOException) {
                    Log.e((String)"GeckoApp", (String)"error submitting data", (Throwable)iOException);
                }
            }
        });
    }

    private static String getRadioTypeName(int n) {
        switch (n) {
            case 2: {
                return "cdma";
            }
            case 1: {
                return "gsm";
            }
            case 0: 
            case 3: {
                return null;
            }
        }
        Log.e((String)"GeckoApp", (String)"", (Throwable)new IllegalArgumentException("Unexpected PHONE_TYPE: " + n));
        return null;
    }

    public void onProviderDisabled(String string2) {
    }

    public void onProviderEnabled(String string2) {
    }

    public void onStatusChanged(String string2, int n, Bundle bundle) {
    }

    public void notifyWakeLockChanged(String string2, String string3) {
        PowerManager.WakeLock wakeLock = this.mWakeLocks.get(string2);
        if (string3.equals("locked-foreground") && wakeLock == null) {
            PowerManager powerManager = (PowerManager)this.getSystemService("power");
            wakeLock = powerManager.newWakeLock(10, string2);
            wakeLock.acquire();
            this.mWakeLocks.put(string2, wakeLock);
        } else if (!string3.equals("locked-foreground") && wakeLock != null) {
            wakeLock.release();
            this.mWakeLocks.remove(string2);
        }
    }

    public void notifyCheckUpdateResult(String string2) {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Update:CheckResult", string2));
    }

    protected void geckoConnected() {
        this.mLayerView.geckoConnected();
        this.mLayerView.setOverScrollMode(2);
    }

    public void setAccessibilityEnabled(boolean bl) {
    }

    protected NotificationClient makeNotificationClient() {
        return new AppNotificationClient(this.getApplicationContext());
    }

    private int getVersionCode() {
        int n = 0;
        try {
            n = this.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"GeckoApp", (String)(this.getPackageName() + " not found"), (Throwable)nameNotFoundException);
        }
        return n;
    }

    private void setLocale(String string2) {
        if (string2 == null) {
            return;
        }
        final String string3 = LocaleManager.setSelectedLocale(string2);
        if (string3 == null) {
            return;
        }
        BrowserHealthRecorder browserHealthRecorder = this.mHealthRecorder;
        if (browserHealthRecorder == null) {
            return;
        }
        browserHealthRecorder.onAppLocaleChanged(string3);
        browserHealthRecorder.onEnvironmentChanged(true, SESSION_END_LOCALE_CHANGED);
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                GeckoApp.this.onLocaleReady(string3);
            }
        });
    }

    static {
        AD_HOC_HEX_VALUES = new HashSet<Character>(Arrays.asList(Character.valueOf('2'), Character.valueOf('6'), Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('A'), Character.valueOf('E')));
    }

    private class FullScreenHolder
    extends FrameLayout {
        public FullScreenHolder(Context context) {
            super(context);
        }

        public void addView(View view, int n) {
            super.addView(view, n);
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                public void run() {
                    GeckoApp.this.mLayerView.hideSurface();
                }
            });
        }

        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            if (keyEvent.isSystem()) {
                return super.onKeyDown(n, keyEvent);
            }
            GeckoApp.this.mFullScreenPluginView.onKeyDown(n, keyEvent);
            return true;
        }

        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            if (keyEvent.isSystem()) {
                return super.onKeyUp(n, keyEvent);
            }
            GeckoApp.this.mFullScreenPluginView.onKeyUp(n, keyEvent);
            return true;
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            return true;
        }

        public boolean onTrackballEvent(MotionEvent motionEvent) {
            GeckoApp.this.mFullScreenPluginView.onTrackballEvent(motionEvent);
            return true;
        }
    }

    public static class MainLayout
    extends RelativeLayout {
        private TouchEventInterceptor mTouchEventInterceptor;
        private MotionEventInterceptor mMotionEventInterceptor;

        public MainLayout(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public void setTouchEventInterceptor(TouchEventInterceptor touchEventInterceptor) {
            this.mTouchEventInterceptor = touchEventInterceptor;
        }

        public void setMotionEventInterceptor(MotionEventInterceptor motionEventInterceptor) {
            this.mMotionEventInterceptor = motionEventInterceptor;
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (this.mTouchEventInterceptor != null && this.mTouchEventInterceptor.onInterceptTouchEvent((View)this, motionEvent)) {
                return true;
            }
            return super.onInterceptTouchEvent(motionEvent);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            if (this.mTouchEventInterceptor != null && this.mTouchEventInterceptor.onTouch((View)this, motionEvent)) {
                return true;
            }
            return super.onTouchEvent(motionEvent);
        }

        public boolean onGenericMotionEvent(MotionEvent motionEvent) {
            if (this.mMotionEventInterceptor != null && this.mMotionEventInterceptor.onInterceptMotionEvent((View)this, motionEvent)) {
                return true;
            }
            return super.onGenericMotionEvent(motionEvent);
        }

        public void setDrawingCacheEnabled(boolean bl) {
            super.setChildrenDrawnWithCacheEnabled(bl);
        }
    }

    private class DeferredCleanupTask
    implements Runnable {
        private static final String CLEANUP_VERSION = "cleanup-version";
        private static final int CURRENT_CLEANUP_VERSION = 1;

        private DeferredCleanupTask() {
        }

        public void run() {
            File file;
            long l = GeckoApp.getAppSharedPreferences().getInt(CLEANUP_VERSION, 0);
            if (l < 1L && (file = new File("res/fonts")).exists() && file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    if (!file2.isFile() || !file2.getName().endsWith(".ttf")) continue;
                    Log.i((String)"GeckoApp", (String)("deleting " + file2.toString()));
                    file2.delete();
                }
                if (!file.delete()) {
                    Log.w((String)"GeckoApp", (String)"unable to delete res/fonts directory (not empty?)");
                } else {
                    Log.i((String)"GeckoApp", (String)"res/fonts directory deleted");
                }
            }
            if (l != 1L) {
                file = GeckoApp.getAppSharedPreferences().edit();
                file.putInt(CLEANUP_VERSION, 1);
                file.commit();
            }
        }
    }

    class PrefetchRunnable
    implements Runnable {
        private String mPrefetchUrl;

        PrefetchRunnable(String string2) {
            this.mPrefetchUrl = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HttpURLConnection httpURLConnection = null;
            try {
                URL uRL = new URL(this.mPrefetchUrl);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestProperty("User-Agent", GeckoApp.this.getUAStringForHost(uRL.getHost()));
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.connect();
            }
            catch (Exception exception) {
                Log.e((String)"GeckoApp", (String)"Exception prefetching URL", (Throwable)exception);
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
    }

    class SessionRestoreException
    extends Exception {
        public SessionRestoreException(Exception exception) {
            super(exception);
        }

        public SessionRestoreException(String string2) {
            super(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StartupAction {
        NORMAL,
        URL,
        PREFETCH;

    }
}

