/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.util.Log;
import java.util.ArrayList;
import org.mozilla.gecko.Envelope;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.ISmsManager;
import org.mozilla.gecko.MessagesListManager;
import org.mozilla.gecko.PendingIntentUID;
import org.mozilla.gecko.Postman;
import org.mozilla.gecko.SmsIOThread;

public class GeckoSmsManager
extends BroadcastReceiver
implements ISmsManager {
    public static final String ACTION_SMS_RECEIVED = "android.provider.Telephony.SMS_RECEIVED";
    public static final String ACTION_SMS_SENT = "org.mozilla.gecko.SMS_SENT";
    public static final String ACTION_SMS_DELIVERED = "org.mozilla.gecko.SMS_DELIVERED";
    public static final int kNoError = 0;
    public static final int kNoSignalError = 1;
    public static final int kNotFoundError = 2;
    public static final int kUnknownError = 3;
    public static final int kInternalError = 4;
    public static final int kNoSimCardError = 5;
    public static final int kRadioDisabledError = 6;
    public static final int kInvalidAddressError = 7;
    public static final int kFdnCheckError = 8;
    public static final int kNonActiveSimCardError = 9;
    private static final int kMaxMessageSize = 160;
    private static final Uri kSmsContentUri = Uri.parse((String)"content://sms");
    private static final Uri kSmsSentContentUri = Uri.parse((String)"content://sms/sent");
    private static final int kSmsTypeInbox = 1;
    private static final int kSmsTypeSentbox = 2;
    private static final int kDeliveryStateSent = 0;
    private static final int kDeliveryStateReceived = 1;
    private static final int kDeliveryStateSending = 2;
    private static final int kDeliveryStateError = 3;
    private static final int kDeliveryStateUnknown = 4;
    private static final int kDeliveryStateNotDownloaded = 5;
    private static final int kDeliveryStateEndGuard = 6;
    private static final int kDeliveryStatusNotApplicable = 0;
    private static final int kDeliveryStatusSuccess = 1;
    private static final int kDeliveryStatusPending = 2;
    private static final int kDeliveryStatusError = 3;
    private static final int kInternalDeliveryStatusNone = -1;
    private static final int kInternalDeliveryStatusComplete = 0;
    private static final int kInternalDeliveryStatusPending = 32;
    private static final int kInternalDeliveryStatusFailed = 64;
    private static final int kMessageClassNormal = 0;
    private static final int kMessageClassClass0 = 1;
    private static final int kMessageClassClass1 = 2;
    private static final int kMessageClassClass2 = 3;
    private static final int kMessageClassClass3 = 4;
    private static final String[] kRequiredMessageRows = new String[]{"_id", "address", "body", "date", "type", "status"};

    public GeckoSmsManager() {
        SmsIOThread.getInstance().start();
    }

    public void start() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(ACTION_SMS_RECEIVED);
        intentFilter.addAction(ACTION_SMS_SENT);
        intentFilter.addAction(ACTION_SMS_DELIVERED);
        GeckoAppShell.getContext().registerReceiver((BroadcastReceiver)this, intentFilter);
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals(ACTION_SMS_RECEIVED)) {
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                return;
            }
            Object[] objectArray = (Object[])bundle.get("pdus");
            for (int i = 0; i < objectArray.length; ++i) {
                SmsMessage smsMessage = SmsMessage.createFromPdu((byte[])((byte[])objectArray[i]));
                GeckoSmsManager.notifySmsReceived(smsMessage.getDisplayOriginatingAddress(), smsMessage.getDisplayMessageBody(), this.getGeckoMessageClass(smsMessage.getMessageClass()), System.currentTimeMillis());
            }
            return;
        }
        if (intent.getAction().equals(ACTION_SMS_SENT) || intent.getAction().equals(ACTION_SMS_DELIVERED)) {
            Bundle bundle = intent.getExtras();
            if (!(bundle != null && bundle.containsKey("envelopeId") && bundle.containsKey("number") && bundle.containsKey("message") && bundle.containsKey("requestId"))) {
                Log.e((String)"GeckoSmsManager", (String)"Got an invalid ACTION_SMS_SENT/ACTION_SMS_DELIVERED!");
                return;
            }
            int n = bundle.getInt("envelopeId");
            Postman postman = Postman.getInstance();
            Envelope envelope = postman.getEnvelope(n);
            if (envelope == null) {
                Log.e((String)"GeckoSmsManager", (String)"Got an invalid envelope id (or Envelope has been destroyed)!");
                return;
            }
            Envelope.SubParts subParts = intent.getAction().equals(ACTION_SMS_SENT) ? Envelope.SubParts.SENT_PART : Envelope.SubParts.DELIVERED_PART;
            envelope.decreaseRemainingParts(subParts);
            if (this.getResultCode() != -1) {
                switch (this.getResultCode()) {
                    case 3: {
                        envelope.setError(4);
                        break;
                    }
                    case 2: 
                    case 4: {
                        envelope.setError(1);
                        break;
                    }
                    default: {
                        envelope.setError(3);
                    }
                }
                envelope.markAsFailed(subParts);
                Log.i((String)"GeckoSmsManager", (String)"SMS part sending failed!");
            }
            if (envelope.arePartsRemaining(subParts)) {
                return;
            }
            if (envelope.isFailing(subParts)) {
                if (subParts == Envelope.SubParts.SENT_PART) {
                    GeckoSmsManager.notifySmsSendFailed(envelope.getError(), bundle.getInt("requestId"));
                    Log.i((String)"GeckoSmsManager", (String)"SMS sending failed!");
                } else {
                    GeckoSmsManager.notifySmsDelivery(envelope.getMessageId(), 3, bundle.getString("number"), bundle.getString("message"), envelope.getMessageTimestamp());
                    Log.i((String)"GeckoSmsManager", (String)"SMS delivery failed!");
                }
            } else if (subParts == Envelope.SubParts.SENT_PART) {
                String string2 = bundle.getString("number");
                String string3 = bundle.getString("message");
                long l = System.currentTimeMillis();
                int n2 = this.saveSentMessage(string2, string3, l);
                GeckoSmsManager.notifySmsSent(n2, string2, string3, l, bundle.getInt("requestId"));
                envelope.setMessageId(n2);
                envelope.setMessageTimestamp(l);
                Log.i((String)"GeckoSmsManager", (String)"SMS sending was successfull!");
            } else {
                GeckoSmsManager.notifySmsDelivery(envelope.getMessageId(), 1, bundle.getString("number"), bundle.getString("message"), envelope.getMessageTimestamp());
                Log.i((String)"GeckoSmsManager", (String)"SMS successfully delivered!");
            }
            if (!envelope.arePartsRemaining(Envelope.SubParts.SENT_PART) && !envelope.arePartsRemaining(Envelope.SubParts.DELIVERED_PART)) {
                postman.destroyEnvelope(n);
            }
            return;
        }
    }

    public void send(String string2, String string3, int n) {
        int n2 = -1;
        try {
            SmsManager smsManager = SmsManager.getDefault();
            Intent intent = new Intent(ACTION_SMS_SENT);
            Intent intent2 = new Intent(ACTION_SMS_DELIVERED);
            Bundle bundle = new Bundle();
            bundle.putString("number", string2);
            bundle.putString("message", string3);
            bundle.putInt("requestId", n);
            if (string3.length() <= 160) {
                n2 = Postman.getInstance().createEnvelope(1);
                bundle.putInt("envelopeId", n2);
                intent.putExtras(bundle);
                intent2.putExtras(bundle);
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)PendingIntentUID.generate(), (Intent)intent, (int)0x10000000);
                PendingIntent pendingIntent2 = PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)PendingIntentUID.generate(), (Intent)intent2, (int)0x10000000);
                smsManager.sendTextMessage(string2, "", string3, pendingIntent, pendingIntent2);
            } else {
                ArrayList arrayList = smsManager.divideMessage(string3);
                n2 = Postman.getInstance().createEnvelope(arrayList.size());
                bundle.putInt("envelopeId", n2);
                intent.putExtras(bundle);
                intent2.putExtras(bundle);
                ArrayList<PendingIntent> arrayList2 = new ArrayList<PendingIntent>(arrayList.size());
                ArrayList<PendingIntent> arrayList3 = new ArrayList<PendingIntent>(arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    arrayList2.add(PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)PendingIntentUID.generate(), (Intent)intent, (int)0x10000000));
                    arrayList3.add(PendingIntent.getBroadcast((Context)GeckoAppShell.getContext(), (int)PendingIntentUID.generate(), (Intent)intent2, (int)0x10000000));
                }
                smsManager.sendMultipartTextMessage(string2, "", arrayList, arrayList2, arrayList3);
            }
        }
        catch (Exception exception) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to send an SMS: ", (Throwable)exception);
            if (n2 != -1) {
                Postman.getInstance().destroyEnvelope(n2);
            }
            GeckoSmsManager.notifySmsSendFailed(3, n);
        }
    }

    public int saveSentMessage(String string2, String string3, long l) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("address", string2);
            contentValues.put("body", string3);
            contentValues.put("date", Long.valueOf(l));
            contentValues.put("status", Integer.valueOf(32));
            ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
            Uri uri = contentResolver.insert(kSmsSentContentUri, contentValues);
            long l2 = ContentUris.parseId((Uri)uri);
            if (l2 > Integer.MAX_VALUE) {
                throw new IdTooHighException();
            }
            return (int)l2;
        }
        catch (IdTooHighException idTooHighException) {
            Log.e((String)"GeckoSmsManager", (String)"The id we received is higher than the higher allowed value.");
            return -1;
        }
        catch (Exception exception) {
            Log.e((String)"GeckoSmsManager", (String)"Something went wrong when trying to write a sent message", (Throwable)exception);
            return -1;
        }
    }

    public void getMessage(int n, int n2) {
        class GetMessageRunnable
        implements Runnable {
            private int mMessageId;
            private int mRequestId;

            GetMessageRunnable(int n, int n2) {
                this.mMessageId = n;
                this.mRequestId = n2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Cursor cursor = null;
                try {
                    int n;
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    Uri uri = ContentUris.withAppendedId((Uri)kSmsContentUri, (long)this.mMessageId);
                    cursor = contentResolver.query(uri, kRequiredMessageRows, null, null, null);
                    if (cursor == null || cursor.getCount() == 0) {
                        throw new NotFoundException();
                    }
                    if (cursor.getCount() != 1) {
                        throw new TooManyResultsException();
                    }
                    cursor.moveToFirst();
                    if (cursor.getInt(cursor.getColumnIndex("_id")) != this.mMessageId) {
                        throw new UnmatchingIdException();
                    }
                    int n2 = cursor.getInt(cursor.getColumnIndex("type"));
                    String string2 = "";
                    String string3 = "";
                    if (n2 == 1) {
                        n = 1;
                        string2 = cursor.getString(cursor.getColumnIndex("address"));
                    } else if (n2 == 2) {
                        n = GeckoSmsManager.this.getGeckoDeliveryStatus(cursor.getInt(cursor.getColumnIndex("status")));
                        string3 = cursor.getString(cursor.getColumnIndex("address"));
                    } else {
                        throw new InvalidTypeException();
                    }
                    GeckoSmsManager.notifyGetSms(cursor.getInt(cursor.getColumnIndex("_id")), n, string3, string2, cursor.getString(cursor.getColumnIndex("body")), cursor.getLong(cursor.getColumnIndex("date")), this.mRequestId);
                }
                catch (NotFoundException notFoundException) {
                    Log.i((String)"GeckoSmsManager", (String)("Message id " + this.mMessageId + " not found"));
                    GeckoSmsManager.notifyGetSmsFailed(2, this.mRequestId);
                }
                catch (UnmatchingIdException unmatchingIdException) {
                    Log.e((String)"GeckoSmsManager", (String)("Requested message id (" + this.mMessageId + ") is different from the one we got."));
                    GeckoSmsManager.notifyGetSmsFailed(3, this.mRequestId);
                }
                catch (TooManyResultsException tooManyResultsException) {
                    Log.e((String)"GeckoSmsManager", (String)("Get too many results for id " + this.mMessageId));
                    GeckoSmsManager.notifyGetSmsFailed(3, this.mRequestId);
                }
                catch (InvalidTypeException invalidTypeException) {
                    Log.i((String)"GeckoSmsManager", (String)"Message has an invalid type, we ignore it.");
                    GeckoSmsManager.notifyGetSmsFailed(2, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)"Error while trying to get message", (Throwable)exception);
                    GeckoSmsManager.notifyGetSmsFailed(3, this.mRequestId);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new GetMessageRunnable(n, n2))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add GetMessageRunnable to the SmsIOThread");
            GeckoSmsManager.notifyGetSmsFailed(3, n2);
        }
    }

    public void deleteMessage(int n, int n2) {
        class DeleteMessageRunnable
        implements Runnable {
            private int mMessageId;
            private int mRequestId;

            DeleteMessageRunnable(int n, int n2) {
                this.mMessageId = n;
                this.mRequestId = n2;
            }

            public void run() {
                try {
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    Uri uri = ContentUris.withAppendedId((Uri)kSmsContentUri, (long)this.mMessageId);
                    int n = contentResolver.delete(uri, null, null);
                    if (n > 1) {
                        throw new TooManyResultsException();
                    }
                    GeckoSmsManager.notifySmsDeleted(n == 1, this.mRequestId);
                }
                catch (TooManyResultsException tooManyResultsException) {
                    Log.e((String)"GeckoSmsManager", (String)"Delete more than one message?", (Throwable)tooManyResultsException);
                    GeckoSmsManager.notifySmsDeleteFailed(3, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)"Error while trying to delete a message", (Throwable)exception);
                    GeckoSmsManager.notifySmsDeleteFailed(3, this.mRequestId);
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new DeleteMessageRunnable(n, n2))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add GetMessageRunnable to the SmsIOThread");
            GeckoSmsManager.notifySmsDeleteFailed(3, n2);
        }
    }

    public void createMessageList(long l, long l2, String[] stringArray, int n, int n2, boolean bl, int n3) {
        class CreateMessageListRunnable
        implements Runnable {
            private long mStartDate;
            private long mEndDate;
            private String[] mNumbers;
            private int mNumbersCount;
            private int mDeliveryState;
            private boolean mReverse;
            private int mRequestId;

            CreateMessageListRunnable(long l, long l2, String[] stringArray, int n, int n2, boolean bl, int n3) {
                this.mStartDate = l;
                this.mEndDate = l2;
                this.mNumbers = stringArray;
                this.mNumbersCount = n;
                this.mDeliveryState = n2;
                this.mReverse = bl;
                this.mRequestId = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Cursor cursor = null;
                boolean bl = true;
                try {
                    int n;
                    int n2;
                    String string2;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (this.mStartDate != 0L) {
                        arrayList.add("date >= " + this.mStartDate);
                    }
                    if (this.mEndDate != 0L) {
                        arrayList.add("date <= " + this.mEndDate);
                    }
                    if (this.mNumbersCount > 0) {
                        string2 = "address IN ('" + this.mNumbers[0] + "'";
                        for (n2 = 1; n2 < this.mNumbersCount; ++n2) {
                            string2 = string2 + ", '" + this.mNumbers[n2] + "'";
                        }
                        string2 = string2 + ")";
                        arrayList.add(string2);
                    }
                    if (this.mDeliveryState == 4) {
                        arrayList.add("type IN ('2', '1')");
                    } else if (this.mDeliveryState == 0) {
                        arrayList.add("type = 2");
                    } else if (this.mDeliveryState == 1) {
                        arrayList.add("type = 1");
                    } else {
                        throw new UnexpectedDeliveryStateException();
                    }
                    string2 = arrayList.size() > 0 ? (String)arrayList.get(0) : "";
                    for (n2 = 1; n2 < arrayList.size(); ++n2) {
                        string2 = string2 + " AND " + (String)arrayList.get(n2);
                    }
                    ContentResolver contentResolver = GeckoAppShell.getContext().getContentResolver();
                    cursor = contentResolver.query(kSmsContentUri, kRequiredMessageRows, string2, null, this.mReverse ? "date DESC" : "date ASC");
                    if (cursor.getCount() == 0) {
                        GeckoSmsManager.notifyNoMessageInList(this.mRequestId);
                        return;
                    }
                    cursor.moveToFirst();
                    int n3 = cursor.getInt(cursor.getColumnIndex("type"));
                    String string3 = "";
                    String string4 = "";
                    if (n3 == 1) {
                        n = 1;
                        string3 = cursor.getString(cursor.getColumnIndex("address"));
                    } else if (n3 == 2) {
                        n = GeckoSmsManager.this.getGeckoDeliveryStatus(cursor.getInt(cursor.getColumnIndex("status")));
                        string4 = cursor.getString(cursor.getColumnIndex("address"));
                    } else {
                        throw new UnexpectedDeliveryStateException();
                    }
                    int n4 = MessagesListManager.getInstance().add(cursor);
                    bl = false;
                    GeckoSmsManager.notifyListCreated(n4, cursor.getInt(cursor.getColumnIndex("_id")), n, string4, string3, cursor.getString(cursor.getColumnIndex("body")), cursor.getLong(cursor.getColumnIndex("date")), this.mRequestId);
                }
                catch (UnexpectedDeliveryStateException unexpectedDeliveryStateException) {
                    Log.e((String)"GeckoSmsManager", (String)"Unexcepted delivery state type", (Throwable)unexpectedDeliveryStateException);
                    GeckoSmsManager.notifyReadingMessageListFailed(3, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)"Error while trying to create a message list cursor", (Throwable)exception);
                    GeckoSmsManager.notifyReadingMessageListFailed(3, this.mRequestId);
                }
                finally {
                    if (cursor != null && bl) {
                        cursor.close();
                    }
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new CreateMessageListRunnable(l, l2, stringArray, n, n2, bl, n3))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add CreateMessageListRunnable to the SmsIOThread");
            GeckoSmsManager.notifyReadingMessageListFailed(3, n3);
        }
    }

    public void getNextMessageInList(int n, int n2) {
        class GetNextMessageInListRunnable
        implements Runnable {
            private int mListId;
            private int mRequestId;

            GetNextMessageInListRunnable(int n, int n2) {
                this.mListId = n;
                this.mRequestId = n2;
            }

            public void run() {
                try {
                    int n;
                    Cursor cursor = MessagesListManager.getInstance().get(this.mListId);
                    if (!cursor.moveToNext()) {
                        MessagesListManager.getInstance().remove(this.mListId);
                        GeckoSmsManager.notifyNoMessageInList(this.mRequestId);
                        return;
                    }
                    int n2 = cursor.getInt(cursor.getColumnIndex("type"));
                    String string2 = "";
                    String string3 = "";
                    if (n2 == 1) {
                        n = 1;
                        string2 = cursor.getString(cursor.getColumnIndex("address"));
                    } else if (n2 == 2) {
                        n = GeckoSmsManager.this.getGeckoDeliveryStatus(cursor.getInt(cursor.getColumnIndex("status")));
                        string3 = cursor.getString(cursor.getColumnIndex("address"));
                    } else {
                        throw new UnexpectedDeliveryStateException();
                    }
                    int n3 = MessagesListManager.getInstance().add(cursor);
                    GeckoSmsManager.notifyGotNextMessage(cursor.getInt(cursor.getColumnIndex("_id")), n, string3, string2, cursor.getString(cursor.getColumnIndex("body")), cursor.getLong(cursor.getColumnIndex("date")), this.mRequestId);
                }
                catch (UnexpectedDeliveryStateException unexpectedDeliveryStateException) {
                    Log.e((String)"GeckoSmsManager", (String)"Unexcepted delivery state type", (Throwable)unexpectedDeliveryStateException);
                    GeckoSmsManager.notifyReadingMessageListFailed(3, this.mRequestId);
                }
                catch (Exception exception) {
                    Log.e((String)"GeckoSmsManager", (String)"Error while trying to get the next message of a list", (Throwable)exception);
                    GeckoSmsManager.notifyReadingMessageListFailed(3, this.mRequestId);
                }
            }
        }
        if (!SmsIOThread.getInstance().execute(new GetNextMessageInListRunnable(n, n2))) {
            Log.e((String)"GeckoSmsManager", (String)"Failed to add GetNextMessageInListRunnable to the SmsIOThread");
            GeckoSmsManager.notifyReadingMessageListFailed(3, n2);
        }
    }

    public void clearMessageList(int n) {
        MessagesListManager.getInstance().remove(n);
    }

    public void stop() {
        GeckoAppShell.getContext().unregisterReceiver((BroadcastReceiver)this);
    }

    public void shutdown() {
        SmsIOThread.getInstance().interrupt();
        MessagesListManager.getInstance().clear();
    }

    private int getGeckoDeliveryStatus(int n) {
        if (n == -1) {
            return 0;
        }
        if (n >= 64) {
            return 3;
        }
        if (n >= 32) {
            return 2;
        }
        return 1;
    }

    private int getGeckoMessageClass(SmsMessage.MessageClass messageClass) {
        switch (messageClass) {
            case CLASS_0: {
                return 1;
            }
            case CLASS_1: {
                return 2;
            }
            case CLASS_2: {
                return 3;
            }
            case CLASS_3: {
                return 4;
            }
        }
        return 0;
    }

    private static native void notifySmsReceived(String var0, String var1, int var2, long var3);

    private static native void notifySmsSent(int var0, String var1, String var2, long var3, int var5);

    private static native void notifySmsDelivery(int var0, int var1, String var2, String var3, long var4);

    private static native void notifySmsSendFailed(int var0, int var1);

    private static native void notifyGetSms(int var0, int var1, String var2, String var3, String var4, long var5, int var7);

    private static native void notifyGetSmsFailed(int var0, int var1);

    private static native void notifySmsDeleted(boolean var0, int var1);

    private static native void notifySmsDeleteFailed(int var0, int var1);

    private static native void notifyNoMessageInList(int var0);

    private static native void notifyListCreated(int var0, int var1, int var2, String var3, String var4, String var5, long var6, int var8);

    private static native void notifyGotNextMessage(int var0, int var1, String var2, String var3, String var4, long var5, int var7);

    private static native void notifyReadingMessageListFailed(int var0, int var1);

    class UnmatchingIdException
    extends Exception {
        private static final long serialVersionUID = 158467542575633280L;

        UnmatchingIdException() {
        }
    }

    class UnexpectedDeliveryStateException
    extends Exception {
        private static final long serialVersionUID = 494122763684005716L;

        UnexpectedDeliveryStateException() {
        }
    }

    class TooManyResultsException
    extends Exception {
        private static final long serialVersionUID = 51883196784325305L;

        TooManyResultsException() {
        }
    }

    class NotFoundException
    extends Exception {
        private static final long serialVersionUID = 1940676816633984L;

        NotFoundException() {
        }
    }

    class InvalidTypeException
    extends Exception {
        private static final long serialVersionUID = 47436856832535912L;

        InvalidTypeException() {
        }
    }

    class IdTooHighException
    extends Exception {
        private static final long serialVersionUID = 29935575131092050L;

        IdTooHighException() {
        }
    }
}

