/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.util.EventDispatcher;
import org.mozilla.gecko.util.GeckoEventListener;

public final class OrderedBroadcastHelper
implements GeckoEventListener {
    public static final String LOGTAG = "GeckoOrdBroadcast";
    public static final String SEND_EVENT = "OrderedBroadcast:Send";
    protected final Context mContext;

    public OrderedBroadcastHelper(Context context) {
        this.mContext = context;
        EventDispatcher eventDispatcher = GeckoAppShell.getEventDispatcher();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.registerEventListener(SEND_EVENT, (GeckoEventListener)this);
    }

    public synchronized void uninit() {
        EventDispatcher eventDispatcher = GeckoAppShell.getEventDispatcher();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.unregisterEventListener(SEND_EVENT, (GeckoEventListener)this);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (!SEND_EVENT.equals(string2)) {
            Log.e((String)LOGTAG, (String)("OrderedBroadcastHelper got unexpected message " + string2));
            return;
        }
        try {
            JSONObject jSONObject2;
            final String string3 = jSONObject.getString("action");
            if (string3 == null) {
                Log.e((String)LOGTAG, (String)"action must not be null");
                return;
            }
            final String string4 = jSONObject.getString("responseEvent");
            if (string4 == null) {
                Log.e((String)LOGTAG, (String)"responseEvent must not be null");
                return;
            }
            JSONObject jSONObject3 = jSONObject2 = jSONObject.has("token") && !jSONObject.isNull("token") ? jSONObject.getJSONObject("token") : null;
            String string5 = jSONObject.has("permission") ? (jSONObject.isNull("permission") ? null : jSONObject.getString("permission")) : "org.mozilla.fennec.permission.PER_ANDROID_PACKAGE";
            BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    int n = this.getResultCode();
                    if (n == -1) {
                        String string2 = this.getResultData();
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("action", (Object)string3);
                            jSONObject.put("token", (Object)jSONObject2);
                            jSONObject.put("data", (Object)string2);
                        }
                        catch (JSONException jSONException) {
                            Log.e((String)OrderedBroadcastHelper.LOGTAG, (String)("Got exception in onReceive handling action " + string3), (Throwable)jSONException);
                            return;
                        }
                        GeckoEvent geckoEvent = GeckoEvent.createBroadcastEvent(string4, jSONObject.toString());
                        GeckoAppShell.sendEventToGecko(geckoEvent);
                    }
                }
            };
            Intent intent = new Intent(string3);
            if (jSONObject2 != null && jSONObject2.has("data")) {
                intent.putExtra("token", jSONObject2.getString("data"));
            }
            this.mContext.sendOrderedBroadcast(intent, string5, broadcastReceiver, null, -1, null, null);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)("Got exception in handleMessage handling event " + string2), (Throwable)jSONException);
            return;
        }
    }
}

