/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.HashMap;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.sqlite.SQLiteBridge;
import org.mozilla.gecko.sqlite.SQLiteBridgeException;

public abstract class SQLiteBridgeContentProvider
extends ContentProvider {
    private HashMap<String, SQLiteBridge> mDatabasePerProfile;
    protected Context mContext = null;
    private final String mLogTag;

    protected SQLiteBridgeContentProvider(String string2) {
        this.mLogTag = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.mDatabasePerProfile == null) {
            return;
        }
        SQLiteBridgeContentProvider sQLiteBridgeContentProvider = this;
        synchronized (sQLiteBridgeContentProvider) {
            for (SQLiteBridge sQLiteBridge : this.mDatabasePerProfile.values()) {
                if (sQLiteBridge == null) continue;
                try {
                    sQLiteBridge.close();
                }
                catch (Exception exception) {}
            }
            this.mDatabasePerProfile = null;
        }
    }

    public void finalize() {
        this.shutdown();
    }

    private SQLiteBridge getDB(Context context, String string2) {
        boolean bl;
        SQLiteBridge sQLiteBridge;
        block4: {
            sQLiteBridge = null;
            bl = true;
            try {
                String string3 = context.getPackageResourcePath();
                GeckoLoader.loadSQLiteLibs((Context)context, (String)string3);
                GeckoLoader.loadNSSLibs((Context)context, (String)string3);
                sQLiteBridge = SQLiteBridge.openDatabase(string2, null, 0);
                int n = sQLiteBridge.getVersion();
                bl = n != this.getDBVersion();
            }
            catch (SQLiteBridgeException sQLiteBridgeException) {
                if (sQLiteBridge != null) {
                    sQLiteBridge.close();
                }
                bl = true;
                Log.e((String)this.mLogTag, (String)"Error getting version ", (Throwable)sQLiteBridgeException);
                if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) break block4;
                Log.e((String)this.mLogTag, (String)"Can not set up database. Gecko is not running");
                return null;
            }
        }
        if (bl) {
            sQLiteBridge = null;
            this.initGecko();
        }
        return sQLiteBridge;
    }

    private String getDatabasePathForProfile(String string2, String string3) {
        File file = GeckoProfile.get(this.mContext, string2).getDir();
        if (file == null) {
            return null;
        }
        String string4 = new File(file, string3).getAbsolutePath();
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLiteBridge getDatabaseForProfile(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = GeckoProfile.get(this.mContext).getName();
            Log.d((String)this.mLogTag, (String)("No profile provided, using '" + string2 + "'"));
        }
        String string3 = this.getDBName();
        String string4 = string2 + "/" + string3;
        SQLiteBridge sQLiteBridge = null;
        SQLiteBridgeContentProvider sQLiteBridgeContentProvider = this;
        synchronized (sQLiteBridgeContentProvider) {
            sQLiteBridge = this.mDatabasePerProfile.get(string4);
            if (sQLiteBridge != null) {
                return sQLiteBridge;
            }
            String string5 = this.getDatabasePathForProfile(string2, string3);
            if (string5 == null) {
                Log.e((String)this.mLogTag, (String)("Failed to get a valid db path for profile '" + string2 + "'' dbName '" + string3 + "'"));
                return null;
            }
            sQLiteBridge = this.getDB(this.mContext, string5);
            if (sQLiteBridge != null) {
                this.mDatabasePerProfile.put(string4, sQLiteBridge);
            }
        }
        return sQLiteBridge;
    }

    private SQLiteBridge getDatabaseForProfilePath(String string2) {
        File file = new File(string2, this.getDBName());
        String string3 = file.getPath();
        return this.getDatabaseForDBPath(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLiteBridge getDatabaseForDBPath(String string2) {
        SQLiteBridge sQLiteBridge = null;
        SQLiteBridgeContentProvider sQLiteBridgeContentProvider = this;
        synchronized (sQLiteBridgeContentProvider) {
            sQLiteBridge = this.mDatabasePerProfile.get(string2);
            if (sQLiteBridge != null) {
                return sQLiteBridge;
            }
            sQLiteBridge = this.getDB(this.mContext, string2);
            if (sQLiteBridge != null) {
                this.mDatabasePerProfile.put(string2, sQLiteBridge);
            }
        }
        return sQLiteBridge;
    }

    private SQLiteBridge getDatabase(Uri uri) {
        String string2 = null;
        String string3 = null;
        string2 = uri.getQueryParameter("profile");
        string3 = uri.getQueryParameter("profilePath");
        if (string3 != null) {
            return this.getDatabaseForProfilePath(string3);
        }
        return this.getDatabaseForProfile(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onCreate() {
        this.mContext = this.getContext();
        SQLiteBridgeContentProvider sQLiteBridgeContentProvider = this;
        synchronized (sQLiteBridgeContentProvider) {
            this.mDatabasePerProfile = new HashMap();
        }
        return true;
    }

    public String getType(Uri uri) {
        return null;
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        int n = 0;
        SQLiteBridge sQLiteBridge = this.getDatabase(uri);
        if (sQLiteBridge == null) {
            return n;
        }
        try {
            n = sQLiteBridge.delete(this.getTable(uri), string2, stringArray);
        }
        catch (SQLiteBridgeException sQLiteBridgeException) {
            Log.e((String)this.mLogTag, (String)"Error deleting record", (Throwable)sQLiteBridgeException);
            throw sQLiteBridgeException;
        }
        return n;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        long l = -1L;
        SQLiteBridge sQLiteBridge = this.getDatabase(uri);
        if (sQLiteBridge == null) {
            return null;
        }
        this.setupDefaults(uri, contentValues);
        boolean bl = !sQLiteBridge.inTransaction();
        try {
            if (bl) {
                sQLiteBridge.beginTransaction();
            }
            this.onPreInsert(contentValues, uri, sQLiteBridge);
            l = sQLiteBridge.insert(this.getTable(uri), null, contentValues);
            if (bl) {
                sQLiteBridge.setTransactionSuccessful();
            }
        }
        catch (SQLiteBridgeException sQLiteBridgeException) {
            Log.e((String)this.mLogTag, (String)"Error inserting in db", (Throwable)sQLiteBridgeException);
            throw sQLiteBridgeException;
        }
        finally {
            if (bl) {
                sQLiteBridge.endTransaction();
            }
        }
        return ContentUris.withAppendedId((Uri)uri, (long)l);
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        SQLiteBridge sQLiteBridge = this.getDatabase(uri);
        if (sQLiteBridge == null) {
            return 0;
        }
        long l = -1L;
        int n = 0;
        String string2 = this.getTable(uri);
        try {
            sQLiteBridge.beginTransaction();
            for (ContentValues contentValues : contentValuesArray) {
                ContentValues contentValues2 = new ContentValues(contentValues);
                this.setupDefaults(uri, contentValues2);
                this.onPreInsert(contentValues2, uri, sQLiteBridge);
                l = sQLiteBridge.insert(string2, null, contentValues2);
                ++n;
            }
            sQLiteBridge.setTransactionSuccessful();
        }
        catch (SQLiteBridgeException sQLiteBridgeException) {
            Log.e((String)this.mLogTag, (String)"Error inserting in db", (Throwable)sQLiteBridgeException);
            throw sQLiteBridgeException;
        }
        finally {
            sQLiteBridge.endTransaction();
        }
        if (n > 0) {
            this.mContext.getContentResolver().notifyChange(uri, null);
        }
        return n;
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n = 0;
        SQLiteBridge sQLiteBridge = this.getDatabase(uri);
        if (sQLiteBridge == null) {
            return n;
        }
        this.onPreUpdate(contentValues, uri, sQLiteBridge);
        try {
            n = sQLiteBridge.update(this.getTable(uri), contentValues, string2, stringArray);
        }
        catch (SQLiteBridgeException sQLiteBridgeException) {
            Log.e((String)this.mLogTag, (String)"Error updating table", (Throwable)sQLiteBridgeException);
            throw sQLiteBridgeException;
        }
        return n;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        Cursor cursor = null;
        SQLiteBridge sQLiteBridge = this.getDatabase(uri);
        if (sQLiteBridge == null) {
            return cursor;
        }
        string3 = this.getSortOrder(uri, string3);
        try {
            cursor = sQLiteBridge.query(this.getTable(uri), stringArray, string2, stringArray2, null, null, string3, null);
            this.onPostQuery(cursor, uri, sQLiteBridge);
        }
        catch (SQLiteBridgeException sQLiteBridgeException) {
            Log.e((String)this.mLogTag, (String)"Error querying database", (Throwable)sQLiteBridgeException);
            throw sQLiteBridgeException;
        }
        return cursor;
    }

    protected abstract String getDBName();

    protected abstract int getDBVersion();

    protected abstract String getTable(Uri var1);

    protected abstract String getSortOrder(Uri var1, String var2);

    protected abstract void setupDefaults(Uri var1, ContentValues var2);

    protected abstract void initGecko();

    protected abstract void onPreInsert(ContentValues var1, Uri var2, SQLiteBridge var3);

    protected abstract void onPreUpdate(ContentValues var1, Uri var2, SQLiteBridge var3);

    protected abstract void onPostQuery(Cursor var1, Uri var2, SQLiteBridge var3);
}

