/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v4.widget.CursorAdapter;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.ListView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TwoLinePageRow;

public class DynamicPanel
extends HomeFragment {
    private static final String LOGTAG = "GeckoDynamicPanel";
    private static final int LOADER_ID_LIST = 0;
    private HomeConfig.PanelConfig mPanelConfig;
    private HomeListAdapter mAdapter;
    private ListView mList;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private HomePager.OnUrlOpenListener mUrlOpenListener;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        if (bundle2 != null) {
            this.mPanelConfig = (HomeConfig.PanelConfig)bundle2.getParcelable("panelConfig");
        }
        if (this.mPanelConfig == null) {
            throw new IllegalStateException("Can't create a DynamicPanel without a PanelConfig");
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.mList = new HomeListView((Context)this.getActivity());
        return this.mList;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.registerForContextMenu((View)this.mList);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new HomeListAdapter((Context)this.getActivity(), null);
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new HomeListLoader((Context)DynamicPanel.this.getActivity(), DynamicPanel.this.mPanelConfig.getId());
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            DynamicPanel.this.mAdapter.swapCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            DynamicPanel.this.mAdapter.swapCursor(null);
        }
    }

    private class HomeListAdapter
    extends CursorAdapter {
        public HomeListAdapter(Context context, Cursor cursor) {
            super(context, cursor, 0);
        }

        public void bindView(View view, Context context, Cursor cursor) {
            TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
            twoLinePageRow.updateFromCursor(cursor);
        }

        public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
            return LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.bookmark_item_row, viewGroup, false);
        }
    }

    private static class HomeListLoader
    extends SimpleCursorLoader {
        private String mProviderId;

        public HomeListLoader(Context context, String string2) {
            super(context);
            this.mProviderId = string2;
        }

        public Cursor loadCursor() {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            Uri uri = BrowserContract.HomeListItems.CONTENT_FAKE_URI.buildUpon().appendQueryParameter("profile", "default").build();
            String[] stringArray = new String[]{this.mProviderId};
            Log.i((String)DynamicPanel.LOGTAG, (String)("Loading fake data for list provider: " + this.mProviderId));
            return contentResolver.query(uri, null, "provider_id = ?", stringArray, null);
        }
    }
}

